/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.actions;

import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.actions.DbDiagramRefresher$accept$;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/diagram/actions/DbDiagramRefresher;", "Ljava/util/function/Consumer;", "", "Lcom/intellij/database/util/ObjectPath;", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/diagram/DiagramBuilder;Lcom/intellij/database/model/basic/BasicModel;)V", "getBuilder", "()Lcom/intellij/diagram/DiagramBuilder;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "accept", "", "createdElements", "refreshDiagram", "newNode", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/database/psi/DbElement;", "updateDataModel", "dataModel", "Lcom/intellij/database/diagram/DbDiagramDataModel;", "created", "updateDiagramFocus", "added", "intellij.database.diagrams"})
@SourceDebugExtension(value={"SMAP\nDbDiagramRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbDiagramRefresher.kt\ncom/intellij/database/diagram/actions/DbDiagramRefresher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n473#2:71\n1#3:72\n*S KotlinDebug\n*F\n+ 1 DbDiagramRefresher.kt\ncom/intellij/database/diagram/actions/DbDiagramRefresher\n*L\n25#1:71\n*E\n"})
public final class DbDiagramRefresher
implements Consumer<List<? extends ObjectPath>> {
    @NotNull
    private final DiagramBuilder builder;
    @NotNull
    private final BasicModel model;

    public DbDiagramRefresher(@NotNull DiagramBuilder builder, @NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.builder = builder;
        this.model = model2;
    }

    @NotNull
    public final DiagramBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(@NotNull List<? extends ObjectPath> createdElements) {
        DiagramNode<DbElement> diagramNode;
        DbElement created2;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(createdElements, (String)"createdElements");
        Project project = this.builder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DatabaseNodeWrappingService wrappingService2 = new DatabaseNodeWrappingService(project);
        Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)createdElements), (Function1)((Function1)new Function1<ObjectPath, JBIterable<DasObject>>(this){
            final /* synthetic */ DbDiagramRefresher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JBIterable<DasObject> invoke(@NotNull ObjectPath it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                JBIterable<DasObject> jBIterable = QNameUtil.findByPath(this.this$0.getModel(), it2);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"findByPath(...)");
                return jBIterable;
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)accept$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        DbElement dbElement = created2 = (DbElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)sequence2, (Function1)((Function1)new Function1<BasicElement, DbElement>(wrappingService2){
            final /* synthetic */ DatabaseNodeWrappingService $wrappingService;
            {
                this.$wrappingService = $wrappingService;
                super(1);
            }

            @Nullable
            public final DbElement invoke(@NotNull BasicElement it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                PsiElement psiElement = this.$wrappingService.wrap(it2);
                return psiElement instanceof DbElement ? (DbElement)psiElement : null;
            }
        })));
        if (dbElement != null) {
            DbElement it2 = dbElement;
            boolean bl = false;
            DiagramDataModel diagramDataModel = this.builder.getDataModel();
            Intrinsics.checkNotNull((Object)diagramDataModel, (String)"null cannot be cast to non-null type com.intellij.database.diagram.DbDiagramDataModel");
            diagramNode = this.updateDataModel((DbDiagramDataModel)diagramDataModel, it2);
        } else {
            diagramNode = null;
        }
        DiagramNode<DbElement> newNode = diagramNode;
        ReadAction.run(() -> DbDiagramRefresher.accept$lambda$1(this, newNode));
    }

    private final DiagramNode<DbElement> updateDataModel(DbDiagramDataModel dataModel, DbElement created2) {
        DiagramNode diagramNode;
        if (DbImplUtilCore.isDataTable(created2.getKind())) {
            return dataModel.addElement(created2);
        }
        DbElement p2 = created2.getParent();
        if (p2 == null) {
            diagramNode = null;
        } else {
            Object v2;
            block4: {
                Collection<DbDiagramNode> collection2 = dataModel.getNodes();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"getNodes(...)");
                Iterable iterable = collection2;
                for (Object t : iterable) {
                    DbDiagramNode it2 = (DbDiagramNode)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getIdentifyingElement().getDelegate(), (Object)p2.getDelegate())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            diagramNode = v2;
        }
        return diagramNode;
    }

    private final void refreshDiagram(DiagramNode<DbElement> newNode) {
        DiagramBuilder.DiagramUpdateQueryParams diagramUpdateQueryParams;
        DiagramBuilder.DiagramUpdateQueryParams it2 = diagramUpdateQueryParams = DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(this.builder);
        boolean bl = false;
        if (newNode != null) {
            DiagramNode[] diagramNodeArray = new DiagramNode[]{newNode};
            it2.withNodeSizeUpdate(diagramNodeArray);
        } else {
            it2.withAllNodeSizeUpdate();
        }
        diagramUpdateQueryParams.runAsync().thenRunAsync(() -> DbDiagramRefresher.refreshDiagram$lambda$4(this, newNode), Futures.inEdt$default(null, (int)1, null));
    }

    private final void updateDiagramFocus(DiagramNode<DbElement> added) {
        IdeFocusManager.getInstance((Project)this.builder.getProject()).requestFocus((Component)this.builder.getView().getCanvasComponent(), true);
        if (added == null) {
            return;
        }
        Node n = this.builder.getNode(added);
        if (n != null) {
            this.builder.getGraph().unselectAll();
            GraphAnimationService.getInstance().focusViewOnNodes(this.builder.getGraphBuilder(), (Collection)CollectionsKt.listOf((Object)n), false);
        }
    }

    private static final void accept$lambda$1(DbDiagramRefresher this$0, DiagramNode $newNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refreshDiagram((DiagramNode<DbElement>)$newNode);
    }

    private static final void refreshDiagram$lambda$4(DbDiagramRefresher this$0, DiagramNode $newNode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateDiagramFocus((DiagramNode<DbElement>)$newNode);
    }
}

