/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.CsvFormatsUI;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CsvFormatComponent
implements ImportComponent<TableEditorComponent.TableEditorComponentInfo, CsvPreviewComponent.CsvPreviewInfo> {
    private final VirtualFile myFile;
    private final Disposable myDisposable;
    private CsvFormatsSelectionUI myForm;
    private GraphObservable.ObserverListener<?> myListener;
    private ImportEditorContext myCurrentContext;

    public CsvFormatComponent(@NotNull VirtualFile file, @NotNull Disposable disposable) {
        if (file == null) {
            CsvFormatComponent.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            CsvFormatComponent.$$$reportNull$$$0(1);
        }
        this.myFile = file;
        this.myDisposable = disposable;
    }

    @NotNull
    public CsvFormatsUI getFormatsUI() {
        CsvFormatsUI csvFormatsUI = (CsvFormatsUI)Objects.requireNonNull(this.myForm);
        if (csvFormatsUI == null) {
            CsvFormatComponent.$$$reportNull$$$0(2);
        }
        return csvFormatsUI;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myForm.getComponent();
        if (jComponent == null) {
            CsvFormatComponent.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            CsvFormatComponent.$$$reportNull$$$0(4);
        }
        this.myListener = listener2;
    }

    @Override
    @NotNull
    public CompletionStage<CsvPreviewComponent.CsvPreviewInfo> notifyChanged(@NotNull TableEditorComponent.TableEditorComponentInfo object) {
        ImportEditorContext context;
        if (object == null) {
            CsvFormatComponent.$$$reportNull$$$0(5);
        }
        if ((context = object.myContext) == null) {
            throw new IllegalArgumentException(CsvFormatComponent.class.getName() + " cannot be initialized with null context");
        }
        this.myCurrentContext = context;
        if (this.getInfo(context) != null) {
            CompletableFuture<CsvPreviewComponent.CsvPreviewInfo> completableFuture = CompletableFuture.completedFuture(this.getInfo(context));
            if (completableFuture == null) {
                CsvFormatComponent.$$$reportNull$$$0(6);
            }
            return completableFuture;
        }
        this.myForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(this.myDisposable, CsvFormatUISettings.DEFAULT);
        this.selectMoreSuitableFormat(context);
        this.myForm.addFormatChangeListener(source -> this.myListener.changed(this, this.getInfo(this.myCurrentContext)), this.myDisposable);
        CompletableFuture<CsvPreviewComponent.CsvPreviewInfo> completableFuture = CompletableFuture.completedFuture(this.getInfo(context));
        if (completableFuture == null) {
            CsvFormatComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    public boolean isParentFor(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CsvFormatComponent.$$$reportNull$$$0(8);
        }
        return observer instanceof CsvPreviewComponent;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder, @NotNull ImportEditorContext context) {
        if (builder == null) {
            CsvFormatComponent.$$$reportNull$$$0(9);
        }
        if (context == null) {
            CsvFormatComponent.$$$reportNull$$$0(10);
        }
        CsvFormat format2 = this.myForm.getSelectedFormat();
        builder.csvFormat(Objects.requireNonNull(format2));
        CsvFormatResolver.saveCsvFormat((CsvFormat)Objects.requireNonNull(format2), (VirtualFile)this.myFile);
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            CsvFormatComponent.$$$reportNull$$$0(11);
        }
        return builder.getFormat() == null;
    }

    private CsvPreviewComponent.FormatInfo getInfo(@NotNull ImportEditorContext context) {
        if (context == null) {
            CsvFormatComponent.$$$reportNull$$$0(12);
        }
        return this.myForm == null ? null : new CsvPreviewComponent.FormatInfo(Objects.requireNonNull(this.myForm.getSelectedFormat()), context);
    }

    private void selectMoreSuitableFormat(@NotNull ImportEditorContext context) {
        Project project;
        CsvFormat format2;
        if (context == null) {
            CsvFormatComponent.$$$reportNull$$$0(13);
        }
        if ((format2 = CsvFormatResolver.getFormat((Project)(project = context.getProject()), (VirtualFile)this.myFile, (boolean)true, null)) != null) {
            this.myForm.select(format2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvFormatComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvFormatComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isParentFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectMoreSuitableFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

