/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.component;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ColumnMappingStrategy;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponentBase;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseTableEditorForm;
import com.intellij.database.view.editors.ImportTableNameForm;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableEditorComponent
implements TableEditorComponentBase<TableEditorComponentInfo, DdlPreviewComponent.DdlPreviewComponentInfo> {
    private final JPanel myPanel;
    private final Disposable myDisposable;
    private final ImportSourceType mySourceType;
    protected final List<? extends GridRow> myInitialRows;
    private final String myProducerName;
    private final String myInitialTargetTableName;
    protected final List<? extends ColumnDescriptor> myProducers;
    protected final DatabaseTableEditorForm myForm;
    protected final List<? extends ColumnDescriptor> myVisibleProducers;
    protected ImportEditorContext myCurrentContext;
    protected List<? extends ColumnDescriptor> myCurrentProducers;
    protected List<? extends GridRow> myCurrentRows;
    @Nullable
    private ImportDatabaseTableEditor<?> myEditor;
    private EditorModelBase.Listener myPreviewUpdater;
    private boolean myInitialNameWasSet;
    private String myGeneratedName;
    private String myCurrentName;
    private String myGeneratedComment;

    public TableEditorComponent(@NotNull Disposable disposable, @NotNull ImportSourceType sourceType, @Nullable List<? extends GridRow> initialRows, @NotNull String producerName, @Nullable String initialTargetTableName, @Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends ColumnDescriptor> visibleProducers) {
        if (disposable == null) {
            TableEditorComponent.$$$reportNull$$$0(0);
        }
        if (sourceType == null) {
            TableEditorComponent.$$$reportNull$$$0(1);
        }
        if (producerName == null) {
            TableEditorComponent.$$$reportNull$$$0(2);
        }
        this.myForm = new DatabaseTableEditorForm();
        this.myInitialNameWasSet = false;
        this.myGeneratedName = null;
        this.myCurrentName = null;
        this.myGeneratedComment = null;
        this.myDisposable = disposable;
        this.mySourceType = sourceType;
        this.myInitialRows = initialRows;
        this.myProducerName = producerName;
        this.myInitialTargetTableName = initialTargetTableName;
        this.myProducers = producers;
        this.myVisibleProducers = visibleProducers;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myForm.getMainPanel(), "Center");
    }

    @Nullable
    public ImportDatabaseTableEditor<?> getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected final ImportDatabaseTableEditor<?> createEditor(@NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @NotNull ImportEditorContext context, boolean shouldUpdateName) {
        if (descriptors == null) {
            TableEditorComponent.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(4);
        }
        String tableName = shouldUpdateName ? this.generateNewTableName(context) : Objects.requireNonNull(this.myEditor).getTable().name;
        String tableComment = this.getComment(context, tableName);
        DbTable existingTable = context.findTable(tableName);
        ImportType importType = existingTable == null ? ImportType.NEW_TABLE : ImportType.EXISTING_TABLE;
        DeModel deModel = AbstractDbRefactoringDialog.createModel(context);
        DeTable table = importType.createTable(context, deModel, descriptors, rows, this.mySourceType, this.myVisibleProducers, existingTable, tableName);
        table.name = tableName;
        this.myCurrentName = tableName;
        table.comment = tableComment;
        DatabaseEditorCapabilities.TableEditorCaps caps = SchemaEditor.forDbms(context.getDbms()).getDbEditorCaps().getTableEditorCaps(importType.tableExists());
        ImportTableNameForm tableNameForm = this.myEditor == null ? null : (ImportTableNameForm)ObjectUtils.tryCast((Object)this.myEditor.getTableNameForm(), ImportTableNameForm.class);
        ImportDatabaseTableEditor<?> editor2 = ImportUtil.createEditor(table, descriptors, context, this.myDisposable, caps, this.myForm, tableNameForm);
        if (this.myPreviewUpdater != null) {
            editor2.addListener(this.myPreviewUpdater, editor2);
        }
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = editor2;
        if (importDatabaseTableEditor == null) {
            TableEditorComponent.$$$reportNull$$$0(5);
        }
        return importDatabaseTableEditor;
    }

    protected final void setEditor(@NotNull ImportDatabaseTableEditor<?> editor2) {
        if (editor2 == null) {
            TableEditorComponent.$$$reportNull$$$0(6);
        }
        if (this.myEditor != null) {
            this.myEditor.setActive(false);
        }
        editor2.setActive(true);
        this.myEditor = editor2;
    }

    @Nullable
    private String getComment(@NotNull ImportEditorContext context, @NotNull String tableName) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(7);
        }
        if (tableName == null) {
            TableEditorComponent.$$$reportNull$$$0(8);
        }
        if (this.myEditor == null || this.myGeneratedComment == null || this.myGeneratedComment.equals(this.myEditor.getTable().comment)) {
            DbTable existingTable = context.findTable(tableName);
            this.myGeneratedComment = existingTable == null ? null : existingTable.getComment();
            return this.myGeneratedComment;
        }
        return this.myEditor.getTable().comment;
    }

    @NotNull
    private String generateNewTableName(@NotNull ImportEditorContext context) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(9);
        }
        if (this.myEditor == null || this.myGeneratedName == null || this.myGeneratedName.equals(this.myEditor.getTable().getName())) {
            this.myGeneratedName = !this.myInitialNameWasSet && this.myInitialTargetTableName != null ? this.myInitialTargetTableName : TableEditorComponent.generateNewName(context, this.myProducerName);
            this.myInitialNameWasSet = true;
            String string = this.myGeneratedName;
            if (string == null) {
                TableEditorComponent.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = this.myEditor.getTable().name;
        if (string == null) {
            TableEditorComponent.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public DeTable getDeTable(@NotNull ImportEditorContext context) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(12);
        }
        if (this.myEditor != null) {
            DeTable deTable = this.myEditor.getTable();
            if (deTable == null) {
                TableEditorComponent.$$$reportNull$$$0(13);
            }
            return deTable;
        }
        String tableName = this.getTableName(context);
        DbTable existingTable = context.findTable(tableName);
        ImportType importType = existingTable == null ? ImportType.NEW_TABLE : ImportType.EXISTING_TABLE;
        DeModel deModel = AbstractDbRefactoringDialog.createModel(context);
        DeTable deTable = importType.createTable(context, deModel, this.getDescriptors(), this.myInitialRows, this.mySourceType, this.myVisibleProducers, existingTable, tableName);
        if (deTable == null) {
            TableEditorComponent.$$$reportNull$$$0(14);
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTableName(@NotNull ImportEditorContext context) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(15);
        }
        return this.myEditor != null ? this.myEditor.getTable().name : this.generateNewTableName(context);
    }

    @NotNull
    protected List<? extends ColumnDescriptor> getDescriptors() {
        List<? extends ColumnDescriptor> list = this.myCurrentProducers != null ? this.myCurrentProducers : Objects.requireNonNull(this.myProducers);
        if (list == null) {
            TableEditorComponent.$$$reportNull$$$0(16);
        }
        return list;
    }

    public boolean hasProducers() {
        return this.myCurrentProducers != null || this.myProducers != null;
    }

    @NotNull
    public static String generateNewName(@NotNull ImportEditorContext context, @NotNull String producerName) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(17);
        }
        if (producerName == null) {
            TableEditorComponent.$$$reportNull$$$0(18);
        }
        String name2 = FileUtilRt.getNameWithoutExtension((String)producerName);
        Object result2 = name2;
        int index2 = 1;
        while (context.isTableExists((String)result2)) {
            result2 = name2 + "_" + index2++;
        }
        String string = result2;
        if (string == null) {
            TableEditorComponent.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TableEditorComponent.$$$reportNull$$$0(20);
        }
        return jPanel;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor == null ? null : this.myEditor.getPreferredFocusedComponent();
    }

    @Override
    public void addListener(final @NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            TableEditorComponent.$$$reportNull$$$0(21);
        }
        this.myPreviewUpdater = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DeTable deTable = Objects.requireNonNull(TableEditorComponent.this.myEditor).getTable();
                DeTable targetBeforeChange = deTable.getEditedDeObject();
                DbTable targetAfterChange = TableEditorComponent.this.myCurrentContext.findTable(deTable.name);
                if (!(targetBeforeChange == null && targetAfterChange == null || TableEditorComponent.this.myCurrentName != null && deTable.name.equals(TableEditorComponent.this.myCurrentName))) {
                    TableEditorComponent.this.recreateEditor();
                }
                TableEditorComponent.this.myCurrentName = deTable.name;
                listener2.changed(TableEditorComponent.this, new DdlPreviewComponent.DdlPreviewComponentInfo(TableEditorComponent.this.myEditor, TableEditorComponent.this.myCurrentContext));
            }
        };
        if (this.myEditor != null) {
            this.myEditor.addListener(this.myPreviewUpdater, this.myEditor);
        }
    }

    protected abstract void recreateEditor();

    @Override
    public void build(@NotNull ImportInfo.Builder builder, @NotNull ImportEditorContext context) {
        if (builder == null) {
            TableEditorComponent.$$$reportNull$$$0(22);
        }
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(23);
        }
        DeTable deTable = this.getDeTable(context);
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = this.myEditor != null ? ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping() : this.createMapping(deTable);
        SchemaApplyHelper helper = new SchemaApplyHelper(Objects.requireNonNullElse(this.myCurrentContext, context), deTable.model);
        BasicTable table = (BasicTable)((Object)Objects.requireNonNull(helper.apply(deTable)));
        builder.mapping(mapping).consumer(table).consumers(new ArrayList<AutoValueDescriptor>(mapping.keySet()));
    }

    @NotNull
    private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> createMapping(@NotNull DeTable deTable) {
        if (deTable == null) {
            TableEditorComponent.$$$reportNull$$$0(24);
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = new LinkedHashMap<AutoValueDescriptor, ColumnDescriptor>();
        HashSet busyDescriptors = new HashSet();
        for (DeColumn column2 : deTable.columns) {
            List descriptors = ContainerUtil.filter(this.myProducers, producer -> !busyDescriptors.contains(producer));
            Object descriptor2 = ColumnMappingStrategy.map(ImportUtilCore.createDescriptor(column2, false), descriptors);
            if (descriptor2 == null) {
                throw new AssertionError((Object)("Cannot find mapping for column " + column2.name));
            }
            busyDescriptors.add(descriptor2);
            mapping.put(ImportUtilCore.createDescriptor(column2, true), (ColumnDescriptor)descriptor2);
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> linkedHashMap = mapping;
        if (linkedHashMap == null) {
            TableEditorComponent.$$$reportNull$$$0(25);
        }
        return linkedHashMap;
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            TableEditorComponent.$$$reportNull$$$0(26);
        }
        return builder.getMapping() == null || builder.getTargetTable() == null;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myEditor == null) {
            return null;
        }
        TableEditorModel model2 = this.myEditor.getTableModel();
        if (model2.getName().isEmpty()) {
            return new ValidationInfo(DatabaseBundle.message("database.data.import.empty.name.error", new Object[0]), this.myEditor.getTableNameForm().getTableNameComponent());
        }
        JComponent columnEditorComponent = this.myEditor.getColumnsEditor().getComponent();
        if (model2.getColumnsCount() == 0) {
            return new ValidationInfo(DatabaseBundle.message("database.data.import.empty.table.error", new Object[0]), columnEditorComponent);
        }
        return this.checkMapping(this.myCurrentContext) ? null : new ValidationInfo(DatabaseBundle.message("database.data.import.mapping.error", new Object[0]), columnEditorComponent);
    }

    private boolean checkMapping(@NotNull ImportEditorContext context) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(27);
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = this.myEditor == null ? null : ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        String tableName = this.myEditor == null ? null : this.myEditor.getTable().name;
        return mapping == null || tableName == null || !context.getImportType(tableName).tableExists() || ContainerUtil.exists(mapping.values(), (Condition)Conditions.notNull());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 11, 13, 14, 16, 19, 20, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/component/TableEditorComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/component/TableEditorComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewTableName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeTable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateNewTableName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeTable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateNewName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 11, 13, 14, 16, 19, 20, 25 -> new IllegalStateException(string);
        };
    }

    public static class TableEditorComponentInfo {
        public final List<? extends ColumnDescriptor> myProducers;
        public final ImportEditorContext myContext;
        public final boolean myShouldUpdateTableName;
        public final List<? extends GridRow> myRows;

        private TableEditorComponentInfo(@Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends GridRow> rows, @Nullable ImportEditorContext context, boolean shouldUpdateTableName) {
            this.myProducers = producers;
            this.myRows = rows;
            this.myContext = context;
            this.myShouldUpdateTableName = shouldUpdateTableName;
        }

        public static TableEditorComponentInfo create(@Nullable DataGrid grid, @Nullable ImportEditorContext context) {
            return TableEditorComponentInfo.create(grid, context, true);
        }

        public static TableEditorComponentInfo create(@Nullable DataGrid grid, @Nullable ImportEditorContext context, boolean shouldUpdateTableName) {
            if (grid == null && context == null) {
                throw new IllegalArgumentException("At least one of the parameters has to be not null");
            }
            List<? extends GridColumn> columns2 = grid == null ? null : ImportUtil.getColumns(grid);
            List<? extends GridRow> rows = grid == null ? null : ImportUtil.getRows(grid);
            return TableEditorComponentInfo.create(columns2, rows, context, shouldUpdateTableName);
        }

        public static TableEditorComponentInfo create(@Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends GridRow> rows, @Nullable ImportEditorContext context) {
            return TableEditorComponentInfo.create(producers, rows, context, true);
        }

        public static TableEditorComponentInfo create(@Nullable List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable ImportEditorContext context, boolean shouldUpdateTableName) {
            if (descriptors == null && context == null) {
                throw new IllegalArgumentException("At least one of the parameters has to be not null");
            }
            return new TableEditorComponentInfo(descriptors, rows, context, shouldUpdateTableName);
        }
    }
}

