/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.scripted;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.extensions.DataConsumer;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptedSourceType
implements ImportAction.SourceType {
    private static final Object[] SENTINEL = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private final DataLoader myLoader;
    private final VirtualFile myInputFile;
    private final BlockingQueue<Object[]> myRows;
    @Nullable
    private final Boolean myFirstRowIsHeader;
    private final int myBatchSize;
    private volatile Object myState;

    public ScriptedSourceType(@NotNull DataLoader loader, @NotNull VirtualFile inputFile, @Nullable Boolean firstRowIsHeader, int batchSize) {
        if (loader == null) {
            ScriptedSourceType.$$$reportNull$$$0(0);
        }
        if (inputFile == null) {
            ScriptedSourceType.$$$reportNull$$$0(1);
        }
        this.myState = null;
        this.myLoader = loader;
        this.myFirstRowIsHeader = firstRowIsHeader;
        this.myInputFile = inputFile;
        this.myRows = new ArrayBlockingQueue<Object[]>(batchSize);
        this.myBatchSize = batchSize;
    }

    @NotNull
    public DataLoader getLoader() {
        DataLoader dataLoader = this.myLoader;
        if (dataLoader == null) {
            ScriptedSourceType.$$$reportNull$$$0(2);
        }
        return dataLoader;
    }

    @NotNull
    public VirtualFile getInputFile() {
        VirtualFile virtualFile = this.myInputFile;
        if (virtualFile == null) {
            ScriptedSourceType.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public Boolean getFirstRowIsHeader() {
        return this.myFirstRowIsHeader;
    }

    @Override
    @NotNull
    public ReaderTask.Source createSource(@NotNull ImportInfo info2) throws IOException {
        if (info2 == null) {
            ScriptedSourceType.$$$reportNull$$$0(4);
        }
        ReaderTask.Source source = this.createSource(info2.getContext().getProject(), info2.getProducers().size());
        if (source == null) {
            ScriptedSourceType.$$$reportNull$$$0(5);
        }
        return source;
    }

    @NotNull
    public ReaderTask.Source createSource(final @NotNull Project project, final int rowLength) throws IOException {
        if (project == null) {
            ScriptedSourceType.$$$reportNull$$$0(6);
        }
        return new ReaderTask.Source(){
            private Future<?> myFuture;
            private double mySize = 0.0;

            @Override
            @Nullable
            public ReaderTask.Result read() throws Exception {
                if (ScriptedSourceType.this.myState == null) {
                    this.runScript();
                }
                ProgressManager.checkCanceled();
                List<Object[]> rows = this.collectRows();
                if (rows.isEmpty()) {
                    return null;
                }
                Int2LongOpenHashMap lines = new Int2LongOpenHashMap();
                this.mySize += (double)rows.size();
                return new ReaderTask.ResultImpl(new BatchRecords(rows, (Int2LongMap)lines, this.mySize), 0L);
            }

            @NotNull
            private List<Object[]> collectRows() throws InterruptedException {
                Object[] row;
                ArrayList<Object[]> rows = new ArrayList<Object[]>(ScriptedSourceType.this.myBatchSize);
                while ((row = ScriptedSourceType.this.myRows.take()) != SENTINEL || ScriptedSourceType.this.myState == Boolean.TRUE) {
                    rows.add(row);
                }
                ScriptedSourceType.this.myRows.put(SENTINEL);
                if (rows.isEmpty() && ScriptedSourceType.this.myState instanceof Throwable) {
                    ExceptionUtil.rethrow((Throwable)((Throwable)ScriptedSourceType.this.myState));
                }
                ArrayList<Object[]> arrayList = rows;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private void runScript() {
                ScriptedSourceType.this.myState = Boolean.TRUE;
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
                    try {
                        ScriptedSourceType.this.myLoader.loadFromFile(project, ScriptedSourceType.this.myInputFile, new DataConsumer(){
                            boolean first = true;

                            public void consumeColumns(String[] names2, Class<?>[] types2) {
                            }

                            public void consume(Object ... row) {
                                try {
                                    ProgressManager.checkCanceled();
                                    if (this.skipRow()) {
                                        return;
                                    }
                                    if (rowLength != -1 && rowLength != row.length) {
                                        Object[] newRow = new Object[rowLength];
                                        System.arraycopy(row, 0, newRow, 0, Math.min(newRow.length, row.length));
                                        row = newRow;
                                    }
                                    ScriptedSourceType.this.myRows.put(row);
                                }
                                catch (InterruptedException exception) {
                                    throw new ProcessCanceledException((Throwable)exception);
                                }
                            }

                            private boolean skipRow() {
                                if (!this.first) {
                                    return false;
                                }
                                this.first = false;
                                return Boolean.TRUE.equals(ScriptedSourceType.this.myFirstRowIsHeader);
                            }
                        });
                        ScriptedSourceType.this.myState = false;
                    }
                    catch (Throwable th) {
                        ScriptedSourceType.this.myState = th;
                    }
                    ScriptedSourceType.this.myRows.add(SENTINEL);
                }, indicator));
            }

            @Override
            public void calculateSize(@NotNull Consumer<Double> callback) {
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.consume((Object)0.0);
            }

            @Override
            @NotNull
            public ImportIndicatorUpdater getIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder adder, @NotNull ImportInfo info2) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (adder == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (info2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return new ImportIndicatorUpdater(indicator, adder, info2){

                    @Override
                    @Nullable
                    public String calculateSpeed(long timeSpent) {
                        long size = Math.round(this.myCurrentSize / (double)timeSpent);
                        return size == 0L ? null : String.format("%s/s", StringUtil.formatFileSize((long)size));
                    }
                };
            }

            @Override
            public void close() throws Exception {
                this.myFuture.cancel(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dbimport/scripted/ScriptedSourceType$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callback";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "adder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "info";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "collectRows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dbimport/scripted/ScriptedSourceType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSize";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getIndicatorUpdater";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 4 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull CheckedDisposable disposable, @NotNull Project project, @NotNull ImportSourceType sourceType, @Nullable List<? extends ColumnDescriptor> producers, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String producerName, @Nullable String initialTargetTableName, boolean multipleSources) throws Exception {
        if (disposable == null) {
            ScriptedSourceType.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ScriptedSourceType.$$$reportNull$$$0(8);
        }
        if (sourceType == null) {
            ScriptedSourceType.$$$reportNull$$$0(9);
        }
        if (producerName == null) {
            ScriptedSourceType.$$$reportNull$$$0(10);
        }
        List<ImportComponent<?, ?>> list = Collections.emptyList();
        if (list == null) {
            ScriptedSourceType.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @Nls
    @NotNull
    public String getProducerName() {
        String string = this.myInputFile.getName();
        if (string == null) {
            ScriptedSourceType.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportEditorContext context, @NotNull DeModel deModel, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            ScriptedSourceType.$$$reportNull$$$0(13);
        }
        if (deModel == null) {
            ScriptedSourceType.$$$reportNull$$$0(14);
        }
        if (descriptors == null) {
            ScriptedSourceType.$$$reportNull$$$0(15);
        }
        if (tableName == null) {
            ScriptedSourceType.$$$reportNull$$$0(16);
        }
        DeTable deTable = ImportUtil.createTable(context, deModel, descriptors, rows, (Function<? super ImportUtil.ColumnTypePredictorInfo, String>)((Function)info2 -> ImportUtilCore.getPreferredTypeBasedOnContent(info2.column, info2.rows, info2.dbms, DbImplUtilCore.getDatabaseVersion(info2.dataSource))), visibleProducers, tableName);
        if (deTable == null) {
            ScriptedSourceType.$$$reportNull$$$0(17);
        }
        return deTable;
    }

    @Override
    @NotNull
    public BasicModTable createNewTable(@NotNull ImportEditorContext context, @NotNull BasicModModel model2, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<? extends GridRow> rows, @Nullable List<? extends ColumnDescriptor> visibleProducers, @NotNull String tableName) {
        if (context == null) {
            ScriptedSourceType.$$$reportNull$$$0(18);
        }
        if (model2 == null) {
            ScriptedSourceType.$$$reportNull$$$0(19);
        }
        if (descriptors == null) {
            ScriptedSourceType.$$$reportNull$$$0(20);
        }
        if (tableName == null) {
            ScriptedSourceType.$$$reportNull$$$0(21);
        }
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        BasicModTable table = ImportUtil.instantiateTable(context, model2);
        Objects.requireNonNull(table);
        table.setName(tableName);
        Version version = DbImplUtilCore.getDatabaseVersion(context.getDataSource());
        Dbms dbms = context.getDbms();
        ImportUtil.fillTableColumns(table, producers, (Function<? super Integer, String>)((Function)i2 -> ImportUtilCore.getPreferredTypeBasedOnContent((ColumnDescriptor)producers.get((int)i2), rows, dbms, version)));
        BasicModTable basicModTable = table;
        if (basicModTable == null) {
            ScriptedSourceType.$$$reportNull$$$0(22);
        }
        return basicModTable;
    }

    @Override
    @Nullable
    public FormatterCreator getFormatterCreator() {
        return null;
    }

    @Override
    @Nullable
    public DasDataSource getProducerSystem() {
        return null;
    }

    @Override
    @NotNull
    @Nls
    @NlsContexts.DialogTitle
    public String getDialogTitle() {
        return "Scripted";
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            ScriptedSourceType.$$$reportNull$$$0(23);
        }
        return dbms;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 11, 12, 17, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 17: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/scripted/ScriptedSourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deModel";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/scripted/ScriptedSourceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 17: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 17: 
            case 22: 
            case 23: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 11, 12, 17, 22, 23 -> new IllegalStateException(string);
        };
    }
}

