/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.graph;

import com.intellij.database.util.AsyncUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphObservable<V> {
    private final List<Consumer<Throwable>> myListeners;
    private final MultiMap<GraphObserver, GraphObserver> myMap;
    private final GraphObserver<V, ?> myRoot;
    private V myInitializer;

    private GraphObservable(@NotNull MultiMap<GraphObserver, GraphObserver> map2, @NotNull GraphObserver<V, ?> root2) {
        if (map2 == null) {
            GraphObservable.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            GraphObservable.$$$reportNull$$$0(1);
        }
        this.myMap = map2;
        this.myRoot = root2;
        this.myListeners = new ArrayList<Consumer<Throwable>>();
        ObserverListener listener2 = new ObserverListener(this);
        for (GraphObserver observer : map2.keySet()) {
            observer.addListener(listener2);
        }
    }

    @NotNull
    public GraphObserver<V, ?> getRoot() {
        GraphObserver<V, ?> graphObserver = this.myRoot;
        if (graphObserver == null) {
            GraphObservable.$$$reportNull$$$0(2);
        }
        return graphObserver;
    }

    @NotNull
    public CompletionStage<?> init() {
        CompletionStage<?> completionStage = this.changed(this.myInitializer);
        if (completionStage == null) {
            GraphObservable.$$$reportNull$$$0(3);
        }
        return completionStage;
    }

    public void initializer(V initializer) {
        this.myInitializer = initializer;
    }

    @NotNull
    public CompletionStage<?> changed(V object) {
        CompletionStage completionStage = this.myRoot.notifyChanged(object).thenCompose(o2 -> GraphObservable.notifyObservers(this.myRoot, this, new HashSet(), o2).whenComplete((o1, e1) -> this.changed((Throwable)e1)));
        if (completionStage == null) {
            GraphObservable.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    public void addListener(@NotNull Consumer<Throwable> consumer2) {
        if (consumer2 == null) {
            GraphObservable.$$$reportNull$$$0(5);
        }
        this.myListeners.add(consumer2);
    }

    private void changed(@Nullable Throwable throwable) {
        this.myListeners.forEach(listener2 -> listener2.consume((Object)AsyncUtil.unwrap(throwable)));
    }

    @NotNull
    private Collection<GraphObserver> next(@NotNull GraphObserver<?, ?> first2) {
        if (first2 == null) {
            GraphObservable.$$$reportNull$$$0(6);
        }
        Collection collection2 = this.myMap.get(first2);
        if (collection2 == null) {
            GraphObservable.$$$reportNull$$$0(7);
        }
        return collection2;
    }

    @NotNull
    private static <V> CompletionStage<?> notifyObservers(@NotNull GraphObserver<?, ?> observer, @NotNull GraphObservable<V> observable, @NotNull Set<GraphObserver<?, ?>> set, @Nullable Object o2) {
        if (observer == null) {
            GraphObservable.$$$reportNull$$$0(8);
        }
        if (observable == null) {
            GraphObservable.$$$reportNull$$$0(9);
        }
        if (set == null) {
            GraphObservable.$$$reportNull$$$0(10);
        }
        if (set.contains(observer)) {
            throw new IllegalStateException();
        }
        set.add(observer);
        Collection<GraphObserver> next = observable.next(observer);
        if (next.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                GraphObservable.$$$reportNull$$$0(11);
            }
            return completableFuture;
        }
        CompletableFuture[] futures = (CompletableFuture[])next.stream().map(graphObserver -> graphObserver.notifyChanged(Objects.requireNonNull(o2)).thenCompose(obj2 -> GraphObservable.notifyObservers(graphObserver, observable, set, obj2))).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        if (completableFuture == null) {
            GraphObservable.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/graph/GraphObservable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/graph/GraphObservable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "changed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyObservers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyObservers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static interface GraphObserver<IN, OUT> {
        public void addListener(@NotNull ObserverListener<?> var1);

        @NotNull
        public CompletionStage<OUT> notifyChanged(@NotNull IN var1);

        public boolean isParentFor(@NotNull GraphObserver<?, ?> var1);
    }

    public static class ObserverListener<V>
    implements EventListener {
        private final GraphObservable<V> myObservable;

        public ObserverListener(@NotNull GraphObservable<V> observable) {
            if (observable == null) {
                ObserverListener.$$$reportNull$$$0(0);
            }
            this.myObservable = observable;
        }

        public void changed(GraphObserver<?, ?> observer, Object object) {
            GraphObservable.notifyObservers(observer, this.myObservable, new HashSet(), object).whenComplete((o2, e2) -> this.myObservable.changed((Throwable)e2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable$ObserverListener", "<init>"));
        }
    }

    public static class Builder<IN, OUT> {
        private final List<GraphObserver<?, ?>> myObservers = new ArrayList();
        private final List<GraphObserver<?, ?>> myInvisibleObservers = new ArrayList();
        private GraphObserver<IN, OUT> myRoot;

        @NotNull
        public Builder<IN, OUT> add(@NotNull List<? extends GraphObserver<?, ?>> observers) {
            if (observers == null) {
                Builder.$$$reportNull$$$0(0);
            }
            for (GraphObserver<?, ?> observer : observers) {
                this.add(observer);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder<IN, OUT> add(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myObservers.add(observer);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder<IN, OUT> addInvisible(@NotNull Collection<? extends GraphObserver<?, ?>> observers) {
            if (observers == null) {
                Builder.$$$reportNull$$$0(4);
            }
            for (GraphObserver<?, ?> observer : observers) {
                this.addInvisible(observer);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder<IN, OUT> addInvisible(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myInvisibleObservers.add(observer);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder<IN, OUT> root(@NotNull GraphObserver<IN, OUT> root2) {
            if (root2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myRoot = root2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public GraphObservable<IN> build() {
            MultiMap map2 = new MultiMap();
            for (GraphObserver<?, ?> observer : this.myObservers) {
                List<GraphObserver<?, ?>> children2 = this.children(observer);
                for (GraphObserver<?, ?> child : children2) {
                    map2.putValue(observer, child);
                }
            }
            return new GraphObservable<IN>((MultiMap<GraphObserver, GraphObserver>)map2, this.myRoot);
        }

        @NotNull
        private List<GraphObserver<?, ?>> children(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                Builder.$$$reportNull$$$0(10);
            }
            ArrayList list = new ArrayList();
            for (GraphObserver<?, ?> invisible : this.myInvisibleObservers) {
                if (observer == invisible || !observer.isParentFor(invisible)) continue;
                list.addAll(this.children(invisible));
            }
            for (GraphObserver<?, ?> current : this.myObservers) {
                if (observer == current || !observer.isParentFor(current)) continue;
                list.add(current);
            }
            ArrayList arrayList = list;
            if (arrayList == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 7, 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "observers";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/graph/GraphObservable$Builder";
                    break;
                }
                case 2: 
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "observer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/graph/GraphObservable$Builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addInvisible";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "root";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addInvisible";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "root";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 7, 9, 11 -> new IllegalStateException(string);
            };
        }
    }
}

