/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.ui.preview.CsvFormatPreview;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.ui.DbComboBoxEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.settings.CsvFormatsComponent;
import com.intellij.database.settings.CsvSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCsvFormatEditor<E extends BasicElement>
extends DbComboBoxEditor<E, CsvFormat, DbSingleValueModelState<CsvFormat>> {
    public DbCsvFormatEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbSingleValueModelState<CsvFormat>> model2) {
        if (controller == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(1);
        }
        super(controller, model2);
        this.myBox.setEditable(true);
        this.myBox.setEditor(new ComboBoxEditor(){
            private Object myFormat = null;
            private final SimpleColoredComponent myRenderer = new SimpleColoredComponent();
            private final JComponent myComponent = new JPanel(new BorderLayout());
            {
                ActionToolbar tb = DbCsvFormatEditor.this.createToolbar();
                tb.setMinimumButtonSize((Dimension)JBUI.size((int)16, (int)16));
                this.myComponent.add((Component)this.myRenderer, "Center");
                this.myComponent.add((Component)tb.getComponent(), "East");
            }

            @Override
            public Component getEditorComponent() {
                return this.myComponent;
            }

            @Override
            public void setItem(Object o2) {
                this.myFormat = o2;
                this.myRenderer.clear();
                DbCsvFormatEditor.this.renderItem(o2, this.myRenderer);
            }

            @Override
            public Object getItem() {
                return this.myFormat;
            }

            @Override
            public void selectAll() {
            }

            @Override
            public void addActionListener(ActionListener listener2) {
            }

            @Override
            public void removeActionListener(ActionListener listener2) {
            }
        });
    }

    @Override
    protected void renderNullValue(SimpleColoredComponent renderer2) {
        renderer2.append(DatabaseBundle.message("DbCsvFormatEditor.detect", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    private ActionToolbar createToolbar() {
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{DumbAwareAction.create((Icon)AllIcons.Actions.Edit, e2 -> this.edit())}), true);
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setTargetComponent((JComponent)this.myBox);
        ActionToolbar actionToolbar = toolbar2;
        if (actionToolbar == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(2);
        }
        return actionToolbar;
    }

    private void edit() {
        Disposable disposable = Disposer.newDisposable();
        List<CsvFormat> formats = DbCsvFormatEditor.getFormats();
        CsvFormat format2 = (CsvFormat)ObjectUtils.tryCast((Object)this.myBox.getSelectedItem(), CsvFormat.class);
        TableCsvFormatPreview preview = this.createPreview(format2, disposable);
        CsvFormatsComponent component2 = preview == null ? new CsvFormatsComponent() : new CsvFormatsComponent((CsvFormatPreview)preview);
        Disposer.register((Disposable)component2, (Disposable)disposable);
        DialogBuilder builder = new DialogBuilder(this.getController().getProject()).title(DataGridBundle.message((String)"dialog.title.csv.formats", (Object[])new Object[0])).dimensionKey(this.getClass().getName()).centerPanel(component2.getComponent());
        builder.setHelpId("Data_Extractors_dialog");
        builder.addDisposable((Disposable)component2);
        String curName = format2 == null ? null : format2.name;
        boolean exists = format2 == null || formats.contains(format2);
        component2.reset(formats, exists ? curName : null);
        if (!exists) {
            format2 = component2.select(format2);
        }
        if (builder.show() == 0) {
            List newFormats = component2.getFormats();
            DbCsvFormatEditor.setFormats(newFormats);
            CsvFormat selected = component2.getSelectedFormat();
            if (selected == null) {
                selected = format2;
            }
            this.myBox.setSelectedItem(newFormats.contains(selected) ? selected : ObjectUtils.NULL);
            this.updateModel();
        }
    }

    public static void setFormats(@NotNull List<CsvFormat> formats) {
        CsvSettings settings;
        if (formats == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(3);
        }
        if (formats != (settings = CsvSettings.getSettings()).getCsvFormats()) {
            settings.setCsvFormats(formats);
            settings.fireChanged();
        }
    }

    @NotNull
    public static List<CsvFormat> getFormats() {
        List list = CsvSettings.getSettings().getCsvFormats();
        if (list == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.SMALL;
        if (fieldSize == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(5);
        }
        return fieldSize;
    }

    @Nullable
    public static DynamicCsvFormat detectFormat(@NotNull Project project, @NotNull VirtualFile file) {
        CsvFormat existingFormat;
        CsvFormat format2;
        if (project == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(6);
        }
        if (file == null) {
            DbCsvFormatEditor.$$$reportNull$$$0(7);
        }
        if ((format2 = CsvFormatResolver.getFormat((Project)project, (VirtualFile)file, (boolean)true, DbCsvFormatEditor::getFormats, (CsvFormatResolver.FormatGetter[])new CsvFormatResolver.FormatGetter[]{CsvFormatResolver.FormatGetter.CONTENT})) == null) {
            return null;
        }
        List<CsvFormat> existing = DbCsvFormatEditor.getFormats();
        if (existing.contains(format2)) {
            existingFormat = format2;
        } else {
            existingFormat = (CsvFormat)ContainerUtil.find(existing, f -> f.dataRecord.equals((Object)format2.dataRecord));
            if (existingFormat == null) {
                return null;
            }
        }
        return DynamicCsvFormat.from(existingFormat, format2);
    }

    @Nullable
    private TableCsvFormatPreview createPreview(CsvFormat format2, Disposable disposable) {
        DbImportDataPreviewManager previewManager = DbImportDataPreviewManager.getInstance(this.getController().getModelController());
        if (previewManager == null || format2 == null) {
            return null;
        }
        CsvPreviewModel model2 = previewManager.getPreviewModel(this.getIdentity());
        if (model2 == null) {
            return null;
        }
        return new TableCsvFormatPreview(this.getController().getProject(), format2, (CharSequence)model2.getText(), disposable, null);
    }

    @Override
    protected void renderValue(ColoredTextContainer renderer2, CsvFormat value2) {
        boolean existing = DbCsvFormatEditor.getFormats().contains(value2);
        boolean detected = !existing;
        SimpleTextAttributes attributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (!existing) {
            attributes2 = attributes2.derive(attributes2.getStyle(), FileStatus.ADDED.getColor(), attributes2.getBgColor(), attributes2.getWaveColor());
        }
        renderer2.append(value2.name, attributes2);
        if (detected) {
            renderer2.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer2.append(DatabaseBundle.message("label.csv.format.detected", new Object[0]), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        }
    }

    @Override
    protected JBIterable<CsvFormat> prepareItems() {
        return JBIterable.from(DbCsvFormatEditor.getFormats());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/editor/DbCsvFormatEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbCsvFormatEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setFormats";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    public record DynamicCsvFormat(@NotNull CsvFormat existing, boolean firstRowIsHeader, boolean firstColumnIsHeader, boolean trimWhitespaces) {
        @NotNull
        private final CsvFormat existing;

        public DynamicCsvFormat(@NotNull CsvFormat existing, boolean firstRowIsHeader, boolean firstColumnIsHeader, boolean trimWhitespaces) {
            if (existing == null) {
                DynamicCsvFormat.$$$reportNull$$$0(0);
            }
        }

        @Nullable
        public static DynamicCsvFormat from(@Nullable CsvSourceData data) {
            if (data == null || data.getFormat() == null) {
                return null;
            }
            return new DynamicCsvFormat(data.getFormat(), data.getFirstRowIsHeader(), data.getFirstColumnIsHeader(), data.getTrimWhitespaces());
        }

        @NotNull
        public static DynamicCsvFormat from(@NotNull CsvFormat existingFormat, @NotNull CsvFormat format2) {
            if (existingFormat == null) {
                DynamicCsvFormat.$$$reportNull$$$0(1);
            }
            if (format2 == null) {
                DynamicCsvFormat.$$$reportNull$$$0(2);
            }
            return new DynamicCsvFormat(existingFormat, format2.headerRecord != null, format2.rowNumbers, format2.dataRecord.trimWhitespace);
        }

        public void applyTo(@NotNull CsvSourceData data) {
            if (data == null) {
                DynamicCsvFormat.$$$reportNull$$$0(3);
            }
            data.setFormat(this.existing);
            data.setFirstRowIsHeader(this.firstRowIsHeader);
            data.setFirstColumnIsHeader(this.firstColumnIsHeader);
            data.setTrimWhitespaces(this.trimWhitespaces);
        }

        @NotNull
        public CsvFormat getEffectiveFormat() {
            CsvRecordFormat dataRecord = this.existing.dataRecord.withTrimWhitespaces(this.trimWhitespaces);
            CsvRecordFormat headerRecord = !this.firstRowIsHeader ? null : (this.existing.headerRecord == null ? dataRecord : this.existing.headerRecord.withTrimWhitespaces(this.existing.headerRecord.trimWhitespace || this.trimWhitespaces));
            return new CsvFormat(dataRecord, headerRecord, this.firstColumnIsHeader);
        }

        @NotNull
        public CsvFormat existing() {
            CsvFormat csvFormat = this.existing;
            if (csvFormat == null) {
                DynamicCsvFormat.$$$reportNull$$$0(4);
            }
            return csvFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existing";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingFormat";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/editor/editor/DbCsvFormatEditor$DynamicCsvFormat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbCsvFormatEditor$DynamicCsvFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "existing";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyTo";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

