/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.MultiInsertRowsTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseDialogsHelperCore;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportManager {
    public static final DbmsExtension<ImportManager> EP = new DbmsExtension("com.intellij.database.dataImporter");
    private final boolean myUseBatches;
    private final boolean myUseSavepoints;
    private final boolean myUseTransactions;
    private final TypeMerger[] myMergers;
    private final Dbms myDbms;
    private final TypeMerger.StringMerger myStringMerger;
    private final int myLinesPerStatement;
    private final boolean mySupportFastMode;

    protected ImportManager(@NotNull Dbms dbms, @NotNull String myTextType, int batchSize, TypeMerger ... mergers) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(0);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(1);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(2);
        }
        this(dbms, myTextType, batchSize, false, true, true, true, mergers);
    }

    protected ImportManager(@NotNull Dbms dbms, @NotNull String myTextType, int linesPerStatement, boolean supportFastMode, boolean useBatches, boolean useSavepoints, boolean useTransactions, TypeMerger ... mergers) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(3);
        }
        if (myTextType == null) {
            ImportManager.$$$reportNull$$$0(4);
        }
        if (mergers == null) {
            ImportManager.$$$reportNull$$$0(5);
        }
        this.myDbms = dbms;
        this.myUseBatches = useBatches;
        this.myUseSavepoints = useSavepoints;
        this.myUseTransactions = useTransactions;
        this.myMergers = mergers;
        this.myStringMerger = new TypeMerger.StringMerger(myTextType);
        this.myLinesPerStatement = linesPerStatement;
        this.mySupportFastMode = supportFastMode;
        Arrays.sort(this.myMergers, Comparator.comparingInt(TypeMerger::getPriority));
    }

    public boolean shouldUseBatches() {
        return this.myUseBatches;
    }

    public boolean shouldUseSavepoints() {
        return this.myUseSavepoints;
    }

    public boolean shouldUseTransactions() {
        return this.myUseTransactions;
    }

    @NotNull
    public TypeMerger.StringMerger getStringMerger() {
        TypeMerger.StringMerger stringMerger = this.myStringMerger;
        if (stringMerger == null) {
            ImportManager.$$$reportNull$$$0(6);
        }
        return stringMerger;
    }

    public TypeMerger @NotNull [] getMergers() {
        if (this.myMergers == null) {
            ImportManager.$$$reportNull$$$0(7);
        }
        return this.myMergers;
    }

    @NotNull
    public static String getInsertStatement(@NotNull ImportInfo info2, int linesCount2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(8);
        }
        Dbms dbms = info2.getContext().getDbms();
        List<AutoValueDescriptor> columnsForInsert = info2.getConsumersForInsert();
        MultiInsertRowsTask task = DmlTaskKt.multiInsert(info2.cache().getBasicTable(), linesCount2, columnsForInsert, true).build(ImportManager.createBuilder(info2.getContext()));
        String string = DmlUtilKt.dmlGenerator(dbms).generate(task).getStatement();
        if (string == null) {
            ImportManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    public int getLinesPerStatement() {
        return this.myLinesPerStatement;
    }

    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public String getLockQuery(@NotNull ImportInfo info2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(14);
        }
        return null;
    }

    public boolean isSupportFastMode() {
        return this.mySupportFastMode;
    }

    @NotNull
    public List<ConnectionStateSwitch> getConnectionStateSwitches(@NotNull ImportInfo info2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ImportManager.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected boolean isSuitable(@Nullable Version productVersion) {
        return true;
    }

    @NotNull
    public static DdlBuilder createBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(17);
        }
        return ImportManager.createConfiguredBuilder(context);
    }

    @NotNull
    protected List<String> getQueries(@NotNull ImportInfo info2, boolean before2) {
        if (info2 == null) {
            ImportManager.$$$reportNull$$$0(18);
        }
        List<String> list = Collections.singletonList(this.triggers(this.alter(ImportManager.createBuilder(info2.getContext()), "TABLE", info2.cache().getBasicTable()).space(), !before2).getStatement());
        if (list == null) {
            ImportManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected DdlBuilder triggers(@NotNull DdlBuilder builder, boolean enable) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = builder.keyword(enable ? "ENABLE" : "DISABLE").space().keyword("TRIGGER").space().keyword("ALL");
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(22);
        }
        return dbms;
    }

    @NotNull
    protected DdlBuilder alter(@NotNull DdlBuilder builder, @NotNull String objectToAlter, @NotNull DasObject table) {
        if (builder == null) {
            ImportManager.$$$reportNull$$$0(23);
        }
        if (objectToAlter == null) {
            ImportManager.$$$reportNull$$$0(24);
        }
        if (table == null) {
            ImportManager.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = builder.keyword("ALTER").space().keyword(objectToAlter).space().qualifiedRef(table);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @NotNull
    public static ImportManager of(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            ImportManager.$$$reportNull$$$0(27);
        }
        for (ImportManager manager : EP.allForDbms(dbms)) {
            if (!manager.isSuitable(version)) continue;
            ImportManager importManager = manager;
            if (importManager == null) {
                ImportManager.$$$reportNull$$$0(28);
            }
            return importManager;
        }
        if (!dbms.is(Dbms.UNKNOWN)) {
            return ImportManager.of(Dbms.UNKNOWN, null);
        }
        throw new AssertionError();
    }

    @NotNull
    public static DdlBuilder createConfiguredBuilder(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            ImportManager.$$$reportNull$$$0(29);
        }
        DdlBuilder ddlBuilder = DatabaseDialogsHelperCore.createDdlBuilder(context, false);
        if (ddlBuilder == null) {
            ImportManager.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 11, 13, 16, 19, 21, 22, 26, 28, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTextType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergers";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectToAlter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringMerger";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertStatement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionStateSwitches";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "triggers";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "alter";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguredBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 30: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInsertStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLockQuery";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionStateSwitches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "triggers";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "alter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguredBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 11, 13, 16, 19, 21, 22, 26, 28, 30 -> new IllegalStateException(string);
        };
    }

    public static interface ConnectionStateSwitch {
        public void turnOn(@NotNull DatabaseConnectionCore var1);

        public void turnOff(@NotNull DatabaseConnectionCore var1);
    }
}

