/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataTypeConversionUtil;
import com.intellij.database.data.types.DbConversionGraph;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.FormatterCreatorProvider;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DatabaseFormatterCreatorTarget;
import com.intellij.database.dbimport.ErrorTaskInfo;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.Version;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportInfo {
    private final CsvFormat myFormat;
    private final BasicTable myTargetTable;
    private final String myProducerName;
    private final ImportSourceType myInputType;
    private final ErrorTaskInfo myErrorTaskInfo;
    private final boolean myLockTable;
    private final List<? extends ColumnDescriptor> myProducers;
    private final Cache myCache;
    private final DatabaseEditorContext myContext;
    private final boolean myInsertAsNull;
    private Map<AutoValueDescriptor, ? extends ColumnDescriptor> myConsumerToProducer;
    private List<AutoValueDescriptor> myConsumers;

    private ImportInfo(@Nullable CsvFormat format2, @NotNull BasicTable targetTable, @NotNull List<AutoValueDescriptor> consumers, @NotNull List<? extends ColumnDescriptor> producers, @NotNull Map<AutoValueDescriptor, ? extends ColumnDescriptor> map2, @NotNull String producerName, @NotNull DatabaseEditorContext context, @NotNull ImportSourceType inputType, @NotNull ErrorTaskInfo errorTaskInfo, boolean lockTable, boolean insertAsNull) {
        if (targetTable == null) {
            ImportInfo.$$$reportNull$$$0(0);
        }
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(1);
        }
        if (producers == null) {
            ImportInfo.$$$reportNull$$$0(2);
        }
        if (map2 == null) {
            ImportInfo.$$$reportNull$$$0(3);
        }
        if (producerName == null) {
            ImportInfo.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ImportInfo.$$$reportNull$$$0(5);
        }
        if (inputType == null) {
            ImportInfo.$$$reportNull$$$0(6);
        }
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(7);
        }
        this.myFormat = format2;
        this.myTargetTable = targetTable;
        this.myProducers = producers;
        this.myProducerName = producerName;
        this.myInputType = inputType;
        this.myErrorTaskInfo = errorTaskInfo;
        this.myLockTable = lockTable;
        this.myConsumers = consumers;
        this.myConsumerToProducer = map2;
        this.myContext = context;
        this.myInsertAsNull = insertAsNull;
        FormatterCreator creator = this.myInputType.getFormatterCreator();
        creator = creator != null ? creator : FormatterCreatorProvider.getCreator((FormatterCreatorProvider.FormatterCreatorTarget)new DatabaseFormatterCreatorTarget(targetTable));
        this.myCache = new Cache(creator);
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumersForInsert() {
        return this.mappedConsumers();
    }

    @NotNull
    public List<? extends ColumnDescriptor> getProducers() {
        List<? extends ColumnDescriptor> list = this.myProducers;
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public ImportSourceType getInputType() {
        ImportSourceType importSourceType = this.myInputType;
        if (importSourceType == null) {
            ImportInfo.$$$reportNull$$$0(9);
        }
        return importSourceType;
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNull;
    }

    @Nullable
    public CsvFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTargetTable.getName();
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            ImportInfo.$$$reportNull$$$0(11);
        }
        return databaseEditorContext;
    }

    @NotNull
    public ObjectPath getTablePath() {
        ObjectPath objectPath = ObjectPaths.of(this.myTargetTable);
        if (objectPath == null) {
            ImportInfo.$$$reportNull$$$0(12);
        }
        return objectPath;
    }

    @NotNull
    public ImportType getType() {
        ImportType importType = this.myContext instanceof ImportEditorContext ? ((ImportEditorContext)this.myContext).getImportType(this.getTableName()) : ImportType.EXISTING_TABLE;
        if (importType == null) {
            ImportInfo.$$$reportNull$$$0(13);
        }
        return importType;
    }

    @NotNull
    public ErrorTaskInfo getErrorTaskInfo() {
        ErrorTaskInfo errorTaskInfo = this.myErrorTaskInfo;
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(14);
        }
        return errorTaskInfo;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getProducerName() {
        String string = this.myProducerName;
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public Cache cache() {
        Cache cache2 = this.myCache;
        if (cache2 == null) {
            ImportInfo.$$$reportNull$$$0(16);
        }
        return cache2;
    }

    public void setConsumers(@NotNull List<JdbcColumnDescriptor> consumers) {
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(17);
        }
        LinkedHashMap<AutoValueDescriptor, ? extends ColumnDescriptor> newMapping = new LinkedHashMap<AutoValueDescriptor, ColumnDescriptor>();
        ArrayList<AutoValueDescriptor> newConsumers = new ArrayList<AutoValueDescriptor>();
        for (JdbcColumnDescriptor consumer2 : consumers) {
            AutoValueDescriptor oldOne = this.findOldConsumer((ColumnDescriptor)consumer2);
            boolean autogenerated = oldOne != null && oldOne.isAutogenerated();
            boolean hasDefault = oldOne != null && oldOne.hasDefault();
            boolean computed = oldOne != null && oldOne.isComputed();
            AutoValueDescriptor newOne = ImportUtilCore.createDescriptor(consumer2, autogenerated, hasDefault, computed);
            newConsumers.add(newOne);
            newMapping.put(newOne, oldOne == null ? null : this.myConsumerToProducer.get(oldOne));
        }
        this.myConsumers = newConsumers;
        this.myConsumerToProducer = newMapping;
    }

    @Nullable
    private AutoValueDescriptor findOldConsumer(@NotNull ColumnDescriptor consumer2) {
        if (consumer2 == null) {
            ImportInfo.$$$reportNull$$$0(18);
        }
        String name2 = consumer2.getName();
        Dbms dbms = this.myContext.getDbms();
        BasicModel model2 = Objects.requireNonNull(this.myContext.getModel());
        NamingService namingService2 = NamingServices.getNamingService(dbms, model2);
        Casing casing = model2.getCasing(ObjectKind.COLUMN, null);
        return (AutoValueDescriptor)ContainerUtil.find(this.myConsumers, c2 -> {
            String candidate2 = c2.getName();
            boolean quoted = namingService2.isQuoted(name2);
            candidate2 = namingService2.unquoteIdentifier(candidate2);
            return Comparing.equal((String)candidate2, (String)name2, (boolean)casing.choose((boolean)DasSchemaExporters.treatAsPlainIdentifier((String)candidate2, (boolean)quoted, null, (boolean)false)).sensitive);
        });
    }

    @NotNull
    private List<AutoValueDescriptor> mappedConsumers() {
        List list = ContainerUtil.filter(this.myConsumers, consumer2 -> this.myConsumerToProducer.get(consumer2) != null);
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTable";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTaskInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTablePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTaskInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "cache";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mappedConsumers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setConsumers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findOldConsumer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15, 16, 19 -> new IllegalStateException(string);
        };
    }

    public class Cache {
        private final Map<ColumnDescriptor, Integer> myCachedMapping;
        private final Map<ColumnDescriptor, Domain> myCachedDomains;
        private final Map<Object, Function<Object, Object>> myConverters;
        private final Map<Object, Function<Object, Object>> myNullValueConverters;
        private final ObjectToTextConverter myToTextConverter;
        private final FormatsCache myFormatsCache;
        private final ConversionGraph myGraph;
        private final FormatterCreator myFormatterCreator;

        Cache(FormatterCreator formatterCreator) {
            if (formatterCreator == null) {
                Cache.$$$reportNull$$$0(0);
            }
            this.myCachedMapping = new HashMap<ColumnDescriptor, Integer>();
            this.myCachedDomains = new HashMap<ColumnDescriptor, Domain>();
            this.myConverters = new HashMap<Object, Function<Object, Object>>();
            this.myNullValueConverters = new HashMap<Object, Function<Object, Object>>();
            this.myFormatterCreator = formatterCreator;
            this.myFormatsCache = new FormatsCache();
            DbObjectFormatter formatter = new DbObjectFormatter(ImportInfo.this.myInputType.getDbms());
            this.myGraph = new DbConversionGraph(this.myFormatsCache, formatterCreator, () -> formatter);
            this.myToTextConverter = new ObjectToTextConverter(this.myGraph);
        }

        public Object @NotNull [] convertLine(Object @NotNull [] objects2) throws ConversionException {
            if (objects2 == null) {
                Cache.$$$reportNull$$$0(1);
            }
            List<AutoValueDescriptor> consumers = ImportInfo.this.mappedConsumers();
            Object[] convertedLine = new Object[ImportInfo.this.myProducers.size()];
            for (AutoValueDescriptor consumer2 : consumers) {
                boolean originalValueIsEmpty;
                ColumnDescriptor producer;
                int index2 = this.getProducerIndex(consumer2);
                Object o2 = index2 == -1 ? null : DbObjectFormatterUtil.unwrap(index2 < objects2.length ? objects2[index2] : null);
                Function<Object, Object> converter = this.getConverter(o2, (ColumnDescriptor)consumer2, producer = ImportInfo.this.myProducers.get(index2));
                Object converted = converter == null ? (this.getDomain((ColumnDescriptor)consumer2) != null ? null : this.myToTextConverter.convert(o2, producer)) : converter.fun(o2);
                boolean bl = originalValueIsEmpty = o2 == null || o2 instanceof String && ((String)o2).isEmpty();
                if (!ImportInfo.this.myInsertAsNull && !originalValueIsEmpty && converted == null) {
                    Object text2 = this.myToTextConverter.convert(o2, producer);
                    throw new ConversionException(text2 == null ? o2 : text2, consumer2.getTypeName(), consumer2.getName(), index2);
                }
                convertedLine[index2] = DbImplUtilCore.prepareValue(ImportInfo.this.myContext.getDbms(), converted, this.myFormatsCache, this.myFormatterCreator);
            }
            if (convertedLine == null) {
                Cache.$$$reportNull$$$0(2);
            }
            return convertedLine;
        }

        @Nullable
        private Domain getDomain(@NotNull ColumnDescriptor consumer2) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(3);
            }
            if (this.myCachedDomains.containsKey(consumer2)) {
                return this.myCachedDomains.get(consumer2);
            }
            Version version = DbImplUtilCore.getDatabaseVersion(ImportInfo.this.myContext.getDataSource());
            Domain domain = BaseDomainRegistry.getDomain(ImportInfo.this.myContext.getDbms(), version, consumer2, true);
            this.myCachedDomains.put(consumer2, domain);
            return domain;
        }

        @Nullable
        private Function<Object, Object> getConverter(@Nullable Object o2, @NotNull ColumnDescriptor consumer2, @NotNull ColumnDescriptor producer) {
            Map<Object, Function<Object, Object>> converters;
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(4);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(5);
            }
            ColumnDescriptor key2 = Cache.isMultiTypeColumn(producer, ImportInfo.this.myInputType.getDbms()) && o2 != null ? new Pair(o2.getClass(), (Object)consumer2) : consumer2;
            Map<Object, Function<Object, Object>> map2 = converters = o2 == null ? this.myNullValueConverters : this.myConverters;
            if (converters.containsKey(key2)) {
                return converters.get(key2);
            }
            Function<Object, Object> converter = this.getNoCached(o2, consumer2, producer);
            converters.put(key2, converter);
            return converter;
        }

        private static boolean isMultiTypeColumn(ColumnDescriptor producer, @NotNull Dbms dbms) {
            if (dbms == null) {
                Cache.$$$reportNull$$$0(6);
            }
            return !(producer instanceof DataConsumer.Column) || dbms.is(Dbms.MONGO) || dbms.is(Dbms.SQLITE) && StringUtil.equalsIgnoreCase((CharSequence)"numeric", (CharSequence)producer.getTypeName());
        }

        @NotNull
        public List<ColumnInfo> getColumnInfos() {
            List<AutoValueDescriptor> descriptors = ImportInfo.this.mappedConsumers();
            ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>();
            for (AutoValueDescriptor descriptor2 : descriptors) {
                int index2 = this.getProducerIndex(descriptor2);
                infos.add(new ColumnInfo(descriptor2.getJavaClassName(), descriptor2.getTypeName(), descriptor2.getType(), index2));
            }
            ArrayList<ColumnInfo> arrayList = infos;
            if (arrayList == null) {
                Cache.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        public DasTable getBasicTable() {
            BasicTable basicTable = ImportInfo.this.myTargetTable;
            if (basicTable == null) {
                Cache.$$$reportNull$$$0(8);
            }
            return basicTable;
        }

        @Nullable
        private Function<Object, Object> getNoCached(@Nullable Object o2, @NotNull ColumnDescriptor consumer2, @NotNull ColumnDescriptor producer) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(9);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(10);
            }
            DbDataSource source = ImportInfo.this.myContext.getDataSource();
            return DataTypeConversionUtil.getConverter(this.myGraph, ImportInfo.this.myInputType.getDbms(), ImportInfo.this.myContext.getDbms(), ImportInfo.this.myInputType.getProducerSystem(), source, producer, consumer2, o2);
        }

        private int getProducerIndex(@NotNull AutoValueDescriptor consumer2) {
            if (consumer2 == null) {
                Cache.$$$reportNull$$$0(11);
            }
            if (this.myCachedMapping.containsKey(consumer2)) {
                return this.myCachedMapping.get(consumer2);
            }
            ColumnDescriptor producer = ImportInfo.this.myConsumerToProducer.get(consumer2);
            int result2 = producer == null ? -1 : ContainerUtil.indexOf(ImportInfo.this.myProducers, current -> StringUtil.equals((CharSequence)producer.getName(), (CharSequence)current.getName()));
            this.myCachedMapping.put((ColumnDescriptor)consumer2, result2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertLine";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnInfos";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "convertLine";
                    break;
                }
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDomain";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getConverter";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isMultiTypeColumn";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getNoCached";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getProducerIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class Builder {
        private CsvFormat myFormat;
        private BasicTable myTargetTable;
        private String myProducerName;
        private ErrorTaskInfo myErrorTaskInfo;
        private boolean myLockTable;
        private List<? extends ColumnDescriptor> myProducers;
        private boolean myInsertAsNull;
        private Map<AutoValueDescriptor, ? extends ColumnDescriptor> myConsumerToProducer;
        private List<AutoValueDescriptor> myConsumers;
        private List<? extends GridRow> myRows;
        private List<? extends ColumnDescriptor> myVisibleProducers;
        private DatabaseEditorContext myContext;

        @NotNull
        public Builder rows(@NotNull List<? extends GridRow> rows) {
            if (rows == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myRows = rows;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder csvFormat(@Nullable CsvFormat format2) {
            this.myFormat = format2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder consumer(@NotNull BasicTable table) {
            if (table == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myTargetTable = table;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder producerName(@NotNull String producerName) {
            if (producerName == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myProducerName = producerName;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder errorTaskInfo(@NotNull ErrorTaskInfo info2) {
            if (info2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myErrorTaskInfo = info2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder lockTable(boolean lockTable) {
            this.myLockTable = lockTable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder producers(@NotNull List<? extends ColumnDescriptor> producers) {
            if (producers == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myProducers = producers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder visibleProducers(@NotNull List<? extends ColumnDescriptor> visibleProducers) {
            if (visibleProducers == null) {
                Builder.$$$reportNull$$$0(12);
            }
            this.myVisibleProducers = visibleProducers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder insertAsNull(boolean insertAsNull) {
            this.myInsertAsNull = insertAsNull;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder mapping(@NotNull Map<AutoValueDescriptor, ? extends ColumnDescriptor> map2) {
            if (map2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myConsumerToProducer = map2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public Builder consumers(@NotNull List<AutoValueDescriptor> descriptors) {
            if (descriptors == null) {
                Builder.$$$reportNull$$$0(17);
            }
            this.myConsumers = descriptors;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder;
        }

        @NotNull
        public ImportInfo build(@NotNull ImportSourceType sourceType) {
            if (sourceType == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return new ImportInfo(this.myFormat, this.myTargetTable, this.myConsumers, this.myProducers, this.myConsumerToProducer, this.myProducerName, this.myContext, sourceType, this.myErrorTaskInfo, this.myLockTable, this.myInsertAsNull);
        }

        public CsvFormat getFormat() {
            return this.myFormat;
        }

        public Map<AutoValueDescriptor, ? extends ColumnDescriptor> getMapping() {
            return this.myConsumerToProducer;
        }

        public List<AutoValueDescriptor> getConsumers() {
            return this.myConsumers;
        }

        public List<? extends ColumnDescriptor> getProducers() {
            return this.myProducers;
        }

        public List<? extends ColumnDescriptor> getVisibleProducers() {
            return this.myVisibleProducers;
        }

        public BasicTable getTargetTable() {
            return this.myTargetTable;
        }

        public String getProducerName() {
            return this.myProducerName;
        }

        public List<? extends GridRow> getRows() {
            return this.myRows;
        }

        public Builder context(@Nullable DatabaseEditorContext context) {
            this.myContext = context;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4, 6, 8, 9, 11, 13, 14, 16, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producerName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producers";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleProducers";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "csvFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producerName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errorTaskInfo";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lockTable";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producers";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visibleProducers";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertAsNull";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapping";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 18: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "consumer";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "producerName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "errorTaskInfo";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "producers";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visibleProducers";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "mapping";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "consumers";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4, 6, 8, 9, 11, 13, 14, 16, 18 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ConversionException
    extends Exception {
        private static final String ERROR_MASK = "conversion failed: \"%s\" to %s";
        private final int myIndex;

        private ConversionException(@NotNull Object value2, @NotNull String typeName, @Nullable String columnName, int index2) {
            if (value2 == null) {
                ConversionException.$$$reportNull$$$0(0);
            }
            if (typeName == null) {
                ConversionException.$$$reportNull$$$0(1);
            }
            super(ConversionException.getMessage(value2, typeName, columnName));
            this.myIndex = index2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @NotNull
        private static String getMessage(@NotNull Object value2, @NotNull String typeName, @Nullable String columnName) {
            if (value2 == null) {
                ConversionException.$$$reportNull$$$0(2);
            }
            if (typeName == null) {
                ConversionException.$$$reportNull$$$0(3);
            }
            String string = String.format(ERROR_MASK, value2, StringUtil.toLowerCase((String)typeName)) + (String)(columnName == null ? "" : " (" + columnName + ")");
            if (string == null) {
                ConversionException.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$ConversionException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$ConversionException";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

