/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.actions.ImportSourceType;
import com.intellij.database.dbimport.AbstractDataSourceType;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.DatabaseSourceType;
import com.intellij.database.dbimport.DbElementTreeCellRenderer;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvSourceType;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.dbimport.ui.component.TableEditorComponentBase;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.targetChooser.DataSourceSchemaComboBox;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ModelTraverserEx;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ImportDialog.class);
    private static final Dimension SIZE = JBUI.size((int)800, (int)600);
    private static final List<ImportDialogSourcesTreeHelper> SOURCES_TREE_HELPERS = List.of(new DbImportDialogSourcesTreeHelper(), new FilesImportDialogSourcesTreeHelper());
    private final JPanel myPanel;
    private final Tree mySourcesTree;
    private final List<ImportPanelInfo> myInfos;
    private final Project myProject;
    private final boolean myIsImportingFromDatabaseSource;
    private final boolean myIsImportingFromOpenFile;
    private final JBPanelWithEmptyText myEmptyTextPanel;
    private boolean hasErrorInSelectedPanel;

    public ImportDialog(final @NotNull ImportEditorContext initialContext, @NotNull List<Pair<ImportAction.SourceType, ImportInfo.Builder>> sources, @Nullable String initialTargetTableName) {
        if (initialContext == null) {
            ImportDialog.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            ImportDialog.$$$reportNull$$$0(1);
        }
        super(initialContext.getProject());
        this.myPanel = new JPanel(new BorderLayout());
        this.myEmptyTextPanel = new JBPanelWithEmptyText().withEmptyText(DatabaseBundle.message("database.data.import.empty.text", new Object[0]));
        ImportAction.SourceType sourceType = (ImportAction.SourceType)sources.get((int)0).first;
        ImportInfo.Builder builder = (ImportInfo.Builder)sources.get((int)0).second;
        this.myProject = initialContext.getProject();
        this.myIsImportingFromDatabaseSource = sourceType instanceof DatabaseSourceType;
        this.myIsImportingFromOpenFile = builder.getProducers() != null;
        this.setOKButtonText(DatabaseBundle.message("database.data.import.ok.text", new Object[0]));
        this.setTitle(sourceType.getDialogTitle());
        CheckedDisposable disposable = Disposer.newCheckedDisposable();
        this.myInfos = this.createPanels(initialContext, sources, initialTargetTableName, disposable);
        JBLayeredPane layeredPane = new JBLayeredPane();
        for (ImportPanelInfo info2 : this.myInfos) {
            layeredPane.add((Component)((Object)info2.myPanel), (Object)JLayeredPane.DEFAULT_LAYER);
        }
        layeredPane.add((Component)this.myEmptyTextPanel);
        layeredPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                JLayeredPane host = (JLayeredPane)e2.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c2 : host.getComponents()) {
                        c2.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        this.mySourcesTree = ImportDialog.createSourcesTree(this.myInfos, this.myProject);
        ImportDialog.installSchemaChangedListeners(this.myInfos, this.mySourcesTree);
        if (this.mySourcesTree != null) {
            TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.mySourcesTree);
            this.addTreeToPanel(this.mySourcesTree);
            this.mySourcesTree.addTreeSelectionListener(new TreeSelectionListener(){
                boolean first = true;

                @Override
                public void valueChanged(TreeSelectionEvent e2) {
                    ImportPanel panel2 = ImportDialog.this.getSelectedPanel();
                    if (panel2 != null && !ImportDialog.isInitialized(panel2)) {
                        ImportDialog.this.initPanel(panel2, this.first, this.first ? initialContext : ImportDialog.this.getContext());
                        this.first = false;
                    }
                    for (ImportPanelInfo info2 : ImportDialog.this.myInfos) {
                        info2.myPanel.setVisible(info2.myPanel == panel2);
                    }
                    ImportDialog.this.myEmptyTextPanel.setVisible(panel2 == null);
                }
            });
            ImportDialog.selectFirstTableNode(this.mySourcesTree);
        } else {
            this.initPanel(this.myInfos.get((int)0).myPanel, true, initialContext);
        }
        this.myPanel.add((Component)layeredPane, "Center");
        Disposer.register((Disposable)this.getDisposable(), (Disposable)disposable);
        layeredPane.setPreferredSize(SIZE);
        this.init();
    }

    @NotNull
    private CompletionStage<?> initPanel(@NotNull ImportPanel panel2, boolean first2, @NotNull ImportEditorContext context) {
        if (panel2 == null) {
            ImportDialog.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ImportDialog.$$$reportNull$$$0(3);
        }
        CompletionStage<?> stage2 = panel2.initializer(context).init(first2, context.getNamespace() == null);
        if (first2) {
            CompletionStage<Object> completionStage = stage2.whenComplete((o2, error2) -> {
                if (error2 != null) {
                    LOG.error(error2);
                }
                this.myOKAction.setEnabled(true);
                this.initValidation();
            });
            if (completionStage == null) {
                ImportDialog.$$$reportNull$$$0(4);
            }
            return completionStage;
        }
        CompletionStage<?> completionStage = stage2;
        if (completionStage == null) {
            ImportDialog.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    private static boolean isInitialized(@NotNull ImportPanel panel2) {
        if (panel2 == null) {
            ImportDialog.$$$reportNull$$$0(6);
        }
        return panel2.getTargetSchemaComponent().getContext() != null;
    }

    private static void selectFirstTableNode(@NotNull Tree tree2) {
        if (tree2 == null) {
            ImportDialog.$$$reportNull$$$0(7);
        }
        for (int i2 = 0; i2 < tree2.getVisibleRowCount(); ++i2) {
            TreePath path = tree2.getPathForRow(i2);
            if (((TreeNode)path.getLastPathComponent()).getChildCount() != 0) continue;
            tree2.setSelectionRow(i2);
            return;
        }
    }

    private void addTreeToPanel(@NotNull Tree tree2) {
        if (tree2 == null) {
            ImportDialog.$$$reportNull$$$0(8);
        }
        LabeledComponent listLabeledComponent = new LabeledComponent();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree2);
        scrollPane.setPreferredSize(new Dimension(300, -1));
        listLabeledComponent.setComponent((JComponent)scrollPane);
        listLabeledComponent.setText(DatabaseBundle.message("import.table.dialog.sources.list", new Object[0]));
        listLabeledComponent.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)20));
        listLabeledComponent.setLabelInsets((Insets)JBUI.insetsBottom((int)5));
        this.myPanel.add((Component)listLabeledComponent, "West");
    }

    private static void installSchemaChangedListeners(@NotNull List<ImportPanelInfo> infos, @Nullable Tree sourcesTree) {
        if (infos == null) {
            ImportDialog.$$$reportNull$$$0(9);
        }
        for (ImportPanelInfo info2 : infos) {
            info2.myPanel.getTargetSchemaComponent().addSchemaChangedListener(context -> {
                for (ImportPanelInfo info22 : infos) {
                    if (info2 == info22 || !ImportDialog.isInitialized(info22.myPanel)) continue;
                    info22.myPanel.contextChanged((ImportEditorContext)context);
                }
                if (sourcesTree != null) {
                    sourcesTree.revalidate();
                    sourcesTree.repaint();
                }
            });
        }
    }

    @NotNull
    private List<ImportPanelInfo> createPanels(@NotNull ImportEditorContext context, @NotNull List<Pair<ImportAction.SourceType, ImportInfo.Builder>> sources, @Nullable String initialTargetTableName, CheckedDisposable disposable) {
        if (context == null) {
            ImportDialog.$$$reportNull$$$0(10);
        }
        if (sources == null) {
            ImportDialog.$$$reportNull$$$0(11);
        }
        List list = JBIterable.from(sources).map(source -> {
            try {
                ImportPanel panel2 = ((ImportAction.SourceType)source.getFirst()).getImportPanel(context, disposable, (ImportSourceType)source.getFirst(), (ImportInfo.Builder)source.getSecond(), this.myProject, initialTargetTableName, sources.size() > 1);
                return new ImportPanelInfo(panel2, (ImportAction.SourceType)source.getFirst(), (ImportInfo.Builder)source.getSecond());
            }
            catch (Exception e2) {
                LOG.error((Throwable)e2);
                return null;
            }
        }).filter(info2 -> info2 != null).toList();
        if (list == null) {
            ImportDialog.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static Tree createSourcesTree(@NotNull List<ImportPanelInfo> infos, @NotNull Project project) {
        if (infos == null) {
            ImportDialog.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ImportDialog.$$$reportNull$$$0(14);
        }
        if (infos.size() <= 1) {
            return null;
        }
        ImportDialogSourcesTreeHelper helper = (ImportDialogSourcesTreeHelper)ContainerUtil.find(SOURCES_TREE_HELPERS, h2 -> h2.accepts(infos));
        if (helper == null) {
            throw new IllegalArgumentException("Cannot find ImportDialogSourcesTreeHelper for import sources " + infos);
        }
        Tree tree2 = new Tree(helper.createTree(infos));
        tree2.getSelectionModel().setSelectionMode(1);
        tree2.setRootVisible(false);
        tree2.setCellRenderer(helper.createCellRenderer(project));
        TreeUtil.expandAll((JTree)tree2);
        return tree2;
    }

    private static boolean hasErrors(@NotNull DefaultMutableTreeNode value2) {
        if (value2 == null) {
            ImportDialog.$$$reportNull$$$0(15);
        }
        if (!(value2 instanceof MyTreeNode)) {
            return false;
        }
        ImportPanel panel2 = ((MyTreeNode)value2).myPanel;
        ValidationInfo info2 = panel2 == null ? null : panel2.validationInfo();
        return info2 != null && !(info2.component instanceof DataSourceSchemaComboBox);
    }

    private void error(@NotNull @NlsContexts.NotificationContent String message2) {
        ImportPanel panel2;
        if (message2 == null) {
            ImportDialog.$$$reportNull$$$0(16);
        }
        if ((panel2 = this.getSelectedPanel()) != null) {
            panel2.reportError(message2);
        }
        this.myOKAction.setEnabled(true);
    }

    @NotNull
    public ImportEditorContext getContext() {
        ImportEditorContext importEditorContext = Objects.requireNonNull(this.myInfos.get((int)0).myPanel.getTargetSchemaComponent().getContext());
        if (importEditorContext == null) {
            ImportDialog.$$$reportNull$$$0(17);
        }
        return importEditorContext;
    }

    @Nullable
    private ImportPanel getSelectedPanel() {
        if (this.mySourcesTree == null) {
            return this.myInfos.get((int)0).myPanel;
        }
        TreePath path = this.mySourcesTree.getSelectionPath();
        MyTreeNode node2 = path == null ? null : (MyTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), MyTreeNode.class);
        return node2 == null ? null : node2.myPanel;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
    }

    protected void doOKAction() {
        boolean hasDdlChanges;
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        boolean bl = hasDdlChanges = ContainerUtil.find(this.myInfos, info2 -> this.getContext().getImportType(info2.myPanel.getTableName(this.getContext())).tableExists() && !StringUtil.isEmptyOrSpaces((String)info2.myPanel.getDdlComponent().getDdlPreviewText())) != null;
        if (hasDdlChanges && !MessageDialogBuilder.yesNo((String)DatabaseBundle.message("database.data.import.schema.change.confirmation.title", new Object[0]), (String)DatabaseBundle.message("database.data.import.schema.change.confirmation.text", new Object[0])).ask((Component)this.getRootPane())) {
            return;
        }
        this.getOKAction().setEnabled(false);
        AsyncTask.withBgIndicatorIfNeeded(AsyncTask.frame(DatabaseBundle.message("database.data.import.initializing.import.sources.progress", new Object[0])), this.myProject, null).computeAsync(null, () -> ImportDialog.compose(this.myInfos, new ArrayList(), this::initializePanelsIfNeeded).whenComplete(null, (infos, th) -> {
            if (th != null) {
                this.error(Objects.requireNonNullElse(th.getMessage(), th.toString()));
                LOG.warn(th);
                return;
            }
            ImportDialog.compose(infos, new ArrayList(), this::runDdl).whenComplete(null, this::runImport);
        }));
    }

    @NotNull
    private AsyncTask<ArrayList<ImportPanelInfo>> initializePanelsIfNeeded(@NotNull ImportPanelInfo info2, @NotNull ArrayList<ImportPanelInfo> infos) {
        if (info2 == null) {
            ImportDialog.$$$reportNull$$$0(18);
        }
        if (infos == null) {
            ImportDialog.$$$reportNull$$$0(19);
        }
        if (!info2.myPanel.getTableEditorComponent().hasProducers() && !ImportDialog.isInitialized(info2.myPanel)) {
            CsvPreviewComponent dataPreview = (CsvPreviewComponent)ObjectUtils.tryCast(info2.myPanel.getDataPreviewComponent(), CsvPreviewComponent.class);
            if (dataPreview != null) {
                dataPreview.setForceLoadData(true);
            }
            AsyncTask<ArrayList<ImportPanelInfo>> asyncTask = AsyncTask.Frame.currentOrAnonymous().wrap(this.initPanel(info2.myPanel, false, this.getContext())).apply(null, r -> (ArrayList)ContainerUtil.addAll((Collection)infos, (Object[])new ImportPanelInfo[]{info2}));
            if (asyncTask == null) {
                ImportDialog.$$$reportNull$$$0(20);
            }
            return asyncTask;
        }
        AsyncTask<ArrayList<ImportPanelInfo>> asyncTask = AsyncTask.completed((ArrayList)ContainerUtil.addAll(infos, (Object[])new ImportPanelInfo[]{info2}));
        if (asyncTask == null) {
            ImportDialog.$$$reportNull$$$0(21);
        }
        return asyncTask;
    }

    @NotNull
    private AsyncTask<ArrayList<Pair<AsyncTask<?>, ImportInfo>>> runDdl(@NotNull ImportPanelInfo info2, @NotNull ArrayList<Pair<AsyncTask<?>, ImportInfo>> importTriggerAndInfos) {
        if (info2 == null) {
            ImportDialog.$$$reportNull$$$0(22);
        }
        if (importTriggerAndInfos == null) {
            ImportDialog.$$$reportNull$$$0(23);
        }
        ImportType type2 = this.getContext().getImportType(info2.myPanel.getTableName(this.getContext()));
        TableEditorComponentBase<?, ?> base = info2.myPanel.getTableEditorComponentBase();
        MyResultProcessor processor2 = new MyResultProcessor(this.getProvider(info2), type2.getCodeGenerationSettings(), null);
        AsyncTask<Void> res2 = processor2.process();
        AsyncTask<ArrayList<Pair<AsyncTask<?>, ImportInfo>>> asyncTask = res2.apply(null, r -> (ArrayList)ContainerUtil.addAll((Collection)importTriggerAndInfos, (Object[])new Pair[]{new Pair((Object)res2, (Object)info2.myPanel.getImportInfo(this.getContext()))}));
        if (asyncTask == null) {
            ImportDialog.$$$reportNull$$$0(24);
        }
        return asyncTask;
    }

    private void runImport(ArrayList<Pair<AsyncTask<?>, ImportInfo>> importTriggerAndInfos, @Nullable Throwable th) {
        if (th != null) {
            if (th instanceof GenericEditingResultProcessor.AbortedByUserException) {
                this.close(1);
            } else {
                this.error(Objects.requireNonNullElse(th.getMessage(), th.toString()));
                LOG.warn(th);
            }
        } else {
            this.close(0);
            Pair item = (Pair)ContainerUtil.getFirstItem(importTriggerAndInfos);
            if (item != null) {
                ImportSettings.store((ImportInfo)item.second);
            }
            ImportDialog.compose(importTriggerAndInfos, null, (importTriggerAndInfo, v2) -> ((AsyncTask)importTriggerAndInfo.getFirst()).apply(null, r2 -> ImportDialog.runImport((ImportInfo)importTriggerAndInfo.getSecond(), this.myProject)));
        }
    }

    private static <T, F> AsyncTask<F> compose(@NotNull List<T> elements2, @Nullable F init2, @NotNull BiFunction<T, F, AsyncTask<F>> func) {
        if (elements2 == null) {
            ImportDialog.$$$reportNull$$$0(25);
        }
        if (func == null) {
            ImportDialog.$$$reportNull$$$0(26);
        }
        AsyncTask<Object> future2 = AsyncTask.completed(init2);
        for (Object e2 : elements2) {
            future2 = future2.applyAsync(null, r -> (AsyncTask)func.apply(e2, r));
        }
        return future2;
    }

    @NotNull
    private ResultProcessorProvider getProvider(final @NotNull ImportPanelInfo info2) {
        if (info2 == null) {
            ImportDialog.$$$reportNull$$$0(27);
        }
        return new ResultProcessorProvider(){

            @Override
            public void settingsChanged() {
            }

            @Override
            @NotNull
            public JBIterable<Pair<PsiElement, String>> collectRenames() {
                ImportEditorContext context = this.getContext();
                JBIterable<Pair<PsiElement, String>> jBIterable = context.getImportType(info2.myPanel.getTableName(context)).tableExists() ? DbRenamePsiElementProcessor.collectRenameElements(info2.myPanel.getDeTable((ImportEditorContext)context).model, context.getDataSource()) : JBIterable.empty();
                if (jBIterable == null) {
                    3.$$$reportNull$$$0(0);
                }
                return jBIterable;
            }

            @Override
            public Project getProject() {
                return ImportDialog.this.myProject;
            }

            @Override
            public boolean isPreviewUsages() {
                return true;
            }

            @Override
            @NotNull
            public String statement() {
                String statement2 = info2.myPanel.getDdlComponent().getDdlPreviewText();
                if (statement2 != null) {
                    String string = statement2;
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                ImportEditorContext context = this.getContext();
                TableSettings settings = context.getImportType(info2.myPanel.getTableName(context)).getCodeGenerationSettings();
                DeTable deTable = info2.myPanel.getDeTable(context);
                DeModel model2 = deTable.model;
                SqlCodeStyleSettings codeStyleSettings = SqlCodeStyles.getSqlSettings((Project)context.getProject(), (Language)context.getSqlDialect());
                TableEditorModel tableEditorModel = new TableEditorModel(deTable, new EditorModelsCache(codeStyleSettings));
                ModelTraverserEx traverser2 = new ModelTraverserEx(settings, tableEditorModel, model2, context.getDataSource());
                String string = traverser2.generate().getScriptText();
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @NotNull
            public ImportEditorContext getContext() {
                ImportEditorContext importEditorContext = ImportDialog.this.getContext();
                if (importEditorContext == null) {
                    3.$$$reportNull$$$0(3);
                }
                return importEditorContext;
            }

            @Override
            @NotNull
            public DeModel getModel() {
                DeModel deModel = info2.myPanel.getDeTable((ImportEditorContext)this.getContext()).model;
                if (deModel == null) {
                    3.$$$reportNull$$$0(4);
                }
                return deModel;
            }

            @Override
            @NotNull
            public DatabaseEditorBaseEx getEditor() {
                ImportDatabaseTableEditor<?> editor2 = info2.myPanel.getTableEditorComponent().getEditor();
                DatabaseEditorBaseEx databaseEditorBaseEx = Objects.requireNonNull(editor2);
                if (databaseEditorBaseEx == null) {
                    3.$$$reportNull$$$0(5);
                }
                return databaseEditorBaseEx;
            }

            @Override
            @NotNull
            public DeObject getEditedObject() {
                DeTable deTable = info2.myPanel.getDeTable(this.getContext());
                if (deTable == null) {
                    3.$$$reportNull$$$0(6);
                }
                return deTable;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dbimport/ImportDialog$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "collectRenames";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "statement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContext";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModel";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditedObject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ImportPanel panel2 = this.getSelectedPanel();
        ValidationInfo info2 = panel2 == null ? null : panel2.validationInfo();
        this.updateSourcesTree(info2);
        if (info2 != null) {
            return info2;
        }
        for (ImportPanelInfo panelInfo : this.myInfos) {
            info2 = panelInfo.myPanel.validationInfo();
            if (info2 == null) continue;
            AbstractDataSourceType sourceType = (AbstractDataSourceType)ObjectUtils.tryCast((Object)panelInfo.mySourceType, AbstractDataSourceType.class);
            String tableName = sourceType == null ? null : (sourceType.getTable() == null ? null : sourceType.getTable().getName());
            return new ValidationInfo(DatabaseBundle.message("database.data.import.error.in.table", info2.message, tableName), (JComponent)this.mySourcesTree);
        }
        return null;
    }

    private void updateSourcesTree(@Nullable ValidationInfo infoInSelectedPanel) {
        boolean changed = infoInSelectedPanel == null == this.hasErrorInSelectedPanel;
        boolean bl = this.hasErrorInSelectedPanel = infoInSelectedPanel != null;
        if (this.mySourcesTree != null && changed) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.mySourcesTree.revalidate();
                this.mySourcesTree.repaint();
            });
        }
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = ((Object)((Object)this)).getClass().getName() + (this.myInfos.size() > 1 ? ".multi" : "");
        if (string == null) {
            ImportDialog.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    protected String getHelpId() {
        return this.myIsImportingFromDatabaseSource ? "import.table.dialog" : (this.myIsImportingFromOpenFile ? "import.file.dialog" : "import.file.format.dialog");
    }

    private static AsyncTask<Boolean> runImport(@NotNull ImportInfo info2, @NotNull Project project) {
        if (info2 == null) {
            ImportDialog.$$$reportNull$$$0(29);
        }
        if (project == null) {
            ImportDialog.$$$reportNull$$$0(30);
        }
        try {
            if (!info2.getType().tableExists() && info2.getConsumersForInsert().isEmpty()) {
                return AsyncTask.completed(null);
            }
            return new DataImporter(project, (ReaderTask.SourceFactory)((Object)info2.getInputType()), info2).importData();
        }
        catch (IOException ex) {
            DataSourceUtil.showNotification(project, DatabaseBundle.message("notification.title.can.t.create.input", new Object[0]), ex.getMessage(), true, Collections.emptyList());
            return AsyncTask.completed(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 12, 17, 20, 21, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialContext";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportDialog";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 22: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importTriggerAndInfos";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanels";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "initializePanelsIfNeeded";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "runDdl";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initPanel";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInitialized";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstTableNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTreeToPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "installSchemaChangedListeners";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPanels";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSourcesTree";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "initializePanelsIfNeeded";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runDdl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "runImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 12, 17, 20, 21, 24, 28 -> new IllegalStateException(string);
        };
    }

    private static class ImportPanelInfo {
        final ImportPanel myPanel;
        final ImportAction.SourceType mySourceType;
        final ImportInfo.Builder myBuilder;

        private ImportPanelInfo(ImportPanel panel2, ImportAction.SourceType type2, ImportInfo.Builder builder) {
            this.myPanel = panel2;
            this.mySourceType = type2;
            this.myBuilder = builder;
        }
    }

    private static interface ImportDialogSourcesTreeHelper {
        public boolean accepts(@NotNull List<ImportPanelInfo> var1);

        @NotNull
        public TreeNode createTree(@NotNull List<ImportPanelInfo> var1);

        @NotNull
        public TreeCellRenderer createCellRenderer(@NotNull Project var1);
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final ImportPanel myPanel;

        MyTreeNode(Object userObject, @Nullable ImportPanel importPanel) {
            super(userObject);
            this.myPanel = importPanel;
        }
    }

    private static class MyResultProcessor
    extends GenericEditingResultProcessor {
        MyResultProcessor(@NotNull ResultProcessorProvider provider, @NotNull TableSettings settings, @Nullable RangeMarker insertPos) {
            if (provider == null) {
                MyResultProcessor.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                MyResultProcessor.$$$reportNull$$$0(1);
            }
            super(provider, settings, insertPos);
        }

        @Override
        @NotNull
        protected DbRenamePsiElementProcessor.MyRenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler2) {
            Pair r;
            if (renames == null) {
                MyResultProcessor.$$$reportNull$$$0(2);
            }
            if (handler2 == null) {
                MyResultProcessor.$$$reportNull$$$0(3);
            }
            if ((r = (Pair)renames.first()) == null) {
                throw new AssertionError((Object)"No renames");
            }
            return new ImportRenameProcessor(this.getProject(), (PsiElement)r.first, handler2, (String)r.second, renames, this.mySettings.renameInCommentsAndLiterals, this.mySettings.renameTextOccurrences);
        }

        @Override
        protected String getTitle() {
            return DatabaseBundle.message("progress.text.import", new Object[0]);
        }

        @Override
        @NotNull
        protected AsyncTask<Void> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler2) {
            if (handler2 == null) {
                MyResultProcessor.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmpty((String)this.myProvider.statement())) {
                AsyncTask<Object> asyncTask = AsyncTask.completed(null);
                if (asyncTask == null) {
                    MyResultProcessor.$$$reportNull$$$0(5);
                }
                return asyncTask;
            }
            AsyncTask<Void> asyncTask = super.processWithoutRenames(handler2);
            if (asyncTask == null) {
                MyResultProcessor.$$$reportNull$$$0(6);
            }
            return asyncTask;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renames";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDialog$MyResultProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$MyResultProcessor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processWithoutRenames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createRenameProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processWithoutRenames";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class DbImportDialogSourcesTreeHelper
    implements ImportDialogSourcesTreeHelper {
        private DbImportDialogSourcesTreeHelper() {
        }

        @Override
        public boolean accepts(@NotNull List<ImportPanelInfo> infos) {
            if (infos == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(0);
            }
            return ContainerUtil.find(infos, info2 -> !(info2.mySourceType instanceof AbstractDataSourceType)) == null;
        }

        @Override
        @NotNull
        public TreeCellRenderer createCellRenderer(@NotNull Project project) {
            if (project == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(1);
            }
            return new DbElementTreeCellRenderer(){

                @Override
                @Nullable
                protected DbElement getDbElement(@NotNull Object value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (DbElement)ObjectUtils.tryCast((Object)value2, DbElement.class);
                }

                @Override
                protected boolean hasErrors(@NotNull DefaultMutableTreeNode value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return ImportDialog.hasErrors(value2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$DbImportDialogSourcesTreeHelper$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getDbElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "hasErrors";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        @Override
        @NotNull
        public TreeNode createTree(@NotNull List<ImportPanelInfo> infos) {
            if (infos == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(2);
            }
            DefaultMutableTreeNode root2 = new DefaultMutableTreeNode();
            List databaseInfos = ContainerUtil.filter(infos, info2 -> info2.mySourceType instanceof DatabaseSourceType && ((DatabaseSourceType)info2.mySourceType).getTable() != null);
            for (ImportPanelInfo info3 : databaseInfos) {
                DbImportDialogSourcesTreeHelper.addNode(root2, info3);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = root2;
            if (defaultMutableTreeNode == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(3);
            }
            return defaultMutableTreeNode;
        }

        private static void addNode(@NotNull DefaultMutableTreeNode root2, @NotNull ImportPanelInfo info2) {
            if (root2 == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(4);
            }
            if (info2 == null) {
                DbImportDialogSourcesTreeHelper.$$$reportNull$$$0(5);
            }
            DbTable table = ((AbstractDataSourceType)info2.mySourceType).getTable();
            DefaultMutableTreeNode currentNode = root2;
            for (DbElement dbElement : ContainerUtil.reverse((List)JBIterable.generate((Object)table, el -> el.getParent()).toList())) {
                DefaultMutableTreeNode newNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)currentNode, (Object)dbElement);
                if (newNode == null) {
                    newNode = new MyTreeNode((Object)dbElement, dbElement == table ? info2.myPanel : null);
                    currentNode.add(newNode);
                }
                currentNode = newNode;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDialog$DbImportDialogSourcesTreeHelper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$DbImportDialogSourcesTreeHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCellRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addNode";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class FilesImportDialogSourcesTreeHelper
    implements ImportDialogSourcesTreeHelper {
        private FilesImportDialogSourcesTreeHelper() {
        }

        @Override
        public boolean accepts(@NotNull List<ImportPanelInfo> infos) {
            if (infos == null) {
                FilesImportDialogSourcesTreeHelper.$$$reportNull$$$0(0);
            }
            return ContainerUtil.find(infos, info2 -> !(info2.mySourceType instanceof CsvSourceType)) == null;
        }

        @Override
        @NotNull
        public TreeNode createTree(@NotNull List<ImportPanelInfo> infos) {
            if (infos == null) {
                FilesImportDialogSourcesTreeHelper.$$$reportNull$$$0(1);
            }
            DefaultMutableTreeNode root2 = new DefaultMutableTreeNode();
            for (ImportPanelInfo info2 : infos) {
                root2.add(new MyTreeNode((Object)((CsvSourceType)info2.mySourceType).getFile(), info2.myPanel));
            }
            DefaultMutableTreeNode defaultMutableTreeNode = root2;
            if (defaultMutableTreeNode == null) {
                FilesImportDialogSourcesTreeHelper.$$$reportNull$$$0(2);
            }
            return defaultMutableTreeNode;
        }

        @Override
        @NotNull
        public TreeCellRenderer createCellRenderer(final @NotNull Project project) {
            if (project == null) {
                FilesImportDialogSourcesTreeHelper.$$$reportNull$$$0(3);
            }
            return new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    VirtualFile file;
                    if (tree2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((file = (VirtualFile)ObjectUtils.tryCast((Object)TreeUtil.getUserObject((Object)value2), VirtualFile.class)) == null) {
                        return;
                    }
                    this.setIcon(IconUtil.getIcon((VirtualFile)file, (int)0, (Project)project));
                    SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)tree2, (String)file.getName(), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/database/dbimport/ImportDialog$FilesImportDialogSourcesTreeHelper$1", "customizeCellRenderer"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDialog$FilesImportDialogSourcesTreeHelper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDialog$FilesImportDialogSourcesTreeHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createTree";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCellRenderer";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ImportRenameProcessor
    extends DbRenamePsiElementProcessor.MyRenameProcessor {
        ImportRenameProcessor(@NotNull Project project, @NotNull PsiElement element2, @NotNull DatabaseRefactoringHandler handler2, @NotNull @NonNls String newName, @NotNull JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                ImportRenameProcessor.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                ImportRenameProcessor.$$$reportNull$$$0(1);
            }
            if (handler2 == null) {
                ImportRenameProcessor.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                ImportRenameProcessor.$$$reportNull$$$0(3);
            }
            if (renames == null) {
                ImportRenameProcessor.$$$reportNull$$$0(4);
            }
            super(project, element2, handler2, newName, (Iterable<Pair<PsiElement, String>>)renames, (SearchScope)GlobalSearchScope.projectScope((Project)project), isSearchInComments, isSearchTextOccurrences);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "renames";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

