/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.CoreDatabaseGridDataHookUp;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseMutator;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypesMutationsStorage;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.VmView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.TxIsolationOwner,
DataRequest.DepartmentHolder,
CoreDatabaseGridDataHookUp {
    private final DatabaseMutator<Domain> myMutator;
    private final DatabaseDepartment myDepartment;
    protected volatile DatabaseSession mySession;
    private DasObject myDatabaseTable;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    public DatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual, @Nullable Function<GridModel<GridRow, GridColumn>, MutationsStorage> storageProvider) {
        if (project == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (valuesEqual == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(3);
        }
        super(project, session2.getMessageBus(), valuesEqual, storageProvider);
        this.mySession = session2;
        this.myDepartment = department;
        TypesMutationsStorage typesMutationsStorage = (TypesMutationsStorage)ObjectUtils.tryCast((Object)this.myStorage, TypesMutationsStorage.class);
        this.myMutator = new DatabaseMutatorImpl<Domain>((GridListModelBase<GridRow, GridColumn>)this.myModel, this.getMutationModel(), this, this.myStorage, typesMutationsStorage, valuesEqual);
    }

    public void setSession(@NotNull DatabaseSession session2) {
        if (session2 == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(4);
        }
        this.mySession = session2;
        this.setDataBus(session2.getMessageBus());
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(5);
        }
        return this == owner || this.getSession().isChildOf(owner);
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DatabaseDepartment databaseDepartment = this.myDepartment;
        if (databaseDepartment == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(6);
        }
        return databaseDepartment;
    }

    @Nullable
    public DatabaseMutator getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        return new DatabaseLoader();
    }

    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource2 = this.getDataSource();
        if (!dataSource2.isWritable()) {
            return true;
        }
        return !this.isEditableTable();
    }

    public boolean isEditableTable() {
        return DmlUtilKt.dmlGenerator(this.getDbms()).isEditableTable(this.myDatabaseTable, this.myDataProperties);
    }

    @Override
    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @Override
    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(7);
        }
        return txMarker;
    }

    @Override
    public void setCurrentTx(@NotNull DataRequest.TxMarker txMarker) {
        if (txMarker == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(8);
        }
        this.mySession.setCurrentTx(txMarker);
    }

    @Override
    @Nullable
    public DasObject getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)this.myDatabaseTable).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasObject databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(9);
        }
        return databaseSession;
    }

    @Override
    @NotNull
    public DbDataSource getDataSource() {
        DatabaseConnectionPoint target2 = (DatabaseConnectionPoint)this.mySession.getTarget();
        DbDataSource dbDataSource = Objects.requireNonNull(DbImplUtilCore.getDbDataSource(this.getProject(), target2.getDataSource()));
        if (dbDataSource == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = ((DatabaseConnectionPoint)this.mySession.getTarget()).getDbms();
        if (dbms == null) {
            DatabaseGridDataHookUp.$$$reportNull$$$0(11);
        }
        return dbms;
    }

    @Override
    @Nullable
    public DasColumn getDatabaseColumn(@Nullable GridColumn column2) {
        if (column2 == null) {
            return null;
        }
        DasObject dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from(DasUtil.getColumns(dasTable)).filter(DasUtil.byName(column2.getName())).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns2 = this.myModel.getColumns();
        for (GridColumn column2 : columns2) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column2.getColumnNumber()));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column2.getName())))) continue;
            return null;
        }
        return this.myTableType;
    }

    @Nullable
    protected static VmView getVirtualView(DasObject dbTable) {
        BasicObjectNode v2 = (BasicObjectNode)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(dbTable), BasicObjectNode.class);
        return v2 == null ? null : (VmView)ObjectUtils.tryCast((Object)v2.extractObject(), VmView.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentTx";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private Integer myRowIdIdx;
        private List<Integer> myColumnsToHide;

        @Override
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns2, int firstRowNum) {
            if (context == null) {
                DatabaseLoader.$$$reportNull$$$0(0);
            }
            if (columns2 == null) {
                DatabaseLoader.$$$reportNull$$$0(1);
            }
            DataRequest.Context c2 = (DataRequest.Context)((Object)ObjectUtils.tryCast((Object)context, DataRequest.Context.class));
            boolean sameQuery = Objects.equals(this.getQueryText(), c2 == null ? null : c2.getQuery());
            ConsoleDataRequest request2 = c2 == null ? null : (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)c2.request), ConsoleDataRequest.class);
            ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = request2 == null ? null : request2.getResultSetSubquery(subQueryIndex);
            SqlTableType sqlTableType = DatabaseGridDataHookUp.this.myTableType = resultSetSubQuery == null ? null : resultSetSubQuery.resultType;
            DatabaseGridDataHookUp.this.myReadOnly = sameQuery ? DatabaseGridDataHookUp.this.myReadOnly : c2 != null && !DbSqlUtil.isResultEditable(c2.request, DatabaseGridDataHookUp.this.myTableType, DatabaseGridDataHookUp.this.myDatabaseTable);
            DatabaseGridDataHookUp.this.myMutator.pageReloaded();
            super.setColumns(context, subQueryIndex, resultSetIndex, columns2, firstRowNum);
        }

        @Override
        protected GridColumn[] prepareColumns(GridColumn @NotNull [] columns2) {
            if (columns2 == null) {
                DatabaseLoader.$$$reportNull$$$0(2);
            }
            HookUpHelper helper = HookUpHelper.get(DatabaseGridDataHookUp.this.getDbms());
            DasObject dasTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            Map nameToDasColumn = CollectionFactory.createCaseInsensitiveStringMap();
            if (dasTable != null) {
                for (DasColumn dasColumn : DasUtil.getColumns(dasTable)) {
                    nameToDasColumn.put(dasColumn.getName(), dasColumn);
                }
            }
            Set virtualColumns = ModelExternalData.getExtraColumns(DatabaseGridDataHookUp.this.getDataSource(), false, dasTable).map(c2 -> c2.name).toSet();
            for (int i2 = 0; i2 < columns2.length; ++i2) {
                GridColumn column2 = columns2[i2];
                SizeProvider sizeProvider = (SizeProvider)ObjectUtils.tryCast((Object)column2, SizeProvider.class);
                JdbcGridColumn c3 = (JdbcGridColumn)ObjectUtils.tryCast((Object)column2, JdbcGridColumn.class);
                DasColumn databaseColumn = (DasColumn)nameToDasColumn.get(column2.getName());
                EnumSet<ColumnDescriptor.Attribute> attributes2 = EnumSet.noneOf(ColumnDescriptor.Attribute.class);
                if (c3 != null) {
                    attributes2.addAll(c3.getAttributes());
                }
                if (databaseColumn != null) {
                    attributes2.addAll(helper.getAttributes(databaseColumn));
                }
                int type2 = column2.getType();
                if (databaseColumn != null && (column2.getType() == 0 || column2.getType() == 1111)) {
                    type2 = DatabaseLoader.getJdbcType(databaseColumn);
                }
                if (this.myColumnsToHide != null && (this.myColumnsToHide.contains(i2) || this.myColumnsToHide.contains(i2 - columns2.length))) {
                    attributes2.add(ColumnDescriptor.Attribute.HIDDEN);
                }
                if (this.myRowIdIdx != null && (this.myRowIdIdx == i2 || this.myRowIdIdx == i2 - columns2.length)) {
                    attributes2.add(ColumnDescriptor.Attribute.ROW_ID);
                }
                if (virtualColumns.contains(column2.getName())) {
                    attributes2.add(ColumnDescriptor.Attribute.VIRTUAL);
                }
                if (type2 == column2.getType() && (c3 == null || attributes2.equals(c3.getAttributes()))) continue;
                String className = column2 instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column2).getJavaClassName() : null;
                columns2[i2] = new DataConsumer.Column(column2.getColumnNumber(), column2.getName(), type2, column2.getTypeName(), className, sizeProvider == null ? -1 : sizeProvider.getSize(), sizeProvider == null ? -1 : sizeProvider.getScale(), c3 == null ? null : c3.getCatalog(), c3 == null ? null : c3.getSchema(), c3 == null ? null : c3.getTable(), attributes2);
            }
            return columns2;
        }

        @Override
        protected void setQueryText(@Nullable String query) {
            super.setQueryText(query);
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(this.canCountRows(query));
        }

        protected boolean canCountRows(@Nullable String query) {
            return StringUtil.isNotEmpty((String)query) && DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms()).generate(DmlTaskKt.wrapInSelect(query, DatabaseGridDataHookUp.this.getProject()).countAll().build(DbImplUtil.createBuilderForUIExec(DatabaseGridDataHookUp.this.getDbms(), null))) != null;
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource source) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(3);
            }
            source.phase = GridRequestSource.Phase.COUNT;
            String unlimitedQuery = DatabaseGridDataHookUp.this.getUnlimitedQueryText(false);
            if (unlimitedQuery == null || !this.canCountRows(unlimitedQuery)) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateTotalRowCount(source, unlimitedQuery);
        }

        protected void updateTotalRowCount(@NotNull GridRequestSource source, @NotNull String unlimitedQuery) {
            if (source == null) {
                DatabaseLoader.$$$reportNull$$$0(4);
            }
            if (unlimitedQuery == null) {
                DatabaseLoader.$$$reportNull$$$0(5);
            }
            DbDataSource system = DatabaseGridDataHookUp.this.getDataSource();
            Dbms dbms = DatabaseGridDataHookUp.this.getDbms();
            Project project = DatabaseGridDataHookUp.this.getProject();
            Version version = system.getVersion();
            String alias = DbImplUtil.findFreeAlias(project, dbms, unlimitedQuery, "t");
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DbImplUtilCore.getDatabaseDialect(dbms), (DasObject)system);
            WrapInSelectTask task = DmlTaskKt.wrapInSelect(unlimitedQuery, project).countAll().version(version).alias(alias).build(builder);
            final WrapInSelectResult result2 = DmlUtilKt.dmlGenerator(dbms).generate(task);
            DataRequest.RawRequest request2 = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                    try {
                        long count = DbImplUtilCore.getRowCount(connection2, Objects.requireNonNull(result2).getStatement());
                        DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(count, true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request2, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        public boolean canUseOffset() {
            return DmlHelper.Companion.getEP().forDbms(DatabaseGridDataHookUp.this.getDbms()).supportsOffset(DatabaseGridDataHookUp.this.getDatabaseTable()) && Registry.is((String)"database.grid.paging.offset");
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2, @Nullable GridRequestSource source) {
            SelectGenerationResult pure2;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(6);
            }
            if ((pure2 = this.createQueryTextPure(attributes2, source)) == null) {
                return null;
            }
            this.myColumnsToHide = pure2.getColumnsToHide();
            this.myRowIdIdx = pure2.getRowIdIdx();
            return pure2.getStatement();
        }

        @Nullable
        public SelectGenerationResult createQueryTextPure(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2, @Nullable GridRequestSource source) {
            DmlTask task;
            boolean appendRowId;
            DasObject dbTable;
            if (attributes2 == null) {
                DatabaseLoader.$$$reportNull$$$0(7);
            }
            if ((dbTable = DatabaseGridDataHookUp.this.getDatabaseTable()) == null) {
                return null;
            }
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            VmView vView = DatabaseGridDataHookUp.getVirtualView(dbTable);
            if (vView != null) {
                return DatabaseLoader.createVirtualViewQuery(dbDialect, vView);
            }
            DmlHelper helper = DmlUtilKt.dmlGenerator(DatabaseGridDataHookUp.this.getDbms());
            boolean bl = appendRowId = !this.disableRowId() && dbTable instanceof DasTable && DatabaseLoader.needRowId((DasTable)dbTable);
            if (source != null && source.phase == GridRequestSource.Phase.LOAD_VALUES_USING_KEYS) {
                task = DmlTaskKt.selectUsingKeys(dbTable).model(DatabaseGridDataHookUp.this.myModel).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).insertNewLines(true).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec(dbDialect, dbTable));
            } else {
                CoreGrid<GridRow, GridColumn> grid = DatabaseLoader.getGrid(source);
                task = this.selectTask(dbTable).tableSamplingSize(grid == null ? null : DataGridUtilCore.getTableSamplingSize(grid)).limit(attributes2.limit().orElse(-1)).offset(attributes2.offset().orElse(0)).appendRowId(appendRowId).build(DbImplUtil.createBuilderForUIExec(dbDialect, dbTable));
            }
            return helper.generate(task);
        }

        @NotNull
        private static SelectGenerationResult createVirtualViewQuery(DatabaseDialectEx dbDialect, VmView vView) {
            DdlBuilder builder = new DdlBuilder().withDialect(dbDialect);
            builder.plain(StringUtil.notNullize((String)vView.getQuery()));
            return new SelectGenerationResult(builder, null, Collections.emptyList());
        }

        @Nullable
        private static CoreGrid<GridRow, GridColumn> getGrid(@Nullable GridRequestSource source) {
            if (source == null) {
                return null;
            }
            if (!(source.place instanceof GridRequestSource.GridRequestPlace)) {
                return null;
            }
            return ((GridRequestSource.GridRequestPlace)source.place).getGrid();
        }

        protected boolean disableRowId() {
            return false;
        }

        @NotNull
        protected SelectTask.Companion.Builder selectTask(@NotNull DasObject dbTable) {
            if (dbTable == null) {
                DatabaseLoader.$$$reportNull$$$0(8);
            }
            SelectTask.Companion.Builder builder = DmlTaskKt.allColumns(dbTable).withVirtualColumns(DatabaseGridDataHookUp.this.getDataSource()).version(DatabaseGridDataHookUp.this.getDataSource().getVersion()).whereClause(this.getWhereClause()).orderBy(this.getOrderBy()).insertNewLines(true);
            if (builder == null) {
                DatabaseLoader.$$$reportNull$$$0(9);
            }
            return builder;
        }

        private static int getJdbcType(@NotNull DasColumn column2) {
            BasicTypedElement element2;
            if (column2 == null) {
                DatabaseLoader.$$$reportNull$$$0(10);
            }
            if ((element2 = (BasicTypedElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(column2), BasicTypedElement.class)) == null) {
                return column2.getDasType().toDataType().jdbcType;
            }
            return DbImplUtil.getModelHelper(element2).getJdbcType(element2);
        }

        private static boolean needRowId(@NotNull DasTable table) {
            if (table == null) {
                DatabaseLoader.$$$reportNull$$$0(11);
            }
            return table.getKind() == ObjectKind.TABLE && DasUtil.getPrimaryKey(table) == null;
        }

        @Nullable
        protected OrderBy getOrderBy() {
            return null;
        }

        @Nullable
        protected WhereClause getWhereClause() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unlimitedQuery";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbTable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareColumns";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateTotalRowCount";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueryTextPure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "selectTask";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getJdbcType";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "needRowId";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9 -> new IllegalStateException(string);
            };
        }
    }
}

