/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalDataSourceValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target2, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        DatabaseDriver driver2;
        if (project == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(2);
        }
        if ((driver2 = target2.getDatabaseDriver()) == null) {
            return;
        }
        DatabaseDriver targetDriver = configInfoProvider == null ? driver2 : configInfoProvider.getTempTargetOrTarget(driver2);
        LocalDataSourceValidator.findSupportProblems(target2, targetDriver, problems);
        DatabaseDriverValidator.findDriverFilesProblems(targetDriver, problems, target2);
        DatabaseConfigValidator authProvider = (DatabaseConfigValidator)ObjectUtils.tryCast((Object)DatabaseAuthProvider.get(target2), DatabaseConfigValidator.class);
        if (authProvider != null && this.getTargetClass().isAssignableFrom(target2.getClass())) {
            authProvider.collectProblems(project, target2, problems, configInfoProvider);
        }
        DatabaseDriverValidator.findDriverLanguageProblem(targetDriver, problems, target2);
    }

    private static void findSupportProblems(@NotNull LocalDataSource target2, DatabaseDriver targetDriver, @NotNull Consumer<? super DataSourceProblem> problems) {
        if (target2 == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(3);
        }
        if (problems == null) {
            LocalDataSourceValidator.$$$reportNull$$$0(4);
        }
        Version version = target2.getVersion();
        Dbms dbms = target2.getDbms();
        if (Version.ZERO.less(version)) {
            Couple<Version> range = DatabaseDriverUtils.getSupportedRange(DatabaseArtifactManager.getArtifacts(), targetDriver, dbms);
            if (version.less((Version)range.first) || ((Version)range.second).less(version)) {
                String text2 = DatabaseBundle.message("notification.content.driver.does.not.support", dbms.getDisplayName(), version);
                DataSourceProblem.HyperText hyperText = new DataSourceProblem.HyperText(DatabaseBundle.message("notification.title.driver.database.incompatibility", new Object[0]), text2, text2, new Object[0]);
                problems.consume((Object)new DataSourceProblem(target2, null, DataSourceProblem.Level.ERROR, hyperText, null));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/LocalDataSourceValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findSupportProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

