/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsHolder;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceProblemsCollector<Key>
implements Disposable {
    private final DataSourceProblemsHolder myDataSourceProblemsHolder;
    private final Map<Key, Errors> myErrors;
    private final ExecutorService myExecutorService;

    public DataSourceProblemsCollector(@NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
        if (dataSourceProblemsHolder == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(0);
        }
        this.myErrors = new HashMap<Key, Errors>();
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"DS problems");
        this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
    }

    public void add(@NotNull Key object, @NotNull DataSourceProblemsProvider provider) {
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(2);
        }
        Errors errors = new Errors(provider, this.myDataSourceProblemsHolder);
        this.myErrors.put(object, errors);
        this.scheduleUpdate(errors);
    }

    public boolean contains(@NotNull Key object) {
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(3);
        }
        return this.myErrors.containsKey(object);
    }

    public void update(@NotNull Key object) {
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(4);
        }
        Errors errors = this.myErrors.get(object);
        this.scheduleUpdate(errors);
    }

    private void scheduleUpdate(Errors errors) {
        if (errors == null) {
            return;
        }
        errors.update(this.myExecutorService);
    }

    public void remove(@NotNull Key object) {
        Errors errors;
        if (object == null) {
            DataSourceProblemsCollector.$$$reportNull$$$0(5);
        }
        if ((errors = this.myErrors.get(object)) != null) {
            errors.setErrors(null);
        }
        this.myErrors.remove(object);
    }

    @Nullable
    public Set<DataSourceProblem> getProblems(Key object) {
        Errors errors = this.myErrors.get(object);
        return errors == null ? null : errors.myErrors;
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e2) {
                ExceptionUtil.rethrow((Throwable)e2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceProblemsHolder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/DataSourceProblemsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Errors {
        private final DataSourceProblemsProvider myProvider;
        private final DataSourceProblemsHolder myDataSourceProblemsHolder;
        private Set<DataSourceProblem> myErrors;
        private final AtomicReference<Future<?>> myUpdate;

        Errors(@NotNull DataSourceProblemsProvider provider, @NotNull DataSourceProblemsHolder dataSourceProblemsHolder) {
            if (provider == null) {
                Errors.$$$reportNull$$$0(0);
            }
            if (dataSourceProblemsHolder == null) {
                Errors.$$$reportNull$$$0(1);
            }
            this.myUpdate = new AtomicReference();
            this.myProvider = provider;
            this.myDataSourceProblemsHolder = dataSourceProblemsHolder;
        }

        public void update(Executor executor) {
            AsyncTask.Frame frame = AsyncTask.Frame.create(DatabaseBundle.message("progress.title.analyzing.data.sources", new Object[0]));
            AsyncTask.withIndicator(frame, (ProgressIndicator)new EmptyProgressIndicator(AsyncTask.getCurrentModality()));
            Future prev = this.myUpdate.getAndSet(frame.computeAsync(null, () -> this.updateImpl(executor, frame)).toFuture());
            if (prev != null) {
                prev.cancel(true);
            }
        }

        @NotNull
        private AsyncTask<Void> updateImpl(Executor executor, @NotNull AsyncTask.Frame frame) {
            if (frame == null) {
                Errors.$$$reportNull$$$0(2);
            }
            Object target2 = this.myProvider.getErrorsTarget();
            AsyncTask<Void> asyncTask = frame.compute(executor, () -> this.getErrors(target2)).apply(AsyncUtil.getEdtExecutor(), this::setErrors);
            if (asyncTask == null) {
                Errors.$$$reportNull$$$0(3);
            }
            return asyncTask;
        }

        @Nullable
        private Set<DataSourceProblem> getErrors(Object target2) {
            Set<DataSourceProblem> errors = this.myProvider.getErrors(target2);
            return errors.isEmpty() ? null : errors;
        }

        public Void setErrors(@Nullable Set<DataSourceProblem> errors) {
            if (this.myErrors != null) {
                for (DataSourceProblem error2 : this.myErrors) {
                    if (errors != null && errors.contains(error2)) continue;
                    this.myDataSourceProblemsHolder.removeError(error2);
                }
            }
            this.myErrors = errors;
            if (errors != null) {
                for (DataSourceProblem error2 : errors) {
                    this.myDataSourceProblemsHolder.addError(error2);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceProblemsHolder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/validation/DataSourceProblemsCollector$Errors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/validation/DataSourceProblemsCollector$Errors";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateImpl";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

