/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.ui.ParametersLayoutUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlPropertiesPanel
implements Disposable {
    private final Map<String, ParamEditor> myFields;
    private final StatelessParametersHolder myParametersHolder;
    private final DataInterchange myDataInterchange;
    private final boolean myAuthSupported;
    private final boolean myEmpty;
    private final JComponent myHeadComponent;
    private final JComponent myTailComponent;
    private final List<ParamEditor> myHeadEditors;
    private final List<ParamEditor> myTailEditors;

    public UrlPropertiesPanel(@NotNull StatelessParametersHolder parametersHolder, @NotNull DataInterchange dataInterchange, final @NotNull Runnable focusCallback) {
        if (parametersHolder == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(1);
        }
        if (focusCallback == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(2);
        }
        this.myFields = new HashMap<String, ParamEditor>();
        this.myParametersHolder = parametersHolder;
        this.myDataInterchange = dataInterchange;
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                focusCallback.run();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                focusCallback.run();
            }
        };
        ArrayList<String> parameters2 = new ArrayList<String>(parametersHolder.getParameterNames());
        this.myDataInterchange.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ParamEditor editor2 = UrlPropertiesPanel.this.myFields.get(evt.getPropertyName());
                String value2 = StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class)));
                if (editor2 != null && !editor2.getText().equals(value2)) {
                    editor2.setText(value2);
                }
            }
        }, this);
        this.myDataInterchange.addGroupedChangeListener(depth -> {
            if (depth != 0) {
                return;
            }
            for (Map.Entry<String, ParamEditor> entry : this.myFields.entrySet()) {
                if (entry.getValue().getComponent().isShowing() || !this.isVisible(entry.getKey())) continue;
                this.resetVisibility();
                break;
            }
        }, this);
        this.myAuthSupported = JdbcUrlParserUtil.isAuthSupported(parametersHolder);
        Couple<List<String>> parameterGroups = ParametersLayoutUtils.groupParameters(parameters2);
        this.myHeadEditors = this.instantiateEditors((List)parameterGroups.first, focusListener);
        this.myHeadComponent = this.myHeadEditors.isEmpty() ? null : new JPanel();
        this.myTailEditors = this.instantiateEditors((List)parameterGroups.second, focusListener);
        this.myTailComponent = this.myTailEditors.isEmpty() ? null : new JPanel();
        for (Map.Entry<String, ParamEditor> entry : this.myFields.entrySet()) {
            entry.getValue().setChangeListener(() -> this.myDataInterchange.putProperty((String)entry.getKey(), ((ParamEditor)entry.getValue()).getText()));
        }
        this.myEmpty = this.myHeadComponent == null && this.myTailComponent == null;
        this.resetVisibility();
    }

    public void resetVisibility() {
        if (this.myHeadComponent != null) {
            this.layoutComponent(this.myHeadComponent, this.myHeadEditors);
        }
        if (this.myTailComponent != null) {
            this.layoutComponent(this.myTailComponent, this.myTailEditors);
        }
    }

    public Map<String, ParamEditor> getFields() {
        return this.myFields;
    }

    public void dispose() {
    }

    @Nullable
    public JComponent getHeadComponent() {
        return this.myHeadComponent;
    }

    @Nullable
    public JComponent getTailComponent() {
        return this.myTailComponent;
    }

    public static void drawLayout(GridLayoutManager l, Component comp, Graphics g2, Color c2) {
        g2.setColor(c2);
        for (int x : l.getVerticalGridLines()) {
            g2.drawLine(x, 0, x, comp.getHeight());
        }
        for (int y : l.getHorizontalGridLines()) {
            g2.drawLine(0, y, comp.getWidth(), y);
        }
    }

    public boolean isEmpty() {
        return this.myEmpty;
    }

    public boolean isAuthSupported() {
        return this.myAuthSupported;
    }

    @Nullable
    public String getActiveParameter() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            return null;
        }
        for (Map.Entry<String, ParamEditor> entry : this.myFields.entrySet()) {
            if (!entry.getValue().getComponent().isAncestorOf(owner)) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    public DataInterchange getDataInterchange() {
        DataInterchange dataInterchange = this.myDataInterchange;
        if (dataInterchange == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(3);
        }
        return dataInterchange;
    }

    boolean isExtra(String param) {
        StatelessParametersHolder.ParameterInfo info2 = param == null ? null : this.myParametersHolder.getParameterInfo(param);
        return info2 != null && info2.isExtra();
    }

    private boolean isVisible(String param) {
        return !this.isExtra(param) || StringUtil.isNotEmpty((String)this.myDataInterchange.getProperty(param));
    }

    private void layoutComponent(JComponent component2, List<ParamEditor> editors2) {
        List<List<ParamEditor>> layout = ParametersLayoutUtils.getLayout(editors2, this.myParametersHolder, this.myDataInterchange);
        ParametersLayoutUtils.layoutComponent(component2, layout);
    }

    @NotNull
    private List<ParamEditor> instantiateEditors(@NotNull List<String> params2, @NotNull FocusListener focusListener) {
        if (params2 == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(4);
        }
        if (focusListener == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(5);
        }
        Pair<List<ParamEditor>, Map<String, ParamEditor>> editorsAndFields = ParametersLayoutUtils.createEditors(params2, this.myParametersHolder, this.myDataInterchange, this);
        List editors2 = (List)editorsAndFields.first;
        Map fields = (Map)editorsAndFields.second;
        this.myFields.putAll(fields);
        for (ParamEditor editor2 : editors2) {
            editor2.addFocusListener(focusListener);
        }
        List list = editors2;
        if (list == null) {
            UrlPropertiesPanel.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataInterchange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusCallback";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/UrlPropertiesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataInterchange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "instantiateEditors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

