/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordStorageComponent {
    @Nls
    private final String myPasswordItem = DatabaseBundle.message("ide.passwords.settings", new Object[0]);
    private final ComboBoxWithWidePopup<Object> myComboBox = new ComboBoxWithWidePopup<Object>((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[]{LocalDataSource.Storage.NO, LocalDataSource.Storage.MEMORY, LocalDataSource.Storage.SESSION, LocalDataSource.Storage.PERSIST, this.myPasswordItem}){

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == PasswordStorageComponent.this.myPasswordItem) {
                PasswordStorageComponent.openPasswordSettings();
            } else {
                super.setSelectedItem(anObject);
            }
        }
    }){

        public int getMinimumPopupWidth() {
            Object proto2 = this.getPrototypeDisplayValue();
            this.setPrototypeDisplayValue(null);
            int width = this.getPreferredSize().width;
            this.setPrototypeDisplayValue(proto2);
            return width;
        }
    };

    public PasswordStorageComponent() {
        this.myComboBox.setPrototypeDisplayValue((Object)LocalDataSource.Storage.MEMORY);
        this.myComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label2, value2, index2) -> {
            label2.setText(PasswordStorageComponent.getText(value2));
            boolean unavailable = PasswordStorageComponent.isUnavailable(value2);
            label2.setToolTipText(this.getTooltip(value2, unavailable));
            label2.setIcon(PasswordStorageComponent.getIcon(value2, unavailable));
        }));
        this.myComboBox.addItemListener(e2 -> this.myComboBox.setToolTipText(this.getTooltip(e2.getItem(), PasswordStorageComponent.isUnavailable(e2.getItem()))));
    }

    @Nullable
    private static Icon getIcon(Object value2, boolean unavailable) {
        return unavailable ? AllIcons.General.Error : (value2 instanceof LocalDataSource.Storage ? null : AllIcons.General.Gear);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    private String getTooltip(Object value2, boolean unavailable) {
        Object tip = this.getToolTip(value2);
        if (unavailable) {
            tip = (String)tip + "\n" + HtmlChunk.br() + DatabaseBundle.message("unavailable.due.to.ide.password.storage.settings", new Object[0]);
        }
        return tip;
    }

    private static boolean isUnavailable(Object value2) {
        return value2 instanceof LocalDataSource.Storage && ((LocalDataSource.Storage)((Object)value2)).isPersisted() && PasswordStorageComponent.isNonPersistentStorage();
    }

    private static void openPasswordSettings() {
        CredentialStoreUiService.Companion.getInstance().openSettings(null);
    }

    public static boolean isNonPersistentStorage() {
        PasswordSafeSettings settings = (PasswordSafeSettings)ApplicationManager.getApplication().getService(PasswordSafeSettings.class);
        ProviderType type2 = settings.getProviderType();
        return type2 == ProviderType.MEMORY_ONLY || type2 == ProviderType.DO_NOT_STORE;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String getToolTip(Object v2) {
        return v2 instanceof LocalDataSource.Storage ? PasswordStorageComponent.getToolTip((LocalDataSource.Storage)((Object)v2)) : (v2 == this.myPasswordItem ? DatabaseBundle.message("open.ide.passwords.settings", new Object[0]) : null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getToolTip(LocalDataSource.Storage v2) {
        if (v2 == LocalDataSource.Storage.NO) {
            return DatabaseBundle.message("data.source.setting.password.storage.tooltip.never", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.MEMORY) {
            return DatabaseBundle.message("data.source.setting.password.storage.tooltip.memory", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.SESSION) {
            return DatabaseBundle.message("data.source.setting.password.storage.tooltip.session", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.PERSIST) {
            return DatabaseBundle.message("data.source.setting.password.storage.tooltip.forever", new Object[0]);
        }
        return "";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getText(Object v2) {
        return v2 instanceof LocalDataSource.Storage ? PasswordStorageComponent.getText((LocalDataSource.Storage)((Object)v2)) : v2.toString();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getText(LocalDataSource.Storage v2) {
        if (v2 == LocalDataSource.Storage.NO) {
            return DatabaseBundle.message("data.source.setting.password.storage.never", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.MEMORY) {
            return DatabaseBundle.message("data.source.setting.password.storage.memory", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.SESSION) {
            return DatabaseBundle.message("data.source.setting.password.storage.session", new Object[0]);
        }
        if (v2 == LocalDataSource.Storage.PERSIST) {
            return DatabaseBundle.message("data.source.setting.password.storage.forever", new Object[0]);
        }
        return "";
    }

    @NotNull
    public JComboBox<?> getComponent() {
        ComboBoxWithWidePopup<Object> comboBoxWithWidePopup = this.myComboBox;
        if (comboBoxWithWidePopup == null) {
            PasswordStorageComponent.$$$reportNull$$$0(0);
        }
        return comboBoxWithWidePopup;
    }

    public LocalDataSource.Storage getStorage() {
        return (LocalDataSource.Storage)((Object)ObjectUtils.notNull((Object)((Object)((LocalDataSource.Storage)((Object)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), LocalDataSource.Storage.class)))), (Object)((Object)LocalDataSource.Storage.NO)));
    }

    public void setPasswordStorage(LocalDataSource.Storage storage) {
        this.myComboBox.setSelectedItem((Object)storage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/PasswordStorageComponent", "getComponent"));
    }
}

