/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParameterEditorModel;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlEditorModel
extends UrlEditorModelBase {
    private final List<ParameterEditorModel> myGroups;
    private int myActive;
    private String myUrl;
    private int myPrevActive;
    private boolean myColdStart;

    public UrlEditorModel(@NotNull Collection<StatelessJdbcUrlParser> parsers) {
        if (parsers == null) {
            UrlEditorModel.$$$reportNull$$$0(0);
        }
        this.myUrl = "";
        this.myColdStart = true;
        MultiMap grouped = MultiMap.createLinked();
        for (StatelessJdbcUrlParser parser2 : parsers) {
            grouped.putValue((Object)parser2.getName(), (Object)parser2);
        }
        this.myGroups = new ArrayList<ParameterEditorModel>(grouped.keySet().size());
        for (String name2 : grouped.keySet()) {
            this.myGroups.add(new ParameterEditorModel(name2, grouped.get((Object)name2)));
        }
        this.myGroups.add(new ParameterEditorModel("URL only", Collections.emptyList()));
        this.myActive = this.myPrevActive = this.getDefaultIdx();
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            UrlEditorModel.$$$reportNull$$$0(1);
        }
        if (this.myUrl.equals(url)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        this.myUrl = url;
    }

    @NotNull
    private ParameterEditorModel getActiveGroup() {
        ParameterEditorModel parameterEditorModel = this.myGroups.get(this.myActive);
        if (parameterEditorModel == null) {
            UrlEditorModel.$$$reportNull$$$0(2);
        }
        return parameterEditorModel;
    }

    @Override
    public void setParameter(@NotNull String param, @NotNull String value2) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            UrlEditorModel.$$$reportNull$$$0(4);
        }
        this.getActiveGroup().setParameter(param, value2);
        if (this.getActiveGroup().getState() == UrlEditorModelBase.State.PARAMS_CHANGED) {
            this.invalidate(UrlEditorModelBase.State.PARAMS_CHANGED);
        }
    }

    public boolean commit(@Nullable Object arg) {
        if (this.getState() == UrlEditorModelBase.State.VALID && this.myPrevActive == this.myActive) {
            assert (this.getActiveGroup().getState() == UrlEditorModelBase.State.VALID);
            return false;
        }
        boolean changed = false;
        if (this.getState() == UrlEditorModelBase.State.URL_CHANGED) {
            if (this.myPrevActive == this.myActive || this.myColdStart) {
                changed = this.chooseGroup();
            }
            this.getActiveGroup().setUrl(this.myUrl);
        }
        changed |= this.getActiveGroup().commit(arg);
        if (!this.myUrl.equals(this.getActiveGroup().getUrl())) {
            changed = true;
            this.myUrl = this.getActiveGroup().getUrl();
        }
        boolean bl = this.myPrevActive != this.myActive;
        this.myPrevActive = this.myActive;
        this.myColdStart = false;
        return this.validate(changed |= bl, arg);
    }

    @Nullable
    public StatelessJdbcUrlParser getMeaningfulParser() {
        if (!this.isUrlOnly()) {
            return this.getCurrentParser();
        }
        for (ParameterEditorModel group2 : this.myGroups) {
            StatelessJdbcUrlParser parser2 = group2.getMeaningfulParser(this.getUrl());
            if (parser2 == null) continue;
            return parser2;
        }
        return null;
    }

    private boolean chooseGroup() {
        if (!this.myColdStart && this.getActiveGroup().isUrlValueValid(this.myUrl)) {
            return false;
        }
        int active = -1;
        int rank = -1;
        int i2 = 0;
        while (i2 + 1 < this.myGroups.size()) {
            int curRank;
            ParameterEditorModel group2 = this.myGroups.get(i2);
            if ((this.myColdStart || i2 != this.myActive) && group2.isUrlValueValid(this.myUrl) && (curRank = this.getRank(group2)) > rank) {
                active = i2;
                rank = curRank;
            }
            ++i2;
        }
        if (active != -1) {
            this.myActive = active;
            return true;
        }
        return false;
    }

    private int getRank(ParameterEditorModel group2) {
        return JdbcUrlParserUtil.getRank(JdbcUrlParserUtil.parsed(group2.getMeaningfulParser(this.myUrl), this.myUrl));
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            UrlEditorModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getAnonymizedUrl() {
        if (!this.isParserValid()) {
            String string = this.getUrl();
            if (string == null) {
                UrlEditorModel.$$$reportNull$$$0(6);
            }
            return string;
        }
        JdbcUrlParser parser2 = JdbcUrlParserUtil.stateful(this.getCurrentParser());
        if (parser2 == null) {
            String string = this.getUrl();
            if (string == null) {
                UrlEditorModel.$$$reportNull$$$0(7);
            }
            return string;
        }
        parser2.setUrlText(this.getUrl());
        for (String parameter : this.getParameterNames()) {
            if (!parser2.isValid() || StringUtil.isEmpty((String)this.getParameter(parameter)) || !"user".equals(parameter) && !"password".equals(parameter)) continue;
            parser2.setParameter(parameter, "");
        }
        String string = parser2.getUrlText();
        if (string == null) {
            UrlEditorModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    public int getActiveGroupId() {
        return this.myActive;
    }

    @NotNull
    public String getGroupName(int id) {
        String string = this.myGroups.get(id).getName();
        if (string == null) {
            UrlEditorModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String param) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(10);
        }
        return this.getActiveGroup().getParameter(param);
    }

    @Override
    @Nullable
    public StatelessParametersHolder getParametersHolderDelegate() {
        return this.getActiveGroup();
    }

    public int getGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public StatelessParametersHolder getGroup(int i2) {
        StatelessParametersHolder statelessParametersHolder = this.myGroups.get(i2);
        if (statelessParametersHolder == null) {
            UrlEditorModel.$$$reportNull$$$0(11);
        }
        return statelessParametersHolder;
    }

    private boolean isValidUrlValue(@NotNull String url) {
        if (url == null) {
            UrlEditorModel.$$$reportNull$$$0(12);
        }
        if (!this.isUrlOnly() && this.getActiveGroup().isUrlValueValid(url)) {
            return true;
        }
        int i2 = 0;
        while (i2 + 1 < this.myGroups.size()) {
            ParameterEditorModel group2 = this.myGroups.get(i2);
            if (i2 != this.myActive && group2.isUrlValueValid(url)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void assign(@NotNull UrlEditorModel source) {
        String url;
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(13);
        }
        if (this.isValidUrlValue(url = source.getUrl()) || source.isUrlOnly() || !source.isParserValid()) {
            this.setUrl(url);
            return;
        }
        int covering = -1;
        for (int i2 = 0; i2 < this.myGroups.size(); ++i2) {
            if (!UrlEditorModel.commonParameters(source, this.myGroups.get(i2), true)) continue;
            covering = i2;
            break;
        }
        if (covering == -1) {
            this.setUrl(url);
            return;
        }
        this.myActive = covering;
        UrlEditorModel.transferParameters(source, this);
    }

    private static boolean commonParameters(@NotNull ParametersHolder source, @NotNull StatelessParametersHolder parameters2, boolean covers) {
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(14);
        }
        if (parameters2 == null) {
            UrlEditorModel.$$$reportNull$$$0(15);
        }
        HashSet<String> parserParams = new HashSet<String>(parameters2.getParameterNames());
        for (String s2 : source.getParameterNames()) {
            boolean swapSidWithService;
            if (StringUtil.isEmpty((String)source.getParameter(s2))) continue;
            boolean bl = swapSidWithService = "SID".equals(s2) && parserParams.contains("service") || "service".equals(s2) && parserParams.contains("SID");
            if (parserParams.contains(s2) == covers && !swapSidWithService) continue;
            return !covers;
        }
        return covers;
    }

    private static void transferParameters(@NotNull ParametersHolder source, @NotNull UrlEditorModel target2) {
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(16);
        }
        if (target2 == null) {
            UrlEditorModel.$$$reportNull$$$0(17);
        }
        for (String parameter : source.getParameterNames()) {
            String value2 = source.getParameter(parameter);
            if (value2 == null) continue;
            target2.setParameter(parameter, value2);
            if ("SID".equals(parameter)) {
                target2.setParameter("service", value2);
            }
            if (!"service".equals(parameter)) continue;
            target2.setParameter("SID", value2);
        }
    }

    @NotNull
    public Collection<TextRange> getInvalidRanges() {
        Collection<TextRange> collection2 = this.getActiveGroup().getInvalidRanges();
        if (collection2 == null) {
            UrlEditorModel.$$$reportNull$$$0(18);
        }
        return collection2;
    }

    @Nullable
    public TextRange getParameterRange(@NotNull String param) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(19);
        }
        return this.getActiveGroup().getParameterRange(param);
    }

    public void selectGroup(int group2) {
        if (this.myActive == group2) {
            return;
        }
        ParameterEditorModel cur = this.myGroups.get(group2);
        ParameterEditorModel prev = this.getActiveGroup();
        this.myActive = group2;
        boolean valid = cur.isUrlValueValid(this.myUrl);
        if (!valid && UrlEditorModel.commonParameters(prev, cur, false)) {
            UrlEditorModel.transferParameters(prev, this);
        } else if (!valid && cur.getActiveParser() != null && cur.getParameterNames().isEmpty()) {
            cur.getActiveParser().purgeErrors();
            this.myUrl = cur.getActiveParser().getUrlText();
            this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        } else {
            cur.setUrl(this.myUrl);
            this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        }
    }

    public boolean isParserValid() {
        return this.getActiveGroup().isParserValid();
    }

    @Nullable
    public StatelessJdbcUrlParser getCurrentParser() {
        return this.getActiveGroup().getActiveParser();
    }

    public boolean isUrlOnly() {
        return this.myActive + 1 == this.myGroups.size();
    }

    public void setUrlOnly(boolean only) {
        if (only == this.isUrlOnly()) {
            return;
        }
        this.selectGroup(only ? this.myGroups.size() - 1 : this.getDefaultIdx());
        this.myColdStart = !only;
    }

    private int getDefaultIdx() {
        for (int i2 = 0; i2 < this.myGroups.size(); ++i2) {
            if (!this.myGroups.get(i2).getName().equals("default")) continue;
            return i2;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9, 11, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/UrlEditorModel";
                break;
            }
            case 3: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/UrlEditorModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymizedUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setParameter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isValidUrlValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assign";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "commonParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "transferParameters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameterRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9, 11, 18 -> new IllegalStateException(string);
        };
    }
}

