/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DbOptionsEditor<Target> {
    private final DbOptionsEditors<Target> myAllEditors;
    private final JComponent myPanel;
    public static Key<Boolean> CUSTOM_LAYOUT = Key.create((String)"CUSTOM_LAYOUT");
    @NotNull
    private final DataContext myDataContext;
    private final int myRowLength;

    public DbOptionsEditor(Target target2, Condition<DbOptionProvider<Target, ?>> initialCondition, Consumer<? super DbOptionProvider<Target, ?>> consumer2, @NotNull DataContext dataContext, int rowLength) {
        if (dataContext == null) {
            DbOptionsEditor.$$$reportNull$$$0(0);
        }
        this.myDataContext = dataContext;
        this.myRowLength = rowLength;
        this.myAllEditors = new DbOptionsEditors<Target>(DbImplUtilCore.classOf(target2), initialCondition, consumer2);
        this.myPanel = new JPanel();
        this.updateList(target2);
        this.myAllEditors.reset(target2);
    }

    public void updateList(Target target2) {
        this.myPanel.removeAll();
        List<DbOptionsEditors.OptionEditor<Target, ?>> filtered2 = this.myAllEditors.getFiltered(target2);
        this.myPanel.setVisible(!filtered2.isEmpty());
        if (!filtered2.isEmpty()) {
            this.myPanel.setLayout((LayoutManager)new GridLayoutManager(filtered2.size(), this.myRowLength));
            boolean hasBiComponent = false;
            for (int i2 = 0; i2 < filtered2.size(); ++i2) {
                DbOptionsEditors.OptionEditor<Target, ?> value2 = filtered2.get(i2);
                JComponent component2 = value2.createComponent(target2, this.myDataContext);
                component2.setToolTipText(value2.provider.getDescription());
                if (Boolean.TRUE.equals(ClientProperty.get((Component)component2, CUSTOM_LAYOUT))) {
                    this.myPanel.add((Component)component2, DatabaseUIUtils.createRowConstraints(i2, true, this.myRowLength));
                    continue;
                }
                if (component2 instanceof JCheckBox) {
                    ((JCheckBox)component2).setText(value2.provider.getDisplayName());
                    this.myPanel.add((Component)component2, DatabaseUIUtils.createRowConstraints(i2, false, this.myRowLength));
                    continue;
                }
                JBLabel label2 = new JBLabel(value2.provider.getDisplayName());
                this.myPanel.add((Component)label2, DatabaseUIUtils.createLabelConstraints(i2, 0, label2.getPreferredSize().width));
                this.myPanel.add((Component)component2, DatabaseUIUtils.createSimpleConstraints(i2, 1, this.myRowLength - 1));
                hasBiComponent = true;
            }
            if (!hasBiComponent) {
                this.myPanel.add((Component)new Spacer(), DatabaseUIUtils.createSimpleConstraints(0, 1, this.myRowLength - 1));
            }
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    public void apply(Target target2) {
        this.myAllEditors.apply(target2);
    }

    public void reset(Target target2) {
        this.updateList(target2);
        this.myAllEditors.reset(target2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dataSource/ui/DbOptionsEditor", "<init>"));
    }

    public static class DbOptionsEditors<Target> {
        private final List<OptionEditor<Target, ?>> myAllValues;

        public DbOptionsEditors(Class<Target> targetClass, Condition<DbOptionProvider<Target, ?>> initialCondition, Consumer<? super DbOptionProvider<Target, ?>> consumer2) {
            this.myAllValues = ContainerUtil.newArrayList((Iterable)DbOptionProvider.getProviders(targetClass).filter(initialCondition).map(p2 -> new OptionEditor(p2, consumer2)));
            this.myAllValues.sort(Comparator.comparing(o2 -> o2.provider.getDisplayName()));
        }

        public void apply(Target target2) {
            for (OptionEditor<Target, ?> value2 : this.myAllValues) {
                value2.apply(target2);
            }
        }

        public void reset(Target target2) {
            for (OptionEditor<Target, ?> value2 : this.myAllValues) {
                value2.reset(target2);
            }
        }

        @NotNull
        public List<OptionEditor<Target, ?>> getFiltered(Target target2) {
            List list = ContainerUtil.filter(this.myAllValues, v2 -> v2.provider.isApplicable(target2));
            if (list == null) {
                DbOptionsEditors.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/ui/DbOptionsEditor$DbOptionsEditors", "getFiltered"));
        }

        public static final class OptionEditor<Target, T> {
            public final DbOptionProvider<Target, T> provider;
            private final Runnable changed;
            public DbOptionProvider.EditorDesc<T> editor;

            public void apply(Target target2) {
                Object value2 = this.editor == null ? this.provider.load(null) : this.editor.getter.get();
                this.provider.store(target2, value2);
            }

            public void reset(Target target2) {
                if (this.editor != null) {
                    T value2 = this.provider.load(target2);
                    this.editor.setter.set(value2);
                }
            }

            public OptionEditor(DbOptionProvider<Target, T> provider, Consumer<? super DbOptionProvider<Target, ?>> consumer2) {
                this.provider = provider;
                this.changed = consumer2 == null ? null : () -> consumer2.accept(provider);
            }

            public JComponent createComponent(Target target2, @NotNull DataContext dataContext) {
                if (dataContext == null) {
                    OptionEditor.$$$reportNull$$$0(0);
                }
                this.editor = this.provider.getEditor(target2, dataContext);
                this.editor.changed.set((Object)this.changed);
                return this.editor.component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/dataSource/ui/DbOptionsEditor$DbOptionsEditors$OptionEditor", "createComponent"));
            }
        }
    }
}

