/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.ui.DriverInstantiateComponent;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent;", "", "configurable", "Lcom/intellij/database/dataSource/DataSourceConfigurable;", "(Lcom/intellij/database/dataSource/DataSourceConfigurable;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getConfigurable", "()Lcom/intellij/database/dataSource/DataSourceConfigurable;", "statusIcon", "Ljavax/swing/JLabel;", "statusText", "Lcom/intellij/ui/components/labels/LinkLabel;", "getInfo", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "showDetails", "", "info", "update", "GrayLabel", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionComponent.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class DataSourceTestConnectionComponent {
    @NotNull
    private final DataSourceConfigurable configurable;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JLabel statusIcon;
    @NotNull
    private final LinkLabel<?> statusText;

    public DataSourceTestConnectionComponent(@NotNull DataSourceConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        Ref.ObjectRef iconLbl = new Ref.ObjectRef();
        Ref.ObjectRef statusLbl = new Ref.ObjectRef();
        this.component = (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((Ref.ObjectRef<JLabel>)iconLbl, statusLbl){
            final /* synthetic */ Ref.ObjectRef<JLabel> $iconLbl;
            final /* synthetic */ Ref.ObjectRef<LinkLabel<?>> $statusLbl;
            {
                this.$iconLbl = $iconLbl;
                this.$statusLbl = $statusLbl;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = DatabaseBundle.message("DataSourceTestConnectionPanel.test.connection", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.link(string, (Function1)new Function1<ActionEvent, Unit>(){

                            public final void invoke(@NotNull ActionEvent it2) {
                                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                this.getConfigurable().getTestConnectionManager().testConnection(null, true);
                            }
                        }).gap(RightGap.SMALL);
                        Icon icon = AllIcons.RunConfigurations.TestPassed;
                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TestPassed");
                        $this$row.icon(icon).applyToComponent((Function1)new Function1<JLabel, Unit>(){

                            public final void invoke(@NotNull JLabel $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $iconLbl.element = $this$applyToComponent;
                            }
                        }).gap(RightGap.SMALL);
                        $this$row.cell((JComponent)((Object)new GrayLabel("", null, (LinkListener<Object>)((LinkListener)(arg_0, arg_1) -> 1.invoke$lambda$0(this, arg_0, arg_1))))).applyToComponent((Function1)new Function1<GrayLabel, Unit>(){

                            public final void invoke(@NotNull GrayLabel $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
                                $statusLbl.element = $this$applyToComponent;
                            }
                        });
                        DefaultActionGroup group2 = new DefaultActionGroup();
                        AnAction anAction = this.getConfigurable().getController().createResetAction(this.getConfigurable());
                        if (anAction != null) {
                            AnAction it2 = anAction;
                            boolean bl = false;
                            group2.add(it2);
                        }
                        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group2, true);
                        DataSourceTestConnectionComponent dataSourceTestConnectionComponent = this;
                        ActionToolbar $this$invoke_u24lambda_u242 = actionToolbar;
                        boolean bl = false;
                        $this$invoke_u24lambda_u242.setMiniMode(true);
                        $this$invoke_u24lambda_u242.setTargetComponent(dataSourceTestConnectionComponent.getConfigurable().getPreferredFocusedComponent());
                        ActionToolbar actionToolbar2 = actionToolbar;
                        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
                        ActionToolbar toolbar2 = actionToolbar2;
                        $this$row.cell(toolbar2.getComponent()).align((Align)AlignX.RIGHT.INSTANCE);
                    }

                    private static final void invoke$lambda$0(DataSourceTestConnectionComponent this$0, LinkLabel linkLabel, Object object) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.showDetails(this$0.getInfo());
                    }
                }), (int)1, null);
            }
        }));
        Object object = iconLbl.element;
        Intrinsics.checkNotNull((Object)object);
        this.statusIcon = (JLabel)object;
        Object object2 = statusLbl.element;
        Intrinsics.checkNotNull((Object)object2);
        this.statusText = (LinkLabel)object2;
        ((DialogPanel)this.component).setBorder(DriverInstantiateComponent.Companion.getTopPanelBorder());
        this.update(this.getInfo());
    }

    @NotNull
    public final DataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final DataSourceTestConnectionManager.TestInfo getInfo() {
        return this.configurable.getTestConnectionManager().getInfo(null);
    }

    private final void showDetails(DataSourceTestConnectionManager.TestInfo info2) {
        DataSourceTestConnectionManager dataSourceTestConnectionManager = this.configurable.getTestConnectionManager();
        RelativePoint relativePoint = RelativePoint.getNorthWestOf((JComponent)((JComponent)this.statusText));
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getNorthWestOf(...)");
        dataSourceTestConnectionManager.showDetails(relativePoint, info2);
    }

    public final void update(@NotNull DataSourceTestConnectionManager.TestInfo info2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        DataSourceInfo dbi = this.configurable.getDatabaseInfo();
        this.statusIcon.setIcon(info2.getIcon());
        Object it2 = object = StringKt.nullize$default((String)dbi.getDatabaseVersion().name, (boolean)false, (int)1, null);
        boolean bl = false;
        Object object2 = Intrinsics.areEqual((Object)dbi.getDbms(), (Object)Dbms.UNKNOWN) || dbi.getDbms() == null ? object : null;
        if (object2 == null) {
            Dbms dbms = dbi.getDbms();
            object2 = dbms != null ? dbms.getDisplayName() : null;
            if (object2 == null) {
                object2 = "";
            }
        }
        String name2 = object2;
        it2 = object = dbi.getExactVersion();
        boolean bl2 = false;
        Object version = !Intrinsics.areEqual((Object)it2, (Object)Version.ZERO) ? object : null;
        Object object3 = version;
        if (object3 == null) {
            object3 = "";
        }
        this.statusText.setText(name2 + " " + object3);
        if (info2.getStatus() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.showDetails(info2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B.\u0012\r\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\b\u0010\u000e\u001a\u00020\fH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$GrayLabel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "icon", "Ljavax/swing/Icon;", "aListener", "Lcom/intellij/ui/components/labels/LinkListener;", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/ui/components/labels/LinkListener;)V", "getActive", "Ljava/awt/Color;", "getHover", "getNormal", "getVisited", "intellij.database.impl"})
    public static final class GrayLabel
    extends LinkLabel<Object> {
        public GrayLabel(@Nullable String text2, @Nullable Icon icon, @Nullable LinkListener<Object> aListener) {
            super(text2, icon, aListener);
            this.setFocusable(true);
        }

        @NotNull
        protected Color getActive() {
            return this.getNormal();
        }

        @NotNull
        protected Color getNormal() {
            Color color = JBUI.CurrentTheme.Label.disabledForeground((boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"disabledForeground(...)");
            return color;
        }

        @NotNull
        protected Color getHover() {
            Color color = JBUI.CurrentTheme.Label.foreground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
            return color;
        }

        @NotNull
        protected Color getVisited() {
            return this.getNormal();
        }
    }
}

