/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducer;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b&\u0018\u0000 S*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0005RSTUVB\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ1\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u00012\u0006\u0010+\u001a\u00020(H$\u00a2\u0006\u0002\u0010,J/\u0010-\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0001H$\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020\u001aH\u0016J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00105J\u001d\u00106\u001a\u0002032\u0006\u0010)\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u00107J\u001d\u00108\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00109J)\u0010:\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020;0&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=H\u0016\u00a2\u0006\u0002\u0010>JC\u0010:\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H?0&\"\u0004\b\u0002\u0010?2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u0002H?0AH\u0016\u00a2\u0006\u0002\u0010CJ)\u0010D\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020;0&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=H\u0002\u00a2\u0006\u0002\u0010>J%\u0010E\u001a\u00020(2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=2\u0006\u0010*\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010FJ'\u0010G\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010H0&2\u0006\u0010)\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010IJ7\u0010J\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\u0006\u0010)\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=2\f\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00010HH\u0002\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020\u001aH\u0014J\u0016\u0010N\u001a\u0002032\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010HH\u0002J!\u0010O\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00028\u00010&2\u0006\u0010)\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010IJ\u0015\u0010P\u001a\u00028\u00012\u0006\u0010*\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010QR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006W"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "INPUT", "STATEMENT", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "getConfiguration", "()Lcom/intellij/database/dataSource/connection/statements/Configuration;", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "currentStatement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "running", "", "getRunning", "()Z", "source", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementSource;", "getSource", "()Lcom/intellij/database/dataSource/connection/statements/SmartStatementSource;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "before", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/dataSource/connection/Either;", "cancel", "closeStatement", "", "it", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "configure", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemoteStatement;", "execute", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;)Lcom/intellij/database/dataSource/connection/Either;", "T", "callback", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lkotlin/jvm/functions/Function1;)Lcom/intellij/database/dataSource/connection/Either;", "executeInCommonWay", "executeJdbcStatement", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "getCurrentStatement", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/Either;", "memorizeAndExecute", "ref", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;)Lcom/intellij/database/dataSource/connection/Either;", "needToDisableEscapeProcessing", "reportProcessed", "statementInstance", "updateStatementConfiguration", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Call", "Companion", "ExceptionTransformer", "Parameterized", "Simple", "intellij.database.core.impl"})
public abstract class JdbcBasedSmartStatement<INPUT, STATEMENT extends RemoteStatement>
implements SmartStatement<INPUT>,
SmartStatementMark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ListenerAuditService auditService;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private STATEMENT currentStatement;
    @NotNull
    private static final Logger LOG;

    public JdbcBasedSmartStatement(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.connection = connection2;
        this.auditService = auditService;
        this.configuration = configuration;
    }

    @NotNull
    protected final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    protected final ListenerAuditService getAuditService() {
        return this.auditService;
    }

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected abstract StatementHolder<STATEMENT> getStatementHolder();

    @Override
    @NotNull
    public SmartStatementSource getSource() {
        return this.configuration.getSource();
    }

    @Override
    public boolean getRunning() {
        return this.currentStatement != null;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        return this.configuration.getDepartment();
    }

    @Override
    @NotNull
    public <T> Either<StagedException, T> execute(INPUT input, @NotNull ExecutionMode mode, @NotNull Function1<? super ResultsProducer, ? extends T> callback) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return EitherKt.transformSafe(this.executeInCommonWay(input, mode), (Function1)new Function1<ClosableResultsProducer, Either<StagedException, T>>(this, callback){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ Function1<ResultsProducer, T> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(1);
            }

            @NotNull
            public final Either<StagedException, T> invoke(@NotNull ClosableResultsProducer it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.RESULTS_PROCESSING, this.this$0, (Function0)new Function0<T>(it2, this.$callback){
                    final /* synthetic */ ClosableResultsProducer $it;
                    final /* synthetic */ Function1<ResultsProducer, T> $callback;
                    {
                        this.$it = $it;
                        this.$callback = $callback;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T invoke() {
                        Object object;
                        AutoCloseable autoCloseable = this.$it;
                        Function1<ResultsProducer, T> function1 = this.$callback;
                        Throwable throwable = null;
                        try {
                            object = function1.invoke((Object)autoCloseable);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        return (T)object;
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public Either<StagedException, ClosableResultsProducer> execute(INPUT input, @NotNull ExecutionMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return this.executeInCommonWay(input, mode).shelter(execute.2.INSTANCE);
    }

    @Override
    public boolean cancel() {
        STATEMENT current = this.currentStatement;
        if (current == null) {
            return true;
        }
        return SmartStatementsUtil.runWithoutReporting(this.connection, StagedException.Stage.CANCEL, this, (Function0)new Function0<Unit>(current){
            final /* synthetic */ STATEMENT $current;
            {
                this.$current = $current;
                super(0);
            }

            public final void invoke() {
                this.$current.cancel();
            }
        }).isRight();
    }

    protected void configure(INPUT input, @NotNull STATEMENT statement2) throws SQLException {
        Intrinsics.checkNotNullParameter(statement2, (String)"statement");
        JdbcHelper jdbcHelper = DbImplUtilCore.getJdbcHelper(this.connection.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)jdbcHelper, (String)"getJdbcHelper(...)");
        JdbcHelper helper = jdbcHelper;
        if (this.configuration.getMaxRows() != null && helper.supportsLimitMaxRows()) {
            statement2.setMaxRows(this.configuration.getMaxRows().intValue());
        }
        if (this.configuration.getFetchSize() != null) {
            statement2.setFetchSize(this.configuration.getFetchSize().intValue());
        }
    }

    private final Either<StagedException, ClosableResultsProducer> executeInCommonWay(INPUT input, ExecutionMode mode) {
        Either<StagedException, StatementHolder.CloseableRef<STATEMENT>> statementEither = this.getCurrentStatement(input);
        StatementHolder.CloseableRef<STATEMENT> statement2 = statementEither.getRight();
        return EitherKt.transformSafe(statementEither, (Function1)new Function1<StatementHolder.CloseableRef<STATEMENT>, Either<StagedException, ExecutionResult>>(this, input, mode){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ INPUT $input;
            final /* synthetic */ ExecutionMode $mode;
            {
                this.this$0 = $receiver;
                this.$input = $input;
                this.$mode = $mode;
                super(1);
            }

            @NotNull
            public final Either<StagedException, ExecutionResult> invoke(@NotNull StatementHolder.CloseableRef<STATEMENT> it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                return JdbcBasedSmartStatement.access$memorizeAndExecute(this.this$0, this.$input, this.$mode, it2);
            }
        }).shelter((Function1)new Function1<ExecutionResult, ClosableResultsProducer>(statement2, this){
            final /* synthetic */ StatementHolder.CloseableRef<STATEMENT> $statement;
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            {
                this.$statement = $statement;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ClosableResultsProducer invoke(@NotNull ExecutionResult it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                StatementHolder.CloseableRef<STATEMENT> closeableRef = this.$statement;
                Intrinsics.checkNotNull(closeableRef);
                return new UniversalResultsProducer<STATEMENT>(closeableRef, this.this$0, this.this$0.getConfiguration(), this.this$0.getConnection(), it2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Either<StagedException, ExecutionResult> memorizeAndExecute(INPUT input, ExecutionMode mode, StatementHolder.CloseableRef<STATEMENT> ref2) {
        Either either;
        STATEMENT statement2 = ref2.getValue();
        boolean error2 = false;
        try {
            this.currentStatement = statement2;
            either = EitherKt.transformSafe(EitherKt.transformSafe(this.before(input, statement2), (Function1)new Function1<List<? extends RemoteCloseable>, Either<StagedException, Pair<? extends List<? extends RemoteCloseable>, ? extends ExecutionResult>>>(this, input, mode, statement2){
                final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
                final /* synthetic */ INPUT $input;
                final /* synthetic */ ExecutionMode $mode;
                final /* synthetic */ STATEMENT $statement;
                {
                    this.this$0 = $receiver;
                    this.$input = $input;
                    this.$mode = $mode;
                    this.$statement = $statement;
                    super(1);
                }

                @NotNull
                public final Either<StagedException, Pair<List<RemoteCloseable>, ExecutionResult>> invoke(@NotNull List<? extends RemoteCloseable> filesToClose) {
                    Intrinsics.checkNotNullParameter(filesToClose, (String)"filesToClose");
                    return SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.EXECUTE, this.this$0, (Function0)new Function0<Pair<? extends List<? extends RemoteCloseable>, ? extends ExecutionResult>>(filesToClose, this.this$0, this.$input, this.$mode, this.$statement){
                        final /* synthetic */ List<RemoteCloseable> $filesToClose;
                        final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
                        final /* synthetic */ INPUT $input;
                        final /* synthetic */ ExecutionMode $mode;
                        final /* synthetic */ STATEMENT $statement;
                        {
                            this.$filesToClose = $filesToClose;
                            this.this$0 = $receiver;
                            this.$input = $input;
                            this.$mode = $mode;
                            this.$statement = $statement;
                            super(0);
                        }

                        @NotNull
                        public final Pair<List<RemoteCloseable>, ExecutionResult> invoke() {
                            return new Pair(this.$filesToClose, (Object)this.this$0.executeJdbcStatement(this.$input, this.$mode, this.$statement));
                        }
                    });
                }
            }), (Function1)new Function1<Pair<? extends List<? extends RemoteCloseable>, ? extends ExecutionResult>, Either<StagedException, ExecutionResult>>(this, input, statement2){
                final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
                final /* synthetic */ INPUT $input;
                final /* synthetic */ STATEMENT $statement;
                {
                    this.this$0 = $receiver;
                    this.$input = $input;
                    this.$statement = $statement;
                    super(1);
                }

                @NotNull
                public final Either<StagedException, ExecutionResult> invoke(@NotNull Pair<? extends List<? extends RemoteCloseable>, ? extends ExecutionResult> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    List filesToClose = (List)pair.component1();
                    ExecutionResult result2 = (ExecutionResult)pair.component2();
                    for (RemoteCloseable closeable : filesToClose) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable t) {
                            JdbcBasedSmartStatement.access$getLOG$cp().warn(t);
                        }
                    }
                    return this.this$0.after(this.$input, this.$statement, result2);
                }
            });
        }
        catch (Throwable t) {
            try {
                error2 = true;
                throw t;
            }
            catch (Throwable throwable) {
                this.auditService.afterStatement(this);
                this.currentStatement = null;
                if (error2) {
                    this.reportProcessed(ref2);
                }
                throw throwable;
            }
        }
        this.auditService.afterStatement(this);
        this.currentStatement = null;
        return either.ifLeft((Function0<Unit>)((Function0)new Function0<Unit>(this, ref2){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ StatementHolder.CloseableRef<STATEMENT> $ref;
            {
                this.this$0 = $receiver;
                this.$ref = $ref;
                super(0);
            }

            public final void invoke() {
                JdbcBasedSmartStatement.access$reportProcessed(this.this$0, this.$ref);
            }
        }));
    }

    private final Either<StagedException, STATEMENT> statementInstance(INPUT input) {
        return EitherKt.transformSafe(SmartStatementsUtil.runReporting(this.connection, StagedException.Stage.CREATE_STATEMENT, this, (Function0)new Function0<STATEMENT>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ INPUT $input;
            {
                this.this$0 = $receiver;
                this.$input = $input;
                super(0);
            }

            @NotNull
            public final STATEMENT invoke() {
                STATEMENT statement2 = this.this$0.createStatement(this.this$0.getConnection(), this.$input);
                JdbcBasedSmartStatement.access$updateStatementConfiguration(this.this$0, statement2);
                this.this$0.getConnection().getAuditService().statementOpened((RemoteStatement)statement2, this.this$0);
                return statement2;
            }
        }), (Function1)new Function1<STATEMENT, Either<StagedException, STATEMENT>>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ INPUT $input;
            {
                this.this$0 = $receiver;
                this.$input = $input;
                super(1);
            }

            @NotNull
            public final Either<StagedException, STATEMENT> invoke(@NotNull STATEMENT it2) {
                Either<StagedException, T> either;
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                try {
                    either = SmartStatementsUtil.runReporting(this.this$0.getConnection(), StagedException.Stage.CONFIGURE_STATEMENT, this.this$0, (Function0)new Function0<STATEMENT>(this.this$0, this.$input, it2){
                        final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
                        final /* synthetic */ INPUT $input;
                        final /* synthetic */ STATEMENT $it;
                        {
                            this.this$0 = $receiver;
                            this.$input = $input;
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final STATEMENT invoke() {
                            this.this$0.configure(this.$input, this.$it);
                            return this.$it;
                        }
                    }).ifLeft((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, it2){
                        final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
                        final /* synthetic */ STATEMENT $it;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                            super(0);
                        }

                        public final void invoke() {
                            JdbcBasedSmartStatement.access$closeStatement(this.this$0, this.$it);
                        }
                    }));
                }
                catch (Throwable t) {
                    JdbcBasedSmartStatement.access$closeStatement(this.this$0, it2);
                    throw t;
                }
                return either;
            }
        });
    }

    private final STATEMENT updateStatementConfiguration(STATEMENT statement2) {
        if (this.needToDisableEscapeProcessing()) {
            try {
                statement2.setEscapeProcessing(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return statement2;
    }

    protected boolean needToDisableEscapeProcessing() {
        return Registry.is((String)"database.disable.escape.processing");
    }

    @NotNull
    protected final Either<StagedException, StatementHolder.CloseableRef<STATEMENT>> getCurrentStatement(INPUT input) {
        return (Either)this.getStatementHolder().invoke(new Function0<Either<StagedException, STATEMENT>>(this, input){
            final /* synthetic */ JdbcBasedSmartStatement<INPUT, STATEMENT> this$0;
            final /* synthetic */ INPUT $input;
            {
                this.this$0 = $receiver;
                this.$input = $input;
                super(0);
            }

            @NotNull
            public final Either<StagedException, STATEMENT> invoke() {
                return JdbcBasedSmartStatement.access$statementInstance(this.this$0, this.$input);
            }
        });
    }

    @NotNull
    protected abstract Either<StagedException, ExecutionResult> after(INPUT var1, @NotNull STATEMENT var2, @NotNull ExecutionResult var3);

    @NotNull
    protected abstract ExecutionResult executeJdbcStatement(INPUT var1, @NotNull ExecutionMode var2, @NotNull STATEMENT var3) throws SQLException;

    @NotNull
    protected abstract STATEMENT createStatement(@NotNull DatabaseConnectionCore var1, INPUT var2) throws SQLException;

    @NotNull
    protected abstract Either<StagedException, List<RemoteCloseable>> before(INPUT var1, @NotNull STATEMENT var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportProcessed(StatementHolder.CloseableRef<STATEMENT> statement2) {
        try {
            this.auditService.resultsProcessed(this);
        }
        finally {
            DbImplUtilCore.closeSafe(statement2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeStatement(STATEMENT it2) {
        try {
            this.connection.getAuditService().beforeStatementClosing((RemoteStatement)it2, this);
        }
        finally {
            JdbcNativeUtil.performSafe(() -> it2.close());
        }
    }

    public static final /* synthetic */ Either access$memorizeAndExecute(JdbcBasedSmartStatement $this, Object input, ExecutionMode mode, StatementHolder.CloseableRef ref2) {
        return $this.memorizeAndExecute(input, mode, ref2);
    }

    public static final /* synthetic */ void access$reportProcessed(JdbcBasedSmartStatement $this, StatementHolder.CloseableRef statement2) {
        $this.reportProcessed(statement2);
    }

    public static final /* synthetic */ RemoteStatement access$updateStatementConfiguration(JdbcBasedSmartStatement $this, RemoteStatement statement2) {
        return $this.updateStatementConfiguration(statement2);
    }

    public static final /* synthetic */ void access$closeStatement(JdbcBasedSmartStatement $this, RemoteStatement it2) {
        $this.closeStatement(it2);
    }

    public static final /* synthetic */ Either access$statementInstance(JdbcBasedSmartStatement $this, Object input) {
        return $this.statementInstance(input);
    }

    static {
        Logger logger2 = Logger.getInstance(JdbcBasedSmartStatement.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ1\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Call;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "basis", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "configure", "", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)V", "createStatement", "Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "intellij.database.core.impl"})
    public static abstract class Call<INPUT>
    extends Parameterized<INPUT> {
        public Call(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }

        @NotNull
        public abstract CallableStatementBasis basis(INPUT var1);

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(INPUT input, @NotNull RemotePreparedStatement statement2, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return EitherKt.transformSafe(super.after(input, statement2, result2), (Function1)new Function1<ExecutionResult, Either<StagedException, ExecutionResult>>(this, input){
                final /* synthetic */ Call<INPUT> this$0;
                final /* synthetic */ INPUT $input;
                {
                    this.this$0 = $receiver;
                    this.$input = $input;
                    super(1);
                }

                @NotNull
                public final Either<StagedException, ExecutionResult> invoke(@NotNull ExecutionResult executionResult) {
                    Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
                    return Either.Companion.right(executionResult.parametrize(this.this$0.basis(this.$input).getOutParameters()));
                }
            });
        }

        @Override
        protected void configure(INPUT input, @NotNull RemotePreparedStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            super.configure(input, (RemoteStatement)statement2);
            List<OutParameter<?>> outParameters = this.basis(input).getOutParameters();
            if (!((Collection)outParameters).isEmpty()) {
                RemoteCallableStatement callableStatement = (RemoteCallableStatement)statement2;
                for (OutParameter<?> parameter : outParameters) {
                    parameter.register(callableStatement);
                }
            }
        }

        @Override
        @NotNull
        protected RemoteCallableStatement createStatement(@NotNull DatabaseConnectionCore connection2, INPUT input) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            RemoteCallableStatement remoteCallableStatement = connection2.getRemoteConnection().prepareCall(this.basis(input).getSql());
            Intrinsics.checkNotNullExpressionValue((Object)remoteCallableStatement, (String)"prepareCall(...)");
            return remoteCallableStatement;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0002\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u0002H\u000b\"\u0004\b\u0002\u0010\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$ExceptionTransformer;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "delegate", "(Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;)V", "getDelegate", "()Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "advance", "", "close", "", "getParameterValue", "T", "parameter", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "(Lcom/intellij/database/dataSource/connection/statements/OutParameter;)Ljava/lang/Object;", "", "index", "", "processCurrent", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "processRemaining", "intellij.database.core.impl"})
    private static final class ExceptionTransformer
    implements ClosableResultsProducer {
        @NotNull
        private final ClosableResultsProducer delegate;

        public ExceptionTransformer(@NotNull ClosableResultsProducer delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final ClosableResultsProducer getDelegate() {
            return this.delegate;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean advance() {
            try {
                return this.delegate.advance();
            }
            catch (StagedException e2) {
                throw e2.getBase();
            }
        }

        @Override
        public <T> T processCurrent(@NotNull ResultsProducer.Processor<T> processor2) {
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            try {
                return this.delegate.processCurrent(processor2);
            }
            catch (StagedException e2) {
                throw e2.getBase();
            }
        }

        @Override
        public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor2) {
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            try {
                this.delegate.processRemaining(processor2);
                return;
            }
            catch (StagedException e2) {
                throw e2.getBase();
            }
        }

        @Override
        public <T> T getParameterValue(@NotNull OutParameter<T> parameter) {
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            try {
                return this.delegate.getParameterValue(parameter);
            }
            catch (StagedException e2) {
                throw e2.getBase();
            }
        }

        @Override
        @Nullable
        public Object getParameterValue(int index2) {
            try {
                return this.delegate.getParameterValue(index2);
            }
            catch (StagedException e2) {
                throw e2.getBase();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ1\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\f2\u0006\u0010\u000f\u001a\u00028\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u0016J#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0014\u00a8\u0006+"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "before", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)Lcom/intellij/database/dataSource/connection/Either;", "completeStatement", "data", "(Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Ljava/lang/Object;)Ljava/util/List;", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "decoration", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "escapeIndexes", "Ljava/util/BitSet;", "(Ljava/lang/Object;)Ljava/util/BitSet;", "executeJdbcStatement", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "extract", "", "(Ljava/lang/Object;)Ljava/lang/String;", "needToDisableEscapeProcessing", "", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nJdbcBasedSmartStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcBasedSmartStatement.kt\ncom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1603#2,9:344\n1855#2:353\n1856#2:355\n1612#2:356\n1#3:354\n*S KotlinDebug\n*F\n+ 1 JdbcBasedSmartStatement.kt\ncom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized\n*L\n209#1:344,9\n209#1:353\n209#1:355\n209#1:356\n209#1:354\n*E\n"})
    public static abstract class Parameterized<INPUT>
    extends JdbcBasedSmartStatement<INPUT, RemotePreparedStatement> {
        public Parameterized(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }

        @NotNull
        public abstract String extract(INPUT var1);

        @NotNull
        public abstract BitSet escapeIndexes(INPUT var1);

        @NotNull
        public abstract ParameterizedStatementDecoration decoration(INPUT var1);

        @Override
        protected boolean needToDisableEscapeProcessing() {
            return false;
        }

        @Override
        @NotNull
        protected RemotePreparedStatement createStatement(@NotNull DatabaseConnectionCore connection2, INPUT input) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            RemotePreparedStatement remotePreparedStatement = connection2.getRemoteConnection().prepareStatement(this.extract(input));
            Intrinsics.checkNotNullExpressionValue((Object)remotePreparedStatement, (String)"prepareStatement(...)");
            return remotePreparedStatement;
        }

        @Override
        @NotNull
        protected Either<StagedException, List<RemoteCloseable>> before(INPUT input, @NotNull RemotePreparedStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            return SmartStatementsUtil.runReporting(this.getConnection(), StagedException.Stage.PARAMETERS_COMPLETION, this, (Function0)new Function0<List<? extends RemoteCloseable>>(this, statement2, input){
                final /* synthetic */ Parameterized<INPUT> this$0;
                final /* synthetic */ RemotePreparedStatement $statement;
                final /* synthetic */ INPUT $input;
                {
                    this.this$0 = $receiver;
                    this.$statement = $statement;
                    this.$input = $input;
                    super(0);
                }

                @NotNull
                public final List<RemoteCloseable> invoke() {
                    return this.this$0.completeStatement(this.$statement, this.$input);
                }
            });
        }

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(INPUT input, @NotNull RemotePreparedStatement statement2, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return Either.Companion.right(result2);
        }

        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(INPUT input, @NotNull ExecutionMode mode, @NotNull RemotePreparedStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            return mode.execute(statement2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final List<RemoteCloseable> completeStatement(@NotNull RemotePreparedStatement statement2, INPUT data) throws Exception {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            BitSet escape = this.escapeIndexes(data);
            Iterable $this$mapNotNull$iv = this.decoration(data).getInParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RemoteCloseable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CallableStatementData.InParameter parameter = (CallableStatementData.InParameter)element$iv$iv;
                boolean bl2 = false;
                if (DbImplUtilCore.setStatementParameter(statement2, (JdbcColumnDescriptor)parameter.getData(), parameter.getData().getObject(), this.getConnection().getDbms(), escape.get(parameter.getIndex() - 1), parameter.getIndex(), parameter.getFormatsCache(), parameter.getFormatterCreator()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J*\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\f2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0018\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "statement", "result", "before", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "createStatement", "executeJdbcStatement", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "scrollableIfPossible", "intellij.database.core.impl"})
    public static abstract class Simple
    extends JdbcBasedSmartStatement<String, RemoteStatement> {
        public Simple(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection2, auditService, configuration);
        }

        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(@NotNull String input, @NotNull ExecutionMode mode, @NotNull RemoteStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            return mode.execute(input, statement2);
        }

        @Override
        @NotNull
        protected Either<StagedException, List<RemoteCloseable>> before(@NotNull String input, @NotNull RemoteStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            return Either.Companion.right(CollectionsKt.emptyList());
        }

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(@NotNull String input, @NotNull RemoteStatement statement2, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return Either.Companion.right(result2);
        }

        @Override
        @NotNull
        protected RemoteStatement createStatement(@NotNull DatabaseConnectionCore connection2, @NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            RemoteStatement remoteStatement = this.scrollableIfPossible(connection2, this.getConfiguration());
            if (remoteStatement == null) {
                RemoteStatement remoteStatement2 = connection2.getRemoteConnection().createStatement();
                remoteStatement = remoteStatement2;
                Intrinsics.checkNotNullExpressionValue((Object)remoteStatement2, (String)"createStatement(...)");
            }
            return remoteStatement;
        }

        private final RemoteStatement scrollableIfPossible(DatabaseConnectionCore connection2, Configuration configuration) {
            if (!configuration.getScrollable() || !Registry.is((String)"database.scrollable.result.sets")) {
                return null;
            }
            try {
                if (connection2.getDbms().isDb2()) {
                    return null;
                }
                RemoteDatabaseMetaData metaData = connection2.getRemoteMetaData();
                if (metaData != null && metaData.supportsResultSetType(1004)) {
                    return connection2.getRemoteConnection().createStatement(1004, 1007);
                }
            }
            catch (Exception e2) {
                LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e2);
            }
            return null;
        }
    }
}

