/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.OneShotSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableCallableStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J*\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/connection/statements/CallableSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Call;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "Lcom/intellij/database/dataSource/connection/statements/OneShotSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "basis", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "statement", "decoration", "escapeIndexes", "Ljava/util/BitSet;", "extract", "", "reuse", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "intellij.database.core.impl"})
public final class CallableSmartStatement
extends JdbcBasedSmartStatement.Call<CallableStatementData>
implements OneShotSmartStatement<CallableStatementData, CallableStatementBasis, ParameterizedStatementDecoration> {
    @NotNull
    private final StatementHolder.OneShot<RemotePreparedStatement> statementHolder;

    public CallableSmartStatement(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super(connection2, auditService, configuration);
        this.statementHolder = new StatementHolder.OneShot(auditService, this);
    }

    @Override
    @NotNull
    protected StatementHolder.OneShot<RemotePreparedStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @Override
    @NotNull
    public ReusableSmartStatement<ParameterizedStatementDecoration> reuse(@NotNull CallableStatementBasis input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new ReusableCallableStatement(input, this.getConnection(), this.getAuditService(), this.getConfiguration());
    }

    @Override
    @NotNull
    protected Either<StagedException, List<RemoteCloseable>> before(@NotNull CallableStatementData input, @NotNull RemotePreparedStatement statement2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        this.getAuditService().beforeCallableStatement(input, this);
        return super.before(input, statement2);
    }

    @Override
    @NotNull
    public String extract(@NotNull CallableStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getBasis().getSql();
    }

    @Override
    @NotNull
    public BitSet escapeIndexes(@NotNull CallableStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getBasis().getEscapingIndexes();
    }

    @Override
    @NotNull
    public ParameterizedStatementDecoration decoration(@NotNull CallableStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getDecoration();
    }

    @Override
    @NotNull
    public CallableStatementBasis basis(@NotNull CallableStatementData input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return input.getBasis();
    }
}

