/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService;
import com.intellij.database.dataSource.connection.audit.JdbcObjectsListener;
import com.intellij.database.dataSource.connection.audit.JdbcWarningsListener;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020\u0018H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010.\u001a\u00020%H\u0016J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010.\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010/\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u00101\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u0002042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u00020\u00182\u0006\u00105\u001a\u00020-H\u0016J\u0018\u00105\u001a\u00020\u00182\u0006\u00105\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "Ljava/lang/AutoCloseable;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;)V", "auditService", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "globalService", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "objectsListeners", "", "Lcom/intellij/database/dataSource/connection/audit/JdbcObjectsListener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "warningsListener", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "getWarningsListener", "()Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "afterStatement", "", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeCallableStatement", "data", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "beforeParameterizedStatement", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "beforeResultsClosing", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "beforeSimpleStatement", "sql", "", "beforeStatementClosing", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "close", "connected", "disconnected", "error", "", "message", "resultsOpened", "resultsProcessed", "statementOpened", "updateCount", "count", "", "warning", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nAdvancedAuditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedAuditService.kt\ncom/intellij/database/dataSource/connection/audit/AdvancedAuditService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1855#2,2:115\n1855#2,2:117\n1855#2,2:119\n1855#2,2:121\n*S KotlinDebug\n*F\n+ 1 AdvancedAuditService.kt\ncom/intellij/database/dataSource/connection/audit/AdvancedAuditService\n*L\n82#1:115,2\n90#1:117,2\n94#1:119,2\n98#1:121,2\n*E\n"})
public final class AdvancedAuditService
implements ListenerAuditService,
AutoCloseable {
    @Nullable
    private final Project project;
    @NotNull
    private final JdbcWarningsListener warningsListener;
    @NotNull
    private final DatabaseGlobalAuditService globalService;
    @NotNull
    private final List<JdbcObjectsListener> objectsListeners;
    @NotNull
    private final AuditService auditService;

    public AdvancedAuditService(@NotNull DatabaseConnectionCore connection2, @NotNull ConnectionRequestor requestor, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        this.project = project;
        this.warningsListener = JdbcWarningsListener.Companion.listenFor(connection2, this);
        this.globalService = DatabaseGlobalAuditService.Companion.get(this.project, connection2);
        Object[] objectArray = new JdbcObjectsListener[]{this.globalService, this.warningsListener};
        this.objectsListeners = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new AuditService[]{requestor.getAuditService(), this.globalService};
        this.auditService = AuditService.Companion.compose((AuditService[])objectArray);
        this.connected();
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JdbcWarningsListener getWarningsListener() {
        return this.warningsListener;
    }

    @Override
    public void connected() {
        this.auditService.connected();
    }

    @Override
    public void disconnected() {
        this.auditService.disconnected();
    }

    @Override
    public void updateCount(int count, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.updateCount(count, mark2);
    }

    @Override
    public void error(@NotNull Throwable error2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.error(error2, mark2);
    }

    @Override
    public void warning(@NotNull Throwable warning, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.warning(warning, mark2);
    }

    @Override
    public void message(@NotNull String message2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.message(message2, mark2);
    }

    @Override
    public void error(@NotNull Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.auditService.error(error2);
    }

    @Override
    public void warning(@NotNull Throwable warning) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        this.auditService.warning(warning);
    }

    @Override
    public void message(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.auditService.message(message2);
    }

    @Override
    public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.beforeSimpleStatement(sql, mark2);
    }

    @Override
    public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.beforeParameterizedStatement(data, mark2);
    }

    @Override
    public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.beforeCallableStatement(data, mark2);
    }

    @Override
    public void resultsProcessed(@NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.resultsProcessed(mark2);
    }

    @Override
    public void beforeStatementClosing(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Iterable $this$forEach$iv = this.objectsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcObjectsListener it2 = (JdbcObjectsListener)element$iv;
            boolean bl = false;
            it2.beforeStatementClosing(statement2, mark2);
        }
    }

    @Override
    public void afterStatement(@NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.auditService.afterStatement(mark2);
    }

    @Override
    public void statementOpened(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Iterable $this$forEach$iv = this.objectsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcObjectsListener it2 = (JdbcObjectsListener)element$iv;
            boolean bl = false;
            it2.statementOpened(statement2, mark2);
        }
    }

    @Override
    public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Iterable $this$forEach$iv = this.objectsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcObjectsListener it2 = (JdbcObjectsListener)element$iv;
            boolean bl = false;
            it2.resultsOpened(resultSet, mark2);
        }
    }

    @Override
    public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Iterable $this$forEach$iv = this.objectsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcObjectsListener it2 = (JdbcObjectsListener)element$iv;
            boolean bl = false;
            it2.beforeResultsClosing(resultSet, mark2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.disconnected();
        }
        finally {
            try {
                DbImplUtilCore.closeSafe(this.warningsListener);
            }
            finally {
                DbImplUtilCore.closeSafe(this.globalService);
            }
        }
    }
}

