/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ConfigUrlOverrider;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.util.InternedJDomReader;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002PQB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ \u0010\u0012\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0014\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\"\u0010\u0014\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0019H\u0007J\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010!\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010\"\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J.\u0010%\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00162\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040'2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u00020)2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J*\u00102\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J,\u00105\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010(\u001a\u00020)H\u0002J\u001e\u00107\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0+H\u0002J\u0018\u00108\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020 H\u0002J\u0018\u0010:\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020 H\u0002J*\u0010;\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J*\u0010<\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u00103\u001a\u0002042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010=\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040$H\u0002J&\u0010?\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0006\u0012\u0004\u0018\u00010\u00040$H\u0002J,\u0010B\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010(\u001a\u00020)H\u0002J&\u0010D\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\f\u0010E\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010F\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0006\u0010/\u001a\u000200H\u0002J\u0018\u0010G\u001a\u00020H2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bJ$\u0010I\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\b\u0010J\u001a\u0004\u0018\u00010\u00042\b\u0010K\u001a\u0004\u0018\u00010\u0004H\u0007JB\u0010I\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\b\u0010J\u001a\u0004\u0018\u00010\u00042\b\u0010L\u001a\u0004\u0018\u00010\u00042\b\u0010M\u001a\u0004\u0018\u00010\u00042\b\u0010N\u001a\u0004\u0018\u00010\u00042\b\u0010O\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization;", "", "()V", "ELEMENT_NAME", "", "LIBRARIES_ELEMENT_NAME", "LIBRARY_ELEMENT_NAME", "copyBySettings", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "temporary", "", "copyBySettingsTo", "", "from", "to", "createDataSourceFromSettings", "settings", "deserialize", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "mode", "Lcom/intellij/database/dataSource/LocalDataSourceSerialization$SaveMode;", "Ljava/io/Reader;", "deserializeBeforeTasks", "xmlReader", "beforeTasks", "", "Lcom/intellij/database/dataSource/LocalDataSource$BeforeTask;", "deserializeElement", "Lorg/jdom/Element;", "deserializeHeaderInnerTag", "deserializeInner", "deserializeLayoutConfigurations", "", "deserializeProperties", "properties", "", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "deserializeSessionTemplates", "", "Lcom/intellij/database/dataSource/DataSourceSessionTemplate;", "dataSource", "deserializeUrlOverrider", "urlOverrider", "Lcom/intellij/database/dataSource/ConfigUrlOverrider;", "getPathMacroManager", "serialize", "serializer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "serializeAdditionalProperties", "additionalProperties", "serializeBeforeTasks", "serializeElement", "rt", "serializeElementInner", "serializeHeader", "serializeHeaderInner", "serializeLayoutConfigurations", "configurations", "serializeLinkedDataSources", "linkedDataSourceIds", "Lcom/intellij/database/util/ObjectPath;", "serializeProperties", "env", "serializeSessionTemplates", "sessionTemplates", "serializeUrlOverrider", "serializedSettings", "Ljava/lang/StringBuffer;", "writeTag", "name", "value", "a1", "v1", "a2", "v2", "NoopSubstitutor", "SaveMode", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nLocalDataSourceSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDataSourceSerialization.kt\ncom/intellij/database/dataSource/LocalDataSourceSerialization\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,735:1\n1#2:736\n107#3:737\n79#3,22:738\n107#3:760\n79#3,22:761\n*S KotlinDebug\n*F\n+ 1 LocalDataSourceSerialization.kt\ncom/intellij/database/dataSource/LocalDataSourceSerialization\n*L\n348#1:737\n348#1:738,22\n704#1:760\n704#1:761,22\n*E\n"})
public final class LocalDataSourceSerialization {
    @NotNull
    public static final LocalDataSourceSerialization INSTANCE = new LocalDataSourceSerialization();
    @NotNull
    public static final String ELEMENT_NAME = "data-source";
    @NotNull
    private static final String LIBRARIES_ELEMENT_NAME = "libraries";
    @NotNull
    private static final String LIBRARY_ELEMENT_NAME = "library";

    private LocalDataSourceSerialization() {
    }

    @JvmStatic
    public static final void serialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        serializer.startNode(ELEMENT_NAME);
        INSTANCE.serializeHeader(project, ds, serializer, mode);
        if (mode.includeSchema()) {
            DasModel dasModel = ds.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
            ModelSerializerKt.serialize(dasModel, serializer, ds.getIntrospectionScope());
        }
        serializer.endNode();
        serializer.flush();
    }

    private final void serializeHeader(Project project, LocalDataSource ds, HierarchicalStreamWriter serializer, SaveMode mode) {
        if (mode.includeConfig()) {
            serializer.addAttribute("source", ds.getSourceName());
        }
        serializer.addAttribute("name", ds.getName());
        if (mode.includeConfig()) {
            if (ds.isReadOnly()) {
                serializer.addAttribute("read-only", String.valueOf(ds.isReadOnly()));
            }
            if (!ds.shouldCheckOutdated()) {
                serializer.addAttribute("check-outdated", String.valueOf(ds.shouldCheckOutdated()));
            }
            if (!ds.shouldTrackNamespaces()) {
                serializer.addAttribute("track-namespaces", String.valueOf(ds.shouldTrackNamespaces()));
            }
            if (ds.isSingleConnection()) {
                serializer.addAttribute("single-connection", String.valueOf(ds.isSingleConnection()));
            }
            if (StringUtil.isNotEmpty((String)ds.getGroupName())) {
                serializer.addAttribute("group", ds.getGroupName());
            }
        }
        serializer.addAttribute("uuid", ds.getUniqueId());
        if (mode.includeDatabaseInfo()) {
            LocalDataSource.getInfoInner(ds).serializeDatabaseInfo(serializer);
        }
        this.serializeHeaderInner(ds, project, serializer, mode);
    }

    private final void serializeHeaderInner(LocalDataSource ds, Project project, HierarchicalStreamWriter serializer, SaveMode mode) {
        PathMacroSubstitutor pathMacroManager = this.getPathMacroManager(project);
        DatabaseDriver driver2 = ds.getDatabaseDriver();
        if (mode.includeConfig()) {
            String url;
            String driverClass;
            SchemaControl schemaControl;
            int isolation;
            String driverRef = ds.getDriverRef();
            if (driver2 != null && !Intrinsics.areEqual((Object)driver2.getId(), (Object)ds.getDriverClass()) || driver2 == null && driverRef != null) {
                DatabaseDriver databaseDriver = driver2;
                LocalDataSourceSerialization.writeTag(serializer, "driver-ref", databaseDriver == null ? driverRef : databaseDriver.getId());
            }
            if (ds.isAutoSynchronize()) {
                LocalDataSourceSerialization.writeTag(serializer, "synchronize", "true");
            }
            if (ds.isImported()) {
                LocalDataSourceSerialization.writeTag(serializer, "imported", "true");
            }
            if (ds.isConfiguredByUrl()) {
                LocalDataSourceSerialization.writeTag(serializer, "configured-by-url", "true");
            }
            if (!StringUtil.isEmpty((String)ds.getComment())) {
                LocalDataSourceSerialization.writeTag(serializer, "remarks", ds.getComment());
            }
            if (!ds.isAutoCommit()) {
                LocalDataSourceSerialization.writeTag(serializer, "auto-commit", "false");
            }
            if ((isolation = ds.getTxIsolation()) != TxIsolation.DEFAULT.getIsolation()) {
                LocalDataSourceSerialization.writeTag(serializer, "isolation", String.valueOf(isolation));
            }
            if ((schemaControl = ds.getSchemaControlOrtNull()) != null && schemaControl != DatabaseDriver.OPTION_SCHEMA_CONTROL.get(driver2)) {
                LocalDataSourceSerialization.writeTag(serializer, "schema-control", schemaControl.name());
            }
            if (!ds.isRewriteBounds()) {
                LocalDataSourceSerialization.writeTag(serializer, "rewrite-bounds", "false");
            }
            if (StringUtil.isNotEmpty((String)(driverClass = ds.getDriverClass()))) {
                LocalDataSourceSerialization.writeTag(serializer, "jdbc-driver", driverClass);
            }
            if (StringUtil.isNotEmpty((String)(url = ds.getUrl()))) {
                LocalDataSourceSerialization.writeTag(serializer, "jdbc-url", pathMacroManager.collapsePathsRecursively(url));
            }
            LinkedHashMap<String, String> additionalProperties = new LinkedHashMap<String, String>(LocalDataSource.getAdditionalPropertiesMap(ds));
            additionalProperties.remove("user");
            additionalProperties.remove("storage");
            this.serializeAdditionalProperties(serializer, (Map<String, String>)additionalProperties, pathMacroManager);
        }
        if (mode.includeLocalConfig()) {
            DBIntrospectionOptions.SourceLoading sourceLoading;
            Level introspectionLevel;
            Couple<String> fakeCurrentSchema;
            LocalDataSourceSerialization.writeTag(serializer, "secret-storage", ds.getPasswordStorage().serialize());
            String string = ds.getAuthProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthProviderId(...)");
            String authProviderId = string;
            if (authProviderId != "user-pass") {
                LocalDataSourceSerialization.writeTag(serializer, "auth-provider", authProviderId);
            }
            String string2 = ds.getUsername();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
            String username = string2;
            if (StringUtil.isNotEmpty((String)username)) {
                LocalDataSourceSerialization.writeTag(serializer, "user-name", username);
            }
            if ((fakeCurrentSchema = ds.getFakeCurrentSchema()) != null) {
                this.writeTag(serializer, "fake-current-schema", "db", (String)fakeCurrentSchema.first, "sc", (String)fakeCurrentSchema.second);
            }
            LocalDataSourceSerialization $this$serializeHeaderInner_u24lambda_u240 = this;
            boolean bl = false;
            serializer.startNode("schema-mapping");
            ds.getSchemaMapping().serialize(serializer);
            serializer.endNode();
            Map<ObjectPath, String> map2 = ds.getLinkedDataSourceIds();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getLinkedDataSourceIds(...)");
            this.serializeLinkedDataSources(serializer, map2);
            String objectPattern = ds.getObjectPattern();
            if (StringUtil.isNotEmpty((String)objectPattern)) {
                LocalDataSourceSerialization.writeTag(serializer, "table-pattern", objectPattern);
            }
            if (ds.useJdbcIntrospector()) {
                LocalDataSourceSerialization.writeTag(serializer, "legacy-introspector", "true");
            }
            if ((introspectionLevel = ds.getIntrospectionLevel()) != null) {
                LocalDataSourceSerialization.writeTag(serializer, "introspection-level", String.valueOf(introspectionLevel.level));
            }
            if ((sourceLoading = ds.getSourceLoadingOrNull()) != null && sourceLoading != DatabaseDriver.OPTION_SOURCE_LOADING.get(driver2)) {
                LocalDataSourceSerialization.writeTag(serializer, "load-sources", StringUtil.toLowerCase((String)sourceLoading.name()));
            }
            String string3 = ds.getIntrospectorSessionId();
            if (string3 != null) {
                String it2 = string3;
                boolean bl2 = false;
                LocalDataSourceSerialization.writeTag(serializer, "introspector-session-template", it2);
            }
            List<LocalDataSource.BeforeTask> list = ds.getBeforeTasks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBeforeTasks(...)");
            this.serializeBeforeTasks(serializer, list);
            List<DataSourceSessionTemplate> list2 = ds.getSessionTemplates();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSessionTemplates(...)");
            this.serializeSessionTemplates(serializer, list2, pathMacroManager);
        }
        if (mode.includeConfig()) {
            String codeStyleName;
            String timeZone;
            CharSequence valueAtt;
            int autoCloseTimeout;
            int keepAliveTimeout;
            String initScript;
            String workingDir;
            String vmOptions = ds.getVmOptions();
            if (StringUtil.isNotEmpty((String)vmOptions)) {
                LocalDataSourceSerialization.writeTag(serializer, "vm-options", pathMacroManager.collapsePath(vmOptions));
            }
            if ((workingDir = ds.getWorkingDir()) != null) {
                LocalDataSourceSerialization.writeTag(serializer, "working-dir", pathMacroManager.collapsePath(workingDir));
            }
            Map<String, String> map3 = ds.getVmEnv();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getVmEnv(...)");
            Map<String, String> vmEnv = map3;
            if (!vmEnv.isEmpty()) {
                serializer.startNode("vm-env");
                this.serializeProperties(serializer, vmEnv, pathMacroManager);
                serializer.endNode();
            }
            Map<String, String> map4 = ds.getDriverProperties();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"getDriverProperties(...)");
            Map<String, String> driverProperties = map4;
            if (!driverProperties.isEmpty()) {
                serializer.startNode("driver-properties");
                this.serializeProperties(serializer, driverProperties, pathMacroManager);
                serializer.endNode();
            }
            if (StringUtil.isNotEmpty((String)(initScript = ds.getInitScript()))) {
                LocalDataSourceSerialization.writeTag(serializer, "init-script", initScript);
            }
            boolean customKATimeout = (keepAliveTimeout = ds.getKeepAliveTimeout()) != 60;
            boolean keepAlive = ds.isKeepAlive();
            if (keepAlive || customKATimeout) {
                String enabledAtt = keepAlive ? "enable" : null;
                String valueAtt2 = customKATimeout ? "timeout" : null;
                this.writeTag(serializer, "keep-alive", enabledAtt, String.valueOf(keepAlive), valueAtt2, String.valueOf(keepAliveTimeout));
            }
            boolean customACTimeout = (autoCloseTimeout = ds.getAutoCloseTimeout()) != 300;
            boolean autoClose = ds.isAutoClose();
            if (autoClose || customACTimeout) {
                String enabledAtt = autoClose ? "enable" : null;
                valueAtt = customACTimeout ? "timeout" : null;
                this.writeTag(serializer, "auto-close", enabledAtt, String.valueOf(autoClose), (String)valueAtt, String.valueOf(autoCloseTimeout));
            }
            if (!((valueAtt = (CharSequence)(timeZone = ds.getTimeZone())) == null || StringsKt.isBlank((CharSequence)valueAtt))) {
                LocalDataSourceSerialization.writeTag(serializer, "time-zone", timeZone);
            }
            if (StringUtil.isNotEmpty((String)(codeStyleName = ds.getCodeStyleName())) && !Intrinsics.areEqual((Object)"Default", (Object)codeStyleName)) {
                LocalDataSourceSerialization.writeTag(serializer, "code-style-scheme-name", codeStyleName);
            }
            Map<String, String> map5 = ds.getLayoutConfigurations();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"getLayoutConfigurations(...)");
            Map<String, String> layoutConfigurations = map5;
            if (!layoutConfigurations.isEmpty()) {
                this.serializeLayoutConfigurations(serializer, layoutConfigurations);
            }
            List<SimpleClasspathElement> list = ds.getOwnClasspath();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOwnClasspath(...)");
            List<SimpleClasspathElement> classpathElements = list;
            if (!((Collection)classpathElements).isEmpty()) {
                serializer.startNode(LIBRARIES_ELEMENT_NAME);
                for (SimpleClasspathElement classpathElement : classpathElements) {
                    Element element2 = new Element(LIBRARY_ELEMENT_NAME);
                    try {
                        classpathElement.serialize(element2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    pathMacroManager.collapsePaths(element2);
                    new HierarchicalStreamCopier().copy(new InternedJDomReader(element2), serializer);
                }
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            DataSourceSslConfiguration sslCfg;
            DataSourceSshTunnelConfiguration sshConfiguration = ds.getSshConfiguration();
            if (sshConfiguration != null && !sshConfiguration.isEmpty()) {
                sshConfiguration.serialize(project, serializer);
            }
            if ((sslCfg = ds.getSslCfg()) != null && !sslCfg.isEmpty()) {
                sslCfg.serialize(serializer);
            }
        }
    }

    private final void serializeAdditionalProperties(HierarchicalStreamWriter serializer, Map<String, String> additionalProperties, PathMacroSubstitutor pathMacroManager) {
        if (!additionalProperties.isEmpty()) {
            serializer.startNode("jdbc-additional-properties");
            this.serializeProperties(serializer, additionalProperties, pathMacroManager);
            serializer.endNode();
        }
    }

    private final void serializeLinkedDataSources(HierarchicalStreamWriter serializer, Map<ObjectPath, String> linkedDataSourceIds) {
        if (!linkedDataSourceIds.isEmpty()) {
            serializer.startNode("linked-data-sources");
            for (Map.Entry<ObjectPath, String> entry : linkedDataSourceIds.entrySet()) {
                String linkedId;
                ObjectPath path = entry.getKey();
                String value2 = entry.getValue();
                if (value2 == null) continue;
                serializer.startNode("linked-data-source");
                serializer.addAttribute("path", path.serialize());
                serializer.addAttribute("linked-id", linkedId);
                serializer.endNode();
            }
            serializer.endNode();
        }
    }

    private final void serializeBeforeTasks(HierarchicalStreamWriter serializer, List<? extends LocalDataSource.BeforeTask> beforeTasks) {
        if (beforeTasks.isEmpty()) {
            return;
        }
        serializer.startNode("before");
        for (LocalDataSource.BeforeTask beforeTask : beforeTasks) {
            serializer.startNode("task");
            serializer.addAttribute("id", beforeTask.providerId);
            Element element2 = beforeTask.serialized;
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"serialized");
            this.serializeElementInner(serializer, element2);
            serializer.endNode();
        }
        serializer.endNode();
    }

    private final void serializeSessionTemplates(HierarchicalStreamWriter serializer, List<? extends DataSourceSessionTemplate> sessionTemplates, PathMacroSubstitutor pathMacroManager) {
        if (sessionTemplates.isEmpty()) {
            return;
        }
        serializer.startNode("session-templates");
        for (DataSourceSessionTemplate dataSourceSessionTemplate : sessionTemplates) {
            String string;
            serializer.startNode("template");
            serializer.addAttribute("id", dataSourceSessionTemplate.getTemplateId());
            serializer.addAttribute("name", dataSourceSessionTemplate.getTemplateName());
            if (dataSourceSessionTemplate.getReadonlyOverride() != null) {
                Boolean it2;
                boolean bl2 = false;
                serializer.addAttribute("read-only", String.valueOf(it2));
            }
            ConfigUrlOverrider configUrlOverrider = dataSourceSessionTemplate.getUrlOverrider();
            Object it2 = configUrlOverrider;
            boolean bl3 = false;
            if ((((ConfigUrlOverrider)it2).isOverriden() ? configUrlOverrider : null) != null) {
                ConfigUrlOverrider urlOverrider;
                urlOverrider = urlOverrider;
                boolean bl4 = false;
                INSTANCE.serializeUrlOverrider(serializer, urlOverrider);
            }
            String string2 = dataSourceSessionTemplate.getAuthProviderIdOverride();
            if (string2 != null) {
                it2 = string2;
                boolean bl5 = false;
                serializer.addAttribute("auth-provider", (String)it2);
            }
            if ((string = dataSourceSessionTemplate.getInitScript()) != null) {
                String string3;
                String it3 = string3 = string;
                boolean bl6 = false;
                string = !Intrinsics.areEqual((Object)it3, (Object)dataSourceSessionTemplate.getDataSource().getInitScript()) ? string3 : null;
                if (string != null) {
                    String it4 = string;
                    boolean bl7 = false;
                    LocalDataSourceSerialization.writeTag(serializer, "init-script", it4);
                }
            }
            Map<String, String> map2 = dataSourceSessionTemplate.myAdditionalProperties;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"myAdditionalProperties");
            this.serializeAdditionalProperties(serializer, map2, pathMacroManager);
            serializer.endNode();
        }
        serializer.endNode();
    }

    private final void serializeUrlOverrider(HierarchicalStreamWriter serializer, ConfigUrlOverrider urlOverrider) {
        serializer.startNode("url");
        for (Map.Entry<String, String> entry : urlOverrider.getParams()) {
            String n = entry.getKey();
            String v2 = entry.getValue();
            serializer.startNode("param");
            serializer.addAttribute("name", n);
            serializer.addAttribute("value", v2);
            serializer.endNode();
        }
        serializer.endNode();
    }

    private final void serializeLayoutConfigurations(HierarchicalStreamWriter serializer, Map<String, String> configurations) {
        serializer.startNode("layout-configurations");
        for (Map.Entry<String, String> entry : configurations.entrySet()) {
            String[] lines;
            String key2 = entry.getKey();
            String value2 = entry.getValue();
            serializer.startNode("namespace");
            serializer.addAttribute("name", key2);
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.splitByLines((String)value2), (String)"splitByLines(...)");
            for (String line : lines) {
                String s2;
                Intrinsics.checkNotNull((Object)line);
                String $this$trim$iv = line;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)(s2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) continue;
                LocalDataSourceSerialization.writeTag(serializer, "line", s2);
            }
            serializer.endNode();
        }
        serializer.endNode();
    }

    private final void serializeProperties(HierarchicalStreamWriter serializer, Map<String, String> env, PathMacroSubstitutor pathMacroManager) {
        for (Map.Entry<String, String> e2 : env.entrySet()) {
            String value2 = pathMacroManager.collapsePathsRecursively(e2.getValue());
            this.writeTag(serializer, "property", "name", e2.getKey(), "value", value2);
        }
    }

    private final void serializeElementInner(HierarchicalStreamWriter serializer, Element rt) {
        for (Attribute attribute : rt.getAttributes()) {
            serializer.addAttribute(attribute.getName(), attribute.getValue());
        }
        for (Element child : rt.getChildren()) {
            Intrinsics.checkNotNull((Object)child);
            this.serializeElement(serializer, child);
        }
    }

    private final void serializeElement(HierarchicalStreamWriter serializer, Element rt) {
        serializer.startNode(rt.getName());
        this.serializeElementInner(serializer, rt);
        serializer.endNode();
    }

    @JvmStatic
    public static final void writeTag(@NotNull HierarchicalStreamWriter serializer, @Nullable String name2, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        if (StringUtil.isEmpty((String)value2)) {
            return;
        }
        serializer.startNode(name2);
        serializer.setValue(value2);
        serializer.endNode();
    }

    private final void writeTag(HierarchicalStreamWriter serializer, String name2, String a1, String v1, String a2, String v2) {
        serializer.startNode(name2);
        if (a1 != null && StringUtil.isNotEmpty((String)v1)) {
            serializer.addAttribute(a1, v1);
        }
        if (a2 != null && StringUtil.isNotEmpty((String)v2)) {
            serializer.addAttribute(a2, v2);
        }
        serializer.endNode();
    }

    @NotNull
    public final LocalDataSource copyBySettings(@Nullable Project project, @NotNull LocalDataSource ds, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        String string = this.serializedSettings(project, ds).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.createDataSourceFromSettings(project, string, temporary);
    }

    public final void copyBySettingsTo(@Nullable Project project, @NotNull LocalDataSource from, @NotNull LocalDataSource to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Element root2 = new Element("settings");
        LocalDataSourceSerialization.serialize(project, from, new JDomWriter(root2), SaveMode.WITHOUT_SCHEMA);
        InternedJDomReader reader = new InternedJDomReader(root2);
        reader.moveDown();
        LocalDataSourceSerialization.deserialize(project, to, reader, SaveMode.ALL);
    }

    @NotNull
    public final StringBuffer serializedSettings(@Nullable Project project, @NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        StringWriter writer = new StringWriter();
        CompactWriter serializer = new CompactWriter(writer);
        LocalDataSourceSerialization.serialize(project, ds, serializer, SaveMode.WITHOUT_SCHEMA);
        serializer.close();
        StringBuffer stringBuffer = writer.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"getBuffer(...)");
        return stringBuffer;
    }

    @NotNull
    public final LocalDataSource createDataSourceFromSettings(@Nullable Project project, @NotNull String settings, boolean temporary) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LocalDataSource clone = new LocalDataSource();
        LocalDataSourceSerialization.deserialize(project, clone, new StringReader(settings));
        if (temporary) {
            clone.myTemporary = true;
        } else {
            clone.setUniqueId(null);
        }
        return clone;
    }

    @JvmStatic
    public static final void deserialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        XppReader xppReader = new XppReader(reader, new MXParser());
        LocalDataSourceSerialization.deserialize(project, ds, xppReader, SaveMode.ALL);
    }

    @JvmStatic
    public static final void deserialize(@Nullable Project project, @NotNull LocalDataSource ds, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (mode.includeConfig()) {
            ds.setDriverClass(null);
            ds.setWorkingDir(null);
        }
        INSTANCE.deserializeInner(project, ds, reader, mode);
    }

    private final void deserializeInner(Project project, LocalDataSource ds, HierarchicalStreamReader reader, SaveMode mode) {
        if (Intrinsics.areEqual((Object)reader.getNodeName(), (Object)ELEMENT_NAME) || mode == SaveMode.ALL && Intrinsics.areEqual((Object)"dataSource", (Object)reader.getNodeName())) {
            String string = reader.getAttribute("name");
            if (string == null) {
                string = "";
            }
            String newName = string;
            String newGroupName = StringKt.nullize((String)reader.getAttribute("group"), (boolean)true);
            String newUniqueId = StringKt.nullize((String)reader.getAttribute("uuid"), (boolean)true);
            ds.modify(() -> LocalDataSourceSerialization.deserializeInner$lambda$9(ds, newName, mode, reader, newGroupName, newUniqueId));
            BasicModModel model2 = null;
            if (mode.includeDatabaseInfo()) {
                LocalDataSource.getInfoInner(ds).deserializeDatabaseInfo(reader, true);
            }
            while (reader.hasMoreChildren()) {
                boolean ok2;
                reader.moveDown();
                String nodeName = reader.getNodeName();
                boolean bl = ok2 = mode.includeDatabaseInfo() && LocalDataSource.getInfoInner(ds).deserializeDatabaseInfo(reader);
                if (!ok2) {
                    ok2 = this.deserializeHeaderInnerTag(ds, project, reader, mode);
                }
                if (!ok2 && mode.includeSchema() && Intrinsics.areEqual((Object)nodeName, (Object)"database-model")) {
                    ModelFactory modelFactory = DbSrcModelStorageService.getInstance().createFactory(project, ds.getUniqueId());
                    Intrinsics.checkNotNullExpressionValue((Object)modelFactory, (String)"createFactory(...)");
                    model2 = ModelSerializerKt.deserialize(reader, modelFactory, ds.getName());
                }
                reader.moveUp();
            }
            if (mode.includeSchema() && model2 != null) {
                ds.setModel(model2);
            }
        }
        String url = ds.getUrl();
        if (Intrinsics.areEqual((Object)ds.getDriverRef(), (Object)"sqlserver.jtds") && url != null && StringsKt.contains$default((CharSequence)url, (CharSequence)"<pipe name>", (boolean)false, (int)2, null)) {
            ds.setDriverRef("sqlserver.localdb.jtds");
        }
    }

    private final boolean deserializeHeaderInnerTag(LocalDataSource ds, Project project, HierarchicalStreamReader xmlReader, SaveMode mode) {
        String nodeName;
        if (!mode.includeConfig() && !mode.includeLocalConfig()) {
            return false;
        }
        if (project != null && project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PathMacroSubstitutor pathMacroManager = this.getPathMacroManager(project);
        DataSourceSchemaMapping dataSourceSchemaMapping = ds.getSchemaMapping();
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceSchemaMapping, (String)"getSchemaMapping(...)");
        DataSourceSchemaMapping schemaMapping = dataSourceSchemaMapping;
        String string = xmlReader.getNodeName();
        if (string == null) {
            return false;
        }
        switch (nodeName = string) {
            case "libraries": {
                ds.setClasspathElements(null);
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)LIBRARY_ELEMENT_NAME, (Object)xmlReader.getNodeName())) {
                        JDomWriter writer = new JDomWriter((JDOMFactory)new DefaultJDOMFactory());
                        new HierarchicalStreamCopier().copy(xmlReader, writer);
                        List list = writer.getTopLevelNodes();
                        Object object = list != null ? CollectionsKt.first((List)list) : null;
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jdom.Element");
                        Element element2 = (Element)object;
                        pathMacroManager.expandPaths(element2);
                        ds.addClasspathElements(SimpleClasspathElementFactory.createElements((Project)project, (Element)element2));
                    }
                    xmlReader.moveUp();
                }
                break;
            }
            case "driver-ref": {
                ds.setDriverRef(xmlReader.getValue());
                break;
            }
            case "synchronize": {
                ds.setAutoSynchronize(Boolean.parseBoolean(xmlReader.getValue()));
                break;
            }
            case "imported": {
                ds.setImported(Boolean.parseBoolean(xmlReader.getValue()));
                break;
            }
            case "configured-by-url": {
                ds.setConfiguredByUrl(Boolean.parseBoolean(xmlReader.getValue()));
                break;
            }
            case "remarks": {
                ds.setComment(xmlReader.getValue());
                break;
            }
            case "auto-commit": {
                ds.setAutoCommit(Boolean.parseBoolean(xmlReader.getValue()));
                break;
            }
            case "isolation": {
                String string2 = xmlReader.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                ds.setTxIsolation(Integer.parseInt(string2));
                break;
            }
            case "schema-control": {
                String string3 = xmlReader.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                ds.setSchemaControl(SchemaControl.valueOf(string3));
                break;
            }
            case "rewrite-bounds": {
                ds.setRewriteBounds(Boolean.parseBoolean(xmlReader.getValue()));
                break;
            }
            case "auth-required": {
                ds.setAuthProviderId("no-auth");
                break;
            }
            case "domain-auth": {
                ds.setAuthProviderId("ms-sso");
                break;
            }
            case "auth-provider": {
                ds.setAuthProviderId(xmlReader.getValue());
                break;
            }
            case "jdbc-driver": {
                ds.setDriverClass(xmlReader.getValue());
                break;
            }
            case "jdbc-url": {
                ds.setUrl(pathMacroManager.expandPath(xmlReader.getValue()));
                break;
            }
            case "jdbc-additional-properties": {
                Map<String, String> map2 = LocalDataSource.getAdditionalPropertiesMap(ds);
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getAdditionalPropertiesMap(...)");
                this.deserializeProperties(xmlReader, map2, pathMacroManager);
                break;
            }
            case "secret-storage": {
                ds.setPasswordStorage(LocalDataSource.Storage.deserialize(xmlReader.getValue()));
                break;
            }
            case "user-name": {
                ds.setUsername(xmlReader.getValue());
                break;
            }
            case "schema-pattern": {
                ds.getSchemaMapping().setIntrospectionScope(TreePatternUtils.patternFromPattern(ds.getDbms(), xmlReader.getValue()));
                break;
            }
            case "introspection-scope": {
                schemaMapping.setIntrospectionScope(TreePatternUtils.importPattern(ds.getDbms(), xmlReader.getValue()));
                break;
            }
            case "introspection-schemas": {
                schemaMapping.setIntrospectionScope(TreePatternUtils.importPattern(ds.getDbms(), xmlReader.getValue()));
                break;
            }
            case "schema-mapping": {
                schemaMapping.deserialize(xmlReader);
                break;
            }
            case "fake-current-schema": {
                ds.setFakeCurrentSchema((Couple<String>)Couple.of((Object)xmlReader.getAttribute("db"), (Object)xmlReader.getAttribute("sc")));
                break;
            }
            case "table-pattern": {
                ds.setObjectPattern(xmlReader.getValue());
                break;
            }
            case "legacy-introspector": {
                ds.setUseJdbcIntrospector(Intrinsics.areEqual((Object)"true", (Object)xmlReader.getValue()));
                break;
            }
            case "introspection-level": {
                ds.setIntrospectionLevel(Level.of(xmlReader.getValue()));
                break;
            }
            case "load-sources": {
                String string4 = StringUtil.toUpperCase((String)xmlReader.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                ds.setSourceLoading(DBIntrospectionOptions.SourceLoading.valueOf(string4));
                break;
            }
            case "introspector-session-template": {
                ds.setIntrospectorSessionId(xmlReader.getValue());
                break;
            }
            case "before": {
                List<LocalDataSource.BeforeTask> writer;
                List<LocalDataSource.BeforeTask> $this$deserializeHeaderInnerTag_u24lambda_u2410 = writer = ds.getBeforeTasks();
                boolean bl = false;
                $this$deserializeHeaderInnerTag_u24lambda_u2410.clear();
                Intrinsics.checkNotNull($this$deserializeHeaderInnerTag_u24lambda_u2410);
                INSTANCE.deserializeBeforeTasks(xmlReader, $this$deserializeHeaderInnerTag_u24lambda_u2410);
                break;
            }
            case "session-templates": {
                ds.setSessionTemplates(this.deserializeSessionTemplates(xmlReader, ds, pathMacroManager));
                break;
            }
            case "linked-data-sources": {
                Map<ObjectPath, String> map3 = ds.getLinkedDataSourceIds();
                Intrinsics.checkNotNullExpressionValue(map3, (String)"getLinkedDataSourceIds(...)");
                Map<ObjectPath, String> linkedDataSourceIds = map3;
                linkedDataSourceIds.clear();
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)"linked-data-source", (Object)xmlReader.getNodeName())) {
                        String path = xmlReader.getAttribute("path");
                        String linkedId = xmlReader.getAttribute("linked-id");
                        if (path != null && linkedId != null) {
                            linkedDataSourceIds.put(ObjectPath.deserialize(path), linkedId);
                        }
                    }
                    xmlReader.moveUp();
                }
                break;
            }
            case "vm-options": {
                ds.setVmOptions(pathMacroManager.expandPath(xmlReader.getValue()));
                break;
            }
            case "working-dir": {
                ds.setWorkingDir(pathMacroManager.expandPath(xmlReader.getValue()));
                break;
            }
            case "init-script": {
                ds.setInitScript(xmlReader.getValue());
                break;
            }
            case "keep-alive": {
                ds.setKeepAlive(Boolean.parseBoolean(xmlReader.getAttribute("enable")));
                ds.setKeepAliveTimeout(StringUtil.parseInt((String)xmlReader.getAttribute("timeout"), (int)60));
                break;
            }
            case "time-zone": {
                ds.setTimeZone(xmlReader.getValue());
                break;
            }
            case "auto-close": {
                Boolean bl = Boolean.valueOf(xmlReader.getAttribute("enable"));
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"valueOf(...)");
                ds.setAutoClose(bl);
                ds.setAutoCloseTimeout(StringUtil.parseInt((String)xmlReader.getAttribute("timeout"), (int)300));
                break;
            }
            case "code-style-scheme-name": {
                ds.setCodeStyleName(xmlReader.getValue());
                break;
            }
            case "layout-configurations": {
                ds.setLayoutConfigurations(this.deserializeLayoutConfigurations(xmlReader));
                break;
            }
            case "driver-properties": {
                Map<String, String> map4 = ds.getDriverProperties();
                Intrinsics.checkNotNullExpressionValue(map4, (String)"getDriverProperties(...)");
                this.deserializeProperties(xmlReader, map4, pathMacroManager);
                break;
            }
            case "vm-env": {
                Map<String, String> map5 = ds.getVmEnv();
                Intrinsics.checkNotNullExpressionValue(map5, (String)"getVmEnv(...)");
                this.deserializeProperties(xmlReader, map5, pathMacroManager);
                break;
            }
            case "ssh-properties": {
                ds.setSshConfiguration(DataSourceSshTunnelConfiguration.deserialize(project, xmlReader, ds));
                break;
            }
            case "ssl-config": {
                ds.setSslCfg(DataSourceSslConfiguration.deserialize(xmlReader));
                break;
            }
            default: {
                return false;
            }
            case "explain-plan-config": 
            case "first-sync": 
            case "default-dialect": 
            case "resolve-scope": 
            case "unqualified-resolve-schemas": 
            case "default-schemas": 
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final List<DataSourceSessionTemplate> deserializeSessionTemplates(HierarchicalStreamReader xmlReader, LocalDataSource dataSource, PathMacroSubstitutor pathMacroManager) {
        templates = new ArrayList<DataSourceSessionTemplate>();
        while (xmlReader.hasMoreChildren()) {
            block11: {
                xmlReader.moveDown();
                if (!Intrinsics.areEqual((Object)"template", (Object)xmlReader.getNodeName())) break block11;
                id = xmlReader.getAttribute("id");
                name = xmlReader.getAttribute("name");
                readOnly = xmlReader.getAttribute("read-only");
                authProvider = xmlReader.getAttribute("auth-provider");
                template = new DataSourceSessionTemplate(dataSource, id);
                v0 = name;
                if (v0 == null) {
                    v0 = "";
                }
                template.setTemplateName(v0);
                v1 = template;
                if (readOnly != null) {
                    var13_13 = v1;
                    $i$a$-let-LocalDataSourceSerialization$deserializeSessionTemplates$1 = false;
                    v2 = Intrinsics.areEqual((Object)it, (Object)"true");
                    v1 = var13_13;
                } else {
                    v2 = null;
                }
                v1.setReadonlyOverride(v2);
                template.setAuthProviderIdOverride(authProvider);
                template.getUrlOverrider().clear();
                while (xmlReader.hasMoreChildren()) {
                    block12: {
                        block13: {
                            xmlReader.moveDown();
                            var10_10 = xmlReader.getNodeName();
                            if (var10_10 == null) break block12;
                            switch (var10_10.hashCode()) {
                                case 30671912: {
                                    if (var10_10.equals("init-script")) break;
                                    ** break;
                                }
                                case 116079: {
                                    if (!var10_10.equals("url")) {
                                        ** break;
                                    }
                                    break block13;
                                }
                                case 378041671: {
                                    if (!var10_10.equals("jdbc-additional-properties")) ** break;
                                    v3 = template.myAdditionalProperties;
                                    Intrinsics.checkNotNullExpressionValue(v3, (String)"myAdditionalProperties");
                                    this.deserializeProperties(xmlReader, v3, pathMacroManager);
                                    ** break;
                                }
                            }
                            template.setInitScript(xmlReader.getValue());
                            ** break;
                        }
                        v4 = template.getUrlOverrider();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getUrlOverrider(...)");
                        this.deserializeUrlOverrider(xmlReader, v4);
                    }
                    xmlReader.moveUp();
                }
                templates.add(template);
            }
            xmlReader.moveUp();
        }
        return templates;
    }

    private final void deserializeUrlOverrider(HierarchicalStreamReader xmlReader, ConfigUrlOverrider urlOverrider) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"param")) {
                String name2 = xmlReader.getAttribute("name");
                String value2 = xmlReader.getAttribute("value");
                if (name2 != null && value2 != null) {
                    urlOverrider.setParam(name2, value2);
                }
            }
            xmlReader.moveUp();
        }
    }

    private final void deserializeBeforeTasks(HierarchicalStreamReader xmlReader, List<LocalDataSource.BeforeTask> beforeTasks) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)"task", (Object)xmlReader.getNodeName())) {
                String id = xmlReader.getAttribute("id");
                Element rt = this.deserializeElement(xmlReader);
                rt.removeAttribute("id");
                beforeTasks.add(new LocalDataSource.BeforeTask(id, rt));
            }
            xmlReader.moveUp();
        }
    }

    private final Element deserializeElement(HierarchicalStreamReader reader) {
        Element res2 = new Element(reader.getNodeName());
        int e2 = reader.getAttributeCount();
        for (int i2 = 0; i2 < e2; ++i2) {
            res2.setAttribute(reader.getAttributeName(i2), reader.getAttribute(i2));
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            res2.addContent(this.deserializeElement(reader));
            reader.moveUp();
        }
        return res2;
    }

    private final void deserializeProperties(HierarchicalStreamReader xmlReader, Map<String, String> properties2, PathMacroSubstitutor pathMacroManager) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"property")) {
                String value2 = pathMacroManager.expandPath(xmlReader.getAttribute("value"));
                Map<String, String> map2 = properties2;
                String string = xmlReader.getAttribute("name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
                map2.put(string, value2);
            }
            xmlReader.moveUp();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> deserializeLayoutConfigurations(HierarchicalStreamReader xmlReader) {
        Map configurations = new HashMap();
        while (xmlReader.hasMoreChildren()) {
            String name2;
            CharSequence charSequence;
            xmlReader.moveDown();
            if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"namespace") && !((charSequence = (CharSequence)(name2 = xmlReader.getAttribute("name"))) == null || charSequence.length() == 0)) {
                String configurationText;
                ArrayList<String> lines = new ArrayList<String>();
                while (xmlReader.hasMoreChildren()) {
                    String s2;
                    xmlReader.moveDown();
                    if (Intrinsics.areEqual((Object)xmlReader.getNodeName(), (Object)"line") && Strings.isNotEmpty((String)(s2 = xmlReader.getValue()))) {
                        void $this$trim$iv;
                        Intrinsics.checkNotNull((Object)s2);
                        String string = s2;
                        ArrayList<String> arrayList = lines;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        arrayList.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    }
                    xmlReader.moveUp();
                }
                Intrinsics.checkNotNullExpressionValue((Object)Strings.join((Collection)lines, (String)"\n"), (String)"join(...)");
                configurations.put(name2, configurationText);
            }
            xmlReader.moveUp();
        }
        return configurations;
    }

    private final PathMacroSubstitutor getPathMacroManager(Project project) {
        PathMacroSubstitutor pathMacroSubstitutor;
        ComponentManager manager;
        Project project2 = project;
        ComponentManager componentManager = manager = project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication();
        if (componentManager == null) {
            pathMacroSubstitutor = NoopSubstitutor.INSTANCE;
        } else {
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)componentManager);
            Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
            pathMacroSubstitutor = (PathMacroSubstitutor)pathMacroManager;
        }
        return pathMacroSubstitutor;
    }

    private static final void deserializeInner$lambda$9(LocalDataSource $ds, String $newName, SaveMode $mode, HierarchicalStreamReader $reader, String $newGroupName, String $newUniqueId) {
        Intrinsics.checkNotNullParameter((Object)$ds, (String)"$ds");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        Intrinsics.checkNotNullParameter((Object)((Object)$mode), (String)"$mode");
        Intrinsics.checkNotNullParameter((Object)$reader, (String)"$reader");
        $ds.setName($newName);
        if ($mode.includeConfig()) {
            $ds.setReadOnly(Intrinsics.areEqual((Object)$reader.getAttribute("read-only"), (Object)"true"));
            $ds.setCheckOutdated(!Intrinsics.areEqual((Object)$reader.getAttribute("check-outdated"), (Object)"false"));
            $ds.setTrackNamespaces(!Intrinsics.areEqual((Object)$reader.getAttribute("track-namespaces"), (Object)"false"));
            $ds.setSingleConnection(Intrinsics.areEqual((Object)$reader.getAttribute("single-connection"), (Object)"true"));
            $ds.setGroupName($newGroupName);
        }
        $ds.setUniqueId($newUniqueId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization$NoopSubstitutor;", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "()V", "collapsePath", "", "text", "recursively", "", "collapsePaths", "", "element", "Lorg/jdom/Element;", "expandPath", "expandPaths", "intellij.database.core.impl"})
    private static final class NoopSubstitutor
    implements PathMacroSubstitutor {
        @NotNull
        public static final NoopSubstitutor INSTANCE = new NoopSubstitutor();

        private NoopSubstitutor() {
        }

        @Nullable
        public String expandPath(@Nullable String text2) {
            return text2;
        }

        @Nullable
        public String collapsePath(@Nullable String text2, boolean recursively) {
            return text2;
        }

        public void expandPaths(@NotNull Element element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        }

        public void collapsePaths(@NotNull Element element2, boolean recursively) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/LocalDataSourceSerialization$SaveMode;", "", "(Ljava/lang/String;I)V", "includeConfig", "", "includeDatabaseInfo", "includeLocalConfig", "includeSchema", "ALL", "CONFIG", "LOCAL_CONFIG", "WITHOUT_SCHEMA", "SCHEMA", "intellij.database.core.impl"})
    public static final class SaveMode
    extends Enum<SaveMode> {
        public static final /* enum */ SaveMode ALL = new SaveMode();
        public static final /* enum */ SaveMode CONFIG = new SaveMode();
        public static final /* enum */ SaveMode LOCAL_CONFIG = new SaveMode();
        public static final /* enum */ SaveMode WITHOUT_SCHEMA = new SaveMode();
        public static final /* enum */ SaveMode SCHEMA = new SaveMode();
        private static final /* synthetic */ SaveMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean includeSchema() {
            return this == ALL || this == SCHEMA;
        }

        public final boolean includeConfig() {
            return this == ALL || this == CONFIG || this == WITHOUT_SCHEMA;
        }

        public final boolean includeLocalConfig() {
            return this == ALL || this == LOCAL_CONFIG || this == WITHOUT_SCHEMA;
        }

        public final boolean includeDatabaseInfo() {
            return this.includeSchema() || this.includeLocalConfig();
        }

        public static SaveMode[] values() {
            return (SaveMode[])$VALUES.clone();
        }

        public static SaveMode valueOf(String value2) {
            return Enum.valueOf(SaveMode.class, value2);
        }

        @NotNull
        public static EnumEntries<SaveMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = saveModeArray = new SaveMode[]{SaveMode.ALL, SaveMode.CONFIG, SaveMode.LOCAL_CONFIG, SaveMode.WITHOUT_SCHEMA, SaveMode.SCHEMA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

