/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseConnectivityConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelRoot;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.properties.Level;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LocalDataSource
extends AbstractDataSource
implements DatabaseConnectionConfig,
DatabaseConnectivityConfiguration,
Iconable {
    private static final Logger LOG = Logger.getInstance(LocalDataSource.class);
    static final int DEFAULT_AUTO_CLOSE_TIMEOUT_S = 300;
    static final int DEFAULT_KEEP_ALIVE_TIMEOUT_S = 60;
    public static final String MY_ELEMENT_FLAG = "LOCAL";
    static final String USER_KEY = "user";
    static final String STORAGE_KEY = "storage";
    public static final String PASSWORD_KEY = "password";
    public static final String FORCE_USE_DRIVER_ICON = "forceUseDriverIcon";
    private boolean myReadOnly;
    private boolean mySingleConnection;
    private boolean myCheckOutdated = true;
    private boolean myTrackNamespaces = true;
    private boolean myGlobal;
    private final DataSourceInfo myInfo = new DataSourceInfo();
    @NotNull
    private volatile DasModel myModel = DasUtil.emptyModel();
    private final AtomicInteger myBatchCounter = new AtomicInteger();
    private final AtomicInteger myBatchChanges = new AtomicInteger();
    private String myDriverRef;
    private DatabaseDriver myDriver;
    private String myDriverClass;
    private String myUrl;
    private Couple<String> myFakeCurrentSchema;
    private String myObjectPattern;
    private boolean myUseJdbcIntrospector;
    @Nullable
    private Level myIntrospectionLevel = null;
    private DBIntrospectionOptions.SourceLoading mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
    private String myIntrospectorSessionId;
    private String myInitScript;
    private String myVmOptions;
    private final Map<String, String> myVmEnv = new LinkedHashMap<String, String>();
    private final Map<String, String> myDriverProperties = new LinkedHashMap<String, String>();
    private String myWorkingDir = "$ProjectFileDir$";
    private boolean myKeepAlive;
    private boolean myAutoClose;
    private String myTimeZone;
    private int myKeepAliveTimeout = 60;
    private int myAutoCloseTimeout = 300;
    @Deprecated
    private final List<SimpleClasspathElement> myClasspathElements = new ArrayList<SimpleClasspathElement>();
    private boolean myAutoSynchronize;
    private boolean myAutoCommit = true;
    private int myIsolation = TxIsolation.DEFAULT.getIsolation();
    private String myAuthProviderId = "user-pass";
    private boolean myConfiguredByUrl = false;
    @Nullable
    private SchemaControl mySchemaControl;
    private boolean myRewriteBounds = true;
    private DataSourceSshTunnelConfiguration mySshConfiguration;
    private DataSourceSslConfiguration mySslCfg;
    private final Map<String, String> myAdditionalProperties = new HashMap<String, String>();
    private boolean myImported = false;
    @Nullable
    private String myCodeStyleName;
    private final Map<String, String> myLayoutConfigurations = new LinkedHashMap<String, String>();
    @Nullable
    private Listener myStorageListener;
    protected boolean myTemporary;
    private final DataSourceSchemaMapping mySchemaMapping = new DataSourceSchemaMapping();
    private final List<BeforeTask> myBeforeTasks = new ArrayList<BeforeTask>(0);
    private final List<DataSourceSessionTemplate> mySessionTemplates = new ArrayList<DataSourceSessionTemplate>(0);
    private final Map<ObjectPath, String> myLinkedDataSourceIds = new HashMap<ObjectPath, String>(0);
    private final BasicModelListener myModelListener = (created2, modified, removed) -> {
        if (this.isInBatch()) {
            this.myBatchChanges.incrementAndGet();
        }
        this.modelChanged();
    };

    public LocalDataSource() {
    }

    @Nullable
    public DataSourceSessionTemplate getIntrospectorSessionTemplate() {
        return this.myIntrospectorSessionId == null ? null : (DataSourceSessionTemplate)ContainerUtil.find(this.mySessionTemplates, t -> t.getTemplateId().equals(this.myIntrospectorSessionId));
    }

    @Nullable
    public String getIntrospectorSessionId() {
        return this.myIntrospectorSessionId;
    }

    public void setIntrospectorSessionId(@Nullable String introspectorSessionId) {
        this.myIntrospectorSessionId = introspectorSessionId;
    }

    @NotNull
    public static LocalDataSource temporary() {
        LocalDataSource res2 = new LocalDataSource();
        res2.myTemporary = true;
        LocalDataSource localDataSource = res2;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(0);
        }
        return localDataSource;
    }

    public LocalDataSource(boolean imported) {
        this.myImported = imported;
    }

    @TestOnly
    @NotNull
    public static LocalDataSource create(String name2, String driver2, String url, String userName) {
        LocalDataSource ds = new LocalDataSource();
        ds.setName(name2);
        ds.setDriverClass(driver2);
        ds.setUrl(url);
        ds.setUsername(userName);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(1);
        }
        return localDataSource;
    }

    @NotNull
    public static LocalDataSource fromDriver(@NotNull DatabaseDriver driver2, @NotNull String url, boolean temporary) {
        if (driver2 == null) {
            LocalDataSource.$$$reportNull$$$0(2);
        }
        if (url == null) {
            LocalDataSource.$$$reportNull$$$0(3);
        }
        LocalDataSource ds = new LocalDataSource();
        ds.myTemporary = temporary;
        ds.setUrlSmart(url);
        ds.setDatabaseDriver(driver2);
        ds.setPasswordStorage(Storage.PERSIST);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @Override
    @Nullable
    public DatabaseConnectivityConfiguration getParentConfiguration() {
        return this.myDriver;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    @Override
    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public boolean shouldCheckOutdated() {
        return this.myCheckOutdated;
    }

    public void setCheckOutdated(boolean checkOutdated) {
        this.myCheckOutdated = checkOutdated;
    }

    public boolean shouldTrackNamespaces() {
        return this.myTrackNamespaces;
    }

    public void setTrackNamespaces(boolean trackNamespaces) {
        this.myTrackNamespaces = trackNamespaces;
    }

    public boolean isSingleConnection() {
        return this.mySingleConnection;
    }

    public void setSingleConnection(boolean singleConnection) {
        this.mySingleConnection = singleConnection;
    }

    @NotNull
    public Map<ObjectPath, String> getLinkedDataSourceIds() {
        Map<ObjectPath, String> map2 = this.myLinkedDataSourceIds;
        if (map2 == null) {
            LocalDataSource.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public void setLinkedDataSourceIds(Map<ObjectPath, String> linkedDataSourceIds) {
        this.myLinkedDataSourceIds.clear();
        this.myLinkedDataSourceIds.putAll(linkedDataSourceIds);
    }

    @Override
    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isRewriteBounds() {
        return this.myRewriteBounds;
    }

    public void setRewriteBounds(boolean rewriteBounds) {
        this.myRewriteBounds = rewriteBounds;
    }

    public void setSchemaControl(@Nullable SchemaControl schemaControl) {
        this.mySchemaControl = schemaControl;
    }

    @Override
    @NotNull
    public SchemaControl getSchemaControl() {
        SchemaControl schemaControl = this.mySchemaControl != null ? this.mySchemaControl : DatabaseDriver.OPTION_SCHEMA_CONTROL.get(this.myDriver);
        if (schemaControl == null) {
            LocalDataSource.$$$reportNull$$$0(6);
        }
        return schemaControl;
    }

    @Nullable
    SchemaControl getSchemaControlOrtNull() {
        return this.mySchemaControl;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getInfo().getDbms();
        if (dbms == null) {
            LocalDataSource.$$$reportNull$$$0(7);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Version getVersion() {
        Version version = this.getInfo().getExactVersion();
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(8);
        }
        return version;
    }

    @NotNull
    public Version getExactDriverVersion() {
        Version version = this.getInfo().getExactDriverVersion();
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(9);
        }
        return version;
    }

    @Override
    @Nullable
    public DatabaseDriver getDatabaseDriver() {
        return this.myDriver;
    }

    public void setDatabaseDriver(@Nullable DatabaseDriver databaseDriver) {
        if (this.myDriver == databaseDriver) {
            return;
        }
        this.myDriver = databaseDriver;
        this.myDriverClass = this.myDriver == null ? null : this.myDriver.getDriverClass();
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public Storage getPasswordStorage() {
        return LocalDataSource.getPasswordStorage(this);
    }

    public void setPasswordStorage(@NotNull Storage passwordStorage) {
        if (passwordStorage == null) {
            LocalDataSource.$$$reportNull$$$0(10);
        }
        LocalDataSource.setPasswordStorage(this, passwordStorage);
    }

    @NotNull
    public String getUsername() {
        return LocalDataSource.getUsername(this);
    }

    public void setUsername(String username) {
        LocalDataSource.setUsername(this, username);
    }

    public void setAutoSynchronize(boolean autoSynchronize) {
        this.myAutoSynchronize = autoSynchronize;
    }

    public boolean isAutoSynchronize() {
        return this.myAutoSynchronize;
    }

    @Override
    public boolean isAutoCommit() {
        return this.myAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.myAutoCommit = autoCommit;
    }

    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    @Override
    public int getTxIsolation() {
        return this.myIsolation;
    }

    @NotNull
    public final Icon getIcon() {
        return this.getIcon(0);
    }

    @NotNull
    public final Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getBaseIcon();
        int theFlags = this.isReadOnly() ? 2048 : 0;
        RowIcon rowIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, icon, theFlags);
        if (rowIcon == null) {
            LocalDataSource.$$$reportNull$$$0(11);
        }
        return rowIcon;
    }

    public Icon getBaseIcon() {
        if (this.myDriver != null && ("true".equals(this.getAdditionalProperty(FORCE_USE_DRIVER_ICON)) || "true".equals(this.myDriver.getAdditionalProperty(FORCE_USE_DRIVER_ICON)))) {
            return this.myDriver.getIcon(0);
        }
        Dbms dbms = this.getDbms();
        if (dbms != Dbms.UNKNOWN) {
            return dbms.getIcon();
        }
        if (this.myDriver != null) {
            return this.myDriver.getIcon(0);
        }
        return Dbms.UNKNOWN.getIcon();
    }

    public void resolveDriver() {
        if (this.myDriver != null) {
            return;
        }
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        DatabaseDriver driver2 = null;
        if (this.myDriverRef != null && (driver2 = DatabaseDriverManager.getInstance().getDriver(this.myDriverRef)) == null) {
            LOG.warn(LocalDataSource.logMessage(this, "failed to find driver with id \"" + this.myDriverRef + "\""));
        }
        if (driver2 == null) {
            driver2 = DbImplUtilCore.guessDatabaseDriver(this);
            if (driver2 == null) {
                LOG.warn(LocalDataSource.logMessage(this, "failed to guess driver"));
            } else {
                LOG.debug(LocalDataSource.logMessage(this, "using driver \"" + driver2.getName() + "\" (" + driver2.getId() + ")"));
            }
        }
        this.setDatabaseDriver(driver2);
    }

    public void ensureDriverConfigured() {
        if (StringUtil.isEmpty((String)this.myDriverClass)) {
            return;
        }
        if (this.myDriver != null && this.acceptsDriver(this.myDriver)) {
            return;
        }
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        if (this.myDriver != null) {
            for (DatabaseDriver databaseDriver : driverManager.getDrivers()) {
                if (!this.acceptsDriver(databaseDriver)) continue;
                this.myDriver = databaseDriver;
                return;
            }
            this.myDriver = this.myDriver.copy(this.getName() + " driver", false);
        } else {
            this.myDriver = driverManager.createDriver(this.myDriverClass, this.myDriverClass, null);
        }
        this.myDriver.setAdditionalClasspathElements(this.myClasspathElements);
        driverManager.updateDriver(this.myDriver);
    }

    private boolean acceptsDriver(@NotNull DatabaseDriver driver2) {
        if (driver2 == null) {
            LocalDataSource.$$$reportNull$$$0(12);
        }
        if (!Objects.equals(this.myDriverClass, driver2.getDriverClass())) {
            return false;
        }
        HashSet<String> set = new HashSet<String>();
        for (SimpleClasspathElement element2 : driver2.getClasspathElements()) {
            for (String s2 : element2.getClassesRootUrls()) {
                set.add(PathUtil.getFileName((String)s2));
            }
        }
        if (set.isEmpty()) {
            driver2.setAdditionalClasspathElements(this.myClasspathElements);
            return true;
        }
        for (SimpleClasspathElement e2 : this.myClasspathElements) {
            for (String s2 : e2.getClassesRootUrls()) {
                if (set.contains(PathUtil.getFileName((String)s2))) continue;
                return false;
            }
        }
        return true;
    }

    public void setIntrospectionScope(@NotNull TreePattern scope) {
        if (scope == null) {
            LocalDataSource.$$$reportNull$$$0(13);
        }
        this.getSchemaMapping().setIntrospectionScope(scope);
        BasicModModel model2 = (BasicModModel)ObjectUtils.tryCast((Object)this.getModel(), BasicModModel.class);
        if (model2 != null) {
            DataSourceSnapshotManager.getInstance().clearOrReviveNamespacesLater(model2, scope);
        }
    }

    public void setSchemaMapping(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            LocalDataSource.$$$reportNull$$$0(14);
        }
        this.mySchemaMapping.assign(mapping);
        BasicModModel model2 = (BasicModModel)ObjectUtils.tryCast((Object)this.getModel(), BasicModModel.class);
        if (model2 != null) {
            DataSourceSnapshotManager.getInstance().clearOrReviveNamespacesLater(model2, this.getIntrospectionScope());
        }
    }

    @Nullable
    public Couple<String> getFakeCurrentSchema() {
        return this.myFakeCurrentSchema;
    }

    public void setFakeCurrentSchema(@Nullable Couple<String> fakeCurrentSchema) {
        this.myFakeCurrentSchema = fakeCurrentSchema != null && fakeCurrentSchema.first == null && fakeCurrentSchema.second == null ? null : fakeCurrentSchema;
    }

    @Override
    @NotNull
    public Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        if (this.myDriver != null) {
            LocalDataSource.putProperties(connectionProperties, this.myDriver.getDriverProperties());
        }
        LocalDataSource.putProperties(connectionProperties, this.myDriverProperties);
        Properties properties2 = connectionProperties;
        if (properties2 == null) {
            LocalDataSource.$$$reportNull$$$0(15);
        }
        return properties2;
    }

    private static void putProperties(Properties result2, Map<String, String> properties2) {
        for (Map.Entry<String, String> entry : properties2.entrySet()) {
            if (entry.getValue() != null) {
                result2.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            result2.remove(entry.getKey());
        }
    }

    public String getSourceName() {
        return MY_ELEMENT_FLAG;
    }

    @Override
    public String getDriverClass() {
        if (this.myDriver != null) {
            return this.myDriver.getDriverClass();
        }
        return this.myDriverClass;
    }

    public void setDriverClass(String driver2) {
        this.myDriverClass = driver2;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public void setUrlSmart(String url) {
        this.setUrl(url);
        this.setConfiguredByUrl(this.checkUrlOnly());
    }

    private boolean checkUrlOnly() {
        if (this.myUrl == null || this.myDriver == null) {
            return false;
        }
        StatelessJdbcUrlParser parser2 = JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), this.myUrl);
        if (parser2 == null) {
            return !StringUtil.isEmptyOrSpaces((String)this.myUrl);
        }
        JdbcUrlParser sparser = parser2.createStateful();
        sparser.setUrlText(this.myUrl);
        return !sparser.isValid() || !StringUtil.isEmpty((String)sparser.getParameter(USER_KEY)) || !StringUtil.isEmpty((String)sparser.getParameter(PASSWORD_KEY));
    }

    public String getDriverRef() {
        return this.myDriverRef;
    }

    void setDriverRef(String driverRef) {
        this.myDriverRef = driverRef;
    }

    @NotNull
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myDriver != null) {
            List<SimpleClasspathElement> list = this.myDriver.getClasspathElements();
            if (list == null) {
                LocalDataSource.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<SimpleClasspathElement> list = Collections.emptyList();
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Deprecated
    public void setClasspathElements(@Nullable List<SimpleClasspathElement> classpathElements) {
        this.myClasspathElements.clear();
        if (classpathElements != null) {
            this.myClasspathElements.addAll(classpathElements);
        }
    }

    void addClasspathElements(@NotNull List<SimpleClasspathElement> classpathElements) {
        if (classpathElements == null) {
            LocalDataSource.$$$reportNull$$$0(18);
        }
        this.myClasspathElements.addAll(classpathElements);
    }

    @Deprecated
    @NotNull
    public List<SimpleClasspathElement> getOwnClasspath() {
        List<SimpleClasspathElement> list = this.myClasspathElements;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(19);
        }
        return list;
    }

    public String getDefaultDialect() {
        if (this.myDriver != null) {
            return this.myDriver.getSqlDialect();
        }
        return null;
    }

    @NotNull
    public List<BeforeTask> getBeforeTasks() {
        List<BeforeTask> list = this.myBeforeTasks;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public List<DataSourceSessionTemplate> getSessionTemplates() {
        List<DataSourceSessionTemplate> list = this.mySessionTemplates;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(21);
        }
        return list;
    }

    public void setSessionTemplates(@NotNull List<DataSourceSessionTemplate> templates) {
        if (templates == null) {
            LocalDataSource.$$$reportNull$$$0(22);
        }
        this.mySessionTemplates.clear();
        this.mySessionTemplates.addAll(templates);
    }

    @Override
    @Nullable
    public String getInitScript() {
        return this.myInitScript;
    }

    @Override
    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript;
    }

    public boolean isKeepAlive() {
        return this.myKeepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.myKeepAlive = keepAlive;
    }

    public void setTimeZone(@Nullable String timeZone) {
        this.myTimeZone = timeZone;
    }

    @Nullable
    public String getTimeZone() {
        return this.myTimeZone;
    }

    public boolean isAutoClose() {
        return this.myAutoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.myAutoClose = autoClose;
    }

    public int getKeepAliveTimeout() {
        return this.myKeepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    public int getAutoCloseTimeout() {
        return this.myAutoCloseTimeout;
    }

    public void setAutoCloseTimeout(int autoCloseTimeout) {
        this.myAutoCloseTimeout = autoCloseTimeout;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public void setWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getDriverProperties() {
        Map<String, String> map2 = this.myDriverProperties;
        if (map2 == null) {
            LocalDataSource.$$$reportNull$$$0(23);
        }
        return map2;
    }

    public String getObjectPattern() {
        return this.myObjectPattern;
    }

    public boolean useJdbcIntrospector() {
        return this.myUseJdbcIntrospector;
    }

    public void setUseJdbcIntrospector(boolean useJdbcIntrospector) {
        this.myUseJdbcIntrospector = useJdbcIntrospector;
    }

    @Nullable
    public Level getIntrospectionLevel() {
        return this.myIntrospectionLevel;
    }

    public void setIntrospectionLevel(@Nullable Level introspectionLevel) {
        this.myIntrospectionLevel = introspectionLevel;
        if (this.myModel instanceof BasicModModel) {
            LocalDataSource.setIntrospectionLevelInModelSafely((BasicModModel)this.myModel, introspectionLevel);
        }
    }

    private static void setIntrospectionLevelInModelSafely(@NotNull BasicModModel mm, @Nullable Level introspectionLevel) {
        Application application;
        if (mm == null) {
            LocalDataSource.$$$reportNull$$$0(24);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            application.executeOnPooledThread(() -> LocalDataSource.setIntrospectionLevelInModel(mm, introspectionLevel));
        } else {
            LocalDataSource.setIntrospectionLevelInModel(mm, introspectionLevel);
        }
    }

    private static void setIntrospectionLevelInModel(@NotNull BasicModModel mm, @Nullable Level introspectionLevel) {
        if (mm == null) {
            LocalDataSource.$$$reportNull$$$0(25);
        }
        mm.modify(BasicModRoot.class, root2 -> {
            if (root2 instanceof BasicModMultiLevelRoot) {
                BasicModMultiLevelRoot r = (BasicModMultiLevelRoot)root2;
                r.setExplicitIntrospectionLevel(introspectionLevel);
            }
        });
    }

    @NotNull
    public DBIntrospectionOptions.SourceLoading getSourceLoading() {
        DBIntrospectionOptions.SourceLoading sourceLoading = this.mySourceLoading != null ? this.mySourceLoading : DatabaseDriver.OPTION_SOURCE_LOADING.get(this.myDriver);
        if (sourceLoading == null) {
            LocalDataSource.$$$reportNull$$$0(26);
        }
        return sourceLoading;
    }

    @Nullable
    DBIntrospectionOptions.SourceLoading getSourceLoadingOrNull() {
        return this.mySourceLoading;
    }

    public void setSourceLoading(@Nullable DBIntrospectionOptions.SourceLoading sourceLoading) {
        this.mySourceLoading = sourceLoading;
    }

    public void setObjectPattern(String objectPattern) {
        this.myObjectPattern = objectPattern;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration getSshConfiguration() {
        return this.mySshConfiguration;
    }

    public void setSshConfiguration(DataSourceSshTunnelConfiguration configuration) {
        this.mySshConfiguration = configuration;
    }

    @Nullable
    public DataSourceSslConfiguration getSslCfg() {
        return this.mySslCfg;
    }

    public void setSslCfg(DataSourceSslConfiguration sslCfg) {
        this.mySslCfg = sslCfg;
    }

    @Override
    @NotNull
    public String getAuthProviderId() {
        String string = this.myAuthProviderId;
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public void setAuthProviderId(@NotNull String authProviderId) {
        if (authProviderId == null) {
            LocalDataSource.$$$reportNull$$$0(28);
        }
        this.myAuthProviderId = authProviderId;
    }

    @NotNull
    public LocalDataSource copy(boolean temporary) {
        LocalDataSource clone = LocalDataSourceSerialization.INSTANCE.copyBySettings(null, this, temporary);
        this.copyExtraParametersTo(clone);
        clone.setDatabaseDriver(this.getDatabaseDriver());
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(29);
        }
        return localDataSource;
    }

    private void copyExtraParametersTo(@NotNull LocalDataSource ds) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(30);
        }
        ds.setGlobal(this.isGlobal());
        ds.setDatabaseDriver(this.getDatabaseDriver());
        ds.setIntrospectionScope(this.getIntrospectionScope());
        ds.setPasswordStorage(ds.getPasswordStorage());
        ds.setUsername(this.getUsername());
    }

    @Override
    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return this;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o2) {
        boolean hasSsl2;
        boolean hasSsh2;
        if (o2 == null) {
            LocalDataSource.$$$reportNull$$$0(31);
        }
        if (this.isConfiguredByUrl() != o2.isConfiguredByUrl()) {
            return false;
        }
        if (this.isImported() != o2.isImported()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o2.getComment())) {
            return false;
        }
        if (this.getPasswordStorage() != o2.getPasswordStorage()) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), o2.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getIntrospectorSessionId(), o2.getIntrospectorSessionId())) {
            return false;
        }
        if (this.getSchemaControl() != o2.getSchemaControl()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getUrl()), (CharSequence)StringUtil.nullize((String)o2.getUrl()))) {
            return false;
        }
        if (this.isAutoSynchronize() != o2.isAutoSynchronize()) {
            return false;
        }
        if (this.isReadOnly() != o2.isReadOnly()) {
            return false;
        }
        if (this.shouldCheckOutdated() != o2.shouldCheckOutdated()) {
            return false;
        }
        if (this.shouldTrackNamespaces() != o2.shouldTrackNamespaces()) {
            return false;
        }
        if (this.isAutoCommit() != o2.isAutoCommit()) {
            return false;
        }
        if (this.getTxIsolation() != o2.getTxIsolation()) {
            return false;
        }
        if (this.isGlobal() != o2.isGlobal()) {
            return false;
        }
        if (!LocalDataSource.driversEqual(this.getDatabaseDriver(), o2.getDatabaseDriver())) {
            return false;
        }
        if (!Objects.equals(this.getAuthProviderId(), o2.getAuthProviderId())) {
            return false;
        }
        if (!this.myDriverProperties.equals(o2.myDriverProperties)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDriverClass(), (CharSequence)o2.getDriverClass())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getSchemaMapping(), (Object)o2.getSchemaMapping())) {
            return false;
        }
        if (!Comparing.equal(this.getFakeCurrentSchema(), o2.getFakeCurrentSchema())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getObjectPattern(), (CharSequence)o2.getObjectPattern())) {
            return false;
        }
        if (this.myUseJdbcIntrospector != o2.useJdbcIntrospector()) {
            return false;
        }
        if (this.myIntrospectionLevel != o2.getIntrospectionLevel()) {
            return false;
        }
        if (this.mySourceLoading != o2.getSourceLoading()) {
            return false;
        }
        if (this.myRewriteBounds != o2.isRewriteBounds()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myVmOptions), (CharSequence)StringUtil.nullize((String)o2.myVmOptions))) {
            return false;
        }
        if (!LocalDataSource.equals(this.myVmEnv, o2.myVmEnv)) {
            return false;
        }
        if (!LocalDataSource.equals(this.myAdditionalProperties, o2.myAdditionalProperties)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myInitScript), (CharSequence)StringUtil.nullize((String)o2.myInitScript))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCodeStyleName, (String)"Default"), (CharSequence)StringUtil.nullize((String)o2.myCodeStyleName, (String)"Default"))) {
            return false;
        }
        if (!this.myLayoutConfigurations.equals(o2.myLayoutConfigurations)) {
            return false;
        }
        if (this.isSingleConnection() != o2.isSingleConnection()) {
            return false;
        }
        if (this.isKeepAlive() != o2.isKeepAlive()) {
            return false;
        }
        if (this.isAutoClose() != o2.isAutoClose()) {
            return false;
        }
        if (this.getKeepAliveTimeout() != o2.getKeepAliveTimeout()) {
            return false;
        }
        if (this.getAutoCloseTimeout() != o2.getAutoCloseTimeout()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getTimeZone(), (CharSequence)o2.getTimeZone())) {
            return false;
        }
        if (!this.getBeforeTasks().equals(o2.getBeforeTasks())) {
            return false;
        }
        if (!DbImplUtilCore.equals(this.getSessionTemplates(), o2.getSessionTemplates(), DataSourceSessionTemplate::equalConfiguration)) {
            return false;
        }
        if (!this.getLinkedDataSourceIds().equals(o2.getLinkedDataSourceIds())) {
            return false;
        }
        boolean hasSsh1 = this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty();
        boolean bl = hasSsh2 = o2.mySshConfiguration != null && !o2.mySshConfiguration.isEmpty();
        if (hasSsh1 != hasSsh2) {
            return false;
        }
        if (hasSsh1 && !this.mySshConfiguration.equalConfiguration(o2.mySshConfiguration)) {
            return false;
        }
        boolean hasSsl1 = this.mySslCfg != null && !this.mySslCfg.isEmpty();
        boolean bl2 = hasSsl2 = o2.mySslCfg != null && !o2.mySslCfg.isEmpty();
        if (hasSsl1 != hasSsl2) {
            return false;
        }
        return !hasSsl1 || this.mySslCfg.equalConfiguration(o2.mySslCfg);
    }

    private static boolean driversEqual(@Nullable DatabaseDriver a, @Nullable DatabaseDriver b2) {
        if (a == null || b2 == null) {
            return a == b2;
        }
        return Objects.equals(a.getId(), b2.getId());
    }

    private static <K, V> boolean equals(@NotNull Map<K, V> m1, @NotNull Map<K, V> m2) {
        if (m1 == null) {
            LocalDataSource.$$$reportNull$$$0(32);
        }
        if (m2 == null) {
            LocalDataSource.$$$reportNull$$$0(33);
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (Comparing.equal(entry.getValue(), m2.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            if (Comparing.equal(entry.getValue(), m1.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setAdditionalProperties(@NotNull Map<String, String> additionalProperties) {
        if (additionalProperties == null) {
            LocalDataSource.$$$reportNull$$$0(34);
        }
        this.myAdditionalProperties.clear();
        this.myAdditionalProperties.putAll(additionalProperties);
    }

    @Override
    @NotNull
    public Set<String> getAdditionalPropertiesNames() {
        Set<String> set = this.myAdditionalProperties.keySet();
        if (set == null) {
            LocalDataSource.$$$reportNull$$$0(35);
        }
        return set;
    }

    @Override
    @Nullable
    public String getAdditionalProperty(@NotNull String name2) {
        if (name2 == null) {
            LocalDataSource.$$$reportNull$$$0(36);
        }
        return this.myAdditionalProperties.get(name2);
    }

    @Override
    public void setAdditionalProperty(@NotNull String name2, @Nullable String value2) {
        if (name2 == null) {
            LocalDataSource.$$$reportNull$$$0(37);
        }
        DbImplUtilCore.putOrRemove(this.myAdditionalProperties, name2, value2);
    }

    public boolean isImported() {
        return this.myImported;
    }

    void setImported(boolean imported) {
        this.myImported = imported;
    }

    public boolean isConfiguredByUrl() {
        return this.myConfiguredByUrl;
    }

    public void setConfiguredByUrl(boolean configuredByUrl) {
        this.myConfiguredByUrl = configuredByUrl;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map2 = this.myVmEnv;
        if (map2 == null) {
            LocalDataSource.$$$reportNull$$$0(38);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            LocalDataSource.$$$reportNull$$$0(39);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Override
    @NotNull
    public String toString() {
        Object str = super.toString();
        String dialect = this.getDefaultDialect();
        Object object = str = (String)str + (String)(dialect != null && !dialect.isEmpty() ? " (" + dialect + ")" : " (unknown dialect)");
        if (object == null) {
            LocalDataSource.$$$reportNull$$$0(40);
        }
        return object;
    }

    @Override
    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            LocalDataSource.$$$reportNull$$$0(41);
        }
        return dasModel;
    }

    public void setModel(@NotNull DasModel newModel) {
        BasicModel newBasicModel;
        BasicModel oldBasicModel;
        DasModel oldModel;
        if (newModel == null) {
            LocalDataSource.$$$reportNull$$$0(42);
        }
        if ((oldModel = this.myModel) == newModel) {
            return;
        }
        BasicModel basicModel = oldBasicModel = oldModel instanceof BasicModel ? (BasicModel)oldModel : null;
        if (oldBasicModel != null) {
            ((BasicModModel)oldBasicModel).removeListener(this.myModelListener);
            ((BasicModModel)oldBasicModel).shelve(false);
        }
        this.myModel = newModel;
        this.incModificationCount();
        BasicModel basicModel2 = newBasicModel = newModel instanceof BasicModel ? (BasicModel)newModel : null;
        if (newBasicModel instanceof BasicModModel) {
            ((BasicModModel)newBasicModel).addListener(this.myModelListener);
        }
        this.notifyModelReplaced(oldBasicModel, newBasicModel);
        this.modelChanged();
    }

    private void modelChanged() {
        Listener listener2 = this.myStorageListener;
        if (listener2 != null) {
            try {
                listener2.dataSourceModelUpdated(this);
            }
            catch (ProcessCanceledException e2) {
                throw e2;
            }
            catch (Exception e3) {
                LOG.error((Throwable)e3);
            }
        }
    }

    void addStorageListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            LocalDataSource.$$$reportNull$$$0(43);
        }
        if (this.myStorageListener != null) {
            throw new AssertionError((Object)"Already has a storage listener");
        }
        this.myStorageListener = listener2;
    }

    void removeStorageListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            LocalDataSource.$$$reportNull$$$0(44);
        }
        if (this.myStorageListener != listener2) {
            throw new AssertionError((Object)"Attempt to remove wrong listener");
        }
        this.myStorageListener = null;
    }

    public void clearModel() {
        LOG.info(LocalDataSource.logMessage(this, "clearModel"));
        BasicModModel model2 = (BasicModModel)ObjectUtils.tryCast((Object)this.myModel, BasicModModel.class);
        if (model2 != null) {
            this.clearIntrospectionCache(model2);
            DbImplUtilCore.performSrcOperation(null, model2, ModalityState.defaultModalityState(), false, model2::clearModel);
        } else {
            this.setModel(DasUtil.emptyModel());
        }
    }

    public void clearIntrospectionCache() {
        BasicModModel model2 = (BasicModModel)ObjectUtils.tryCast((Object)this.myModel, BasicModModel.class);
        if (model2 != null) {
            this.clearIntrospectionCache(model2);
        }
    }

    private void clearIntrospectionCache(@NotNull BasicModModel model2) {
        if (model2 == null) {
            LocalDataSource.$$$reportNull$$$0(45);
        }
        ModelHelper helper = DbImplUtilCore.getModelHelper(this.getDbms());
        helper.invalidateIntrospectionCache(model2);
    }

    public void performBatch(Runnable runnable) {
        this.myBatchCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            if (this.myBatchCounter.decrementAndGet() == 0 && this.myBatchChanges.getAndSet(0) != 0) {
                this.modelChanged();
            }
        }
    }

    public boolean hasDriverFiles() {
        return this.myDriver != null && this.myDriver.hasDriverFiles() || !this.myClasspathElements.isEmpty();
    }

    public boolean isInBatch() {
        return this.myBatchCounter.get() != 0;
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(46);
        }
        return localDataSource;
    }

    @Override
    @NotNull
    public DatabaseConnectionConfig getMutableConfig() {
        LocalDataSource localDataSource = this;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(47);
        }
        return localDataSource;
    }

    @Override
    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = this.getInfo().getDatabaseVersion();
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(48);
        }
        return nameVersion;
    }

    @NotNull
    public NameVersion getDriverVersion() {
        NameVersion nameVersion = this.getInfo().getDriverVersion();
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(49);
        }
        return nameVersion;
    }

    public String getJDBCVersion() {
        return this.getInfo().getJdbcVersion();
    }

    public Casing getCaseModes() {
        return this.getInfo().getCasing();
    }

    public DataSourceInfo getInfo() {
        DataSourceInfo.initDbmsFromJdbcIfNeeded(this, this.myInfo);
        return this.myInfo;
    }

    @NlsSafe
    @Nullable
    public String getCodeStyleName() {
        return this.myCodeStyleName;
    }

    public void setCodeStyleName(@Nullable String codeStyleName) {
        this.myCodeStyleName = codeStyleName;
    }

    @Nullable
    @NlsSafe
    public String getLayoutConfigurationFor(@NotNull String key2) {
        if (key2 == null) {
            LocalDataSource.$$$reportNull$$$0(50);
        }
        return this.myLayoutConfigurations.get(key2);
    }

    public void setLayoutConfigurationFor(@NotNull String key2, @Nullable String layoutConfiguration) {
        if (key2 == null) {
            LocalDataSource.$$$reportNull$$$0(51);
        }
        this.myLayoutConfigurations.put(key2, Strings.nullize((String)layoutConfiguration, (boolean)true));
    }

    @NotNull
    public Map<String, String> getLayoutConfigurations() {
        Map<String, String> map2 = this.myLayoutConfigurations;
        if (map2 == null) {
            LocalDataSource.$$$reportNull$$$0(52);
        }
        return map2;
    }

    public void setLayoutConfigurations(@Nullable Map<String, String> layoutConfigurations) {
        this.myLayoutConfigurations.clear();
        if (layoutConfigurations != null) {
            this.myLayoutConfigurations.putAll(layoutConfigurations);
        }
    }

    @NotNull
    public DataSourceSchemaMapping getSchemaMapping() {
        DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
        if (dataSourceSchemaMapping == null) {
            LocalDataSource.$$$reportNull$$$0(53);
        }
        return dataSourceSchemaMapping;
    }

    @NotNull
    public TreePattern getIntrospectionScope() {
        TreePattern treePattern = this.getSchemaMapping().getIntrospectionScope();
        if (treePattern == null) {
            LocalDataSource.$$$reportNull$$$0(54);
        }
        return treePattern;
    }

    @NotNull
    private static String logMessage(@NotNull LocalDataSource ds, @NotNull String message2) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(55);
        }
        if (message2 == null) {
            LocalDataSource.$$$reportNull$$$0(56);
        }
        String string = "Data source \"" + ds.getName() + "\" {" + ds.getUniqueId() + "}: " + message2;
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static Storage getPasswordStorage(@NotNull DatabaseConnectionPoint point) {
        if (point == null) {
            LocalDataSource.$$$reportNull$$$0(58);
        }
        Storage storage = Storage.deserialize(point.getAdditionalProperty(STORAGE_KEY));
        if (storage == null) {
            LocalDataSource.$$$reportNull$$$0(59);
        }
        return storage;
    }

    public static void setPasswordStorage(@NotNull DatabaseConnectionConfig config, @NotNull Storage passwordStorage) {
        if (config == null) {
            LocalDataSource.$$$reportNull$$$0(60);
        }
        if (passwordStorage == null) {
            LocalDataSource.$$$reportNull$$$0(61);
        }
        config.setAdditionalProperty(STORAGE_KEY, passwordStorage.serialize());
    }

    @NotNull
    public static String getUsername(@NotNull DatabaseConnectionPoint point) {
        if (point == null) {
            LocalDataSource.$$$reportNull$$$0(62);
        }
        String string = StringUtil.notNullize((String)point.getAdditionalProperty(USER_KEY));
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(63);
        }
        return string;
    }

    public static void setUsername(@NotNull DatabaseConnectionConfig config, String username) {
        if (config == null) {
            LocalDataSource.$$$reportNull$$$0(64);
        }
        config.setAdditionalProperty(USER_KEY, StringUtil.nullize((String)username));
    }

    @NotNull
    public static Map<String, String> getAdditionalPropertiesMap(@NotNull LocalDataSource ds) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(65);
        }
        Map<String, String> map2 = ds.myAdditionalProperties;
        if (map2 == null) {
            LocalDataSource.$$$reportNull$$$0(66);
        }
        return map2;
    }

    static DataSourceInfo getInfoInner(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            LocalDataSource.$$$reportNull$$$0(67);
        }
        return dataSource2.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 10, 12, 13, 14, 18, 22, 24, 25, 28, 30, 31, 32, 33, 34, 36, 37, 39, 42, 43, 44, 45, 50, 51, 55, 56, 58, 60, 61, 62, 64, 65, 67 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordStorage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpathElements";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authProviderId";
                break;
            }
            case 30: 
            case 55: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalProperties";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "temporary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 51: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedDataSourceIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaControl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactDriverVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnClasspath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionTemplates";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverProperties";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLoading";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthProviderId";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesNames";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableConfig";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverVersion";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutConfigurations";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaMapping";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionScope";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "logMessage";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasswordStorage";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromDriver";
                break;
            }
            case 10: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setPasswordStorage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDriver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaMapping";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addClasspathElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setSessionTemplates";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevelInModelSafely";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevelInModel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setAuthProviderId";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyExtraParametersTo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperties";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperty";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperty";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addStorageListener";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeStorageListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "clearIntrospectionCache";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutConfigurationFor";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutConfigurationFor";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "logMessage";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPasswordStorage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getUsername";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setUsername";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPropertiesMap";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getInfoInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 10, 12, 13, 14, 18, 22, 24, 25, 28, 30, 31, 32, 33, 34, 36, 37, 39, 42, 43, 44, 45, 50, 51, 55, 56, 58, 60, 61, 62, 64, 65, 67 -> new IllegalArgumentException(string);
        };
    }

    public static enum Storage {
        PERSIST,
        MEMORY,
        SESSION,
        NO;

        private static final String MASTER_KEY = "MASTER_KEY";
        private static final String FOR_SESSION = "SESSION";
        private static final String FORGET = "FORGET";

        public boolean isMemory() {
            return this == MEMORY || this == SESSION;
        }

        public boolean isPersisted() {
            return this == PERSIST;
        }

        public boolean isOneTime() {
            return this == NO;
        }

        public static Storage deserialize(@Nullable String s2) {
            if (MASTER_KEY.equalsIgnoreCase(s2)) {
                return PERSIST;
            }
            if (FOR_SESSION.equalsIgnoreCase(s2)) {
                return SESSION;
            }
            if (FORGET.equalsIgnoreCase(s2)) {
                return NO;
            }
            return MEMORY;
        }

        @Nullable
        public String serialize() {
            if (this == PERSIST) {
                return StringUtil.toLowerCase((String)MASTER_KEY);
            }
            if (this == SESSION) {
                return StringUtil.toLowerCase((String)FOR_SESSION);
            }
            if (this == NO) {
                return StringUtil.toLowerCase((String)FORGET);
            }
            return null;
        }
    }

    public static interface Listener
    extends EventListener {
        public void dataSourceModelUpdated(@NotNull LocalDataSource var1);
    }

    public static class BeforeTask {
        public final String providerId;
        public final Element serialized;

        public BeforeTask(String providerId, Element serialized) {
            this.providerId = providerId;
            this.serialized = serialized;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof BeforeTask)) {
                return false;
            }
            BeforeTask task = (BeforeTask)o2;
            return this.providerId.equals(task.providerId) && JDOMInterner.equals((Element)this.serialized, (Element)task.serialized);
        }

        public int hashCode() {
            return Objects.hash(this.providerId, JDOMInterner.hashCode((Element)this.serialized));
        }
    }
}

