/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.DbUiUtilCore;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\"\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dataSource/IntrospectionScheduleOptionProvider;", "Lcom/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider;", "", "()V", "getDescription", "getDisplayName", "getEditor", "Lcom/intellij/database/dataSource/DbOptionProvider$EditorDesc;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLocation", "Lcom/intellij/database/dataSource/DbOptionProvider$UiLocation;", "isApplicable", "", "load", "store", "", "value", "intellij.database.connectivity"})
public final class IntrospectionScheduleOptionProvider
extends DbOptionProvider.LocalDataSourceOptionProvider<String> {
    @Override
    public boolean isApplicable(@NotNull LocalDataSource target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return true;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("IntrospectionScheduleOptionProvider.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = DatabaseBundle.message("IntrospectionScheduleOptionProvider.desc", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    public String load(@Nullable LocalDataSource target2) {
        Object object = target2;
        return object != null && (object = ((LocalDataSource)object).getAdditionalProperty("auto-refresh-interval")) != null ? StringKt.nullize$default((String)object, (boolean)false, (int)1, null) : null;
    }

    @Override
    @NotNull
    public DbOptionProvider.EditorDesc<String> getEditor(@Nullable LocalDataSource target2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DbOptionProvider.EditorDesc<String> $this$getEditor_u24lambda_u240 = DbOptionProvider.getTextField(null);
        boolean bl = false;
        JComponent jComponent = $this$getEditor_u24lambda_u240.component;
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JTextField");
        JTextField textField = (JTextField)jComponent;
        textField.setColumns(6);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(textField){
            final /* synthetic */ JTextField $textField;
            {
                this.$textField = $textField;
            }

            protected void textChanged(@NotNull DocumentEvent e2) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                JComponent jComponent = this.$textField;
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                DbUiUtilCore.setError(jComponent, this.getError(string));
            }

            private final String getError(String text2) {
                String string;
                try {
                    if (((CharSequence)text2).length() > 0) {
                        Double.parseDouble(text2);
                    }
                    string = null;
                }
                catch (NumberFormatException e2) {
                    string = "Should be integer or decimal number";
                }
                return string;
            }
        });
        return new DbOptionProvider.EditorDesc<String>((JComponent)JBUI.Panels.simplePanel().addToLeft((Component)$this$getEditor_u24lambda_u240.component).addToCenter((Component)new JLabel(DatabaseBundle.message("IntrospectionScheduleOptionProvider.unit", new Object[0]))), $this$getEditor_u24lambda_u240.setter, $this$getEditor_u24lambda_u240.getter, $this$getEditor_u24lambda_u240.changed);
    }

    @Override
    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        return DbOptionProvider.UiLocation.INTROSPECTION;
    }

    @Override
    public void store(@NotNull LocalDataSource target2, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        target2.setAdditionalProperty("auto-refresh-interval", StringKt.nullize$default((String)value2, (boolean)false, (int)1, null));
    }
}

