/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DataSourceSshPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import javax.swing.border.Border;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class DatabaseSshTunnelEstablisherUi {
    static Function<? super DataSourceSshPanel, Boolean> ourSshInterceptor = null;

    @TestOnly
    public static void setCredentialsInterceptor(Function<? super DataSourceSshPanel, Boolean> di) {
        ourSshInterceptor = di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<DataSourceSshTunnelConfiguration, SshUiData> askSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NlsContexts.DialogMessage @NotNull String message2, boolean error2) {
        if (project == null) {
            DatabaseSshTunnelEstablisherUi.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisherUi.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            DatabaseSshTunnelEstablisherUi.$$$reportNull$$$0(2);
        }
        Disposable disposable = Disposer.newDisposable();
        try {
            boolean ok2;
            DataSourceSshPanel sshPanel = new DataSourceSshPanel(project, dataSource2, disposable);
            sshPanel.reset(dataSource2);
            if (ourSshInterceptor == null) {
                sshPanel.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)4));
                DialogBuilder builder = DatabaseCredentialsUi.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), sshPanel.getComponent(), DatabaseBundle.message("dialog.title.opening.tunnel.for", dataSource2.getName()), message2);
                builder.setPreferredFocusComponent(sshPanel.getPreferredFocusedComponent());
                ok2 = builder.show() == 0;
            } else {
                ok2 = (Boolean)ourSshInterceptor.fun((Object)sshPanel);
            }
            if (!ok2) {
                throw new ProcessCanceledException();
            }
            sshPanel.saveData(dataSource2, true);
            DataSourceSshTunnelConfiguration config = sshPanel.createSshConfig();
            if (config == null || !config.isEnabled()) {
                Pair<DataSourceSshTunnelConfiguration, SshUiData> pair = null;
                return pair;
            }
            Pair pair = new Pair((Object)config, (Object)sshPanel.getUiData());
            return pair;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/DatabaseSshTunnelEstablisherUi";
        objectArray[2] = "askSshCredentials";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

