/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseNameColorExtension
implements ExtendableTextComponent.Extension {
    private static final String NO_COLOR_ID = "NO COLOR";
    private static final String CUSTOM_ID = "CUSTOM";
    private static final int ICON_SIZE = EmptyIcon.ICON_16.getIconWidth();
    private static final String SHORTCUT_ACTION = "ExpandExpandableComponent";
    private static final Color ICON_COLOR = JBColor.namedColor((String)"Component.iconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.5));
    private static final Color ICON_COLOR_HOVERED = JBColor.namedColor((String)"Component.hoverIconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.9));
    final Icon icon;
    final Icon iconHovered;
    private final DatabaseNameComponent myNameComponent;
    @NonNls
    private String myColorIDString;
    private List<String> myStandardColors;

    DatabaseNameColorExtension(@NotNull DatabaseNameComponent nameComponent) {
        if (nameComponent == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(0);
        }
        this.icon = this.createColorIcon(false);
        this.iconHovered = this.createColorIcon(true);
        this.myColorIDString = null;
        this.myNameComponent = nameComponent;
        this.myStandardColors = this.getStandardColors();
        if (!(this.myNameComponent.getConfigurable() instanceof AbstractDataSourceConfigurable)) {
            throw new AssertionError();
        }
    }

    private Project getProject() {
        return this.myNameComponent.getConfigurable().getProject();
    }

    private ExtendableTextField getTextField() {
        return this.myNameComponent.getNameField();
    }

    @NotNull
    static Icon createColorIcon(@Nullable Color color) {
        return color == null ? EmptyIcon.ICON_16 : new RoundColorIcon(ICON_SIZE, color);
    }

    @NotNull
    Icon createColorIcon(final boolean hovered) {
        return new RoundColorIcon(ICON_SIZE, ICON_COLOR){

            @Override
            public void paintIcon(Component component2, Graphics g2, int i2, int j) {
                Color color;
                Color color2 = DatabaseNameColorExtension.this.myColorIDString != null ? DatabaseNameColorExtension.getColor(DatabaseNameColorExtension.this.myColorIDString, DatabaseNameColorExtension.this.getProject()) : (color = hovered ? ICON_COLOR_HOVERED : DatabaseNameColorExtension.this.getTextField().getBackground());
                Color borderColor = DatabaseNameColorExtension.this.myColorIDString != null ? ICON_COLOR : (hovered ? ICON_COLOR_HOVERED : ICON_COLOR);
                this.doPaint(g2, i2, j, color, borderColor);
            }
        };
    }

    private List<String> getStandardColors() {
        if (this.myStandardColors == null) {
            this.myStandardColors = new ArrayList<String>(FileColorManager.getInstance((Project)this.getProject()).getColorIDs());
        }
        return this.myStandardColors;
    }

    public void apply(@NotNull RawDataSource source) {
        if (source == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(1);
        }
        if (!source.isGlobal()) {
            DatabaseColorManager.setColorId(this.getElement(source), this.myColorIDString, false, false);
        } else {
            DatabaseColorManager.setColorIdForGlobalDataSource(this.getElement(source), this.myColorIDString, false);
        }
        AssignColorAction.updateOpenFileEditors(this.getProject());
        AssignColorAction.updateDatabaseToolwindow(this.getProject());
    }

    public void reset(@NotNull RawDataSource source) {
        if (source == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(2);
        }
        this.myColorIDString = DatabaseColorManager.getColorId(this.getElement(source), (Ref<Boolean>)Ref.create((Object)false));
        this.getTextField().repaint();
    }

    void setChosenColor(@Nullable String colorID) {
        this.myColorIDString = colorID;
        this.getTextField().repaint();
        this.myNameComponent.getConfigurable().getController().clearModifiedCache();
    }

    @NotNull
    private DbElement getElement(@NotNull RawDataSource dataSource2) {
        if (dataSource2 == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(3);
        }
        Object manager = ((AbstractDataSourceConfigurable)this.myNameComponent.getConfigurable()).getManager();
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)DbPsiFacade.getInstance(this.getProject())).createDataSourceWrapperElement(dataSource2, (DataSourceManager<?>)manager);
        if (dbDataSource == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(4);
        }
        return dbDataSource;
    }

    public boolean isModified() {
        Object target2 = this.myNameComponent.getConfigurable().getTarget();
        return !Objects.equals(DatabaseColorManager.getColorId(this.getElement((RawDataSource)target2), (Ref<Boolean>)Ref.create((Object)false)), this.myColorIDString);
    }

    @NotNull
    private static Color getColor(@Nullable @NonNls String colorID, @NotNull Project project) {
        Color color;
        if (project == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(5);
        }
        if (colorID == null) {
            Color color2 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color2 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(6);
            }
            return color2;
        }
        Color color3 = FileColorManager.getInstance((Project)project).getColor(colorID);
        if (color3 != null) {
            Color color4 = color3;
            if (color4 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(7);
            }
            return color4;
        }
        try {
            color = ColorUtil.fromHex((String)colorID);
        }
        catch (Exception e2) {
            Color color5 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color5 == null) {
                DatabaseNameColorExtension.$$$reportNull$$$0(9);
            }
            return color5;
        }
        if (color == null) {
            DatabaseNameColorExtension.$$$reportNull$$$0(8);
        }
        return color;
    }

    @Nullable
    static KeyboardShortcut getExtensionKeyboardShortcut() {
        AnAction baseAction = ActionManager.getInstance().getAction(SHORTCUT_ACTION);
        return baseAction == null ? null : (KeyboardShortcut)JBIterable.of((Object[])baseAction.getShortcutSet().getShortcuts()).filter(KeyboardShortcut.class).first();
    }

    public Icon getIcon(boolean hovered) {
        return hovered ? this.iconHovered : this.icon;
    }

    public String getTooltip() {
        return DatabaseBundle.message("DatabaseNameColorExtension.choose.color", KeymapUtil.getFirstKeyboardShortcutText((String)SHORTCUT_ACTION));
    }

    public int getIconGap() {
        return 3;
    }

    public Runnable getActionOnClick() {
        return this::perform;
    }

    private void perform() {
        FileColorManager colorManager = FileColorManager.getInstance((Project)this.getProject());
        JBIterable values2 = JBIterable.of((Object)new ColorIDAndName(NO_COLOR_ID, DatabaseBundle.message("DatabaseNameColorExtension.no.color", new Object[0]))).append((Iterable)JBIterable.from((Iterable)colorManager.getColorIDs()).map(id -> new ColorIDAndName((String)id, colorManager.getColorName(id)))).append(this.myColorIDString != null && !colorManager.getColorIDs().contains(this.myColorIDString) ? new ColorIDAndName(this.myColorIDString, this.myColorIDString) : null).append((Object)new ColorIDAndName(CUSTOM_ID, DatabaseNameColorExtension.getCustom()));
        JBIterable icons = values2.map(v2 -> Strings.areSameInstance((String)v2.id, (String)NO_COLOR_ID) || Strings.areSameInstance((String)v2.id, (String)CUSTOM_ID) ? null : colorManager.getColor(v2.id)).map(DatabaseNameColorExtension::createColorIcon);
        BaseListPopupStep<ColorIDAndName> popupStep = new BaseListPopupStep<ColorIDAndName>("", values2.toList(), icons.toList()){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(ColorIDAndName value2) {
                String string = value2.name;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public PopupStep<?> onChosen(ColorIDAndName selectedValue, boolean finalChoice) {
                if (Strings.areSameInstance((String)selectedValue.id, (String)DatabaseNameColorExtension.CUSTOM_ID)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Color color = ColorPicker.showDialog((Component)DatabaseNameColorExtension.this.getTextField(), (String)DatabaseBundle.message("DatabaseNameColorExtension.choose.color.title", new Object[0]), (Color)DatabaseNameColorExtension.getColor(DatabaseNameColorExtension.this.myColorIDString, DatabaseNameColorExtension.this.getProject()), (boolean)false, null, (boolean)false);
                        if (color != null) {
                            DatabaseNameColorExtension.this.setChosenColor(ColorUtil.toHex((Color)color));
                        }
                    }, ModalityState.stateForComponent((Component)DatabaseNameColorExtension.this.getTextField()));
                } else {
                    DatabaseNameColorExtension.this.setChosenColor(Strings.areSameInstance((String)selectedValue.id, (String)DatabaseNameColorExtension.NO_COLOR_ID) ? null : selectedValue.id);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseNameColorExtension$2", "getTextFor"));
            }
        };
        popupStep.setDefaultOptionIndex(values2.indexOf(v2 -> v2.id.equals(this.myColorIDString)));
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
        Rectangle bounds = ((TextFieldWithPopupHandlerUI)this.getTextField().getUI()).getExtensionIconBounds((ExtendableTextComponent.Extension)this);
        Point point = bounds.getLocation();
        point.y += bounds.width + JBUIScale.scale((int)2);
        popup2.show(new RelativePoint((Component)this.getTextField(), point));
    }

    @Nls
    private static String getCustom() {
        return ApplicationBundle.message((String)"custom.option", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseNameColorExtension";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseNameColorExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class RoundColorIcon
    extends ColorIcon {
        final Color borderColor;

        RoundColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(0);
            }
            this(size, color, ICON_COLOR);
        }

        RoundColorIcon(int size, @NotNull Color color, @NotNull Color borderColor) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(1);
            }
            if (borderColor == null) {
                RoundColorIcon.$$$reportNull$$$0(2);
            }
            super(size, color, true);
            this.borderColor = borderColor;
        }

        public void paintIcon(Component component2, Graphics g2, int i2, int j) {
            this.doPaint(g2, i2, j, this.getIconColor(), this.borderColor);
        }

        void doPaint(Graphics g2, int i2, int j, Color color, Color borderColor) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
            int dim = this.getIconWidth() - 2;
            g2.setColor(color);
            g2.fillOval(i2 + 1, j + 1, dim, dim);
            g2.setColor(borderColor);
            g2.drawOval(i2 + 1, j + 1, dim, dim);
            config.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "borderColor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseNameColorExtension$RoundColorIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ColorIDAndName {
        final String id;
        @Nls
        final String name;

        private ColorIDAndName(String id, @Nls String name2) {
            this.id = id;
            this.name = name2;
        }
    }
}

