/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceScheduler;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "dataSources", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/dataSource/DataSourceScheduler;", "createIfActive", "dataSource", "project", "Lcom/intellij/openapi/project/Project;", "remove", "validateActive", "validateDataSourceScheduler", "", "Companion", "DataSourceListener", "DriverListener", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseIntrospectionScheduleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,267:1\n372#2,7:268\n*S KotlinDebug\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager\n*L\n76#1:268,7\n*E\n"})
public final class DatabaseIntrospectionScheduleManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<LocalDataSource, DataSourceScheduler> dataSources;

    public DatabaseIntrospectionScheduleManager(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.dataSources = new HashMap();
    }

    private final void validateDataSourceScheduler(Project project, LocalDataSource dataSource2) {
        DataSourceScheduler dataSourceScheduler = this.validateActive(project, dataSource2);
        if (dataSourceScheduler != null) {
            dataSourceScheduler.validate(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceScheduler validateActive(Project project, LocalDataSource dataSource2) {
        DataSourceScheduler dataSourceScheduler;
        Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
        synchronized (map2) {
            boolean bl = false;
            dataSourceScheduler = this.dataSources.get(dataSource2);
        }
        DataSourceScheduler dsScheduler = dataSourceScheduler;
        return dsScheduler == null ? this.createIfActive(dataSource2, project) : (dsScheduler.isActive() ? dsScheduler : this.remove(dataSource2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceScheduler remove(LocalDataSource dataSource2) {
        DataSourceScheduler dataSourceScheduler;
        Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
        synchronized (map2) {
            boolean bl = false;
            dataSourceScheduler = this.dataSources.remove(dataSource2);
        }
        DataSourceScheduler dataSourceScheduler2 = dataSourceScheduler;
        if (dataSourceScheduler2 != null) {
            dataSourceScheduler2.cancel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataSourceScheduler createIfActive(LocalDataSource dataSource2, Project project) {
        DataSourceScheduler dataSourceScheduler;
        Function0<DataSourceScheduler> function0 = DataSourceScheduler.Companion.factoryIfActive(this.cs, dataSource2, project);
        if (function0 != null) {
            Function0<DataSourceScheduler> it2 = function0;
            boolean bl = false;
            Map<LocalDataSource, DataSourceScheduler> map2 = this.dataSources;
            synchronized (map2) {
                Object object;
                boolean bl2 = false;
                Map<LocalDataSource, DataSourceScheduler> $this$getOrPut$iv = this.dataSources;
                boolean $i$f$getOrPut = false;
                DataSourceScheduler value$iv = $this$getOrPut$iv.get(dataSource2);
                if (value$iv == null) {
                    Object answer$iv = it2.invoke();
                    $this$getOrPut$iv.put(dataSource2, (DataSourceScheduler)answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                DataSourceScheduler dataSourceScheduler2 = object;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var5_5
                dataSourceScheduler = dataSourceScheduler2;
            }
        } else {
            dataSourceScheduler = null;
        }
        return dataSourceScheduler;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion;", "", "()V", "instance", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "getInstance", "()Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager;", "validateDataSourceScheduler", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseIntrospectionScheduleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,267:1\n31#2,2:268\n*S KotlinDebug\n*F\n+ 1 DatabaseIntrospectionScheduleManager.kt\ncom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$Companion\n*L\n41#1:268,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DatabaseIntrospectionScheduleManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<DatabaseIntrospectionScheduleManager> serviceClass$iv = DatabaseIntrospectionScheduleManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseIntrospectionScheduleManager)object;
        }

        public final void validateDataSourceScheduler(@Nullable Project project, @NotNull LocalDataSource dataSource2) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            this.getInstance().validateDataSourceScheduler(project, dataSource2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dataSourceChanged", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "App", "Proj", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$App;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$Proj;", "intellij.database.connectivity"})
    public static abstract class DataSourceListener
    implements DataSourceStorage.Listener {
        @Nullable
        private final Project project;

        private DataSourceListener(Project project) {
            this.project = project;
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource2) {
            if (dataSource2 != null) {
                Companion.validateDataSourceScheduler(this.project, dataSource2);
            } else {
                for (LocalDataSource ds : DataSourceStorage.getStorage(this.project).getOwnDataSources()) {
                    Intrinsics.checkNotNull((Object)ds);
                    Companion.validateDataSourceScheduler(this.project, ds);
                }
            }
        }

        public /* synthetic */ DataSourceListener(Project project, DefaultConstructorMarker $constructor_marker) {
            this(project);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$App;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "()V", "intellij.database.connectivity"})
        public static final class App
        extends DataSourceListener {
            public App() {
                super(null, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener$Proj;", "Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DataSourceListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "intellij.database.connectivity"})
        public static final class Proj
        extends DataSourceListener {
            public Proj(@Nullable Project project) {
                super(project, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/DatabaseIntrospectionScheduleManager$DriverListener;", "Lcom/intellij/database/console/JdbcDriverManager$Listener;", "()V", "onStarted", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "onTerminated", "intellij.database.connectivity"})
    public static final class DriverListener
    implements JdbcDriverManager.Listener {
        @Override
        public void onStarted(@NotNull LocalDataSource dataSource2, @NotNull ConsoleRunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Companion.validateDataSourceScheduler(configuration.getProject(), dataSource2);
        }

        @Override
        public void onTerminated(@NotNull LocalDataSource dataSource2, @Nullable ConsoleRunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            ConsoleRunConfiguration consoleRunConfiguration = configuration;
            Companion.validateDataSourceScheduler((Project)(consoleRunConfiguration != null ? consoleRunConfiguration.getProject() : null), dataSource2);
        }
    }
}

