/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\bg\u0018\u0000 ,2\u00020\u0001:\u0003*+,J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H&J\r\u0010\u0015\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0016H&J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J$\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020\u0018H\u0016J,\u0010%\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0018H\u0016J\u001a\u0010(\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010\u0013H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006-\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "getId", "Lorg/jetbrains/annotations/NonNls;", "handleConnectionFailure", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "loadAuthConfig", "", "external", "saveAuthConfig", "", "data", "setNewPassword", "newPass", "ApplicabilityLevel", "AuthWidget", "Companion", "intellij.database.core.impl"})
@ApiStatus.Experimental
public interface DatabaseAuthProvider
extends DatabaseConnectionInterceptor {
    @NotNull
    public static final Companion Companion = com.intellij.database.dataSource.DatabaseAuthProvider$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @NotNull
    public String getDisplayName();

    @Nullable
    default public AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        AuthWidget authWidget;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config instanceof LocalDataSource) {
            LocalDataSource localDataSource = config.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            authWidget = this.createWidget(project, credentials, localDataSource);
        } else {
            authWidget = null;
        }
        return authWidget;
    }

    @Deprecated(message="Anti misuse: wrong implementation returned preferred for all data sources, causing switch suggestions.", replaceWith=@ReplaceWith(expression="com.intellij.database.dataSource.DatabaseAuthProvider#getApplicability", imports={}))
    @ApiStatus.ScheduledForRemoval
    default public boolean isApplicable(@NotNull LocalDataSource dataSource2, @NotNull ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return false;
    }

    @NotNull
    default public ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LocalDataSource localDataSource = point.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        if (!this.isApplicable(localDataSource, level)) {
            return ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        return level == ApplicabilityLevel.DEFAULT ? ApplicabilityLevel.Result.DEFAULT : ApplicabilityLevel.Result.APPLICABLE;
    }

    @Nullable
    default public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return null;
    }

    default public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
    }

    default public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
    }

    @Override
    @Nullable
    default public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull Throwable e2, boolean silent, int attempt, @NotNull Continuation<? super Boolean> $completion) {
        return DatabaseConnectionInterceptor.DatabaseAuthProvider.super.handleConnectionFailure(proto2, e2, silent, attempt, $completion);
    }

    @Deprecated(message="Use DatabaseConnectionConfig overload", replaceWith=@ReplaceWith(expression="createWidget", imports={}))
    @ApiStatus.ScheduledForRemoval
    @Nullable
    default public AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource2) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        return null;
    }

    @JvmStatic
    public static void copyAllCredentials(@NotNull DatabaseConnectionPoint from, @NotNull DatabaseCredentials fromStorage, @NotNull DatabaseConnectionConfig to, @NotNull DatabaseCredentials toStorage) {
        Companion.copyAllCredentials(from, fromStorage, to, toStorage);
    }

    @JvmStatic
    @NotNull
    public static List<DatabaseAuthProvider> getApplicable(@NotNull DatabaseConnectionPoint point) {
        return Companion.getApplicable(point);
    }

    @JvmStatic
    public static boolean isApplicable(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
        return Companion.isApplicable(ap, point);
    }

    @JvmStatic
    public static boolean isPreferred(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
        return Companion.isPreferred(ap, point);
    }

    @JvmStatic
    @Nullable
    public static DatabaseAuthProvider getPreferred(@NotNull DatabaseConnectionPoint point) {
        return Companion.getPreferred(point);
    }

    @JvmStatic
    @NotNull
    public static DatabaseAuthProvider getDefault(@NotNull DatabaseConnectionPoint point) {
        return Companion.getDefault(point);
    }

    @JvmStatic
    @Nullable
    public static DatabaseAuthProvider get(@NotNull String id) {
        return Companion.get(id);
    }

    @JvmStatic
    @NotNull
    public static DatabaseAuthProvider get(@NotNull DatabaseConnectionPoint point) {
        return Companion.get(point);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000f\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "", "", "(Ljava/lang/String;I)V", "APPLICABLE", "DEFAULT", "PREFERRED", "Result", "intellij.database.core.impl"})
    public static final class ApplicabilityLevel
    extends Enum<ApplicabilityLevel>
    implements Comparable<ApplicabilityLevel> {
        public static final /* enum */ ApplicabilityLevel APPLICABLE = new ApplicabilityLevel();
        public static final /* enum */ ApplicabilityLevel DEFAULT = new ApplicabilityLevel();
        public static final /* enum */ ApplicabilityLevel PREFERRED = new ApplicabilityLevel();
        private static final /* synthetic */ ApplicabilityLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ApplicabilityLevel[] values() {
            return (ApplicabilityLevel[])$VALUES.clone();
        }

        public static ApplicabilityLevel valueOf(String value2) {
            return Enum.valueOf(ApplicabilityLevel.class, value2);
        }

        @NotNull
        public static EnumEntries<ApplicabilityLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityLevelArray = new ApplicabilityLevel[]{ApplicabilityLevel.APPLICABLE, ApplicabilityLevel.DEFAULT, ApplicabilityLevel.PREFERRED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0002j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "", "", "(Ljava/lang/String;I)V", "clamp", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "maxSupport", "NOT_APPLICABLE", "APPLICABLE", "DEFAULT", "PREFERRED", "intellij.database.core.impl"})
        public static final class Result
        extends Enum<Result>
        implements Comparable<Result> {
            public static final /* enum */ Result NOT_APPLICABLE = new Result();
            public static final /* enum */ Result APPLICABLE = new Result();
            public static final /* enum */ Result DEFAULT = new Result();
            public static final /* enum */ Result PREFERRED = new Result();
            private static final /* synthetic */ Result[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            @NotNull
            public final Result clamp(@NotNull ApplicabilityLevel level) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Result support = this.maxSupport(level);
                return this.compareTo((Enum)support) <= 0 ? this : support;
            }

            private final Result maxSupport(ApplicabilityLevel level) {
                return switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1 -> APPLICABLE;
                    case 2 -> DEFAULT;
                    case 3 -> PREFERRED;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public static Result[] values() {
                return (Result[])$VALUES.clone();
            }

            public static Result valueOf(String value2) {
                return Enum.valueOf(Result.class, value2);
            }

            @NotNull
            public static EnumEntries<Result> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = resultArray = new Result[]{Result.NOT_APPLICABLE, Result.APPLICABLE, Result.DEFAULT, Result.PREFERRED};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ApplicabilityLevel.values().length];
                    try {
                        nArray[ApplicabilityLevel.APPLICABLE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ApplicabilityLevel.DEFAULT.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[ApplicabilityLevel.PREFERRED.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\u0003H&J\b\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u0003H&J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\tH\u0017J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "", "forceSave", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "hidePassword", "isPasswordChanged", "", "onChanged", "r", "Ljava/lang/Runnable;", "reloadCredentials", "reset", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "resetCredentials", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "save", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "copyCredentials", "updateFromUrl", "holder", "Lcom/intellij/database/dataSource/url/template/ParametersHolder;", "updateUrl", "model", "Lcom/intellij/database/dataSource/url/template/MutableParametersHolder;", "intellij.database.core.impl"})
    public static interface AuthWidget {
        public void onChanged(@NotNull Runnable var1);

        default public void save(@NotNull DatabaseConnectionConfig config, boolean copyCredentials) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (config instanceof LocalDataSource) {
                LocalDataSource localDataSource = config.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                this.save(localDataSource, copyCredentials);
            }
        }

        default public void reset(@NotNull DatabaseConnectionPoint point, boolean resetCredentials) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (point instanceof LocalDataSource) {
                LocalDataSource localDataSource = point.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                this.reset(localDataSource, resetCredentials);
            }
        }

        public boolean isPasswordChanged();

        public void hidePassword();

        public void reloadCredentials();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        public void forceSave();

        public void updateFromUrl(@NotNull ParametersHolder var1);

        public void updateUrl(@NotNull MutableParametersHolder var1);

        @Deprecated(message="Use DatabaseConnectionConfig overload")
        @ApiStatus.ScheduledForRemoval
        default public void save(@NotNull LocalDataSource dataSource2, boolean copyCredentials) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        }

        @Deprecated(message="Use DatabaseConnectionConfig overload")
        @ApiStatus.ScheduledForRemoval
        default public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0018\u0010\u0018\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u001a\u0010\u0019\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dataSource/DatabaseAuthProvider$Companion;", "", "()V", "copyAllCredentials", "", "from", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "fromStorage", "Lcom/intellij/database/access/DatabaseCredentials;", "to", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "toStorage", "get", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "point", "id", "", "getApplicable", "", "getDefault", "getPreferred", "isApplicable", "", "ap", "isDefault", "isPreferred", "intellij.database.core.impl"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final void copyAllCredentials(@NotNull DatabaseConnectionPoint from, @NotNull DatabaseCredentials fromStorage, @NotNull DatabaseConnectionConfig to, @NotNull DatabaseCredentials toStorage) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)fromStorage, (String)"fromStorage");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)toStorage, (String)"toStorage");
            DatabaseAuthProvider provider = this.get(from);
            Object c2 = provider.loadAuthConfig(from, fromStorage, true);
            provider.saveAuthConfig(to, toStorage, c2, true);
            LocalDataSource localDataSource = to.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            DasDataSource dasDataSource = localDataSource;
            LocalDataSource localDataSource2 = from.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"getDataSource(...)");
            toStorage.setSslPassphrase(dasDataSource, fromStorage.getSslPassphrase(localDataSource2));
        }

        @JvmStatic
        @NotNull
        public final List<DatabaseAuthProvider> getApplicable(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            List list = JBIterable.from((Iterable)DatabaseConnectionInterceptor.Companion.getEP_NAME().getExtensionsIfPointIsRegistered()).filter(DatabaseAuthProvider.class).filter(arg_0 -> Companion.getApplicable$lambda$0(point, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            return list;
        }

        @JvmStatic
        public final boolean isApplicable(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return ap != null && ap.getApplicability(point, ApplicabilityLevel.APPLICABLE) != ApplicabilityLevel.Result.NOT_APPLICABLE;
        }

        @JvmStatic
        public final boolean isPreferred(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return ap != null && ap.getApplicability(point, ApplicabilityLevel.PREFERRED).compareTo((Enum)ApplicabilityLevel.Result.PREFERRED) >= 0;
        }

        public final boolean isDefault(@Nullable DatabaseAuthProvider ap, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return ap != null && ap.getApplicability(point, ApplicabilityLevel.DEFAULT).compareTo((Enum)ApplicabilityLevel.Result.DEFAULT) >= 0;
        }

        @JvmStatic
        @Nullable
        public final DatabaseAuthProvider getPreferred(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            return (DatabaseAuthProvider)DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.getPreferred$lambda$1(point, arg_0));
        }

        @JvmStatic
        @NotNull
        public final DatabaseAuthProvider getDefault(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Object object = DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.getDefault$lambda$2((Function1)new Function1<DatabaseConnectionInterceptor, Boolean>(point){
                final /* synthetic */ DatabaseConnectionPoint $point;
                {
                    this.$point = $point;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull DatabaseConnectionInterceptor it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DatabaseAuthProvider && com.intellij.database.dataSource.DatabaseAuthProvider$Companion.$$INSTANCE.isDefault((DatabaseAuthProvider)it2, this.$point);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.DatabaseAuthProvider");
            return (DatabaseAuthProvider)object;
        }

        @JvmStatic
        @Nullable
        public final DatabaseAuthProvider get(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return (DatabaseAuthProvider)DatabaseConnectionInterceptor.Companion.getEP_NAME().findFirstSafe(arg_0 -> Companion.get$lambda$3((Function1)new Function1<DatabaseConnectionInterceptor, Boolean>(id){
                final /* synthetic */ String $id;
                {
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull DatabaseConnectionInterceptor it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    return it2 instanceof DatabaseAuthProvider && Intrinsics.areEqual((Object)((DatabaseAuthProvider)it2).getId(), (Object)this.$id);
                }
            }, arg_0));
        }

        @JvmStatic
        @NotNull
        public final DatabaseAuthProvider get(@NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String string = point.getAuthProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthProviderId(...)");
            DatabaseAuthProvider provider = this.get(string);
            if (provider != null) {
                return provider;
            }
            LocalDataSource localDataSource = point.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource2 = localDataSource;
            DatabaseAuthProvider preferred = this.getPreferred(dataSource2);
            DatabaseAuthProvider databaseAuthProvider = preferred;
            if (databaseAuthProvider == null) {
                databaseAuthProvider = this.getDefault(dataSource2);
            }
            return databaseAuthProvider;
        }

        private static final boolean getApplicable$lambda$0(DatabaseConnectionPoint $point, DatabaseAuthProvider ap) {
            Intrinsics.checkNotNullParameter((Object)$point, (String)"$point");
            return $$INSTANCE.isApplicable(ap, $point);
        }

        private static final boolean getPreferred$lambda$1(DatabaseConnectionPoint $point, DatabaseConnectionInterceptor e2) {
            Intrinsics.checkNotNullParameter((Object)$point, (String)"$point");
            return e2 instanceof DatabaseAuthProvider && $$INSTANCE.isPreferred((DatabaseAuthProvider)e2, $point);
        }

        private static final boolean getDefault$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean get$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

