/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DbNamespaceNode;
import com.intellij.database.view.DbNamespacesTree;
import com.intellij.database.view.DbSchemaNode;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataSourceSchemasPanel {
    public static final String INTROSPECTION_ERROR = "INTROSPECTION_ERROR";
    private final DataSourceConfigurable myDialog;
    private JPanel myRoot;
    private JPanel mySchemasPanel;
    private final MyScopeEditor myScopeEditor;
    private ExpandableTextField myObjectFilter;
    private TextFieldWithAutoCompletion<Pair<String, ObjectKind>> mySchemaPattern;
    private JComponent myOptionsPanel;
    private final DbOptionsEditor<LocalDataSource> myOptionsEditor;
    private TreePattern mySchemaPatternScope = TreePattern.EMPTY;
    private boolean myUpdatingField = false;
    private boolean myUpdatingTree = false;
    private boolean myTreeDirty = false;
    private boolean myScopeFromField = true;
    private boolean myModelIsReset = true;

    public DataSourceSchemasPanel(DataSourceConfigurable dialog) {
        this.myDialog = dialog;
        this.myOptionsEditor = new DbOptionsEditor<LocalDataSource>((LocalDataSource)this.myDialog.getTarget(), p2 -> p2.getLocation() == DbOptionProvider.UiLocation.SCHEMAS, p2 -> {
            if (p2.isAffectsIntrospection()) {
                this.reintrospect();
            }
        }, dialog.getDataContext(), 2);
        this.$$$setupUI$$$();
        this.myScopeEditor = new MyScopeEditor(dialog);
        this.mySchemasPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.mySchemasPanel.setLayout(new BorderLayout());
        this.mySchemasPanel.add((Component)this.myScopeEditor.getComponent(), "Center");
        UiNotifyConnector.installOn((Component)this.myScopeEditor.getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                DataSourceSchemasPanel.this.introspectIfNeeded();
            }
        });
        UIUtil.uiTraverser((Component)this.myRoot).filter(EditorTextField.class).forEach(etf -> etf.setDisposedWith((Disposable)this.myDialog));
    }

    private void introspectIfNeeded() {
        if (this.myModelIsReset) {
            this.myModelIsReset = false;
            try {
                BasicModel model2 = (BasicModel)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> DataSourceSchemasPanel.tryCopy((BasicModel)ObjectUtils.tryCast((Object)((LocalDataSource)this.myDialog.getDataSource()).getModel(), BasicModel.class)), DatabaseBundle.message("dialog.title.initializing.model", new Object[0]), true, this.myDialog.getProject());
                this.myScopeEditor.setInitialModel((LocalDataSource)this.myDialog.getDataSource(), model2);
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        this.myScopeEditor.introspectIfEmpty();
    }

    private void reintrospect() {
        this.myScopeEditor.introspectIfCan();
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myOptionsPanel = this.myOptionsEditor.getComponent();
        this.myObjectFilter = new ExpandableTextField(s2 -> JBIterable.of((Object[])s2.split("\\|\\|")).map(StringUtil::trim).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil::trim), (String)"||"));
        this.mySchemaPattern = new TextFieldWithAutoCompletion(this.myDialog.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletion(), false, "");
        this.mySchemaPattern.setFont(this.myObjectFilter.getFont());
        new ExpandableEditorSupport(this.mySchemaPattern, s2 -> JBIterable.of((Object[])s2.split("\\|")).transform(StringUtil::trim).toList(), strings -> StringUtil.join((Iterable)JBIterable.from((Iterable)strings).transform(StringUtil::trim), (String)"|"));
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        String tooltipText = shortcuts.length == 0 ? "" : DatabaseBundle.message("for.help", KeymapUtil.getShortcutText((Shortcut)shortcuts[0]));
        this.mySchemaPattern.addSettingsProvider(e2 -> e2.getContentComponent().setToolTipText(tooltipText));
        this.myObjectFilter.setToolTipText(tooltipText);
        AnAction action = new AnAction(CommonBundle.message((String)"action.help", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e2) {
                Component c2;
                if (e2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (UIUtil.isAncestor(DataSourceSchemasPanel.this.mySchemaPattern, (Component)(c2 = (Component)e2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)))) {
                    DataSourceSchemasPanel.showHint(DataSourceSchemasPanel.this.mySchemaPattern, DatabaseBundle.message("DataSourceSchemasPanel.schema.pattern.hint", new Object[0]));
                }
                if (UIUtil.isAncestor((Component)DataSourceSchemasPanel.this.myObjectFilter, (Component)c2)) {
                    DataSourceSchemasPanel.showHint((JComponent)DataSourceSchemasPanel.this.myObjectFilter, DatabaseBundle.message("DataSourceSchemasPanel.object.filter.hint", StringUtil.join((Collection)ContainerUtil.sorted(DbImplUtilCore.FILTER_BY_NAME.keySet()), (String)"</b>, <b>")));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$2", "actionPerformed"));
            }
        };
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this.mySchemaPattern);
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)this.myObjectFilter);
        this.mySchemaPattern.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e2) {
                if (e2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!DataSourceSchemasPanel.this.myUpdatingTree && !DataSourceSchemasPanel.this.myUpdatingField) {
                    DataSourceSchemasPanel.this.myScopeFromField = true;
                }
                if (!DataSourceSchemasPanel.this.myUpdatingField) {
                    DataSourceSchemasPanel.this.myScopeEditor.setFieldScope(TreePatternUtils.parse(((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getDbms(), e2.getDocument().getText()), false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$3", "documentChanged"));
            }
        });
    }

    public void saveSettings(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(0);
        }
        dataSource2.setFakeCurrentSchema(this.myScopeEditor.getFakeCurrentSchema());
        dataSource2.setObjectPattern(StringUtil.nullize((String)this.myObjectFilter.getText()));
        dataSource2.setSchemaMapping(this.myScopeEditor.getSchemaMapping());
        this.myOptionsEditor.apply(dataSource2);
    }

    public void reset(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(1);
        }
        this.myScopeEditor.setInitialModel(null, null);
        this.myModelIsReset = true;
        this.myScopeEditor.resetFieldScope(dataSource2.getIntrospectionScope());
        this.myScopeEditor.setFakeCurrentSchema(dataSource2.getFakeCurrentSchema());
        this.myScopeEditor.setSchemaMapping(dataSource2.getSchemaMapping());
        this.myObjectFilter.setText(StringUtil.notNullize((String)dataSource2.getObjectPattern()));
        this.myOptionsEditor.reset(dataSource2);
    }

    private static void showHint(final JComponent component2, @NlsContexts.HintText String text2) {
        JComponent label2 = HintUtil.createInformationLabel((String)text2, (HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e2) {
                if (e2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ("#regex".equals(e2.getDescription())) {
                    RegExHelpPopup.createRegExLinkRunnable((Component)component2).run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$4", "hyperlinkActivated"));
            }
        }, null, null);
        JBPopupFactory.getInstance().createBalloonBuilder(label2).setFillColor(HintUtil.getInformationColor()).createBalloon().show(RelativePoint.getNorthWestOf((JComponent)component2), Balloon.Position.above);
    }

    @Nullable
    public static BasicModel tryCopy(final @Nullable BasicModel basicModel) {
        if (basicModel == null) {
            return null;
        }
        BasicModModel modModel = DbSrcModelStorageService.getInstance().createFactory(null, (String)null).createModel(basicModel.getDbms());
        modModel.modify(BasicModRoot.class, new ModelModifier<BasicModRoot>(){

            @Override
            public void perform(BasicModRoot element2) {
                this.copy(element2, basicModel.getRoot());
            }

            void copy(BasicModElement to, BasicElement from) {
                5.copyProp(to, from);
                for (BasicMetaObject<BasicNamespace> basicMetaObject : from.getMetaObject().children) {
                    if (!basicMetaObject.kindOf(BasicNamespace.class)) continue;
                    this.copy((ModFamily<?>)to.familyOf(basicMetaObject.kind), from.familyOf(basicMetaObject.kind));
                }
            }

            private static void copyProp(BasicModElement to, BasicElement from) {
                ModelLightCopier.copyProperties(from, to, false, false);
            }

            void copy(ModFamily<?> to, Family<?> from) {
                if (to == null || from == null) {
                    return;
                }
                BaseModel.createBulk(to, from, (t, f) -> this.copy((BasicModElement)t, (BasicElement)f));
            }
        });
        return modModel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySchemasPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12), null, 0, 0, null, null));
        ExpandableTextField expandableTextField = this.myObjectFilter;
        jPanel3.add((Component)expandableTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSchemasPanel.class).getString("data.source.object.filter.label"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        TextFieldWithAutoCompletion<Pair<String, ObjectKind>> textFieldWithAutoCompletion = this.mySchemaPattern;
        jPanel3.add((Component)textFieldWithAutoCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSchemasPanel.class).getString("data.source.editor.schema.pattern.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        JComponent jComponent = this.myOptionsPanel;
        jPanel3.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataSource";
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemasPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyScopeEditor
    extends DataSourceScopeEditor {
        MyScopeEditor(DataSourceConfigurable dialog) {
            super(dialog.getProject());
            this.getTree().addCheckboxTreeListener(new CheckboxTreeListener(){

                public void beforeNodeStateChanged(@NotNull CheckedTreeNode node2) {
                    if (node2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyScopeEditor.this.beforeStateChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$1", "beforeNodeStateChanged"));
                }
            });
        }

        @Override
        @NotNull
        public DataSourceSchemaMapping getSchemaMapping() {
            this.mySchemaMapping.setIntrospectionScope(this.getScope());
            DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
            if (dataSourceSchemaMapping == null) {
                MyScopeEditor.$$$reportNull$$$0(0);
            }
            return dataSourceSchemaMapping;
        }

        @Override
        protected void handleIntrospectionError(@Nls @Nullable String msg) {
            if (msg == null) {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, null);
            } else {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, DatabaseBundle.message("notification.title.DatabaseConfigEditor.error", new Object[0]), msg, new Object[0]);
            }
        }

        @Override
        @Nullable
        protected LocalDataSource getDataSource(boolean withCredentials) {
            if (!withCredentials) {
                return DataSourceSchemasPanel.this.myDialog.getTempDataSource();
            }
            LocalDataSource dataSource2 = DataSourceSchemasPanel.this.myDialog.getTempDataSourceForConnection();
            if (this.myModel != ((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getModel() && this.myModel != null) {
                dataSource2.setModel(this.myModel);
            }
            return dataSource2;
        }

        @Override
        protected void onIntrospectionFinished(LocalDataSource dataSource2) {
            DataSourceSchemasPanel.this.myDialog.bulkUpdate(() -> {
                if (!DataSourceSchemasPanel.this.myTreeDirty && DataSourceSchemasPanel.this.mySchemaPatternScope.isEmpty() && !dataSource2.getIntrospectionScope().isEmpty()) {
                    this.setScopes(dataSource2.getIntrospectionScope(), dataSource2.getIntrospectionScope());
                }
                super.onIntrospectionFinished(dataSource2);
            });
        }

        @Override
        @NotNull
        protected DatabaseCredentials getCredentials() {
            DatabaseCredentials databaseCredentials = DataSourceSchemasPanel.this.myDialog.getSecretService();
            if (databaseCredentials == null) {
                MyScopeEditor.$$$reportNull$$$0(1);
            }
            return databaseCredentials;
        }

        @Override
        protected void onStateChanged() {
            if (DataSourceSchemasPanel.this.myTreeDirty) {
                this.updateTreeScope();
            }
        }

        @Override
        @NotNull
        protected Dbms getDbms() {
            Dbms dbms = ((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getDbms();
            if (dbms == null) {
                MyScopeEditor.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = new JPanel(new BorderLayout());
            ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("DbSourceSchemas", (ActionGroup)this.createTreeActions(), true);
            toolbar2.setTargetComponent((JComponent)((Object)this.getTree()));
            northPanel.add((Component)toolbar2.getComponent(), "West");
            northPanel.add((Component)this.getFilteringTree().installSearchField(), "East");
            JPanel jPanel = northPanel;
            if (jPanel == null) {
                MyScopeEditor.$$$reportNull$$$0(3);
            }
            return jPanel;
        }

        @Override
        protected void beforeStateChanged() {
            if (!DataSourceSchemasPanel.this.myUpdatingTree && !DataSourceSchemasPanel.this.myUpdatingField) {
                DataSourceSchemasPanel.this.myScopeFromField = false;
            }
            DataSourceSchemasPanel.this.myTreeDirty = true;
        }

        @Override
        protected void onSetScopeReady() {
            this.updateTreeScope();
        }

        private TreePattern getScope() {
            if (DataSourceSchemasPanel.this.myScopeFromField) {
                return DataSourceSchemasPanel.this.mySchemaPatternScope;
            }
            if (DataSourceSchemasPanel.this.myTreeDirty) {
                this.updateTreeScope();
            }
            return this.mySelectedScope;
        }

        private void updateTreeScope() {
            if (this.myRechecking) {
                return;
            }
            DataSourceSchemasPanel.this.myTreeDirty = false;
            TreePattern scope = this.getEditorState();
            if (scope.equals(this.mySelectedScope)) {
                return;
            }
            this.mySelectedScope = scope;
            if (!DataSourceSchemasPanel.this.myScopeFromField) {
                this.setFieldScope(scope, true);
            }
        }

        private void resetFieldScope(TreePattern scope) {
            DataSourceSchemasPanel.this.myScopeFromField = true;
            this.setFieldScope(scope, true);
        }

        private void setFieldScope(TreePattern scope, boolean updateText) {
            if (DataSourceSchemasPanel.this.myUpdatingField) {
                return;
            }
            DataSourceSchemasPanel.this.myUpdatingField = true;
            try {
                DataSourceSchemasPanel.this.mySchemaPatternScope = scope;
                if (updateText) {
                    DataSourceSchemasPanel.this.mySchemaPattern.setText(TreePatternUtils.serialize(scope));
                }
                if (DataSourceSchemasPanel.this.myScopeFromField) {
                    this.setTreeScope(scope);
                }
            }
            finally {
                DataSourceSchemasPanel.this.myUpdatingField = false;
            }
        }

        private void setTreeScope(TreePattern scope) {
            if (DataSourceSchemasPanel.this.myUpdatingTree) {
                return;
            }
            DataSourceSchemasPanel.this.myUpdatingTree = true;
            try {
                this.setScopes(scope, DataSourceSchemasPanel.this.myUpdatingField ? scope : null);
            }
            finally {
                DataSourceSchemasPanel.this.myUpdatingTree = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaMapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCredentials";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNorthPanel";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MyCompletion
    extends TextFieldWithAutoCompletionListProvider<Pair<String, ObjectKind>> {
        protected MyCompletion() {
            super(null);
        }

        public boolean isDumbAware() {
            return true;
        }

        @Nullable
        public String getPrefix(@NotNull String text2, int offset) {
            if (text2 == null) {
                MyCompletion.$$$reportNull$$$0(0);
            }
            int last2 = Math.max(TreePatternUtils.lastIndexOf(text2, '|', offset - 1), Math.max(TreePatternUtils.lastIndexOf(text2, ':', offset - 1), TreePatternUtils.lastIndexOf(text2, ',', offset - 1)));
            return text2.substring(Math.max(0, last2 + 1), offset);
        }

        @Nullable
        protected String getTailText(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(1);
            }
            return "*".equals(item.first) ? "  All " + StringUtil.pluralize((String)((ObjectKind)item.second).code()) : ("@".equals(item.first) ? "  Current " + ((ObjectKind)item.second).code() : null);
        }

        @Nullable
        protected Icon getIcon(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(2);
            }
            return DbPresentationCore.getIcon((ObjectKind)item.second);
        }

        @NotNull
        protected String getLookupString(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(3);
            }
            String string = (String)item.first;
            if (string == null) {
                MyCompletion.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Collection<Pair<String, ObjectKind>> getItems(String prefix, boolean cached, CompletionParameters parameters2) {
            JBIterable schs;
            int offset = parameters2.getOffset();
            String text2 = parameters2.getEditor().getDocument().getText();
            int dbPos = TreePatternUtils.lastIndexOf(text2, '|', offset - 1);
            int scPos = Math.max(TreePatternUtils.lastIndexOf(text2, ':', offset - 1), TreePatternUtils.lastIndexOf(text2, ',', offset - 1));
            boolean isDb = scPos == -1 || scPos < dbPos;
            DbNamespaceNode root2 = DataSourceSchemasPanel.this.myScopeEditor.getRoot();
            if (isDb) {
                JBIterable dbs2 = root2.findChild(ObjectKind.DATABASE) == null ? JBIterable.empty() : JBIterable.from(root2.getChildNodes()).transform(DbNamespacesTree::getNodeName).filter(Conditions.notNull());
                Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)dbs2).transform(n -> Pair.create((Object)n, (Object)ObjectKind.DATABASE)).toSet();
                if (set == null) {
                    MyCompletion.$$$reportNull$$$0(5);
                }
                return set;
            }
            String dbName = text2.substring(0, scPos);
            if (root2.findChild(ObjectKind.DATABASE) == null) {
                schs = JBIterable.from(root2.getChildNodes()).transform(DbNamespacesTree::getNodeName);
            } else {
                DbSchemaNode db2 = "*".equals(dbName) || "@".equals(dbName) ? null : (DbNamespaceNode)JBIterable.from(root2.getChildNodes()).find(n -> dbName.equals(DbNamespacesTree.getNodeName(n)));
                schs = (db2 == null ? JBIterable.from(root2.getChildNodes()).flatten(DbSchemaNode::getChildNodes) : JBIterable.from(db2.getChildNodes())).transform(DbNamespacesTree::getNodeName);
            }
            Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)schs).transform(n -> Pair.create((Object)n, (Object)ObjectKind.SCHEMA)).toSet();
            if (set == null) {
                MyCompletion.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull Pair<String, ObjectKind> item) {
            if (item == null) {
                MyCompletion.$$$reportNull$$$0(7);
            }
            String text2 = this.getLookupString(item);
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(item, (String)TreePatternUtils.escape(text2)).withLookupString(text2).withPresentableText(text2).withIcon(this.getIcon(item)).withTailText(this.getTailText(item), true);
            if (lookupElementBuilder == null) {
                MyCompletion.$$$reportNull$$$0(8);
            }
            return lookupElementBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyCompletion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyCompletion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 8 -> new IllegalStateException(string);
            };
        }
    }
}

