/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.ui.HardViewport;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceGeneralPanel {
    private final DataSourceConfigurable myConfigurable;
    private final JBScrollPane myRoot;
    private String myGeneratedName;
    private final DynamicJdbcUrlEditor myUrlPanel;
    private final DbOptionsEditor<LocalDataSource> myOptionsEditor;

    DataSourceGeneralPanel(@NotNull DataSourceConfigurable configurable) {
        if (configurable == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(0);
        }
        this.myGeneratedName = "";
        this.myConfigurable = configurable;
        this.myRoot = new HardViewport.ScrollPane();
        JPanel propsPanel = new JPanel(new BorderLayout());
        this.myRoot.setViewportView((Component)propsPanel);
        this.myRoot.setHorizontalScrollBarPolicy(31);
        this.myUrlPanel = new DynamicJdbcUrlEditor(configurable, () -> {
            this.generateName();
            configurable.fireChanged();
        });
        propsPanel.add((Component)this.myUrlPanel.getComponent(), "North");
        this.myUrlPanel.getComponent().setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.myOptionsEditor = new DbOptionsEditor<LocalDataSource>((LocalDataSource)this.myConfigurable.getTarget(), p2 -> p2.getLocation() == DbOptionProvider.UiLocation.GENERAL, null, configurable.getDataContext(), 6);
        propsPanel.add((Component)this.myOptionsEditor.getComponent(), "South");
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        this.generateName();
    }

    private void generateName() {
        String generatedName = this.myUrlPanel.generateNameFromParameters();
        if (!Objects.equals(generatedName, this.myGeneratedName) && Objects.equals(this.myConfigurable.createUniqueName(this.myGeneratedName), this.myConfigurable.getNameValue()) || StringUtil.isEmptyOrSpaces((String)this.myConfigurable.getNameValue())) {
            this.myConfigurable.setGeneratedName(this.myConfigurable.createUniqueName(generatedName));
        }
        this.myGeneratedName = generatedName;
    }

    @NotNull
    public JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRoot;
        if (jBScrollPane == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(1);
        }
        return jBScrollPane;
    }

    public void onActivity() {
        this.myUrlPanel.onActivity();
    }

    public void saveSettings(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(2);
        }
        this.myUrlPanel.saveSettings(dataSource2, copyCredentials, actual);
        this.myOptionsEditor.apply(dataSource2);
    }

    public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
        if (dataSource2 == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(3);
        }
        this.myUrlPanel.reset(dataSource2, resetCredentials);
        this.myOptionsEditor.reset(dataSource2);
    }

    public void requestUrlFocus() {
        this.myUrlPanel.requestUrlFocus();
    }

    @NotNull
    public String generateNameFromParameters() {
        String string = this.myConfigurable.createUniqueName(this.myUrlPanel.generateNameFromParameters());
        if (string == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setDriver(@Nullable DatabaseDriver driver2) {
        this.myUrlPanel.setDriver(driver2, this.myUrlPanel.getUrl(), this.myUrlPanel.isUrlOnly());
    }

    public boolean isPasswordChanged() {
        DatabaseAuthProvider.AuthWidget widget = this.myUrlPanel.getAuthPanel().getAuthWidget();
        return widget != null && widget.isPasswordChanged();
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myUrlPanel.getActualDriver();
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myUrlPanel.getDriver();
    }

    @NotNull
    public UrlEditorModel getUrlEditorModel() {
        UrlEditorModel urlEditorModel = this.myUrlPanel.getEditorModel();
        if (urlEditorModel == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(5);
        }
        return urlEditorModel;
    }

    public void updateDriverLink() {
        this.myUrlPanel.updateDriverLink();
    }

    public void onApply() {
        this.myUrlPanel.reset((LocalDataSource)this.myConfigurable.getDataSource(), true);
    }

    public void hidePassword() {
        DatabaseAuthProvider.AuthWidget widget = this.myUrlPanel.getAuthPanel().getAuthWidget();
        if (widget != null) {
            widget.hidePassword();
        }
    }

    public void reloadCredentials() {
        DatabaseAuthProvider.AuthWidget widget = this.myUrlPanel.getAuthPanel().getAuthWidget();
        if (widget != null) {
            widget.reloadCredentials();
        }
    }

    @NotNull
    public DynamicJdbcUrlEditor getUrlEditor() {
        DynamicJdbcUrlEditor dynamicJdbcUrlEditor = this.myUrlPanel;
        if (dynamicJdbcUrlEditor == null) {
            DataSourceGeneralPanel.$$$reportNull$$$0(6);
        }
        return dynamicJdbcUrlEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNameFromParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditorModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class MyUserActivityWrapper
    extends TransactionAction.PreferencesUserActivityWrapper
    implements DescriptionPopup.TxPopup.TxIsolationSelector {
        private final DescriptionPopup.TxPopup.TxIsolationSelector mySelector;

        MyUserActivityWrapper(@NotNull JComponent component2, @NotNull DescriptionPopup.TxPopup.TxIsolationSelector selector) {
            if (component2 == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(1);
            }
            super(component2);
            this.mySelector = selector;
        }

        @Override
        @NotNull
        protected DescriptionPopup.TxPopup.TxSelector getSelector() {
            DescriptionPopup.TxPopup.TxIsolationSelector txIsolationSelector = this.mySelector;
            if (txIsolationSelector == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(2);
            }
            return txIsolationSelector;
        }

        @Override
        public boolean isSelected(@NotNull TxIsolation isolation) {
            if (isolation == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(3);
            }
            return this.mySelector.isSelected(isolation);
        }

        @Override
        public void select(@NotNull TxIsolation isolation, AnActionEvent e2) {
            if (isolation == null) {
                MyUserActivityWrapper.$$$reportNull$$$0(4);
            }
            this.mySelector.select(isolation, e2);
            this.fireUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyUserActivityWrapper";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyUserActivityWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static class DataSourceTxModeAction
    extends TransactionAction.PreferencesTxModeAction {
        private final MyTxIsolationSelector mySelector;
        private final List<TxIsolation> availableLevels;

        DataSourceTxModeAction(MyTxIsolationSelector selector, @NotNull Dbms id) {
            if (id == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
            this.availableLevels = DataSourceTxModeAction.getAvailableLevels(id);
        }

        @Override
        @NotNull
        public MyTxIsolationSelector getSelector() {
            MyTxIsolationSelector myTxIsolationSelector = this.mySelector;
            if (myTxIsolationSelector == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(1);
            }
            return myTxIsolationSelector;
        }

        @Override
        @NotNull
        protected TransactionAction.PreferencesUserActivityWrapper createActivityWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(2);
            }
            return new MyUserActivityWrapper(component2, this.mySelector);
        }

        @Override
        @Nullable
        protected DescriptionPopup.TxSettingsPopup createPopup(@NotNull TransactionAction.PreferencesUserActivityWrapper activityWrapper) {
            MyUserActivityWrapper myUserActivityWrapper;
            if (activityWrapper == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(3);
            }
            if ((myUserActivityWrapper = (MyUserActivityWrapper)ObjectUtils.tryCast((Object)activityWrapper, MyUserActivityWrapper.class)) == null) {
                return null;
            }
            return new DescriptionPopup.TxSettingsPopup(this.availableLevels, myUserActivityWrapper);
        }

        @NotNull
        private static List<TxIsolation> getAvailableLevels(@NotNull Dbms id) {
            if (id == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(4);
            }
            List list = TxIsolation.levelsSupported(id) ? ContainerUtil.filter((Object[])TxIsolation.values(), isolation -> isolation.isSupported(id, null)) : ContainerUtil.emptyList();
            if (list == null) {
                DataSourceTxModeAction.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$DataSourceTxModeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$DataSourceTxModeAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelector";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createActivityWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopup";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAvailableLevels";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 5 -> new IllegalStateException(string);
            };
        }
    }

    static class MyTxIsolationSelector
    extends DescriptionPopup.TxPopup.TxSelectorImpl
    implements DescriptionPopup.TxPopup.TxIsolationSelector {
        private TxIsolation myIsolation = TxIsolation.DEFAULT;

        MyTxIsolationSelector() {
        }

        @Override
        public boolean isSelected(@NotNull TxIsolation isolation) {
            if (isolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(0);
            }
            return this.myIsolation == isolation;
        }

        @Override
        public void select(@NotNull TxIsolation isolation, AnActionEvent e2) {
            if (isolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(1);
            }
            this.myIsolation = isolation;
        }

        @NotNull
        public TxIsolation getIsolation() {
            TxIsolation txIsolation = this.myIsolation;
            if (txIsolation == null) {
                MyTxIsolationSelector.$$$reportNull$$$0(2);
            }
            return txIsolation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyTxIsolationSelector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceGeneralPanel$MyTxIsolationSelector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIsolation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "select";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

