/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001a\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u001a\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0000\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a(\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\r0\u001aj\b\u0012\u0004\u0012\u00020\r`\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001aF\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\r\u0018\u00010\u001aj\n\u0012\u0004\u0012\u00020\r\u0018\u0001`\u001b2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"DATA_SOURCE_RAW_SETTINGS_BEGIN", "", "DATA_SOURCE_RAW_SETTINGS_BEGIN2", "DATA_SOURCE_RAW_SETTINGS_END", "DATA_SOURCE_RAW_SETTINGS_END2", "DATA_SOURCE_SETTINGS_BEGIN", "DATA_SOURCE_SETTINGS_END", "DATA_SOURCE_SETTINGS_HEADER", "addSuffixIfNeeded", "originalName", "project", "Lcom/intellij/openapi/project/Project;", "createDataSourceFromSettings", "Lcom/intellij/database/dataSource/LocalDataSource;", "buffer", "exportDataSourcesSettings", "dss", "", "exportSettings", "", "ds", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDataSourceNames", "importDataSourceFromText", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "text", "importDataSourcesBy", "prefix", "suffix", "include", "", "isDataSourceSettings", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceExportImportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceExportImportHelper.kt\ncom/intellij/database/dataSource/DataSourceExportImportHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1549#2:87\n1620#2,3:88\n*S KotlinDebug\n*F\n+ 1 DataSourceExportImportHelper.kt\ncom/intellij/database/dataSource/DataSourceExportImportHelperKt\n*L\n85#1:87\n85#1:88,3\n*E\n"})
public final class DataSourceExportImportHelperKt {
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_HEADER = "#DataSourceSettings#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_BEGIN = "#BEGIN#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_END = "#END#";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_BEGIN = "<data-source source=\"LOCAL\" ";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_END = "</data-source>";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_BEGIN2 = "<dataSource ";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_END2 = "</dataSource>";

    @Nullable
    public static final String exportDataSourcesSettings(@NotNull Collection<? extends LocalDataSource> dss2) {
        Intrinsics.checkNotNullParameter(dss2, (String)"dss");
        StringBuilder b2 = new StringBuilder(1024);
        b2.append(DATA_SOURCE_SETTINGS_HEADER).append('\n');
        for (LocalDataSource localDataSource : dss2) {
            DataSourceExportImportHelperKt.exportSettings(localDataSource, b2);
        }
        if (((CharSequence)b2).length() == 0) {
            return null;
        }
        return b2.toString();
    }

    public static final void exportSettings(@NotNull LocalDataSource ds, @NotNull StringBuilder b2) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        b2.append("#LocalDataSource: ").append(ds.getName()).append('\n');
        StringBuffer text2 = LocalDataSourceSerialization.INSTANCE.serializedSettings(null, ds);
        b2.append(DATA_SOURCE_SETTINGS_BEGIN).append('\n');
        b2.append(text2);
        if (b2.charAt(b2.length() - 1) != '\n') {
            b2.append('\n');
        }
        b2.append(DATA_SOURCE_SETTINGS_END).append('\n').append('\n');
    }

    public static final boolean isDataSourceSettings(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_SETTINGS_HEADER, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN2, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final ArrayList<LocalDataSource> importDataSourceFromText(@NotNull String text2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        ArrayList arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_SETTINGS_BEGIN, DATA_SOURCE_SETTINGS_END, false, text2, project);
        if (arrayList == null && (arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_RAW_SETTINGS_BEGIN, DATA_SOURCE_RAW_SETTINGS_END, true, text2, project)) == null && (arrayList = DataSourceExportImportHelperKt.importDataSourcesBy(DATA_SOURCE_RAW_SETTINGS_BEGIN2, DATA_SOURCE_RAW_SETTINGS_END2, true, text2, project)) == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private static final ArrayList<LocalDataSource> importDataSourcesBy(String prefix, String suffix2, boolean include, String text2, Project project) {
        int q1;
        int p2;
        int p1 = StringsKt.indexOf$default((CharSequence)text2, (String)prefix, (int)0, (boolean)false, (int)6, null);
        if (p1 == -1) {
            return null;
        }
        ArrayList<LocalDataSource> dataSources2 = new ArrayList<LocalDataSource>();
        while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)suffix2, (int)(q1 = p1 + (include ? 0 : prefix.length())), (boolean)false, (int)4, null)) >= 0) {
            int q2 = p2 + (include ? suffix2.length() : 0);
            Collection collection2 = dataSources2;
            String string = text2.substring(q1, q2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection2.add(DataSourceExportImportHelperKt.createDataSourceFromSettings(string, project));
            p1 = StringsKt.indexOf$default((CharSequence)text2, (String)prefix, (int)(p2 + suffix2.length()), (boolean)false, (int)4, null);
        }
        return dataSources2;
    }

    private static final LocalDataSource createDataSourceFromSettings(String buffer, Project project) {
        LocalDataSource localDataSource;
        LocalDataSource $this$createDataSourceFromSettings_u24lambda_u240 = localDataSource = LocalDataSourceSerialization.INSTANCE.createDataSourceFromSettings(project, buffer, false);
        boolean bl = false;
        $this$createDataSourceFromSettings_u24lambda_u240.resolveDriver();
        if ($this$createDataSourceFromSettings_u24lambda_u240.getDatabaseDriver() == null) {
            $this$createDataSourceFromSettings_u24lambda_u240.ensureDriverConfigured();
        }
        $this$createDataSourceFromSettings_u24lambda_u240.setGlobal(project == null);
        String string = $this$createDataSourceFromSettings_u24lambda_u240.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        $this$createDataSourceFromSettings_u24lambda_u240.setName(DataSourceExportImportHelperKt.addSuffixIfNeeded(string, project));
        return localDataSource;
    }

    private static final String addSuffixIfNeeded(String originalName, Project project) {
        Collection<String> existentNames = DataSourceExportImportHelperKt.getDataSourceNames(project);
        Object name2 = originalName;
        int k = 1;
        while (existentNames.contains(name2)) {
            name2 = originalName + " [" + ++k + "]";
        }
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> getDataSourceNames(Project project) {
        void $this$mapTo$iv$iv;
        List<LocalDataSource> list = DataSourceStorage.getStorage(project).getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it2.getName());
        }
        return (List)destination$iv$iv;
    }
}

