/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingLink;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DataSourceConfigurable
extends AbstractDataSourceConfigurable<LocalDataSourceManager, LocalDataSource>
implements DataSourceFacade {
    private static final Key<Boolean> RESET_CONNECTION_YES_FOR_ALL_KEY = Key.create((String)"RESET_CONNECTION_YES_FOR_ALL_KEY");
    public static final Key<Function<LocalDataSource, Collection<DatabaseDriver>>> DRIVER_VARIANTS_PROVIDER = Key.create((String)"DRIVER_VARIANTS_PROVIDER");
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private JBTabbedPane myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private long myLastSaveStamp;
    private Couple<DataSourceInfo> myConnectionInfo;
    private final DataSourceTestConnectionManager myTestConnectionManager = new DataSourceTestConnectionManager(this);
    private DataSourceTestConnectionComponent myTestConnectionComponent;
    private DatabaseNameComponent myNameComponent;
    private DdlMappingLink myMappingLink;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceSchemasPanel mySchemasPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private DbOptionsEditor.DbOptionsEditors<LocalDataSource> myCustomTabs;
    private boolean myGlobal;

    public DataSourceConfigurable(LocalDataSourceManager manager, LocalDataSource dataSource2, Project project) {
        super(manager, dataSource2, project);
        this.myTempDataSource = dataSource2.copy(true);
    }

    public void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceConfigurable.$$$reportNull$$$0(0);
        }
        this.updateDatabaseInfo(source.getInfo());
    }

    public void updateDatabaseInfo(@NotNull DataSourceInfo info2) {
        if (info2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(1);
        }
        this.myConnectionInfo = Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)info2);
    }

    public DataSourceInfo getDatabaseInfo() {
        DataSourceInfo main = ((LocalDataSource)this.myDataSource).getInfo();
        return Objects.equals(Pair.getFirst(this.myConnectionInfo), main) ? (DataSourceInfo)this.myConnectionInfo.second : main;
    }

    public void onTestConnectionUpdate(@NotNull DataSourceTestConnectionManager.TestInfo info2) {
        if (info2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(2);
        }
        if (info2.getSessionTemplateId() == null) {
            this.myTestConnectionComponent.update(info2);
        } else {
            this.myOptionsPanel.getSessionTemplates().update(info2);
        }
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        long curStamp = this.getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveData(this.myTempDataSource, false, true);
        } else {
            this.myTempDataSource.getInfo().copyFrom(this.getDatabaseInfo());
        }
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(ds, true, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @TestOnly
    @Nullable
    public AsyncTask<?> testConnection(boolean checkConfiguration) {
        return this.myTestConnectionManager.testConnection(null, checkConfiguration);
    }

    @NotNull
    public DynamicJdbcUrlEditor getUrlEditor() {
        DynamicJdbcUrlEditor dynamicJdbcUrlEditor = this.myGeneralPanel.getUrlEditor();
        if (dynamicJdbcUrlEditor == null) {
            DataSourceConfigurable.$$$reportNull$$$0(5);
        }
        return dynamicJdbcUrlEditor;
    }

    public DataSourceSshSslPanel getSshSslPanel() {
        return this.mySshSslPanel;
    }

    public void hidePasswords() {
        this.myGeneralPanel.hidePassword();
        this.mySshSslPanel.hidePassword();
        this.myOptionsPanel.hidePassword();
    }

    public void reloadCredentials() {
        this.myGeneralPanel.reloadCredentials();
        this.mySshSslPanel.reloadCredentials();
        this.myOptionsPanel.reloadCredentials();
        this.myController.clearModifiedCache();
    }

    private JComponent createCenterPanel() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myMappingLink = new DdlMappingLink(this.getController()){

            @Override
            protected void setUp(DdlMapping mapping) {
                mapping.setName(DataSourceConfigurable.this.getController().generateObjectName(mapping, DataSourceConfigurable.this.getNameValue() + " Mapping"));
                mapping.setDataSourceId(((LocalDataSource)DataSourceConfigurable.this.getDataSource()).getUniqueId());
            }

            @Override
            protected JBIterable<DdlMapping> getMappings() {
                String id = ((LocalDataSource)DataSourceConfigurable.this.getTarget()).getUniqueId();
                return DataSourceConfigurable.this.getController().getMappings().map(DataSourceConfigurable.this.getController()::getTempTargetOrTarget).filter(m -> id.equals(m.getDataSourceId()));
            }
        };
        this.myNameComponent.getComponent().add((Component)((Object)this.myMappingLink), DatabaseUIUtils.createSimpleConstraints(0, 3, 2));
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.mySchemasPanel = new DataSourceSchemasPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), this, this.myController);
        this.mySshSslPanel = new DataSourceSshSslPanel(this.myProject, (LocalDataSource)this.myDataSource, this);
        this.myTestConnectionComponent = new DataSourceTestConnectionComponent(this);
        this.myCustomTabs = new DbOptionsEditor.DbOptionsEditors<LocalDataSource>(LocalDataSource.class, p2 -> p2.getLocation() == DbOptionProvider.UiLocation.NEW_TAB, null);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabComponentInsets(null);
        this.myPanel.add((Component)this.myTabbedPane, "Center");
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.general", new Object[0]), (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.options", new Object[0]), (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.ssh.ssl", new Object[0]), (Component)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.schemas", new Object[0]), (Component)this.mySchemasPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.advanced", new Object[0]), (Component)this.myAdvancedPanel.getComponent());
        this.updateMappingLink();
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myPanel;
    }

    private void updateMappingLink() {
        this.myMappingLink.updateText();
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    @Override
    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false, true);
        this.myTestConnectionManager.resetStatus();
        this.myGeneralPanel.onActivity();
        this.validateDeps();
        this.validateCustomTabs(this.myTempDataSource);
    }

    private void validateCustomTabs(LocalDataSource dataSource2) {
        Component comp;
        HashMap<DbOptionsEditor.DbOptionsEditors.OptionEditor, Component> active = new HashMap<DbOptionsEditor.DbOptionsEditors.OptionEditor, Component>();
        int count = this.myTabbedPane.getTabCount();
        for (int i2 = 0; i2 < count; ++i2) {
            comp = this.myTabbedPane.getComponentAt(i2);
            DbOptionsEditor.DbOptionsEditors.OptionEditor editor2 = (DbOptionsEditor.DbOptionsEditors.OptionEditor)UIUtil.getClientProperty((Component)comp, DbOptionsEditor.DbOptionsEditors.OptionEditor.class);
            if (editor2 == null) continue;
            active.put(editor2, comp);
        }
        List<DbOptionsEditor.DbOptionsEditors.OptionEditor<LocalDataSource, ?>> toActivate = this.myCustomTabs.getFiltered(dataSource2);
        if (toActivate.size() == active.size() && active.keySet().containsAll(toActivate)) {
            return;
        }
        for (int i3 = this.myTabbedPane.getTabCount() - 1; i3 >= 0; --i3) {
            comp = this.myTabbedPane.getComponentAt(i3);
            if (UIUtil.getClientProperty((Component)comp, DbOptionsEditor.DbOptionsEditors.OptionEditor.class) == null) continue;
            this.myTabbedPane.removeTabAt(i3);
        }
        for (DbOptionsEditor.DbOptionsEditors.OptionEditor<LocalDataSource, ?> editor3 : toActivate) {
            Component component2 = (Component)active.get(editor3);
            if (component2 == null) {
                component2 = editor3.createComponent(dataSource2, this.getDataContext());
                ((JComponent)component2).putClientProperty(DbOptionsEditor.DbOptionsEditors.OptionEditor.class, editor3);
            }
            this.myTabbedPane.addTab(editor3.provider.getDisplayName(), null, component2, editor3.provider.getDescription());
        }
    }

    @Override
    protected void validateDeps() {
        this.mySshSslPanel.getSshPanel().updateInfoLabel();
        this.myGeneralPanel.updateDriverLink();
        this.updateMappingLink();
    }

    public DataSourceTestConnectionManager getTestConnectionManager() {
        return this.myTestConnectionManager;
    }

    public static void initTabbedPane(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(7);
        }
        UIUtil.uiChildren((Component)tabbedPane).consumeEach(UIUtil::removeScrollBorder);
        tabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(tabbedPane, controller));
        tabbedPane.addChangeListener(e2 -> {
            int index2 = tabbedPane.getSelectedIndex();
            controller.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, Pair.create((Object)(index2 < 0 ? null : tabbedPane.getTitleAt(index2)), (Object)index2));
        });
    }

    public static int getDefaultTabIndex(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        Pair p2;
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(8);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(9);
        }
        if ((p2 = (Pair)controller.getUserData(DatabaseConfigEditor.SELECTED_TAB_KEY)) == null) {
            return 0;
        }
        if ((Integer)p2.second < tabbedPane.getTabCount() && (Integer)p2.second >= 0 && Objects.equals(p2.first, tabbedPane.getTitleAt(((Integer)p2.second).intValue()))) {
            return (Integer)p2.second;
        }
        String title = (String)p2.first;
        int idx = DataSourceConfigurable.findTabIndex(tabbedPane, title);
        return idx == -1 ? 0 : idx;
    }

    public static int findTabIndex(@NotNull JBTabbedPane tabbedPane, String title) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(10);
        }
        for (int i2 = tabbedPane.getTabCount() - 1; i2 > 0; --i2) {
            if (!Objects.equals(title, tabbedPane.getTitleAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static int findTabIndex(@NotNull JBTabbedPane tabbedPane, JComponent component2) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(11);
        }
        for (int i2 = tabbedPane.getTabCount() - 1; i2 > 0; --i2) {
            if (!Objects.equals(component2, tabbedPane.getComponentAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    @NlsSafe
    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name2) {
        if (name2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(12);
        }
        this.myNameComponent.setGeneratedName(name2);
    }

    @Override
    public void saveData(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(13);
        }
        dataSource2.getInfo().copyFrom(this.getDatabaseInfo());
        this.saveGeneralSettings(dataSource2, copyCredentials, actual);
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource2);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveDataSource(dataSource2);
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource2, copyCredentials);
        }
        if (this.myCustomTabs != null) {
            this.myCustomTabs.apply(dataSource2);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(14);
        }
        dataSource2.setGlobal(this.myGlobal);
        this.myNameComponent.save(dataSource2);
        this.myGeneralPanel.saveSettings(dataSource2, copyCredentials, actual);
        this.mySchemasPanel.saveSettings(dataSource2);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    private static String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "data.sources.and.drivers.dialog";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(tempDataSource, true, true);
        String error2 = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseBundle.message("error.text.database.driver.not.configured", new Object[0]) : null;
        if (error2 != null && (ret = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DatabaseBundle.message("message.title.invalid.datasource", new Object[0]), (String)DatabaseBundle.message("confirmation.text.error.occurred.save.datasource", error2)).icon(Messages.getErrorIcon())).show()) != 0) {
            return;
        }
        boolean newDataSource = this.isNewDataSource();
        boolean isGlobalChanged = !newDataSource && tempDataSource.isGlobal() != ((LocalDataSource)this.myDataSource).isGlobal();
        boolean isUrlChanged = !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl());
        DataSourceSshTunnelConfiguration prevSshConfiguration = ((LocalDataSource)this.myDataSource).getSshConfiguration();
        boolean areCredentialsChanged = !this.equalCredentials(tempDataSource, (LocalDataSource)this.myDataSource, this.isPasswordChanged());
        boolean isAuthChanged = areCredentialsChanged || !DataSourceSshTunnelConfiguration.equal(tempDataSource.getSshConfiguration(), prevSshConfiguration) || !DataSourceSslConfiguration.equal(tempDataSource.getSslCfg(), ((LocalDataSource)this.myDataSource).getSslCfg());
        boolean resetConnections = isAuthChanged || tempDataSource.isSingleConnection() != ((LocalDataSource)this.myDataSource).isSingleConnection() || !Objects.equals(tempDataSource.getDriverClass(), ((LocalDataSource)this.myDataSource).getDriverClass()) || !tempDataSource.getClasspathElements().equals(((LocalDataSource)this.myDataSource).getClasspathElements()) || !tempDataSource.getConnectionProperties().equals(((LocalDataSource)this.myDataSource).getConnectionProperties()) || !Objects.equals(tempDataSource.getVmOptions(), ((LocalDataSource)this.myDataSource).getVmOptions()) || !tempDataSource.getVmEnv().equals(((LocalDataSource)this.myDataSource).getVmEnv()) || !LocalDataSource.getAdditionalPropertiesMap(tempDataSource).equals(LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)this.myDataSource));
        boolean isSchemaChanged = newDataSource || isAuthChanged || isUrlChanged || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getObjectPattern(), (String)((LocalDataSource)this.myDataSource).getObjectPattern()) || DbOptionProvider.getProviders((LocalDataSource)this.myDataSource).filter(DbOptionProvider::isAffectsIntrospection).find(p2 -> !Comparing.equal(p2.getValue(this.myTempDataSource), p2.getValue((LocalDataSource)this.myDataSource))) != null;
        this.enablePillsIfNeeded((LocalDataSource)this.myDataSource, this.myTempDataSource);
        this.saveData((LocalDataSource)this.myDataSource, true, false);
        this.applyCredentials(tempDataSource);
        this.myGeneralPanel.onApply();
        this.mySshSslPanel.onApply();
        this.myNameComponent.apply((AbstractDataSource)this.myDataSource);
        this.updateDatabaseInfo(tempDataSource);
        if (isGlobalChanged) {
            this.myController.onChangesApplied(indicator -> {
                try {
                    indicator.setText(DatabaseBundle.message("progress.text.moving.storage", ((LocalDataSource)this.myDataSource).getName()));
                    if (((LocalDataSource)this.myDataSource).isGlobal()) {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, this.getProject(), null);
                    } else {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, null, this.getProject());
                    }
                    if (((LocalDataSource)this.myDataSource).isGlobal()) {
                        DatabaseColorManager.changeDsScopeToGlobal(this.getProject(), (LocalDataSource)this.myDataSource);
                    } else {
                        DatabaseColorManager.changeDsScopeToProject(this.getProject(), (LocalDataSource)this.myDataSource);
                    }
                }
                catch (IOException e2) {
                    DbUIUtil.createNotification(this.myDataSource, DatabaseBundle.message("notification.content.failed.to.move.storage", e2.getMessage()), NotificationType.ERROR, "DataSourceConfigurable.storage.move.failed").notify(this.myProject);
                }
            });
        }
        JdbcDriverManager manager = JdbcDriverManager.getDriverManager(this.myProject);
        if (resetConnections && !manager.getActiveConfigurations((LocalDataSource)this.myDataSource).isEmpty()) {
            boolean yesForAll;
            int answer = Boolean.TRUE.equals(this.myController.getUserData(RESET_CONNECTION_YES_FOR_ALL_KEY)) ? 0 : Messages.showYesNoCancelDialog((Component)this.myPanel, (String)DatabaseBundle.message("DataSourceConfigurable.apply.reconnect", ((LocalDataSource)this.myDataSource).getName()), (String)DatabaseBundle.message("DataSourceConfigurable.apply.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (String)CommonBundle.getYesForAllButtonText(), (Icon)Messages.getQuestionIcon());
            boolean bl = yesForAll = answer == 2;
            if (yesForAll) {
                this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, true);
            }
            if (answer == 0 || yesForAll) {
                this.myController.onChangesApplied(indicator -> {
                    this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, null);
                    SessionsUtil.deactivateDataSourceAsync(this.myProject, (LocalDataSource)this.myDataSource, null);
                });
            }
        }
        if (isSchemaChanged) {
            this.myController.onChangesApplied(indicator -> DataSourceUtil.performAutoSyncTask(LoaderContext.selectGeneralTask(this.myProject, (LocalDataSource)this.myDataSource), true));
        }
        if (newDataSource) {
            if (((LocalDataSourceManager)this.myManager).getDataSources().isEmpty() && SqlPsiFacade.getInstance((Project)this.getProject()).getConfiguredDefaultDialect() == null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LocalDataSource ds = (LocalDataSource)ContainerUtil.find(((LocalDataSourceManager)this.myManager).getDataSources(), o2 -> !SqlDialects.isGenericDialect(DbSqlUtilCore.getSqlDialect(o2)));
                    SqlPsiFacade psiFacade2 = SqlPsiFacade.getInstance((Project)this.getProject());
                    if (ds != null && psiFacade2.getConfiguredDefaultDialect() == null) {
                        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(ds);
                        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.title.default.sql.dialect", new Object[0]), DatabaseBundle.message("notification.content.you.can.set.as.default.sql.dialect", dialect.getDisplayName()), NotificationType.INFORMATION).setListener((notification, event) -> {
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                if ("set".equals(event.getDescription())) {
                                    psiFacade2.setDialectMapping(null, dialect);
                                } else if ("configure".equals(event.getDescription())) {
                                    psiFacade2.openDialectsConfigurable(Collections.emptyList());
                                }
                            }
                        }).setDisplayId("DataSourceConfigurable.set.default.dialect").notify(this.getProject());
                    }
                }, ModalityState.nonModal());
            }
            ((LocalDataSourceManager)this.myManager).addDataSource((LocalDataSource)this.myDataSource);
        } else {
            ((LocalDataSourceManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
    }

    private void enablePillsIfNeeded(LocalDataSource prev, LocalDataSource cur) {
        byte oldLevelValue;
        byte newLevelValue;
        Level newLevel;
        Level oldLevel = prev.getIntrospectionLevel();
        if (oldLevel == (newLevel = cur.getIntrospectionLevel())) {
            return;
        }
        if (newLevel != null && (newLevelValue = newLevel.level) < (oldLevelValue = oldLevel != null ? (byte)oldLevel.level : (byte)3)) {
            this.myController.onChangesApplied(indicator -> {
                DatabaseViewOptions viewOptions = (DatabaseViewOptions)this.getProject().getServiceIfCreated(DatabaseViewOptions.class);
                if (viewOptions != null) {
                    viewOptions.enableBluePillsIfWasNot();
                }
            });
        }
    }

    private void applyCredentials(LocalDataSource tempDataSource) {
        DatabaseCredentials dc = DatabaseCredentials.getInstance();
        DatabaseCredentials local = this.myController.getSecretService();
        DatabaseAuthProvider authProvider = DatabaseAuthProvider.get(tempDataSource);
        Object credentials = authProvider.loadAuthConfig(tempDataSource, local, true);
        authProvider.saveAuthConfig((DatabaseConnectionConfig)((Object)this.myDataSource), dc, credentials, true);
        dc.setSslPassphrase(this.myDataSource, local.getSslPassphrase(tempDataSource));
    }

    public void resetFromTemp() {
        this.bulkUpdate(() -> {
            this.myGeneralPanel.reset(this.myTempDataSource, false);
            this.mySchemasPanel.reset(this.myTempDataSource);
        });
    }

    @Override
    public void init(@NotNull Runnable watcher) {
        if (watcher == null) {
            DataSourceConfigurable.$$$reportNull$$$0(15);
        }
        this.registerWatcher(watcher);
        this.bulkUpdate(() -> this.reset((LocalDataSource)this.getTarget(), false));
        this.myTracker.incModificationCount();
    }

    @Override
    protected JComponent getComponent() {
        return this.myPanel;
    }

    @Override
    protected void reset(@NotNull LocalDataSource o2) {
        if (o2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(16);
        }
        this.reset(o2, true);
    }

    @Override
    public JComponent getCommonBar() {
        return this.myTestConnectionComponent.getComponent();
    }

    public void reset(@NotNull LocalDataSource o2, boolean resetCredentials) {
        if (o2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(17);
        }
        this.myConnectionInfo = o2.getInfo().equals(((LocalDataSource)this.myDataSource).getInfo()) ? null : Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)o2.getInfo());
        this.setGlobal(o2.isGlobal());
        this.myGeneralPanel.reset(o2, resetCredentials);
        this.myAdvancedPanel.resetDataSource(o2);
        this.myNameComponent.reset(o2, (Computable<String>)((Computable)() -> this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset(o2, resetCredentials);
        this.myOptionsPanel.reset(o2);
        this.mySchemasPanel.reset(o2);
        this.myCustomTabs.reset(o2);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (!tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource)) {
            return true;
        }
        if (this.isPasswordChanged()) {
            return true;
        }
        return this.myNameComponent.isModified();
    }

    private boolean isPasswordChanged() {
        return this.myGeneralPanel.isPasswordChanged() || this.mySshSslPanel.isSslPassphraseChanged();
    }

    private boolean equalCredentials(LocalDataSource d1, LocalDataSource d2, boolean loadCredentials) {
        if (!loadCredentials) {
            return this.equalCredentialsImpl(d1, d2, false);
        }
        return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.equalCredentialsImpl(d1, d2, true), DatabaseBundle.message("dialog.title.checking.configuration", new Object[0]), true, this.myProject);
    }

    private boolean equalCredentialsImpl(LocalDataSource d1, LocalDataSource d2, boolean loadCredentials) {
        DatabaseAuthProvider p2;
        DatabaseAuthProvider p1 = DatabaseAuthProvider.get(d1);
        if (p1 != (p2 = DatabaseAuthProvider.get(d2))) {
            return false;
        }
        boolean loadPass = this.myGeneralPanel.isPasswordChanged();
        return Objects.equals(p1.loadAuthConfig(d1, loadPass ? this.getSecretService() : null, !loadCredentials), p1.loadAuthConfig(d2, loadPass ? DatabaseCredentials.getInstance() : null, !loadCredentials));
    }

    @Override
    public void showErrorNotification(@Nls String message2, @NotNull Object id) {
        if (id == null) {
            DataSourceConfigurable.$$$reportNull$$$0(18);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myController.showErrorNotification(this, id, message2 == null ? null : DatabaseBundle.message("notification.title.DatabaseConfigEditor.error", new Object[0]), message2, new Object[0]));
    }

    public void setDriver(@Nullable DatabaseDriver driver2) {
        DatabaseDriver prevActualDriver = this.myGeneralPanel.getActualDriver();
        this.myGeneralPanel.setDriver(driver2);
        DatabaseDriver newActualDriver = this.myGeneralPanel.getActualDriver();
        if (prevActualDriver != newActualDriver) {
            this.myAdvancedPanel.migrateDriver(prevActualDriver, newActualDriver);
        }
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
        this.fireChanged();
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void actualizeDriver() {
        this.setDriver(this.getDriver());
    }

    @Nullable
    DatabaseDriver getDriver() {
        return this.myGeneralPanel.getDriver();
    }

    @Override
    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfulParser();
    }

    @Override
    public CoroutineScope getCoroutineScope() {
        return this.myController.getCoroutineScope();
    }

    @NotNull
    public ParametersHolder getActualParameter() {
        UrlEditorModel urlEditorModel = this.myGeneralPanel.getUrlEditorModel();
        if (urlEditorModel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(19);
        }
        return urlEditorModel;
    }

    public void setIntrospectionLevel(@NotNull Level level) {
        if (level == null) {
            DataSourceConfigurable.$$$reportNull$$$0(20);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setIntrospectionLevel(level);
        }
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceConfigurable.$$$reportNull$$$0(21);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setSourceLoading(mode);
        }
    }

    @TestOnly
    @Nullable
    public DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.myGeneralPanel.getUrlEditor().getAuthPanel().getAuthWidget();
    }

    public String getUrl() {
        return this.myGeneralPanel.getUrlEditor().getUrl();
    }

    @TestOnly
    public void setUrl(String url) {
        this.myGeneralPanel.getUrlEditor().setUrl(url, false);
    }

    public void setExtraProperty(String name2, String value2) {
        this.myGeneralPanel.getUrlEditor().setExtraProperty(name2, value2);
    }

    @NotNull
    public JComponent selectAdvancedPanel() {
        int index2 = DataSourceConfigurable.findTabIndex(this.myTabbedPane, DatabaseBundle.message("DataSourceConfigurable.tab.advanced", new Object[0]));
        if (index2 != -1) {
            this.myTabbedPane.setSelectedIndex(index2);
        }
        JPanel jPanel = this.myAdvancedPanel.getComponent();
        if (jPanel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    public JComponent selectSslPanel() {
        int index2 = DataSourceConfigurable.findTabIndex(this.myTabbedPane, DatabaseBundle.message("DataSourceConfigurable.tab.ssh.ssl", new Object[0]));
        if (index2 != -1) {
            this.myTabbedPane.setSelectedIndex(index2);
        }
        return this.mySshSslPanel.getComponent();
    }

    @NotNull
    public DefaultActionGroup getMoreOptionsAction() {
        DefaultActionGroup actions = new DefaultActionGroup();
        this.myGeneralPanel.getUrlEditor().addMoreActions(actions);
        actions.addSeparator();
        this.mySshSslPanel.addSshSslMoreActions(actions);
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            DataSourceConfigurable.$$$reportNull$$$0(23);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 19, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSourceForConnection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "selectAdvancedPanel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreOptionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestConnectionUpdate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTabbedPane";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTabIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTabIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveGeneralSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevel";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 19, 22, 23 -> new IllegalStateException(string);
        };
    }
}

