/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.ui.UserActivityWatcher;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseConfigurable<T>
implements Disposable,
Configurable,
ModificationTracker {
    public static final DataKey<AbstractDatabaseConfigurable<?>> CONFIGURABLE = DataKey.create((String)"abstractDatabaseConfigurable");
    protected final T myTarget;
    protected final Project myProject;
    protected final SimpleModificationTracker myTracker;
    protected DatabaseConfigEditor myController;
    private boolean myBulkUpdate;
    private boolean myChangedInBulk;
    private Runnable myWatcher;
    private boolean myDepsInvalid;
    @NotNull
    private final DataContext myDataContext;

    protected AbstractDatabaseConfigurable(@NotNull Project project, @NotNull T target2) {
        if (project == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(1);
        }
        this.myTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myTarget = target2;
        this.myDataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(CONFIGURABLE, (Object)this).build();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(3);
        }
        return t;
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.myDataContext;
        if (dataContext == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(4);
        }
        return dataContext;
    }

    @NotNull
    public abstract T getTempTarget();

    public abstract boolean isTempTarget(@Nullable Object var1);

    public final void reset() {
        this.bulkUpdate(() -> this.reset(this.getTarget()));
    }

    public void bulkUpdate(Runnable r) {
        boolean prev = this.myBulkUpdate;
        try {
            this.myBulkUpdate = true;
            r.run();
        }
        finally {
            this.myBulkUpdate = prev;
        }
        if (this.myChangedInBulk) {
            this.myChangedInBulk = false;
            this.fireChanged();
        }
    }

    public void fireChanged() {
        if (this.myBulkUpdate) {
            this.myChangedInBulk = true;
            return;
        }
        this.myTracker.incModificationCount();
        if (this.myWatcher != null) {
            this.myWatcher.run();
        }
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount() + this.myController.getModificationTracker().getModificationCount();
    }

    public void init(@NotNull Runnable watcher) {
        if (watcher == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(5);
        }
        this.registerWatcher(watcher);
        this.reset();
    }

    protected abstract JComponent getComponent();

    protected void registerWatcher(@NotNull Runnable w) {
        if (w == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(6);
        }
        UserActivityWatcher watcher = new UserActivityWatcher(){

            protected boolean trackListSelection() {
                return false;
            }
        };
        watcher.addUserActivityListener(this::fireChanged);
        watcher.register((Component)this.getComponent());
        this.myWatcher = w;
        this.getComponent().addHierarchyListener(e2 -> {
            if (!this.myDepsInvalid || (e2.getChangeFlags() & 4L) == 0L) {
                return;
            }
            this.myDepsInvalid = false;
            this.validateDeps();
        });
    }

    protected void validateDeps() {
    }

    protected abstract void reset(@NotNull T var1);

    public void setController(@NotNull DatabaseConfigEditor controller) {
        if (controller == null) {
            AbstractDatabaseConfigurable.$$$reportNull$$$0(7);
        }
        this.myController = controller;
    }

    public DatabaseConfigEditor getController() {
        return this.myController;
    }

    @Nullable
    public abstract JComponent getCommonBar();

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public void beforeShowNotify() {
    }

    public void onUserActivity() {
    }

    public final void onDepActivity() {
        if (this.getComponent().isShowing()) {
            this.myDepsInvalid = false;
            this.validateDeps();
        } else {
            this.myDepsInvalid = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AbstractDatabaseConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AbstractDatabaseConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerWatcher";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setController";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

