/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.TypeConversionHelper;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Domain {
    public static final Domain EMPTY = new Domain(ConversionPoint.UNKNOWN, ""){

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality cardinality = Cardinality.EMPTY;
            if (cardinality == null) {
                1.$$$reportNull$$$0(0);
            }
            return cardinality;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                1.$$$reportNull$$$0(1);
            }
            Compatibility compatibility = Compatibility.incompatible();
            if (compatibility == null) {
                1.$$$reportNull$$$0(2);
            }
            return compatibility;
        }

        @Override
        @NotNull
        public Object trim(@NotNull Object o2) {
            if (o2 == null) {
                1.$$$reportNull$$$0(3);
            }
            Object object = o2;
            if (object == null) {
                1.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cardinality";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/domain/Domain$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    };
    private final ConversionPoint myPoint;
    private final String myName;
    private String @Nullable [] myAliases;
    private OperationSupport myOperationSupport;
    private TypeConversionHelper myTypeConversionHelper;
    private VersionRange myVersionRange;

    protected Domain(@NotNull ConversionPoint point, @NotNull String name2) {
        if (point == null) {
            Domain.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            Domain.$$$reportNull$$$0(1);
        }
        this.myAliases = null;
        this.myTypeConversionHelper = TypeConversionHelper.DEFAULT_TYPE_CONVERSION_HELPER;
        this.myVersionRange = null;
        this.myPoint = point;
        this.myName = name2;
        this.myOperationSupport = OperationSupport.DEFAULT_OPERATION_SUPPORT;
    }

    @NotNull
    public Domain withOperationSupport(@NotNull OperationSupport operationSupport) {
        if (operationSupport == null) {
            Domain.$$$reportNull$$$0(2);
        }
        this.myOperationSupport = operationSupport;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(3);
        }
        return domain;
    }

    @NotNull
    public Domain withAliases(String ... aliases) {
        if (aliases == null) {
            Domain.$$$reportNull$$$0(4);
        }
        if (this.myAliases != null) {
            throw new IllegalStateException("Aliases already initialized");
        }
        this.myAliases = aliases;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(5);
        }
        return domain;
    }

    @NotNull
    public Domain withVersionRange(@Nullable VersionRange versionRange) {
        this.myVersionRange = versionRange;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(6);
        }
        return domain;
    }

    @NotNull
    public OperationSupport getOperationSupport() {
        OperationSupport operationSupport = this.myOperationSupport;
        if (operationSupport == null) {
            Domain.$$$reportNull$$$0(7);
        }
        return operationSupport;
    }

    public VersionRange getVersionRange() {
        return this.myVersionRange;
    }

    @NotNull
    public Domain withTypeConversionHelper(@NotNull TypeConversionHelper helper) {
        if (helper == null) {
            Domain.$$$reportNull$$$0(8);
        }
        this.myTypeConversionHelper = helper;
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(9);
        }
        return domain;
    }

    public TypeConversionHelper getTypeConversionHelper() {
        return this.myTypeConversionHelper;
    }

    @NotNull
    public ConversionPoint getPoint() {
        ConversionPoint conversionPoint = this.myPoint;
        if (conversionPoint == null) {
            Domain.$$$reportNull$$$0(10);
        }
        return conversionPoint;
    }

    public boolean contains(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(11);
        }
        return this.getCompatibility(domain).isCanContains();
    }

    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            Domain.$$$reportNull$$$0(12);
        }
        Domain domain2 = this;
        if (domain2 == null) {
            Domain.$$$reportNull$$$0(13);
        }
        return domain2;
    }

    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            Domain.$$$reportNull$$$0(14);
        }
        Domain domain = this;
        if (domain == null) {
            Domain.$$$reportNull$$$0(15);
        }
        return domain;
    }

    @NotNull
    public String name() {
        String string = this.simpleName();
        if (string == null) {
            Domain.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String simpleName() {
        String string = this.myName;
        if (string == null) {
            Domain.$$$reportNull$$$0(17);
        }
        return string;
    }

    public String toString() {
        return this.myName + " " + this.getPoint() + " " + this.getLogicType();
    }

    public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
        if (descriptor2 == null) {
            Domain.$$$reportNull$$$0(18);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myName, (CharSequence)descriptor2.getTypeName()) || this.myAliases != null && ContainerUtil.find((Object[])this.myAliases, alias -> StringUtil.equalsIgnoreCase((CharSequence)alias, (CharSequence)descriptor2.getTypeName())) != null;
    }

    public boolean supportedIn(@Nullable Version version) {
        return this.myVersionRange == null || version == null || this.myVersionRange.contains(version);
    }

    public final boolean supports(@NotNull Operation operation2) {
        if (operation2 == null) {
            Domain.$$$reportNull$$$0(19);
        }
        return this.getOperationSupport().supportsOperation(this, operation2);
    }

    @NotNull
    public LogicalType getLogicType() {
        LogicalType logicalType = this.getPoint().getLogicalType();
        if (logicalType == null) {
            Domain.$$$reportNull$$$0(20);
        }
        return logicalType;
    }

    @NotNull
    public abstract Cardinality cardinality();

    @NotNull
    public abstract Compatibility getCompatibility(@NotNull Domain var1);

    @Nullable
    public abstract Object trim(@NotNull Object var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 9, 10, 13, 15, 16, 17, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSupport";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Domain";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withOperationSupport";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withAliases";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSupport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withTypeConversionHelper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withOperationSupport";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withAliases";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withTypeConversionHelper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 9, 10, 13, 15, 16, 17, 20 -> new IllegalStateException(string);
        };
    }
}

