/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NotNull;

public abstract class Compatibility
implements Comparable<Compatibility> {
    private static final Compatibility INCOMPATIBLE = new Incompatible();
    private final Cardinality myCardinality;
    private final int myPriority;
    private final boolean myCanContains;
    private final int myLabelSimilarity;
    private final boolean myCompatible;

    protected Compatibility(@NotNull Cardinality cardinality, int labelSimilarity, int priority, boolean canContains, boolean compatible) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(0);
        }
        this.myCardinality = cardinality;
        this.myPriority = priority;
        this.myCanContains = canContains;
        this.myLabelSimilarity = labelSimilarity;
        this.myCompatible = compatible;
    }

    boolean isCanContains() {
        return this.myCanContains;
    }

    public boolean isCompatible() {
        return this.myCompatible;
    }

    public int getPriority() {
        return this.myPriority;
    }

    Cardinality getCardinality() {
        return this.myCardinality;
    }

    int getLabelSimilarity() {
        return this.myLabelSimilarity;
    }

    @Override
    public int compareTo(Compatibility o2) {
        int byLabel = Integer.compare(o2.myLabelSimilarity, this.myLabelSimilarity);
        if (byLabel != 0) {
            return byLabel;
        }
        int byPriority = Integer.compare(o2.getPriority(), this.myPriority);
        if (byPriority != 0) {
            return byPriority;
        }
        return this.myCardinality.compareTo(o2.myCardinality);
    }

    @NotNull
    public static Compatibility full(@NotNull Cardinality cardinality, @NotNull LogicalType first2, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(1);
        }
        if (first2 == null) {
            Compatibility.$$$reportNull$$$0(2);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(3);
        }
        return Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)Full::new), cardinality, first2, second);
    }

    @NotNull
    public static Compatibility compatibleLossy(@NotNull Cardinality cardinality, @NotNull LogicalType first2, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(4);
        }
        if (first2 == null) {
            Compatibility.$$$reportNull$$$0(5);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(6);
        }
        return Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)CompatibleLossy::new), cardinality, first2, second);
    }

    @NotNull
    public static Compatibility incompatibleLossless(@NotNull Cardinality cardinality, @NotNull LogicalType first2, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(7);
        }
        if (first2 == null) {
            Compatibility.$$$reportNull$$$0(8);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(9);
        }
        return Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)IncompatibleLossless::new), cardinality, first2, second);
    }

    @NotNull
    public static Compatibility incompatibleLossy(@NotNull Cardinality cardinality, @NotNull LogicalType first2, @NotNull LogicalType second) {
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(10);
        }
        if (first2 == null) {
            Compatibility.$$$reportNull$$$0(11);
        }
        if (second == null) {
            Compatibility.$$$reportNull$$$0(12);
        }
        return Compatibility.create((PairFunction<Cardinality, Integer, Compatibility>)((PairFunction)IncompatibleLossy::new), cardinality, first2, second);
    }

    @NotNull
    public static Compatibility incompatible() {
        Compatibility compatibility = INCOMPATIBLE;
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(13);
        }
        return compatibility;
    }

    @NotNull
    private static Compatibility create(@NotNull PairFunction<Cardinality, Integer, Compatibility> constructor, @NotNull Cardinality cardinality, @NotNull LogicalType from, @NotNull LogicalType to) {
        if (constructor == null) {
            Compatibility.$$$reportNull$$$0(14);
        }
        if (cardinality == null) {
            Compatibility.$$$reportNull$$$0(15);
        }
        if (from == null) {
            Compatibility.$$$reportNull$$$0(16);
        }
        if (to == null) {
            Compatibility.$$$reportNull$$$0(17);
        }
        Compatibility compatibility = (Compatibility)constructor.fun((Object)cardinality, (Object)to.getSuitability(from));
        if (compatibility == null) {
            Compatibility.$$$reportNull$$$0(18);
        }
        return compatibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardinality";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/Compatibility";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/Compatibility";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "incompatible";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "full";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compatibleLossy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "incompatibleLossless";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "incompatibleLossy";
                break;
            }
            case 13: 
            case 18: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 18 -> new IllegalStateException(string);
        };
    }

    private static class Incompatible
    extends Compatibility {
        protected Incompatible() {
            super(Cardinality.EMPTY, 0, 1, false, false);
        }
    }

    private static class IncompatibleLossy
    extends Compatibility {
        protected IncompatibleLossy(@NotNull Cardinality cardinality, int label2) {
            if (cardinality == null) {
                IncompatibleLossy.$$$reportNull$$$0(0);
            }
            super(cardinality, label2, 2, true, false);
        }

        @Override
        public int compareTo(Compatibility o2) {
            if (!(o2 instanceof IncompatibleLossy)) {
                return super.compareTo(o2);
            }
            int byLabel = Integer.compare(o2.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o2.getCardinality().compareTo(this.getCardinality());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$IncompatibleLossy", "<init>"));
        }
    }

    private static class IncompatibleLossless
    extends Compatibility {
        protected IncompatibleLossless(@NotNull Cardinality cardinality, int label2) {
            if (cardinality == null) {
                IncompatibleLossless.$$$reportNull$$$0(0);
            }
            super(cardinality, label2, 3, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$IncompatibleLossless", "<init>"));
        }
    }

    private static class CompatibleLossy
    extends Compatibility {
        protected CompatibleLossy(@NotNull Cardinality cardinality, int label2) {
            if (cardinality == null) {
                CompatibleLossy.$$$reportNull$$$0(0);
            }
            super(cardinality, label2, 4, true, true);
        }

        @Override
        public int compareTo(Compatibility o2) {
            if (!(o2 instanceof CompatibleLossy)) {
                return super.compareTo(o2);
            }
            int byLabel = Integer.compare(o2.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o2.getCardinality().compareTo(this.getCardinality());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$CompatibleLossy", "<init>"));
        }
    }

    private static final class Full
    extends Compatibility {
        private Full(@NotNull Cardinality c2, int label2) {
            if (c2 == null) {
                Full.$$$reportNull$$$0(0);
            }
            super(c2, label2, 5, true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility$Full", "<init>"));
        }
    }
}

