/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.ThreadContext;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfo;
import com.intellij.database.connection.throwable.info.ThrowableInfoUtil;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionManagerListener;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.introspection.DbmsMismatchException;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000b56789:;<=>?B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0003J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0003J\"\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u0010H\u0007JB\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0007JH\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J@\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#2\n\b\u0003\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010%\u001a\u00020&H\u0003J$\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0007J(\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0007J!\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0002\u00a2\u0006\u0002\u00101J$\u00102\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R/\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006@"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager;", "", "()V", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/console/session/DatabaseSessionManagerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTopic$annotations", "getTopic", "()Lcom/intellij/util/messages/Topic;", "findSession", "Lcom/intellij/database/console/session/DatabaseSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateNameForSession", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "prefix", "getExactSession", "title", "getFacade", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "path", "Lcom/intellij/database/util/SearchPath;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "silent", "", "getSession", "type", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "getSessions", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "onEdt", "T", "computable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "openSession", "projectScopedSessions", "Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "ConnectionWithClient", "Facade", "Factories", "Factory", "Indexer", "MultiConnection", "ProjectSessions", "SessionType", "SingleConnection", "TemporaryClient", "WrapperRequest", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,681:1\n857#2,2:682\n1002#2,2:684\n766#2:686\n857#2,2:687\n766#2:689\n857#2,2:690\n1#3:692\n31#4,2:693\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager\n*L\n74#1:682,2\n75#1:684,2\n81#1:686\n81#1:687,2\n86#1:689\n86#1:690,2\n144#1:693,2\n*E\n"})
public final class DatabaseSessionManager {
    @NotNull
    public static final DatabaseSessionManager INSTANCE = new DatabaseSessionManager();
    @NotNull
    private static final Topic<DatabaseSessionManagerListener> topic;

    private DatabaseSessionManager() {
    }

    @NotNull
    public static final Topic<DatabaseSessionManagerListener> getTopic() {
        return topic;
    }

    @JvmStatic
    public static /* synthetic */ void getTopic$annotations() {
    }

    @Nls
    private final String generateNameForSession(Project project, DatabaseConnectionPoint connectionPoint) {
        return this.generateNameForSession(project, connectionPoint, null);
    }

    @Nls
    private final String generateNameForSession(Project project, DatabaseConnectionPoint connectionPoint, @Nls String prefix) {
        Object object;
        LocalDataSource localDataSource = connectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        Sequence sessions2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)DatabaseSessionManager.getSessions(project, localDataSource)), (Function1)((Function1)new Function1<DatabaseSession, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DatabaseSession it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return this.$prefix == null && StringUtil.isNotNegativeNumber((CharSequence)it2.getTitle()) || this.$prefix != null && StringsKt.startsWith$default((String)it2.getTitle(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
        })), (Function1)generateNameForSession.sessions.2.INSTANCE);
        Long idx = Indexer.INSTANCE.generateIndex(SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.plus((Sequence)sessions2, (Object)"default"))), prefix);
        if (prefix == null) {
            object = idx;
            if (object == null || (object = ((Long)object).toString()) == null) {
                object = "1";
            }
        } else {
            object = idx == null ? prefix : prefix + " " + idx;
        }
        return object;
    }

    @JvmStatic
    @Nullable
    public static final DatabaseSession findSession(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        return DatabaseSessionViewService.Companion.getInstance().findDatabaseSession(e2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = INSTANCE.projectScopedSessions(project).getSessions();
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            DatabaseSession it2 = (DatabaseSession)element$iv;
            boolean bl = false;
            if (!(!it2.isInternal())) continue;
            destination$iv.add(element$iv);
        }
        ArrayList sessions2 = (ArrayList)destination$iv;
        List $this$sortBy$iv = sessions2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b2) {
                    DatabaseSession it2 = (DatabaseSession)a;
                    boolean bl = false;
                    int n = it2.isService() ? 0 : 1;
                    it2 = (DatabaseSession)b2;
                    Comparable comparable = Integer.valueOf(n);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it2.isService() ? 0 : 1));
                }
            });
        }
        return sessions2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it2 = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getTarget(), (Object)dataSource2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<DatabaseSession> getSessions(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ConsoleRunConfiguration configuration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Iterable $this$filter$iv = DatabaseSessionManager.getSessions(project, dataSource2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseSession it2 = (DatabaseSession)element$iv$iv;
            boolean bl = false;
            if (!(configuration == null || Intrinsics.areEqual((Object)((Object)it2.getConfiguration()), (Object)((Object)configuration)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return DatabaseSessionManager.getSession$default(project, connectionPoint, null, false, null, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
        DatabaseSession databaseSession;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            LocalDataSource localDataSource = connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            Iterable iterable = DatabaseSessionManager.getSessions(project, localDataSource);
            for (Object t : iterable) {
                DatabaseSession it2 = (DatabaseSession)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getTitle(), (Object)title)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((databaseSession = (DatabaseSession)v1) == null) {
            databaseSession = DatabaseSessionManager.getSession$default(project, connectionPoint, null, false, title, null, 32, null);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession getExactSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @NotNull String title) {
        DatabaseSession databaseSession;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            LocalDataSource localDataSource = connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            Iterable iterable = DatabaseSessionManager.getSessions(project, localDataSource);
            for (Object t : iterable) {
                DatabaseSession it2 = (DatabaseSession)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getTitle(), (Object)title)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((databaseSession = (DatabaseSession)v1) == null) {
            databaseSession = DatabaseSessionManager.getSession(project, connectionPoint, null, false, title, SessionType.NEW);
        }
        return databaseSession;
    }

    @JvmStatic
    @NotNull
    public static final DatabaseSession openSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        return DatabaseSessionManager.getSession(project, connectionPoint, null, false, INSTANCE.generateNameForSession(project, connectionPoint, title), SessionType.NEW);
    }

    @JvmStatic
    @NotNull
    public static final Facade getFacade(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, @Nullable ErrorHandler handler2, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return DatabaseSessionManager.getFacade(project, connectionPoint, credentialsStore, path, false, handler2, department);
    }

    public static /* synthetic */ Facade getFacade$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, SearchPath searchPath, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 8) != 0) {
            searchPath = null;
        }
        if ((n & 0x10) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.getFacade(project, databaseConnectionPoint, databaseCredentials, searchPath, errorHandler, databaseDepartment);
    }

    @JvmStatic
    @NotNull
    public static final Facade getFacade(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler2, @NotNull DatabaseDepartment department) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)department, (String)"department");
        return new Facade(connectionPoint, credentialsStore, project, path, silent, handler2, department);
    }

    public static /* synthetic */ Facade getFacade$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, Object object) {
        if ((n & 0x20) != 0) {
            errorHandler = null;
        }
        return DatabaseSessionManager.getFacade(project, databaseConnectionPoint, databaseCredentials, searchPath, bl, errorHandler, databaseDepartment);
    }

    @JvmStatic
    private static final DatabaseSession getSession(Project project, DatabaseConnectionPoint connectionPoint, DatabaseCredentials credentialsStore, boolean silent, @Nls String title, SessionType type2) {
        String sessionTitle = Intrinsics.areEqual((Object)title, (Object)"default") ? INSTANCE.generateNameForSession(project, connectionPoint, "default") : title;
        return INSTANCE.projectScopedSessions(project).getSession(project, connectionPoint, credentialsStore, silent, sessionTitle, type2);
    }

    static /* synthetic */ DatabaseSession getSession$default(Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            sessionType = SessionType.NOT_IMPORTANT;
        }
        return DatabaseSessionManager.getSession(project, databaseConnectionPoint, databaseCredentials, bl, string, sessionType);
    }

    private final ProjectSessions projectScopedSessions(Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProjectSessions> serviceClass$iv = ProjectSessions.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ProjectSessions)object;
    }

    private final <T> T onEdt(Function0<? extends T> computable) {
        return (T)UIUtil.invokeAndWaitIfNeeded(() -> DatabaseSessionManager.onEdt$lambda$6(computable));
    }

    private static final Object onEdt$lambda$6(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke();
    }

    static {
        Topic topic = Topic.create((String)"database session manager topic", DatabaseSessionManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        DatabaseSessionManager.topic = topic;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\rH\u0096\u0001J\t\u0010\u000e\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u000e\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\t\u0010\u0018\u001a\u00020\u0012H\u0096\u0001J\u000e\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u0010\u0010#\u001a\t\u0018\u00010$\u00a2\u0006\u0002\b%H\u0097\u0001J\u000e\u0010&\u001a\u00070'\u00a2\u0006\u0002\b\u0017H\u0097\u0001J\u000e\u0010(\u001a\u00070 \u00a2\u0006\u0002\b\u0017H\u0097\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001J\b\u0010+\u001a\u00020\rH\u0016J\t\u0010,\u001a\u00020\u0012H\u0096\u0001J\u0018\u0010-\u001a\u00020\r2\r\b\u0001\u0010.\u001a\u00070/\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\t\u00100\u001a\u00020\rH\u0096\u0001J\u0018\u00100\u001a\u00020\r2\r\b\u0001\u0010.\u001a\u00070/\u00a2\u0006\u0002\b\u0017H\u0096\u0001J\u0011\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u0012H\u0096\u0001J\u0011\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\u0012H\u0096\u0001J\u0011\u00105\u001a\n 6*\u0004\u0018\u00010/0/H\u0096\u0001J\t\u00107\u001a\u000208H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u00069"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ConnectionWithClient;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatements$PurposedConnection;", "connection", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/console/client/DatabaseSessionClient;)V", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "commit", "", "component1", "component2", "copy", "equals", "", "other", "", "getAuditService", "Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "Lorg/jetbrains/annotations/NotNull;", "getAutoCommit", "getConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "getConnectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getDbms", "Lcom/intellij/database/Dbms;", "getDriverVersion", "Lcom/intellij/database/util/Version;", "getRemoteConnection", "Lcom/intellij/database/remote/jdbc/RemoteConnection;", "getRemoteMetaData", "Lcom/intellij/database/remote/jdbc/RemoteDatabaseMetaData;", "Lorg/jetbrains/annotations/Nullable;", "getRequestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "getVersion", "hashCode", "", "interrupt", "isReadOnly", "releaseSavepoint", "savepoint", "Lcom/intellij/database/remote/jdbc/RemoteSavepoint;", "rollback", "setAutoCommit", "p0", "setReadOnly", "only", "setSavepoint", "kotlin.jvm.PlatformType", "toString", "", "intellij.database.connectivity"})
    private static final class ConnectionWithClient
    implements DatabaseConnection,
    InterruptibleDatabaseConnection,
    SmartStatements.PurposedConnection {
        @NotNull
        private final DatabaseConnection connection;
        @NotNull
        private final DatabaseSessionClient client;

        public ConnectionWithClient(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.connection = connection2;
            this.client = client;
        }

        @Override
        public void commit() {
            this.connection.commit();
        }

        @Override
        @NotNull
        public AdvancedAuditService getAuditService() {
            return this.connection.getAuditService();
        }

        @Override
        public boolean getAutoCommit() {
            return this.connection.getAutoCommit();
        }

        @Override
        @NotNull
        public ConsoleRunConfiguration getConfiguration() {
            return this.connection.getConfiguration();
        }

        @Override
        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            return this.connection.getConnectionPoint();
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            return this.connection.getDbms();
        }

        @Override
        @NotNull
        public Version getDriverVersion() {
            return this.connection.getDriverVersion();
        }

        @Override
        @NotNull
        public RemoteConnection getRemoteConnection() {
            return this.connection.getRemoteConnection();
        }

        @Override
        @Nullable
        public RemoteDatabaseMetaData getRemoteMetaData() {
            return this.connection.getRemoteMetaData();
        }

        @Override
        @NotNull
        public ConnectionRequestor getRequestor() {
            return this.connection.getRequestor();
        }

        @Override
        @NotNull
        public Version getVersion() {
            return this.connection.getVersion();
        }

        @Override
        public boolean isReadOnly() {
            return this.connection.isReadOnly();
        }

        @Override
        public void releaseSavepoint(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback() {
            this.connection.rollback();
        }

        @Override
        public void rollback(@NotNull RemoteSavepoint savepoint) {
            Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
            this.connection.rollback(savepoint);
        }

        @Override
        public void setAutoCommit(boolean p0) {
            this.connection.setAutoCommit(p0);
        }

        @Override
        public void setReadOnly(boolean only) {
            this.connection.setReadOnly(only);
        }

        @Override
        public RemoteSavepoint setSavepoint() {
            return this.connection.setSavepoint();
        }

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            DatabaseDepartment databaseDepartment = this.client.getDepartment();
            Intrinsics.checkNotNullExpressionValue((Object)databaseDepartment, (String)"getDepartment(...)");
            return databaseDepartment;
        }

        @Override
        public void interrupt() {
            this.client.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.Cancel(this.client));
        }

        private final DatabaseConnection component1() {
            return this.connection;
        }

        private final DatabaseSessionClient component2() {
            return this.client;
        }

        @NotNull
        public final ConnectionWithClient copy(@NotNull DatabaseConnection connection2, @NotNull DatabaseSessionClient client) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            return new ConnectionWithClient(connection2, client);
        }

        public static /* synthetic */ ConnectionWithClient copy$default(ConnectionWithClient connectionWithClient, DatabaseConnection databaseConnection, DatabaseSessionClient databaseSessionClient, int n, Object object) {
            if ((n & 1) != 0) {
                databaseConnection = connectionWithClient.connection;
            }
            if ((n & 2) != 0) {
                databaseSessionClient = connectionWithClient.client;
            }
            return connectionWithClient.copy(databaseConnection, databaseSessionClient);
        }

        @NotNull
        public String toString() {
            return "ConnectionWithClient(connection=" + this.connection + ", client=" + this.client + ")";
        }

        public int hashCode() {
            int result2 = this.connection.hashCode();
            result2 = result2 * 31 + this.client.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionWithClient)) {
                return false;
            }
            ConnectionWithClient connectionWithClient = (ConnectionWithClient)other;
            if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionWithClient.connection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.client, (Object)connectionWithClient.client);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 82\u00020\u0001:\t89:;<=>?@BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJA\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f\"\b\b\u0001\u0010 *\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H\u001f0#2\u0006\u0010$\u001a\u0002H 2\u0006\u0010%\u001a\u00020&H\u0002\u00a2\u0006\u0002\u0010'J/\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H\u001f0#H\u0002\u00a2\u0006\u0002\u0010)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0+J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180+H\u0002J\u0010\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010+H\u0002J%\u0010-\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H\u001f0#\u00a2\u0006\u0002\u00100J(\u00101\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u001f0#H\u0082@\u00a2\u0006\u0002\u00102J0\u00101\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u001f0#H\u0082@\u00a2\u0006\u0002\u00103J(\u00104\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H\u001f0#H\u0086@\u00a2\u0006\u0002\u00102J&\u00105\u001a\b\u0012\u0004\u0012\u0002H\u001f06\"\u0004\b\u0000\u0010\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H\u001f0#J%\u00107\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H\u001f0#\u00a2\u0006\u0002\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade;", "", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/database/util/SearchPath;", "silent", "", "handler", "Lcom/intellij/database/util/ErrorHandler;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/util/SearchPath;ZLcom/intellij/database/util/ErrorHandler;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;)V", "getConnectionPoint", "()Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getPath", "()Lcom/intellij/database/util/SearchPath;", "checkBounds", "", "info", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "compute", "T", "C", "Lcom/intellij/database/dataSource/DatabaseConnection;", "work", "Lkotlin/Function1;", "connection", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lkotlin/jvm/functions/Function1;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)Ljava/lang/Object;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connect", "Lcom/intellij/database/util/GuardedRef;", "currentConnection", "multiRunSync", "worker", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "perform", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/intellij/database/console/client/DatabaseSessionClient;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "run", "runAsync", "Lcom/intellij/database/util/AsyncTask;", "runSync", "Companion", "ConnectionInfo", "ConnectionReference", "ConnectionsRouter", "Lockpick", "MultipleSessionsRouter", "Routers", "Runner", "SingleSessionRouter", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Facade\n+ 2 extensions.kt\ncom/intellij/openapi/util/ExtensionsKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,681:1\n22#2,6:682\n22#2,6:688\n310#3,11:694\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Facade\n*L\n298#1:682,6\n408#1:688,6\n415#1:694,11\n*E\n"})
    public static final class Facade {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final DatabaseConnectionPoint connectionPoint;
        @Nullable
        private final DatabaseCredentials credentialsStore;
        @NotNull
        private final Project project;
        @Nullable
        private final SearchPath path;
        private final boolean silent;
        @Nullable
        private final ErrorHandler handler;
        @NotNull
        private final DatabaseDepartment department;
        @NotNull
        private static final Routers routers = new Routers(MultipleSessionsRouter.INSTANCE, new SingleSessionRouter());

        public Facade(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, @NotNull Project project, @Nullable SearchPath path, boolean silent, @Nullable ErrorHandler handler2, @NotNull DatabaseDepartment department) {
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.connectionPoint = connectionPoint;
            this.credentialsStore = credentialsStore;
            this.project = project;
            this.path = path;
            this.silent = silent;
            this.handler = handler2;
            this.department = department;
        }

        public /* synthetic */ Facade(DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, Project project, SearchPath searchPath, boolean bl, ErrorHandler errorHandler, DatabaseDepartment databaseDepartment, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                searchPath = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                errorHandler = null;
            }
            this(databaseConnectionPoint, databaseCredentials, project, searchPath, bl, errorHandler, databaseDepartment);
        }

        @NotNull
        public final DatabaseConnectionPoint getConnectionPoint() {
            return this.connectionPoint;
        }

        @Nullable
        public final SearchPath getPath() {
            return this.path;
        }

        @Nullable
        public final <T> Object run(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work, @NotNull Continuation<? super T> $completion) {
            return this.perform((Function1)new Function1<ConnectionInfo, T>(this, work){
                final /* synthetic */ Facade this$0;
                final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                {
                    this.this$0 = $receiver;
                    this.$work = $work;
                    super(1);
                }

                public final T invoke(@NotNull ConnectionInfo info2) {
                    Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                    return (T)Facade.access$compute(this.this$0, info2, this.$work);
                }
            }, $completion);
        }

        @NotNull
        public final <T> AsyncTask<T> runAsync(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            Intrinsics.checkNotNullParameter(work, (String)"work");
            return AsyncTask.Frame.asAsyncTask$default(AsyncTask.Companion.currentFrame(), null, new Function2<CoroutineScope, Continuation<? super T>, Object>(this, work, null){
                int label;
                final /* synthetic */ Facade this$0;
                final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                {
                    this.this$0 = $receiver;
                    this.$work = $work;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.run(this.$work, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }

        public final <T> T runSync(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            Intrinsics.checkNotNullParameter(work, (String)"work");
            return this.multiRunSync((Function1)new Function1<Runner, T>(work){
                final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                {
                    this.$work = $work;
                    super(1);
                }

                public final T invoke(@NotNull Runner r) {
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    return r.perform(this.$work);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T multiRunSync(@NotNull Function1<? super Runner, ? extends T> worker) {
            Object object;
            Intrinsics.checkNotNullParameter(worker, (String)"worker");
            GuardedRef<ConnectionInfo> guardedRef = this.currentConnection();
            if (guardedRef != null) {
                AutoCloseable autoCloseable = guardedRef;
                Throwable throwable = null;
                try {
                    GuardedRef info2 = (GuardedRef)autoCloseable;
                    boolean bl = false;
                    Object object2 = worker.invoke((Object)new Runner(this, info2){
                        final /* synthetic */ Facade this$0;
                        final /* synthetic */ GuardedRef<ConnectionInfo> $info;
                        {
                            this.this$0 = $receiver;
                            this.$info = $info;
                        }

                        public <T> T perform(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
                            Intrinsics.checkNotNullParameter(work, (String)"work");
                            ConnectionInfo connectionInfo = this.$info.get();
                            Intrinsics.checkNotNullExpressionValue((Object)connectionInfo, (String)"get(...)");
                            return (T)Facade.access$compute(this.this$0, connectionInfo, work);
                        }
                    });
                    return (T)object2;
                }
                catch (Throwable info2) {
                    throwable = info2;
                    throw info2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            Disposable $this$use$iv = this.client();
            boolean $i$f$use = false;
            try {
                DatabaseSessionClient client = (DatabaseSessionClient)$this$use$iv;
                boolean bl = false;
                object = worker.invoke((Object)new Runner(this, client){
                    final /* synthetic */ Facade this$0;
                    final /* synthetic */ DatabaseSessionClient $client;
                    {
                        this.this$0 = $receiver;
                        this.$client = $client;
                    }

                    public <T> T perform(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
                        Intrinsics.checkNotNullParameter(work, (String)"work");
                        return (T)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this.this$0, this.$client, work, null){
                            int label;
                            final /* synthetic */ Facade this$0;
                            final /* synthetic */ DatabaseSessionClient $client;
                            final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                            {
                                this.this$0 = $receiver;
                                this.$client = $client;
                                this.$work = $work;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = Facade.access$perform(this.this$0, this.$client, (Function1)new Function1<ConnectionInfo, T>(this.this$0, this.$work){
                                            final /* synthetic */ Facade this$0;
                                            final /* synthetic */ Function1<InterruptibleDatabaseConnection, T> $work;
                                            {
                                                this.this$0 = $receiver;
                                                this.$work = $work;
                                                super(1);
                                            }

                                            public final T invoke(@NotNull ConnectionInfo info2) {
                                                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                                                return (T)Facade.access$compute(this.this$0, info2, this.$work);
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                    }
                });
            }
            finally {
                if ($this$use$iv != null) {
                    Disposer.dispose((Disposable)$this$use$iv);
                }
            }
            return (T)object;
        }

        @NotNull
        public final GuardedRef<DatabaseConnection> connect() throws Exception {
            GuardedRef<ConnectionInfo> infoRef = this.connection();
            InterruptibleDatabaseConnection interruptibleDatabaseConnection = infoRef.get().getConnection();
            return new GuardedRef<DatabaseConnection>(infoRef, interruptibleDatabaseConnection){
                final /* synthetic */ GuardedRef<ConnectionInfo> $infoRef;
                {
                    this.$infoRef = $infoRef;
                    super($super_call_param$1);
                }

                protected void close(@NotNull DatabaseConnection ref2) {
                    Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                    this.$infoRef.close();
                }
            };
        }

        private final GuardedRef<ConnectionInfo> currentConnection() {
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            ConnectionReference current = router.getCurrent();
            if (current != null) {
                this.checkBounds(current.getResource());
                return new Lockpick(current, router);
            }
            return null;
        }

        private final GuardedRef<ConnectionInfo> connection() {
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            GuardedRef<ConnectionInfo> guardedRef = this.currentConnection();
            if (guardedRef != null) {
                GuardedRef<ConnectionInfo> it2 = guardedRef;
                boolean bl = false;
                return it2;
            }
            CountDownLatch latch = new CountDownLatch(1);
            CompletableFuture emptyFuture = new CompletableFuture();
            CompletableFuture<ConnectionInfo> resultFuture = new CompletableFuture<ConnectionInfo>();
            emptyFuture.exceptionally(arg_0 -> Facade.connection$lambda$3(resultFuture, arg_0));
            String string = DatabaseBundle.message("progress.title.block.request.until.connection.released", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            AsyncTask.Frame.asAsyncTask$default(AsyncTask.Companion.frame(string), null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, resultFuture, latch, null){
                int label;
                final /* synthetic */ Facade this$0;
                final /* synthetic */ CompletableFuture<ConnectionInfo> $resultFuture;
                final /* synthetic */ CountDownLatch $latch;
                {
                    this.this$0 = $receiver;
                    this.$resultFuture = $resultFuture;
                    this.$latch = $latch;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = Facade.access$perform(this.this$0, (Function1)new Function1<ConnectionInfo, Unit>(this.$resultFuture, this.$latch){
                                final /* synthetic */ CompletableFuture<ConnectionInfo> $resultFuture;
                                final /* synthetic */ CountDownLatch $latch;
                                {
                                    this.$resultFuture = $resultFuture;
                                    this.$latch = $latch;
                                    super(1);
                                }

                                public final void invoke(@NotNull ConnectionInfo it2) {
                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                    this.$resultFuture.complete(it2);
                                    this.$latch.await();
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            try {
                ConnectionInfo result2 = resultFuture.get();
                Intrinsics.checkNotNull((Object)result2);
                ConnectionReference reference = new ConnectionReference(result2, latch);
                router.save(reference);
                return new Lockpick(reference, router);
            }
            catch (ExecutionException e2) {
                Throwable cause = e2.getCause();
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new ProcessCanceledException();
                }
                throw throwable;
            }
        }

        private final void checkBounds(ConnectionInfo info2) {
            if (this.path == null) {
                return;
            }
            SearchPath searchPath = info2.getContext().getSearchPath();
            if (!JdbcUrlParserUtil.outOfBounds(info2.getConnection().getConnectionPoint(), searchPath != null ? searchPath.getCurrent() : null, this.path.getCurrent())) {
                return;
            }
            throw new IllegalStateException("Cannot switch a database. The connection is used by another client. Disable the single connection mode and try again");
        }

        @NotNull
        public final DatabaseSessionClient client() {
            SessionType sessionType = this.department.isService() ? SessionType.SERVICE : SessionType.NOT_IMPORTANT;
            DatabaseSession session2 = DatabaseSessionManager.getSession(this.project, this.connectionPoint, this.credentialsStore, this.silent, null, sessionType);
            return this.client(session2);
        }

        @NotNull
        public final VisibleDatabaseSessionClient client(@NotNull DatabaseSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            TemporaryClient client = new TemporaryClient(session2, this.department, this.path);
            session2.attach(client);
            return client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T compute(ConnectionInfo info2, Function1<? super InterruptibleDatabaseConnection, ? extends T> work) {
            T t;
            ConnectionReference reference = new ConnectionReference(info2, null, 2, null);
            LocalDataSource localDataSource = this.connectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            ConnectionsRouter router = routers.choose(localDataSource);
            router.save(reference);
            try {
                t = this.compute(work, (DatabaseConnection)info2.getConnection(), info2.getContext());
            }
            finally {
                router.remove();
            }
            return t;
        }

        private final <T, C extends DatabaseConnection> T compute(Function1<? super C, ? extends T> work, C connection2, DataRequest.Context context) {
            Object object;
            try {
                object = work.invoke(connection2);
            }
            catch (DbmsMismatchException e2) {
                throw e2;
            }
            catch (ProcessCanceledException e3) {
                throw e3;
            }
            catch (Exception e4) {
                if (!AsyncUtil.isCancellation(e4)) {
                    context.error(e4);
                }
                throw new ProcessCanceledException((Throwable)e4);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final <T> Object perform(Function1<? super ConnectionInfo, ? extends T> var1_1, Continuation<? super T> var2_2) {
            if (!(var2_2 instanceof perform.1)) ** GOTO lbl-1000
            var9_3 = var2_2;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Facade this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Facade.access$perform(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$use$iv = this.client();
                    $i$f$use = false;
                    it = (DatabaseSessionClient)$this$use$iv;
                    $i$a$-use-DatabaseSessionManager$Facade$perform$2 = false;
                    $continuation.L$0 = $this$use$iv;
                    $continuation.label = 1;
                    v0 = this.perform(it, (Function1<? super ConnectionInfo, ? extends T>)work, (Continuation<? super T>)$continuation);
                    ** if (v0 != var10_5) goto lbl23
lbl22:
                    // 1 sources

                    return var10_5;
lbl23:
                    // 1 sources

                    ** GOTO lbl33
                }
                case 1: {
                    $i$f$use = false;
                    $i$a$-use-DatabaseSessionManager$Facade$perform$2 = false;
                    $this$use$iv = (Disposable)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl33:
                        // 2 sources

                        var7_12 = v0;
                    }
                    catch (Throwable var7_13) {
                        throw var7_13;
                    }
                    finally {
                        if ($this$use$iv != null) {
                            Disposer.dispose((Disposable)$this$use$iv);
                        }
                    }
                    return var7_12;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> Object perform(DatabaseSessionClient client, Function1<? super ConnectionInfo, ? extends T> work, Continuation<? super T> $completion) {
            boolean $i$f$suspendCancellableCoroutine = false;
            Continuation<? super T> uCont$iv = $completion;
            boolean bl = false;
            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
            cancellable$iv.initCancellability();
            CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
            boolean bl2 = false;
            AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.installThreadContext((CoroutineContext)cont.getContext(), (boolean)true);
            Throwable throwable = null;
            try {
                AccessToken it2 = (AccessToken)autoCloseable;
                boolean bl3 = false;
                CoroutinesKt.blockingContextToIndicator((Function0)((Function0)new Function0<Unit>(this, cont, client, work){
                    final /* synthetic */ Facade this$0;
                    final /* synthetic */ CancellableContinuation<T> $cont;
                    final /* synthetic */ DatabaseSessionClient $client;
                    final /* synthetic */ Function1<ConnectionInfo, T> $work;
                    {
                        this.this$0 = $receiver;
                        this.$cont = $cont;
                        this.$client = $client;
                        this.$work = $work;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void invoke() {
                        boolean submitted = false;
                        try {
                            ErrorHandler errorHandler = Facade.access$getHandler$p(this.this$0);
                            WrapperRequest<T> request2 = new WrapperRequest<T>(this.$client, this.$cont, this.$work, errorHandler){
                                final /* synthetic */ DatabaseSessionClient $client;
                                final /* synthetic */ Function1<ConnectionInfo, T> $work;
                                {
                                    this.$client = $client;
                                    this.$work = $work;
                                    super($client, $cont, $super_call_param$1);
                                }

                                public T process(@NotNull DataRequest.Context context, @NotNull DatabaseConnectionCore connection2) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                                    Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                                    return (T)this.$work.invoke((Object)new ConnectionInfo(new ConnectionWithClient((DatabaseConnection)connection2, this.$client), context));
                                }
                            };
                            submitted = request2.submit();
                            if (submitted) return;
                        }
                        catch (Throwable throwable) {
                            CancellableContinuation.DefaultImpls.cancel$default(this.$cont, null, (int)1, null);
                            throw throwable;
                        }
                        CancellableContinuation.DefaultImpls.cancel$default(this.$cont, null, (int)1, null);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object object = cancellable$iv.getResult();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }

        private static final Unit connection$lambda$3(CompletableFuture $resultFuture, Throwable it2) {
            Intrinsics.checkNotNullParameter((Object)$resultFuture, (String)"$resultFuture");
            $resultFuture.completeExceptionally(it2);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$compute(Facade $this, ConnectionInfo info2, Function1 work) {
            return $this.compute(info2, work);
        }

        public static final /* synthetic */ Object access$perform(Facade $this, Function1 work, Continuation $completion) {
            return $this.perform(work, $completion);
        }

        public static final /* synthetic */ Object access$perform(Facade $this, DatabaseSessionClient client, Function1 work, Continuation $completion) {
            return $this.perform(client, work, $completion);
        }

        public static final /* synthetic */ ErrorHandler access$getHandler$p(Facade $this) {
            return $this.handler;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Companion;", "", "()V", "routers", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "getRouters", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "intellij.database.connectivity"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Routers getRouters() {
                return routers;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "", "connection", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "(Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;Lcom/intellij/database/datagrid/DataRequest$Context;)V", "getConnection", "()Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "getContext", "()Lcom/intellij/database/datagrid/DataRequest$Context;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.connectivity"})
        private static final class ConnectionInfo {
            @NotNull
            private final InterruptibleDatabaseConnection connection;
            @NotNull
            private final DataRequest.Context context;

            public ConnectionInfo(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                this.connection = connection2;
                this.context = context;
            }

            @NotNull
            public final InterruptibleDatabaseConnection getConnection() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context getContext() {
                return this.context;
            }

            @NotNull
            public final InterruptibleDatabaseConnection component1() {
                return this.connection;
            }

            @NotNull
            public final DataRequest.Context component2() {
                return this.context;
            }

            @NotNull
            public final ConnectionInfo copy(@NotNull InterruptibleDatabaseConnection connection2, @NotNull DataRequest.Context context) {
                Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                return new ConnectionInfo(connection2, context);
            }

            public static /* synthetic */ ConnectionInfo copy$default(ConnectionInfo connectionInfo, InterruptibleDatabaseConnection interruptibleDatabaseConnection, DataRequest.Context context, int n, Object object) {
                if ((n & 1) != 0) {
                    interruptibleDatabaseConnection = connectionInfo.connection;
                }
                if ((n & 2) != 0) {
                    context = connectionInfo.context;
                }
                return connectionInfo.copy(interruptibleDatabaseConnection, context);
            }

            @NotNull
            public String toString() {
                return "ConnectionInfo(connection=" + this.connection + ", context=" + this.context + ")";
            }

            public int hashCode() {
                int result2 = this.connection.hashCode();
                result2 = result2 * 31 + this.context.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionInfo)) {
                    return false;
                }
                ConnectionInfo connectionInfo = (ConnectionInfo)other;
                if (!Intrinsics.areEqual((Object)this.connection, (Object)connectionInfo.connection)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)connectionInfo.context));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "", "resource", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "engineLatch", "Ljava/util/concurrent/CountDownLatch;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;Ljava/util/concurrent/CountDownLatch;)V", "getEngineLatch", "()Ljava/util/concurrent/CountDownLatch;", "referenced", "", "getReferenced", "()I", "setReferenced", "(I)V", "getResource", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.database.connectivity"})
        private static final class ConnectionReference {
            @NotNull
            private final ConnectionInfo resource;
            @Nullable
            private final CountDownLatch engineLatch;
            private int referenced;

            public ConnectionReference(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.resource = resource;
                this.engineLatch = engineLatch;
            }

            public /* synthetic */ ConnectionReference(ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    countDownLatch = null;
                }
                this(connectionInfo, countDownLatch);
            }

            @NotNull
            public final ConnectionInfo getResource() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch getEngineLatch() {
                return this.engineLatch;
            }

            public final int getReferenced() {
                return this.referenced;
            }

            public final void setReferenced(int n) {
                this.referenced = n;
            }

            @NotNull
            public final ConnectionInfo component1() {
                return this.resource;
            }

            @Nullable
            public final CountDownLatch component2() {
                return this.engineLatch;
            }

            @NotNull
            public final ConnectionReference copy(@NotNull ConnectionInfo resource, @Nullable CountDownLatch engineLatch) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                return new ConnectionReference(resource, engineLatch);
            }

            public static /* synthetic */ ConnectionReference copy$default(ConnectionReference connectionReference, ConnectionInfo connectionInfo, CountDownLatch countDownLatch, int n, Object object) {
                if ((n & 1) != 0) {
                    connectionInfo = connectionReference.resource;
                }
                if ((n & 2) != 0) {
                    countDownLatch = connectionReference.engineLatch;
                }
                return connectionReference.copy(connectionInfo, countDownLatch);
            }

            @NotNull
            public String toString() {
                return "ConnectionReference(resource=" + this.resource + ", engineLatch=" + this.engineLatch + ")";
            }

            public int hashCode() {
                int result2 = this.resource.hashCode();
                result2 = result2 * 31 + (this.engineLatch == null ? 0 : this.engineLatch.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConnectionReference)) {
                    return false;
                }
                ConnectionReference connectionReference = (ConnectionReference)other;
                if (!Intrinsics.areEqual((Object)this.resource, (Object)connectionReference.resource)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.engineLatch, (Object)connectionReference.engineLatch);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.connectivity"})
        private static interface ConnectionsRouter {
            @Nullable
            public ConnectionReference getCurrent();

            public void save(@NotNull ConnectionReference var1);

            public void remove();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Lockpick;", "Lcom/intellij/database/util/GuardedRef;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionInfo;", "reference", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "router", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;)V", "getReference", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "close", "", "info", "intellij.database.connectivity"})
        private static final class Lockpick
        extends GuardedRef<ConnectionInfo> {
            @NotNull
            private final ConnectionReference reference;
            @NotNull
            private final ConnectionsRouter router;

            public Lockpick(@NotNull ConnectionReference reference, @NotNull ConnectionsRouter router) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                super(reference.getResource());
                this.reference = reference;
                this.router = router;
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + 1);
            }

            @NotNull
            public final ConnectionReference getReference() {
                return this.reference;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void close(@NotNull ConnectionInfo info2) {
                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                ConnectionReference connectionReference = this.reference;
                int n = connectionReference.getReferenced();
                connectionReference.setReferenced(n + -1);
                if (this.reference.getReferenced() != 0) {
                    return;
                }
                try {
                    this.router.remove();
                }
                finally {
                    CountDownLatch countDownLatch = this.reference.getEngineLatch();
                    if (countDownLatch != null) {
                        countDownLatch.countDown();
                    }
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "remove", "", "save", "reference", "intellij.database.connectivity"})
        private static final class MultipleSessionsRouter
        implements ConnectionsRouter {
            @NotNull
            public static final MultipleSessionsRouter INSTANCE = new MultipleSessionsRouter();
            @Nullable
            private static final ConnectionReference current;

            private MultipleSessionsRouter() {
            }

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return current;
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            }

            @Override
            public void remove() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Routers;", "", "multi", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;", "single", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$MultipleSessionsRouter;Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;)V", "choose", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.connectivity"})
        private static final class Routers {
            @NotNull
            private final MultipleSessionsRouter multi;
            @NotNull
            private final SingleSessionRouter single;

            public Routers(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                this.multi = multi;
                this.single = single;
            }

            @NotNull
            public final ConnectionsRouter choose(@NotNull LocalDataSource dataSource2) {
                Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                return dataSource2.isSingleConnection() ? (ConnectionsRouter)this.single : (ConnectionsRouter)this.multi;
            }

            private final MultipleSessionsRouter component1() {
                return this.multi;
            }

            private final SingleSessionRouter component2() {
                return this.single;
            }

            @NotNull
            public final Routers copy(@NotNull MultipleSessionsRouter multi, @NotNull SingleSessionRouter single) {
                Intrinsics.checkNotNullParameter((Object)multi, (String)"multi");
                Intrinsics.checkNotNullParameter((Object)single, (String)"single");
                return new Routers(multi, single);
            }

            public static /* synthetic */ Routers copy$default(Routers routers, MultipleSessionsRouter multipleSessionsRouter, SingleSessionRouter singleSessionRouter, int n, Object object) {
                if ((n & 1) != 0) {
                    multipleSessionsRouter = routers.multi;
                }
                if ((n & 2) != 0) {
                    singleSessionRouter = routers.single;
                }
                return routers.copy(multipleSessionsRouter, singleSessionRouter);
            }

            @NotNull
            public String toString() {
                return "Routers(multi=" + this.multi + ", single=" + this.single + ")";
            }

            public int hashCode() {
                int result2 = this.multi.hashCode();
                result2 = result2 * 31 + this.single.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Routers)) {
                    return false;
                }
                Routers routers = (Routers)other;
                if (!Intrinsics.areEqual((Object)this.multi, (Object)routers.multi)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.single, (Object)routers.single);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J'\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00030\u0005H&\u00a2\u0006\u0002\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "", "perform", "T", "work", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/InterruptibleDatabaseConnection;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.database.connectivity"})
        public static interface Runner {
            public <T> T perform(@NotNull Function1<? super InterruptibleDatabaseConnection, ? extends T> var1);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$SingleSessionRouter;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionsRouter;", "()V", "current", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "getCurrent", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$ConnectionReference;", "localRefs", "Ljava/lang/ThreadLocal;", "remove", "", "save", "reference", "intellij.database.connectivity"})
        private static final class SingleSessionRouter
        implements ConnectionsRouter {
            @NotNull
            private final ThreadLocal<ConnectionReference> localRefs = new ThreadLocal();

            @Override
            @Nullable
            public ConnectionReference getCurrent() {
                return this.localRefs.get();
            }

            @Override
            public void save(@NotNull ConnectionReference reference) {
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                this.localRefs.set(reference);
            }

            @Override
            public void remove() {
                this.localRefs.remove();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "", "()V", "singleConnection", "Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "chooseOneFor", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "intellij.database.connectivity"})
    private static final class Factories {
        @NotNull
        private final SingleConnection singleConnection = new SingleConnection(MultiConnection.INSTANCE);

        @NotNull
        public final Factory chooseOneFor(@NotNull LocalDataSource dataSource2, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return sessionType == SessionType.SERVICE || dataSource2.isSingleConnection() && sessionType == SessionType.NOT_IMPORTANT ? (Factory)this.singleConnection : (Factory)MultiConnection.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J6\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\rH&J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0003\u0010\f\u001a\u0004\u0018\u00010\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.connectivity"})
    public static interface Factory {
        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nls @Nullable String var3);

        public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, DatabaseConnectionPoint databaseConnectionPoint, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
            }
            if ((n & 4) != 0) {
                string = null;
            }
            return factory.instance(project, databaseConnectionPoint, string);
        }

        @NotNull
        public DatabaseSession instance(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nullable DatabaseCredentials var3, boolean var4, @Nls @Nullable String var5);

        public static /* synthetic */ DatabaseSession instance$default(Factory factory, Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instance");
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            return factory.instance(project, databaseConnectionPoint, databaseCredentials, bl, string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$Indexer;", "", "()V", "generateIndex", "", "sessions", "", "", "prefix", "(Ljava/util/List;Ljava/lang/String;)Ljava/lang/Long;", "retrieveIndex", "session", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Indexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,681:1\n2624#2,3:682\n1#3:685\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$Indexer\n*L\n637#1:682,3\n*E\n"})
    private static final class Indexer {
        @NotNull
        public static final Indexer INSTANCE = new Indexer();

        private Indexer() {
        }

        @Nullable
        public final Long generateIndex(@NotNull List<String> sessions2, @Nullable String prefix) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        Intrinsics.checkNotNullParameter(sessions2, (String)"sessions");
                        if (sessions2.isEmpty()) break block10;
                        if (prefix == null) break block11;
                        Iterable $this$none$iv = sessions2;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                String it2 = (String)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it2, (Object)prefix)) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) break block11;
                }
                return null;
            }
            List sortedSessions = CollectionsKt.sortedWith((Iterable)sessions2, Indexer::generateIndex$lambda$1);
            long index2 = 1L;
            for (String session2 : sortedSessions) {
                long idxOfSession = this.retrieveIndex(session2, prefix);
                if (idxOfSession == -1L) continue;
                if (idxOfSession == index2) {
                    long l = index2;
                    index2 = l + 1L;
                }
                if (idxOfSession <= index2) continue;
                return index2;
            }
            return index2;
        }

        public static /* synthetic */ Long generateIndex$default(Indexer indexer, List list, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return indexer.generateIndex(list, string);
        }

        private final long retrieveIndex(String session2, String prefix) {
            int idx;
            String it2 = session2;
            boolean bl = false;
            String string = prefix;
            char[] cArray = (string != null ? StringsKt.substringAfter$default((String)it2, (String)string, null, (int)2, null) : it2).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] title = cArray;
            for (idx = title.length - 1; idx > -1 && idx < title.length && Character.isDigit(title[idx]); --idx) {
            }
            int shift = prefix != null && StringsKt.startsWith$default((String)session2, (String)prefix, (boolean)false, (int)2, null) ? prefix.length() : 0;
            String string2 = session2.substring(shift + idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String numericSuffix = string2;
            Long l = StringsKt.toLongOrNull((String)numericSuffix);
            return l != null ? l : -1L;
        }

        private static final int generateIndex$lambda$1(String s1, String s2) {
            return StringUtil.naturalCompare((String)s1, (String)s2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$MultiConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "()V", "instance", "Lcom/intellij/database/console/session/DatabaseSession;", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.connectivity"})
    private static final class MultiConnection
    implements Factory {
        @NotNull
        public static final MultiConnection INSTANCE = new MultiConnection();

        private MultiConnection() {
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, connectionPoint);
            }
            String resultTitle = string;
            return new MessageBusSession(project, connectionPoint, new MessageBusSession.NaturalKernel(project, resultTitle, connectionPoint, null, false), resultTitle);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            String string = title;
            if (string == null) {
                string = INSTANCE.generateNameForSession(project, connectionPoint);
            }
            String resultTitle = string;
            return new MessageBusSession(project, connectionPoint, new MessageBusSession.NaturalKernel(project, resultTitle, connectionPoint, credentialsStore, silent), resultTitle);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J>\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u001f\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u000b2\u0006\u0010\u001f\u001a\u0002H\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factories;", "sessions", "", "Lcom/intellij/database/console/session/DatabaseSession;", "getSessions", "()Ljava/util/Set;", "dispose", "", "getFactories", "dataSource", "getSession", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "sessionType", "Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "index", "T", "session", "(Lcom/intellij/database/console/session/DatabaseSession;)Lcom/intellij/database/console/session/DatabaseSession;", "remember", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDatabaseSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,681:1\n372#2,7:682\n*S KotlinDebug\n*F\n+ 1 DatabaseSessionManager.kt\ncom/intellij/database/console/session/DatabaseSessionManager$ProjectSessions\n*L\n193#1:682,7\n*E\n"})
    private static final class ProjectSessions
    implements Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<LocalDataSource, Factories> map;
        @NotNull
        private final Set<DatabaseSession> sessions;

        public ProjectSessions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.map = new HashMap();
            Set set = ConcurrentCollectionFactory.createConcurrentSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
            this.sessions = set;
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
            Topic<DataSourceStorage.Listener> topic = DataSourceStorage.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new DataSourceStorage.Listener(){

                @Override
                public void dataSourceRemoved(@NotNull LocalDataSource dataSource2) {
                    Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
                    INSTANCE.onEdt((Function0)new Function0<Factories>(this, dataSource2){
                        final /* synthetic */ ProjectSessions this$0;
                        final /* synthetic */ LocalDataSource $dataSource;
                        {
                            this.this$0 = $receiver;
                            this.$dataSource = $dataSource;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final Factories invoke() {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Iterable iterable = this.this$0.getSessions();
                            LocalDataSource localDataSource = this.$dataSource;
                            boolean $i$f$filter = false;
                            void var4_6 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                DatabaseSession it2 = (DatabaseSession)element$iv$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it2.getTarget(), (Object)localDataSource)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$forEach$iv = (List)destination$iv$iv;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                DatabaseSession it3 = (DatabaseSession)element$iv;
                                boolean bl = false;
                                SessionsUtil.close(it3);
                            }
                            return (Factories)ProjectSessions.access$getMap$p(this.this$0).remove(this.$dataSource);
                        }
                    });
                }
            });
        }

        @NotNull
        public final Set<DatabaseSession> getSessions() {
            return this.sessions;
        }

        @NotNull
        public final DatabaseSession getSession(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nls @Nullable String title, @NotNull SessionType sessionType) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            Intrinsics.checkNotNullParameter((Object)((Object)sessionType), (String)"sessionType");
            return (DatabaseSession)INSTANCE.onEdt((Function0)new Function0<DatabaseSession>(this, connectionPoint, sessionType, project, credentialsStore, silent, title){
                final /* synthetic */ ProjectSessions this$0;
                final /* synthetic */ DatabaseConnectionPoint $connectionPoint;
                final /* synthetic */ SessionType $sessionType;
                final /* synthetic */ Project $project;
                final /* synthetic */ DatabaseCredentials $credentialsStore;
                final /* synthetic */ boolean $silent;
                final /* synthetic */ String $title;
                {
                    this.this$0 = $receiver;
                    this.$connectionPoint = $connectionPoint;
                    this.$sessionType = $sessionType;
                    this.$project = $project;
                    this.$credentialsStore = $credentialsStore;
                    this.$silent = $silent;
                    this.$title = $title;
                    super(0);
                }

                @NotNull
                public final DatabaseSession invoke() {
                    LocalDataSource localDataSource = this.$connectionPoint.getDataSource();
                    Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                    Factories factories = ProjectSessions.access$getFactories(this.this$0, localDataSource);
                    LocalDataSource localDataSource2 = this.$connectionPoint.getDataSource();
                    Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"getDataSource(...)");
                    return ProjectSessions.access$remember(this.this$0, ProjectSessions.access$index(this.this$0, factories.chooseOneFor(localDataSource2, this.$sessionType).instance(this.$project, this.$connectionPoint, this.$credentialsStore, this.$silent, this.$title)));
                }
            });
        }

        public static /* synthetic */ DatabaseSession getSession$default(ProjectSessions projectSessions, Project project, DatabaseConnectionPoint databaseConnectionPoint, DatabaseCredentials databaseCredentials, boolean bl, String string, SessionType sessionType, int n, Object object) {
            if ((n & 0x20) != 0) {
                sessionType = SessionType.NOT_IMPORTANT;
            }
            return projectSessions.getSession(project, databaseConnectionPoint, databaseCredentials, bl, string, sessionType);
        }

        public void dispose() {
        }

        private final DatabaseSession remember(DatabaseSession session2) {
            if (this.sessions.contains(session2)) {
                return session2;
            }
            Disposer.register((Disposable)session2, () -> ProjectSessions.remember$lambda$0(this, session2));
            ((Collection)this.sessions).add(session2);
            ((DatabaseSessionManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionOpened(session2);
            return session2;
        }

        private final Factories getFactories(LocalDataSource dataSource2) {
            Factories factories;
            Map<LocalDataSource, Factories> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            Factories value$iv = $this$getOrPut$iv.get(dataSource2);
            if (value$iv == null) {
                boolean bl = false;
                Factories answer$iv = new Factories();
                $this$getOrPut$iv.put(dataSource2, answer$iv);
                factories = answer$iv;
            } else {
                factories = value$iv;
            }
            return factories;
        }

        private final <T extends DatabaseSession> T index(T session2) {
            if (this.sessions.contains(session2)) {
                return session2;
            }
            Disposer.register((Disposable)this, (Disposable)session2);
            return session2;
        }

        private static final void remember$lambda$0(ProjectSessions this$0, DatabaseSession $session) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
            ((Collection)this$0.sessions).remove($session);
            ((DatabaseSessionManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DatabaseSessionManager.getTopic())).sessionClosed($session);
        }

        public static final /* synthetic */ DatabaseSession access$remember(ProjectSessions $this, DatabaseSession session2) {
            return $this.remember(session2);
        }

        public static final /* synthetic */ DatabaseSession access$index(ProjectSessions $this, DatabaseSession session2) {
            return $this.index(session2);
        }

        public static final /* synthetic */ Factories access$getFactories(ProjectSessions $this, LocalDataSource dataSource2) {
            return $this.getFactories(dataSource2);
        }

        public static final /* synthetic */ Map access$getMap$p(ProjectSessions $this) {
            return $this.map;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SessionType;", "", "(Ljava/lang/String;I)V", "SERVICE", "NOT_IMPORTANT", "NEW", "intellij.database.connectivity"})
    public static final class SessionType
    extends Enum<SessionType> {
        public static final /* enum */ SessionType SERVICE = new SessionType();
        public static final /* enum */ SessionType NOT_IMPORTANT = new SessionType();
        public static final /* enum */ SessionType NEW = new SessionType();
        private static final /* synthetic */ SessionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SessionType[] values() {
            return (SessionType[])$VALUES.clone();
        }

        public static SessionType valueOf(String value2) {
            return Enum.valueOf(SessionType.class, value2);
        }

        @NotNull
        public static EnumEntries<SessionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sessionTypeArray = new SessionType[]{SessionType.SERVICE, SessionType.NOT_IMPORTANT, SessionType.NEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$SingleConnection;", "Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;", "honestFactory", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Factory;)V", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "instance", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "credentialsStore", "Lcom/intellij/database/access/DatabaseCredentials;", "silent", "", "title", "", "intellij.database.connectivity"})
    private static final class SingleConnection
    implements Factory {
        @NotNull
        private final Factory honestFactory;
        @Nullable
        private DatabaseSession session;

        public SingleConnection(@NotNull Factory honestFactory) {
            Intrinsics.checkNotNullParameter((Object)honestFactory, (String)"honestFactory");
            this.honestFactory = honestFactory;
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            return this.session(project, connectionPoint, null, false);
        }

        @Override
        @NotNull
        public DatabaseSession instance(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseCredentials credentialsStore, boolean silent, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
            return this.session(project, connectionPoint, credentialsStore, silent);
        }

        private final DatabaseSession session(Project project, DatabaseConnectionPoint connectionPoint, DatabaseCredentials credentialsStore, boolean silent) {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.session == null) {
                DatabaseSession databaseSession = this.session = this.honestFactory.instance(project, connectionPoint, credentialsStore, silent, "");
                Intrinsics.checkNotNull((Object)databaseSession);
                Disposer.register((Disposable)databaseSession, () -> SingleConnection.session$lambda$0(this));
            }
            DatabaseSession databaseSession = this.session;
            Intrinsics.checkNotNull((Object)databaseSession);
            return databaseSession;
        }

        private static final void session$lambda$0(SingleConnection this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            INSTANCE.onEdt((Function0)new Function0<Unit>(this$0){
                final /* synthetic */ SingleConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    SingleConnection.access$setSession$p(this.this$0, null);
                }
            });
        }

        public static final /* synthetic */ void access$setSession$p(SingleConnection $this, DatabaseSession databaseSession) {
            $this.session = databaseSession;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J\b\u0010(\u001a\u00020\u0011H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u000bH\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020\u000bH\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0010\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020+H\u0016J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$TemporaryClient;", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "Lcom/intellij/database/datagrid/DataRequest$CustomSearchPathOwner;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "path", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/database/console/session/DatabaseSession;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Lcom/intellij/database/util/SearchPath;)V", "disposed", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "messageBus", "Lcom/intellij/database/DataBus$Consuming;", "kotlin.jvm.PlatformType", "getSession", "()Lcom/intellij/database/console/session/DatabaseSession;", "showOnActivity", "getShowOnActivity", "()Z", "title", "", "getTitle", "()Ljava/lang/String;", "detached", "", "trigger", "Lcom/intellij/database/console/client/DatabaseSessionClient$DetachTrigger;", "dispose", "focusOnError", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getCurrentTx", "Lcom/intellij/database/datagrid/DataRequest$TxMarker;", "getDepartment", "getDisplayName", "getMessageBus", "getSearchPath", "getTxIsolation", "", "isActive", "isEphemeral", "isValid", "setAutoCommit", "autoCommit", "setTxIsolation", "isolation", "showOnAttention", "intellij.database.connectivity"})
    private static final class TemporaryClient
    implements VisibleDatabaseSessionClient,
    DataRequest.CustomSearchPathOwner {
        @NotNull
        private final DatabaseSession session;
        @NotNull
        private final DatabaseDepartment department;
        @Nullable
        private final SearchPath path;
        @NotNull
        private final String title;
        private volatile boolean disposed;
        private final DataBus.Consuming messageBus;

        public TemporaryClient(@NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @Nullable SearchPath path) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)department, (String)"department");
            this.session = session2;
            this.department = department;
            this.path = path;
            this.title = this.department.getDepartmentName();
            this.messageBus = this.getSession().getMessageBus().filterFor(this);
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.department.getIcon();
        }

        @Override
        public boolean getShowOnActivity() {
            return false;
        }

        @Override
        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Override
        public int getTxIsolation() {
            return this.getSession().getTxIsolation();
        }

        @Override
        public void setTxIsolation(int isolation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean showOnAttention(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            return false;
        }

        @Override
        public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger2) {
            Intrinsics.checkNotNullParameter((Object)((Object)trigger2), (String)"trigger");
        }

        @Override
        public boolean focusOnError(@NotNull DataRequest.Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            return false;
        }

        @Override
        public boolean isActive() {
            return !this.disposed;
        }

        @Override
        public boolean isValid() {
            return !this.disposed;
        }

        @Override
        @NotNull
        public DatabaseDepartment getDepartment() {
            return this.department;
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.path;
        }

        @Override
        @NotNull
        public DataRequest.TxMarker getCurrentTx() {
            DataRequest.TxMarker txMarker = this.getSession().getCurrentTx();
            Intrinsics.checkNotNullExpressionValue((Object)txMarker, (String)"getCurrentTx(...)");
            return txMarker;
        }

        @NotNull
        public String getDisplayName() {
            return this.getTitle();
        }

        @Override
        @NotNull
        public DataBus.Consuming getMessageBus() {
            DataBus.Consuming consuming = this.messageBus;
            Intrinsics.checkNotNullExpressionValue((Object)consuming, (String)"messageBus");
            return consuming;
        }

        @Override
        public boolean isEphemeral() {
            return true;
        }

        @Override
        public void setAutoCommit(boolean autoCommit) {
            this.getSession().setAutoCommit(autoCommit);
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u001d\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u001aR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bR\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest;", "T", "Lcom/intellij/database/datagrid/DataRequest$RawRequest;", "owner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "errorHandler", "Lcom/intellij/database/util/ErrorHandler;", "(Lcom/intellij/database/datagrid/DataRequest$OwnerEx;Lkotlinx/coroutines/CancellableContinuation;Lcom/intellij/database/util/ErrorHandler;)V", "auditor", "Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "getAuditor", "()Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "getCont", "()Lkotlinx/coroutines/CancellableContinuation;", "getOwner", "process", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "(Lcom/intellij/database/datagrid/DataRequest$Context;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)Ljava/lang/Object;", "processRaw", "", "submit", "", "TemporaryAuditor", "intellij.database.connectivity"})
    private static abstract class WrapperRequest<T>
    extends DataRequest.RawRequest {
        @NotNull
        private final CancellableContinuation<T> cont;
        @NotNull
        private final TemporaryAuditor<T> auditor;

        public WrapperRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CancellableContinuation<? super T> cont, @Nullable ErrorHandler errorHandler) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(cont, (String)"cont");
            super(owner);
            this.cont = cont;
            this.auditor = new TemporaryAuditor(errorHandler);
        }

        @NotNull
        public final CancellableContinuation<T> getCont() {
            return this.cont;
        }

        @NotNull
        public final TemporaryAuditor<T> getAuditor() {
            return this.auditor;
        }

        public abstract T process(@NotNull DataRequest.Context var1, @NotNull DatabaseConnectionCore var2);

        @Override
        public final void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            if (this.auditor.hasErrors()) {
                return;
            }
            try {
                this.cont.resume(this.process(context, connection2), null);
            }
            catch (InterruptedException e2) {
                CancellableContinuation.DefaultImpls.cancel$default(this.cont, null, (int)1, null);
                throw new ProcessCanceledException((Throwable)e2);
            }
            catch (ProcessCanceledException e3) {
                CancellableContinuation.DefaultImpls.cancel$default(this.cont, null, (int)1, null);
                throw e3;
            }
            catch (Throwable t) {
                ((Continuation)this.cont).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
                throw new ProcessCanceledException(t);
            }
        }

        @Override
        @NotNull
        public DataRequest.OwnerEx getOwner() {
            DataRequest.Owner owner = super.getOwner();
            Intrinsics.checkNotNull((Object)owner, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.DataRequest.OwnerEx");
            return (DataRequest.OwnerEx)owner;
        }

        public final boolean submit() {
            this.getOwner().getMessageBus().addAuditor(this.auditor);
            this.getOwner().getMessageBus().getDataProducer().processRequest((GridDataRequest)this);
            return this.auditor.getSubmitted();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest$TemporaryAuditor;", "T", "Lcom/intellij/database/datagrid/DataAuditor;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "(Lcom/intellij/database/console/session/DatabaseSessionManager$WrapperRequest;Lcom/intellij/database/util/ErrorHandler;)V", "connected", "", "submitted", "getSubmitted", "()Z", "setSubmitted", "(Z)V", "wasError", "error", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "errorInfo", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "hasErrors", "isMy", "request", "Lcom/intellij/database/datagrid/DataRequest;", "jobFinished", "producer", "Lcom/intellij/database/datagrid/DataProducer;", "jobSubmitted", "intellij.database.connectivity"})
        private final class TemporaryAuditor<T>
        implements DataAuditor {
            @Nullable
            private final ErrorHandler handler;
            private volatile boolean connected;
            private volatile boolean wasError;
            private boolean submitted;

            public TemporaryAuditor(ErrorHandler handler2) {
                this.handler = handler2;
            }

            public final boolean getSubmitted() {
                return this.submitted;
            }

            public final void setSubmitted(boolean bl) {
                this.submitted = bl;
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
                Intrinsics.checkNotNullParameter((Object)errorInfo, (String)"errorInfo");
                DataRequest dataRequest = context.request;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dataRequest), (String)"request");
                if (!this.isMy(dataRequest)) {
                    return;
                }
                ErrorHandler errorHandler = this.handler;
                if (errorHandler != null) {
                    errorHandler.add(errorInfo);
                }
                this.wasError = true;
                if (this.connected) {
                    return;
                }
                if (this.handler != null) {
                    CancellableContinuation.DefaultImpls.cancel$default(WrapperRequest.this.getCont(), null, (int)1, null);
                } else {
                    Continuation continuation = (Continuation)WrapperRequest.this.getCont();
                    Throwable throwable = ThrowableInfoUtil.getActualThrowable((ThrowableInfo)((ThrowableInfo)errorInfo));
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"getActualThrowable(...)");
                    Throwable throwable2 = throwable;
                    continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2)));
                }
            }

            public final boolean hasErrors() {
                this.connected = true;
                return this.wasError;
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
                Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                if (!this.isMy(request2)) {
                    return;
                }
                this.submitted = true;
            }

            @Override
            public void jobFinished(@NotNull DataRequest request2, @NotNull DataProducer producer) {
                Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
                Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
                if (this.isMy(request2) && !WrapperRequest.this.getCont().isCompleted()) {
                    CancellableContinuation.DefaultImpls.cancel$default(WrapperRequest.this.getCont(), null, (int)1, null);
                }
            }

            private final boolean isMy(DataRequest request2) {
                return Intrinsics.areEqual(WrapperRequest.this, (Object)((Object)request2));
            }
        }
    }
}

