/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.database.datagrid.ObjectNormalizerProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationResultFetcher {
    protected final DbDataSource mySource;
    protected final Project myProject;
    private final List<GridRow> myRows;
    private final List<? extends GridColumn> myColumns;
    private final DataRequest.OwnerEx myOwnerEx;
    private final String myQuery;
    private final AtomicReference<GridDataRequest> myCurrentRequest;
    private boolean myLoaded;
    private int myFetched;
    private long myCount;

    EvaluationResultFetcher(@NotNull List<GridRow> rows, @NotNull List<? extends GridColumn> columns2, @NotNull Project project, @NotNull DataRequest.OwnerEx ex, @NotNull DbDataSource source, @NotNull String query, boolean loaded2) {
        if (rows == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(0);
        }
        if (columns2 == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(1);
        }
        if (project == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(2);
        }
        if (ex == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(3);
        }
        if (source == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(4);
        }
        if (query == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(5);
        }
        this.myRows = rows;
        this.myColumns = columns2;
        this.myProject = project;
        this.myOwnerEx = ex;
        this.mySource = source;
        this.myQuery = query;
        this.myLoaded = loaded2;
        this.myCurrentRequest = new AtomicReference();
        this.myCount = -1L;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.mySource.getDbms();
        if (dbms == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public List<? extends GridRow> getRows() {
        List list = ContainerUtil.getFirstItems(this.myRows, (int)this.myFetched);
        if (list == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(8);
        }
        return list;
    }

    public long getRowCount() {
        return this.myLoaded || this.myCount == -1L ? (long)this.myRows.size() : this.myCount;
    }

    public boolean isRowCountPrecise() {
        return this.myCount != -1L || this.myLoaded;
    }

    public int getFetchSize() {
        return DatabaseSettings.getSettings().previewRows;
    }

    @NotNull
    public List<? extends GridColumn> getColumns() {
        List<? extends GridColumn> list = this.myColumns;
        if (list == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void fetchCached() {
        this.fetchCached(null);
    }

    public void fetch(@NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(10);
        }
        if (this.isBusy(callback) || this.fetchCached(callback)) {
            return;
        }
        RowsLoadRequest request2 = this.resetStateOnProcessed(new RowsLoadRequest(this.myOwnerEx, this.getQuery(this.myFetched, EvaluationResultFetcher.getBatchSize()), this.myFetched, EvaluationResultFetcher.getBatchSize()));
        this.myCurrentRequest.set(request2);
        request2.getPromise().onProcessed(v2 -> DbUIUtil.invokeLaterIfNeeded(() -> {
            this.myFetched = Math.min(this.myFetched + this.getFetchSize(), this.myRows.size());
            callback.run();
        }));
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
    }

    public void count(final @NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(11);
        }
        if (this.isBusy(callback)) {
            return;
        }
        this.myCurrentRequest.set(this.resetStateOnProcessed(new DataRequest.RawRequest(this.myOwnerEx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) throws Exception {
                try {
                    String t = DbImplUtil.findFreeAlias(EvaluationResultFetcher.this.myProject, EvaluationResultFetcher.this.mySource.getDbms(), EvaluationResultFetcher.this.myQuery, "t");
                    String query = EvaluationResultFetcher.this.getCountQuery(t);
                    if (query != null) {
                        EvaluationResultFetcher.this.myCount = DbImplUtilCore.getRowCount(connection2, query);
                    }
                }
                finally {
                    DbUIUtil.invokeLaterIfNeeded(callback);
                }
            }
        }));
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest(this.myCurrentRequest.get());
    }

    @NotNull
    protected String getQuery(int start2, int load) {
        String string = this.myQuery;
        if (string == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    protected String getCountQuery(@NotNull String alias) {
        if (alias == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(13);
        }
        WrapInSelectTask task = DmlTaskKt.wrapInSelect(this.myQuery, this.myProject).countAll().version(this.mySource.getVersion()).alias(alias).build(DbImplUtil.createBuilderForUIExec(this.mySource.getDbms(), (DasObject)this.mySource));
        WrapInSelectResult result2 = DmlUtilKt.dmlGenerator(this.mySource.getDbms()).generate(task);
        return result2 == null ? null : result2.getStatement();
    }

    public boolean canFetch() {
        return this.myRows.size() > this.myFetched || !this.myLoaded;
    }

    public boolean isBusy() {
        return this.myCurrentRequest.get() != null;
    }

    private boolean fetchCached(@Nullable Runnable callback) {
        if (this.myFetched < this.myRows.size() || this.myLoaded) {
            this.myFetched = Math.min(this.myFetched + this.getFetchSize(), this.myRows.size());
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        return false;
    }

    private boolean isBusy(@NotNull Runnable callback) {
        if (callback == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(14);
        }
        if (this.isBusy()) {
            callback.run();
            return true;
        }
        return false;
    }

    @NotNull
    private <T extends GridDataRequest> T resetStateOnProcessed(@NotNull T request2) {
        if (request2 == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(15);
        }
        request2.getPromise().onProcessed(v2 -> this.myCurrentRequest.set(null));
        T t = request2;
        if (t == null) {
            EvaluationResultFetcher.$$$reportNull$$$0(16);
        }
        return t;
    }

    public static int getBatchSize() {
        return DatabaseSettings.getSettings().previewRows * 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/EvaluationResultFetcher";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationResultFetcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resetStateOnProcessed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCountQuery";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBusy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetStateOnProcessed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 12, 16 -> new IllegalStateException(string);
        };
    }

    protected class RowsLoadRequest
    extends DataRequest.IsolatedQueryRequest {
        private int myCount;
        private final Function<// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull GridDataRequest.Context, @NotNull ObjectNormalizer> myCache;

        protected RowsLoadRequest(@NotNull DataRequest.OwnerEx owner, String query, int loaded2, int toLoad) {
            if (owner == null) {
                RowsLoadRequest.$$$reportNull$$$0(0);
            }
            if (query == null) {
                RowsLoadRequest.$$$reportNull$$$0(1);
            }
            super(owner, query, DataRequest.newConstraints(loaded2, toLoad, 0, 0, 0), null);
            this.myCache = ObjectNormalizerProvider.getCache();
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            if (context == null) {
                RowsLoadRequest.$$$reportNull$$$0(2);
            }
            if (rows == null) {
                RowsLoadRequest.$$$reportNull$$$0(3);
            }
            ObjectNormalizer.convertRows((ObjectNormalizer)((ObjectNormalizer)this.myCache.fun((Object)context)), rows, EvaluationResultFetcher.this.myColumns);
            EvaluationResultFetcher.this.myRows.addAll(rows);
            this.myCount += rows.size();
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            if (context == null) {
                RowsLoadRequest.$$$reportNull$$$0(4);
            }
            EvaluationResultFetcher.this.myLoaded = total <= EvaluationResultFetcher.this.myRows.size();
        }

        public int getCount() {
            return this.myCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

