/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.ConsoleLogger;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002BCB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u001b\u0010\u0018\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J(\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0001H\u0007J8\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001a\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a0\"JE\u0010#\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001a\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a0\"J8\u0010#\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001a\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a0\"JH\u0010$\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001a\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a0\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014JH\u0010(\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010\u001c2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014H\u0002J8\u0010,\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u001a\u0010!\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a0\"J-\u0010-\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u000b\u00101\u001a\u00070\u000b\u00a2\u0006\u0002\b2H\u0002JL\u00103\u001a\u00020 2\u0006\u00104\u001a\u0002052\n\u00106\u001a\u0006\u0012\u0002\b\u0003072\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020\u00042\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<H\u0002J6\u0010>\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u001b2\b\u0010?\u001a\u0004\u0018\u00010\u001c2\n\u00106\u001a\u0006\u0012\u0002\b\u0003072\u0006\u0010%\u001a\u00020&H\u0007JO\u0010@\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0<2\u0006\u0010A\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/database/console/RunSqlScriptAction;", "", "()V", "BATCH_MAX_LENGTH", "", "BATCH_MAX_SIZE", "addConsole", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "taskName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "files", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vfs/VirtualFile;", "rerunRunnable", "Ljava/lang/Runnable;", "indicatorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getTargetElement", "Lcom/intellij/database/psi/DbElement;", "file", "getTaskName", "makeTargetPair", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/util/ObjectPath;", "source", "object", "patchDialects", "", "targets", "", "perform", "performImpl", "reporter", "Lcom/intellij/database/datagrid/DataAuditors$PrintingAdapter;", "indicator", "performStepImpl", "dataSource", "startDestination", "progressMultiplier", "prepare", "reportAndLog", "logger", "messageType", "Lcom/intellij/openapi/ui/MessageType;", "message", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "runScript", "r", "Lcom/intellij/database/console/RunSqlScriptAction$Runner;", "scriptModel", "Lcom/intellij/database/script/ScriptModel;", "progress", "counter", "", "doneAnything", "Lcom/intellij/openapi/util/Ref;", "", "runStatements", "destination", "runWithConsole", "runnable", "Runner", "StatementConsumer", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nRunSqlScriptAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunSqlScriptAction.kt\ncom/intellij/database/console/RunSqlScriptAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n1726#2,3:562\n*S KotlinDebug\n*F\n+ 1 RunSqlScriptAction.kt\ncom/intellij/database/console/RunSqlScriptAction\n*L\n261#1:562,3\n*E\n"})
public final class RunSqlScriptAction {
    @NotNull
    public static final RunSqlScriptAction INSTANCE = new RunSqlScriptAction();
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MAX_LENGTH = 512000;

    private RunSqlScriptAction() {
    }

    private final String getTaskName(JBIterable<VirtualFile> files2) {
        String string = files2.size() == 1 ? ((VirtualFile)files2.iterator().next()).getName() : files2.size() + " files";
        Intrinsics.checkNotNull((Object)string);
        String title = string;
        Object[] objectArray = new Object[]{StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20))};
        String string2 = DatabaseBundle.message("tab.title.run", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    public final void perform(@NotNull Project project, @NotNull JBIterable<VirtualFile> files2, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targets2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        this.perform(project, this.getTaskName(files2), files2, targets2);
    }

    public final void perform(@NotNull Project project, @NotNull String taskName, @NotNull JBIterable<VirtualFile> files2, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targets2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Ref reporter = Ref.create(null);
        AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Intrinsics.checkNotNull((Object)reporter);
        this.runWithConsole(project, taskName, files2, indicatorRef, (Ref<DataAuditors.PrintingAdapter>)reporter, () -> RunSqlScriptAction.perform$lambda$0(project, files2, targets2, taskName, indicatorRef, reporter));
    }

    private final void runWithConsole(Project project, String taskName, JBIterable<VirtualFile> files2, AtomicReference<ProgressIndicator> indicatorRef, Ref<DataAuditors.PrintingAdapter> reporter, Runnable runnable) {
        ConsoleView consoleView = this.addConsole(project, taskName, files2, runnable, indicatorRef);
        reporter.set((Object)new ConsoleLogger(consoleView));
        runnable.run();
    }

    public final void performImpl(@NotNull Project project, @NotNull JBIterable<VirtualFile> files2, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targets2, @NotNull DataAuditors.PrintingAdapter reporter, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setFraction(0.0);
        indicator.setIndeterminate(false);
        for (Pair<LocalDataSource, ObjectPath> pair : targets2) {
            try {
                Object object = pair.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                this.performStepImpl(project, (LocalDataSource)object, (ObjectPath)pair.second, files2, targets2.size(), reporter, indicator);
            }
            catch (ProcessCanceledException pce) {
                indicator.checkCanceled();
            }
        }
    }

    private final void performStepImpl(Project project, LocalDataSource dataSource2, ObjectPath startDestination, JBIterable<VirtualFile> files2, int progressMultiplier, DataAuditors.PrintingAdapter reporter, ProgressIndicator indicator) {
        Language language = DbSqlUtilCore.getLanguage(dataSource2);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        ObjectPath objectPath = startDestination;
        if (objectPath == null) {
            VirtualFile virtualFile = (VirtualFile)files2.single();
            if (virtualFile != null) {
                VirtualFile it2 = virtualFile;
                boolean bl = false;
                objectPath = ObjectPaths.of(INSTANCE.getTargetElement(project, it2));
            } else {
                objectPath = null;
            }
        }
        ObjectPath destination = objectPath;
        Runner r = new Runner(project, dataSource2, destination, reporter);
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        Object[] objectArray = new Object[3];
        objectArray[0] = dataSource2.getName();
        Object object = destination;
        if (object == null || (object = ((ObjectPath)object).getDisplayName()) == null) {
            object = "";
        }
        objectArray[1] = object;
        objectArray[2] = destination != null ? 0 : 1;
        String string = DatabaseBundle.message("notification.content.connecting.to.choice", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.reportAndLog(project, reporter, messageType, string);
        Ref ref2 = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref2, (String)"create(...)");
        Ref doneAnything = ref2;
        r.withConnected(() -> RunSqlScriptAction.performStepImpl$lambda$5(indicator, r, reporter, files2, project, progressMultiplier, doneAnything, dataSource2, language2));
    }

    public final void prepare(@NotNull Project project, @NotNull JBIterable<VirtualFile> files2, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targets2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] virtualFileArray = (VirtualFile[])files2.toArray((Object[])VirtualFile.EMPTY_ARRAY);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        this.patchDialects(project, files2, targets2);
    }

    public final void patchDialects(@NotNull Project project, @NotNull JBIterable<VirtualFile> files2, @NotNull List<? extends Pair<LocalDataSource, ObjectPath>> targets2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        SqlPsiFacade sqlPsiFacade2 = sqlPsiFacade;
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet((Iterable)((Iterable)JBIterable.from((Iterable)targets2).transform(arg_0 -> RunSqlScriptAction.patchDialects$lambda$6(patchDialects.preferredDialects.1.INSTANCE, arg_0))));
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"newLinkedHashSet(...)");
        Set preferredDialects2 = linkedHashSet;
        SqlLanguageDialect sqlLanguageDialect = SqlDialects.getGenericDialect();
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getGenericDialect(...)");
        SqlLanguageDialect genericDialect = sqlLanguageDialect;
        preferredDialects2.remove(genericDialect);
        SqlLanguageDialect preferredDialect = (SqlLanguageDialect)CollectionsKt.firstOrNull((Iterable)preferredDialects2);
        if (preferredDialect == null) {
            return;
        }
        List list = files2.filter(arg_0 -> RunSqlScriptAction.patchDialects$lambda$7((Function1)new Function1<VirtualFile, Boolean>((Set<SqlLanguageDialect>)preferredDialects2, project){
            final /* synthetic */ Set<SqlLanguageDialect> $preferredDialects;
            final /* synthetic */ Project $project;
            {
                this.$preferredDialects = $preferredDialects;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@Nullable VirtualFile file) {
                return !CollectionsKt.contains((Iterable)this.$preferredDialects, (Object)LanguageUtil.getLanguageForPsi((Project)this.$project, (VirtualFile)file));
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List remapDialect2 = list;
        if (!remapDialect2.isEmpty()) {
            WriteAction.run(() -> RunSqlScriptAction.patchDialects$lambda$8(remapDialect2, sqlPsiFacade2, preferredDialect));
        }
    }

    @JvmStatic
    @Nullable
    public static final Pair<LocalDataSource, ObjectPath> makeTargetPair(@NotNull LocalDataSource source, @NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        return object == source ? Pair.create((Object)source, null) : (object instanceof DasObject ? Pair.create((Object)source, (Object)ObjectPaths.of((DasObject)object)) : null);
    }

    private final DbElement getTargetElement(Project project, VirtualFile file) {
        return DbImplUtilCore.findElement(project, file);
    }

    private final void reportAndLog(Project project, DataAuditors.PrintingAdapter logger2, MessageType messageType, String message2) {
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message2, messageType).notify(project);
        ConsoleViewContentType contentType = Intrinsics.areEqual((Object)messageType, (Object)MessageType.ERROR) ? ConsoleViewContentType.ERROR_OUTPUT : (Intrinsics.areEqual((Object)messageType, (Object)MessageType.WARNING) ? ConsoleViewContentType.LOG_WARNING_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
        logger2.println(message2, contentType);
    }

    private final ConsoleView addConsole(Project project, String taskName, JBIterable<VirtualFile> files2, Runnable rerunRunnable, AtomicReference<ProgressIndicator> indicatorRef) {
        ConsoleView consoleView = DbUIUtil.addConsole(project, taskName, () -> RunSqlScriptAction.addConsole$lambda$10(files2), rerunRunnable, indicatorRef);
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"addConsole(...)");
        return consoleView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void runStatements(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath destination, @NotNull ScriptModel<?> scriptModel, @NotNull DataAuditors.PrintingAdapter reporter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter(scriptModel, (String)"scriptModel");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ProgressIndicator progress = (ProgressIndicator)new EmptyProgressIndicator();
        long[] counter = new long[3];
        try {
            Runner r = new Runner(project, dataSource2, destination, reporter);
            r.withConnected(() -> RunSqlScriptAction.runStatements$lambda$11(progress, r, reporter, scriptModel, counter));
        }
        finally {
            Disposer.dispose((Disposable)scriptModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runScript(Runner r, ScriptModel<?> scriptModel, DataAuditors.PrintingAdapter reporter, ProgressIndicator progress, long[] counter, int progressMultiplier, Ref<Boolean> doneAnything) {
        try {
            VirtualFile virtualFile = scriptModel.getVirtualFile();
            long fileSize = virtualFile.getLength();
            float averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
            counter[2] = 0L;
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.createValue(RunSqlScriptAction::runScript$lambda$12);
            Intrinsics.checkNotNullExpressionValue((Object)notNullLazyValue, (String)"createValue(...)");
            NotNullLazyValue dmlSet = notNullLazyValue;
            StatementConsumer consumer2 = new StatementConsumer(r);
            for (JBIterable itGroup : scriptModel.statements().split(JBIterable.Split.GROUP, arg_0 -> RunSqlScriptAction.runScript$lambda$13((Function1)new Function1<ScriptModel.StatementIt<?>, Boolean>((NotNullLazyValue<TokenSet>)dmlSet){
                final /* synthetic */ NotNullLazyValue<TokenSet> $dmlSet;
                {
                    this.$dmlSet = $dmlSet;
                    super(1, Intrinsics.Kotlin.class, "notDml", "runScript$notDml(Lcom/intellij/openapi/util/NotNullLazyValue;Lcom/intellij/database/script/ScriptModel$StatementIt;)Z", 0);
                }

                @NotNull
                public final Boolean invoke(@NotNull ScriptModel.StatementIt<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return RunSqlScriptAction.access$runScript$notDml(this.$dmlSet, p0);
                }
            }, arg_0))) {
                Ref<Boolean> ref2 = doneAnything;
                if (ref2 != null) {
                    ref2.set((Object)true);
                }
                double fraction = -1.0;
                if (consumer2.getInBatch()) {
                    reporter.print("");
                }
                consumer2.startGroup();
                for (ScriptModel.StatementIt it2 : itGroup) {
                    String sql;
                    progress.checkCanceled();
                    Intrinsics.checkNotNullExpressionValue((Object)it2.text(), (String)"text(...)");
                    long l = counter[0];
                    counter[0] = l + 1L;
                    counter[2] = counter[2] + (long)sql.length();
                    long curOffset = it2.rangeOffset() + (long)it2.range().getEndOffset();
                    fraction = (float)curOffset * averageBytesPerChar / (float)fileSize / (float)progressMultiplier;
                    if (!consumer2.getInBatch()) {
                        reporter.println(StringUtil.first((String)sql, (int)240, (boolean)true), ConsoleViewContentType.USER_INPUT);
                        progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                    }
                    Intrinsics.checkNotNull((Object)it2);
                    if (consumer2.wouldFlush(sql, RunSqlScriptAction.runScript$notDml((NotNullLazyValue<TokenSet>)dmlSet, it2)) && consumer2.getInBatch()) {
                        reporter.print("");
                    }
                    if (consumer2.statement(sql, RunSqlScriptAction.runScript$notDml((NotNullLazyValue<TokenSet>)dmlSet, it2))) {
                        progress.setFraction(fraction);
                    } else if (r.getBatch().size() % 10 == 1) {
                        reporter.rawPrint(".", ConsoleViewContentType.USER_INPUT);
                    }
                    counter[1] = counter[1] + r.getAndResetFailCount();
                }
                if (consumer2.getInBatch() && !((Collection)r.getBatch()).isEmpty()) {
                    reporter.print("");
                }
                if (consumer2.endGroup()) {
                    progress.setFraction(fraction);
                }
                counter[1] = counter[1] + r.getAndResetFailCount();
            }
        }
        catch (TooLongStatementException e2) {
            Object[] objectArray = new Object[]{e2.getMessage()};
            reporter.error(DatabaseBundle.message("0.increasing.memory.via.xmx.may.help.aborting", objectArray));
        }
        finally {
            counter[1] = counter[1] + r.getAndResetFailCount();
        }
    }

    private static final void perform$lambda$0(Project $project, JBIterable $files, List $targets, String $taskName, AtomicReference $indicatorRef, Ref $reporter) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Intrinsics.checkNotNullParameter((Object)$taskName, (String)"$taskName");
        Intrinsics.checkNotNullParameter((Object)$indicatorRef, (String)"$indicatorRef");
        INSTANCE.prepare($project, (JBIterable<VirtualFile>)$files, $targets);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable($project, $taskName, $indicatorRef, (JBIterable<VirtualFile>)$files, $targets, (Ref<DataAuditors.PrintingAdapter>)$reporter){
            final /* synthetic */ Project $project;
            final /* synthetic */ AtomicReference<ProgressIndicator> $indicatorRef;
            final /* synthetic */ JBIterable<VirtualFile> $files;
            final /* synthetic */ List<Pair<LocalDataSource, ObjectPath>> $targets;
            final /* synthetic */ Ref<DataAuditors.PrintingAdapter> $reporter;
            {
                this.$project = $project;
                this.$indicatorRef = $indicatorRef;
                this.$files = $files;
                this.$targets = $targets;
                this.$reporter = $reporter;
                super($project, $taskName, true, null);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$indicatorRef.set(indicator);
                Object object = this.$reporter.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                RunSqlScriptAction.INSTANCE.performImpl(this.$project, this.$files, this.$targets, (DataAuditors.PrintingAdapter)object, indicator);
            }
        });
    }

    private static final PsiFile performStepImpl$lambda$5$lambda$2(Project $project, VirtualFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return PsiManager.getInstance((Project)$project).findFile($file);
    }

    private static final ScriptModel performStepImpl$lambda$5$lambda$3(Project $project, VirtualFile $file, Language $language) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$language, (String)"$language");
        return SqlPsiFacade.getInstance((Project)$project).createScriptModel($file, $language);
    }

    private static final AsyncTask performStepImpl$lambda$5$lambda$4(Project $project, LocalDataSource $dataSource, Runner $r) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Intrinsics.checkNotNullParameter((Object)$r, (String)"$r");
        return DataSourceUtil.performAutoSyncTask(DataSourceUiUtil.preparePathBasedLoaderContext($project, $dataSource, $r.getDestination()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void performStepImpl$lambda$5(ProgressIndicator $indicator, Runner $r, DataAuditors.PrintingAdapter $reporter, JBIterable $files, Project $project, int $progressMultiplier, Ref $doneAnything, LocalDataSource $dataSource, Language $language) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$r, (String)"$r");
        Intrinsics.checkNotNullParameter((Object)$reporter, (String)"$reporter");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$doneAnything, (String)"$doneAnything");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Intrinsics.checkNotNullParameter((Object)$language, (String)"$language");
        $indicator.checkCanceled();
        $indicator.setText($r.getDataSource().getName());
        if ($r.getRr() == null) {
            $reporter.error(DatabaseBundle.message("notification.content.unable.to.acquire.connection", new Object[0]));
            return;
        }
        Object total = -1L;
        Object chars = -1L;
        long executed = 0L;
        long failed = 0L;
        boolean aborted = false;
        long t0 = System.currentTimeMillis();
        for (VirtualFile file : $files) {
            ScriptModel scriptModel;
            long t1;
            Object[] counter;
            block10: {
                MessageType messageType = MessageType.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                Object[] objectArray = new Object[]{file.getPresentableUrl()};
                String string = DatabaseBundle.message("notification.content.run", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                INSTANCE.reportAndLog($project, $reporter, messageType, string);
                objectArray = new long[3];
                objectArray[0] = 0L;
                objectArray[1] = 0L;
                objectArray[2] = 0L;
                counter = objectArray;
                t1 = System.currentTimeMillis();
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> RunSqlScriptAction.performStepImpl$lambda$5$lambda$2($project, file));
                if (psiFile == null) {
                    Object[] objectArray2 = new Object[]{file.getName()};
                    $reporter.error(DatabaseBundle.message("notification.content.no.psi.for.file", objectArray2));
                    continue;
                }
                Object object = ReadAction.compute(() -> RunSqlScriptAction.performStepImpl$lambda$5$lambda$3($project, file, $language));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                scriptModel = (ScriptModel)object;
                try {
                    INSTANCE.runScript($r, scriptModel, $reporter, $indicator, (long[])counter, $progressMultiplier * $files.size(), (Ref<Boolean>)$doneAnything);
                    if (total < 0L) {
                        total = counter[0];
                    }
                    if (chars >= 0L) break block10;
                    chars = counter[2];
                }
                catch (ProcessCanceledException e2) {
                    try {
                        aborted = true;
                    }
                    catch (Throwable throwable) {
                        Disposer.dispose((Disposable)scriptModel);
                        executed += counter[0];
                        failed += counter[1];
                        if ($files.size() > 1) {
                            long t2 = System.currentTimeMillis() - t1;
                            MessageType messageType2 = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                            Intrinsics.checkNotNull((Object)messageType2);
                            Object[] objectArray3 = new Object[]{$dataSource.getName(), (long)counter[0], total, total < 0L ? 0 : 1, (long)counter[1], counter[1] > 0L ? 0 : 1, NlsMessages.formatDuration((long)t2), aborted ? 0 : 1};
                            String string2 = DatabaseBundle.message("notification.content.choice.statements.executed.choice.failed.in.choice.aborted", objectArray3);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                            INSTANCE.reportAndLog($project, $reporter, messageType2, string2);
                        }
                        throw throwable;
                    }
                    Disposer.dispose((Disposable)scriptModel);
                    executed += counter[0];
                    failed += counter[1];
                    if ($files.size() <= 1) break;
                    long t2 = System.currentTimeMillis() - t1;
                    MessageType messageType3 = counter[1] > 0L ? MessageType.ERROR : MessageType.WARNING;
                    Intrinsics.checkNotNull((Object)messageType3);
                    Object[] objectArray4 = new Object[]{$dataSource.getName(), (long)counter[0], total, total < 0L ? 0 : 1, (long)counter[1], counter[1] > 0L ? 0 : 1, NlsMessages.formatDuration((long)t2), 0};
                    String string3 = DatabaseBundle.message("notification.content.choice.statements.executed.choice.failed.in.choice.aborted", objectArray4);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    INSTANCE.reportAndLog($project, $reporter, messageType3, string3);
                    break;
                }
            }
            Disposer.dispose((Disposable)scriptModel);
            executed += counter[0];
            failed += counter[1];
            if ($files.size() <= 1) continue;
            long t2 = System.currentTimeMillis() - t1;
            MessageType messageType = counter[1] > 0L ? MessageType.ERROR : MessageType.INFO;
            Intrinsics.checkNotNull((Object)messageType);
            Object[] objectArray = new Object[]{$dataSource.getName(), (long)counter[0], total, total < 0L ? 0 : 1, (long)counter[1], counter[1] > 0L ? 0 : 1, NlsMessages.formatDuration((long)t2), 1};
            String string = DatabaseBundle.message("notification.content.choice.statements.executed.choice.failed.in.choice.aborted", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            INSTANCE.reportAndLog($project, $reporter, messageType, string);
        }
        if (Intrinsics.areEqual((Object)true, (Object)$doneAnything.get())) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> RunSqlScriptAction.performStepImpl$lambda$5$lambda$4($project, $dataSource, $r));
        }
        long t3 = System.currentTimeMillis() - t0;
        MessageType messageType = failed > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
        Intrinsics.checkNotNull((Object)messageType);
        Object[] objectArray = new Object[]{executed, total * (long)$files.size(), total < 0L ? 0 : 1, failed, failed > 0L ? 0 : 1, NlsMessages.formatDuration((long)t3), chars, chars < 0L ? 0 : 1, aborted ? 0 : 1};
        String string = DatabaseBundle.message("notification.content.summary.choice.statements.executed.choice.failed.in.choice.symbols.in.file.choice.aborted", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        INSTANCE.reportAndLog($project, $reporter, messageType, string);
    }

    private static final SqlLanguageDialect patchDialects$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SqlLanguageDialect)$tmp0.invoke(p0);
    }

    private static final boolean patchDialects$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void patchDialects$lambda$8(List $remapDialect, SqlPsiFacade $sqlPsiFacade, SqlLanguageDialect $preferredDialect) {
        Intrinsics.checkNotNullParameter((Object)$remapDialect, (String)"$remapDialect");
        Intrinsics.checkNotNullParameter((Object)$sqlPsiFacade, (String)"$sqlPsiFacade");
        for (VirtualFile file : $remapDialect) {
            $sqlPsiFacade.setDialectMapping(file, $preferredDialect);
        }
    }

    private static final boolean addConsole$lambda$10(JBIterable $files) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
            Iterable $this$all$iv = (Iterable)$files;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VirtualFile it2 = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (it2.isValid()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void runStatements$lambda$11(ProgressIndicator $progress, Runner $r, DataAuditors.PrintingAdapter $reporter, ScriptModel $scriptModel, long[] $counter) {
        Intrinsics.checkNotNullParameter((Object)$progress, (String)"$progress");
        Intrinsics.checkNotNullParameter((Object)$r, (String)"$r");
        Intrinsics.checkNotNullParameter((Object)$reporter, (String)"$reporter");
        Intrinsics.checkNotNullParameter((Object)$scriptModel, (String)"$scriptModel");
        Intrinsics.checkNotNullParameter((Object)$counter, (String)"$counter");
        $progress.checkCanceled();
        $progress.setText($r.getDataSource().getName());
        if ($r.getRr() == null) {
            $reporter.error(DatabaseBundle.message("unable.to.acquire.connection", new Object[0]));
            return;
        }
        INSTANCE.runScript($r, $scriptModel, $reporter, $progress, $counter, 1, null);
    }

    private static final TokenSet runScript$lambda$12() {
        IElementType[] iElementTypeArray = new IElementType[]{SqlTokenRegistry.findCompositeType((String)"SQL_INSERT_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_UPDATE_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_DELETE_STATEMENT")};
        return TokenSet.create((IElementType[])iElementTypeArray);
    }

    private static final boolean runScript$notDml(NotNullLazyValue<TokenSet> dmlSet, ScriptModel.StatementIt<?> o2) {
        return !((TokenSet)dmlSet.getValue()).contains(o2.type());
    }

    private static final boolean runScript$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$runScript$notDml(NotNullLazyValue dmlSet, ScriptModel.StatementIt o2) {
        return RunSqlScriptAction.runScript$notDml((NotNullLazyValue<TokenSet>)dmlSet, o2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\rJ\u0006\u00106\u001a\u00020\u0012J\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u0002042\u0006\u00108\u001a\u000209J\u0014\u0010;\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0=J\u001e\u0010>\u001a\u0002042\u0006\u0010?\u001a\u00020@2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0=H\u0002J\u001c\u0010A\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0=2\u0006\u00105\u001a\u00020\rJ\u0016\u0010B\u001a\u0002042\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0=H\u0002J\u000e\u0010C\u001a\u0002042\u0006\u0010D\u001a\u00020EJ+\u0010F\u001a\u0002HG\"\u0004\b\u0000\u0010G2\u0018\u0010H\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0=\u0012\u0004\u0012\u0002HG0I\u00a2\u0006\u0002\u0010JR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0004\b#\u0010\u0016R\u001c\u0010$\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006K"}, d2={"Lcom/intellij/database/console/RunSqlScriptAction$Runner;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "destination", "Lcom/intellij/database/util/ObjectPath;", "reporter", "Lcom/intellij/database/datagrid/DataAuditors$PrintingAdapter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/ObjectPath;Lcom/intellij/database/datagrid/DataAuditors$PrintingAdapter;)V", "batch", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getBatch", "()Ljava/util/ArrayList;", "batchLength", "", "getBatchLength", "()J", "setBatchLength", "(J)V", "batchUpdatesSupported", "", "getBatchUpdatesSupported", "()Z", "setBatchUpdatesSupported", "(Z)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getDestination", "()Lcom/intellij/database/util/ObjectPath;", "failCount", "getFailCount", "setFailCount", "prevConnection", "getPrevConnection", "()Ljava/lang/Object;", "setPrevConnection", "(Ljava/lang/Object;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getReporter", "()Lcom/intellij/database/datagrid/DataAuditors$PrintingAdapter;", "rr", "Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "getRr", "()Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;", "setRr", "(Lcom/intellij/database/console/session/DatabaseSessionManager$Facade$Runner;)V", "addBatch", "", "sql", "getAndResetFailCount", "init", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "prepare", "runBatch", "statement", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "runBatched", "batchCount", "", "runSingle", "tryRunButch", "withConnected", "r", "Ljava/lang/Runnable;", "withStatement", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.database.impl"})
    private static final class Runner {
        @NotNull
        private final Project project;
        @NotNull
        private final LocalDataSource dataSource;
        @Nullable
        private final ObjectPath destination;
        @NotNull
        private final DataAuditors.PrintingAdapter reporter;
        private boolean batchUpdatesSupported;
        @Nullable
        private DatabaseSessionManager.Facade.Runner rr;
        @Nullable
        private Object prevConnection;
        private long failCount;
        @NotNull
        private final ArrayList<String> batch;
        private long batchLength;

        public Runner(@NotNull Project project, @NotNull LocalDataSource dataSource2, @Nullable ObjectPath destination, @NotNull DataAuditors.PrintingAdapter reporter) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.project = project;
            this.dataSource = dataSource2;
            this.destination = destination;
            this.reporter = reporter;
            this.batch = new ArrayList();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final ObjectPath getDestination() {
            return this.destination;
        }

        @NotNull
        public final DataAuditors.PrintingAdapter getReporter() {
            return this.reporter;
        }

        public final boolean getBatchUpdatesSupported() {
            return this.batchUpdatesSupported;
        }

        public final void setBatchUpdatesSupported(boolean bl) {
            this.batchUpdatesSupported = bl;
        }

        @Nullable
        public final DatabaseSessionManager.Facade.Runner getRr() {
            return this.rr;
        }

        public final void setRr(@Nullable DatabaseSessionManager.Facade.Runner runner) {
            this.rr = runner;
        }

        @Nullable
        public final Object getPrevConnection() {
            return this.prevConnection;
        }

        public final void setPrevConnection(@Nullable Object object) {
            this.prevConnection = object;
        }

        public final long getFailCount() {
            return this.failCount;
        }

        public final void setFailCount(long l) {
            this.failCount = l;
        }

        @NotNull
        public final ArrayList<String> getBatch() {
            return this.batch;
        }

        public final long getBatchLength() {
            return this.batchLength;
        }

        public final void setBatchLength(long l) {
            this.batchLength = l;
        }

        public final long getAndResetFailCount() {
            long result2 = this.failCount;
            this.failCount = 0L;
            return result2;
        }

        public final void init(@NotNull DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            try {
                if (!this.dataSource.getDbms().isTransactSql()) {
                    RemoteDatabaseMetaData metaData = connection2.getRemoteMetaData();
                    boolean bl = this.batchUpdatesSupported = metaData != null && metaData.supportsBatchUpdates();
                    if (this.batchUpdatesSupported) {
                        Object[] objectArray = new Object[]{1000};
                        this.reporter.print(DatabaseBundle.message("using.batch.mode.0.insert.update.delete.statements.max", objectArray));
                    }
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngineUtils.getErrorInfo(ex, this.dataSource));
            }
        }

        public final void prepare(@NotNull DatabaseConnection connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            if (this.destination != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe(DbImplUtil.getDatabaseDialect(this.dataSource), this.destination, connection2);
            }
        }

        public final void withConnected(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            ErrorHandler handler2 = new ErrorHandler();
            try {
                DatabaseSessionManager.getFacade(this.project, this.dataSource, null, SearchPath.of(this.destination), false, handler2, DGDepartment.DATA_IMPORT).multiRunSync((Function1)new Function1<DatabaseSessionManager.Facade.Runner, Unit>(this, r){
                    final /* synthetic */ Runner this$0;
                    final /* synthetic */ Runnable $r;
                    {
                        this.this$0 = $receiver;
                        this.$r = $r;
                        super(1);
                    }

                    public final void invoke(@NotNull DatabaseSessionManager.Facade.Runner runner) {
                        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
                        this.this$0.setRr(runner);
                        runner.perform((Function1)new Function1<DatabaseConnection, Unit>((Object)this.this$0){

                            public final void invoke(@NotNull DatabaseConnection p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                ((Runner)this.receiver).init(p0);
                            }
                        });
                        this.$r.run();
                    }
                });
            }
            catch (ProcessCanceledException e2) {
                if (handler2.hasErrors()) {
                    this.reporter.error(handler2.getSummary());
                }
                throw e2;
            }
            catch (Exception e3) {
                this.reporter.error(e3);
            }
        }

        public final <T> T withStatement(@NotNull Function1<? super ReusableSmartStatement<String>, ? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            DatabaseSessionManager.Facade.Runner runner = this.rr;
            Intrinsics.checkNotNull((Object)runner);
            return runner.perform((Function1)new Function1<InterruptibleDatabaseConnection, T>(this, block){
                final /* synthetic */ Runner this$0;
                final /* synthetic */ Function1<ReusableSmartStatement<String>, T> $block;
                {
                    this.this$0 = $receiver;
                    this.$block = $block;
                    super(1);
                }

                public final T invoke(@NotNull InterruptibleDatabaseConnection it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    if (!Intrinsics.areEqual((Object)it2, (Object)this.this$0.getPrevConnection())) {
                        this.this$0.prepare(it2);
                    }
                    return (T)this.$block.invoke(SmartStatements.Companion.poweredBy(it2).simple(Configuration.Companion.getDefault()).reuse());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void runSingle(@NotNull ReusableSmartStatement<String> statement2, @NotNull String sql) {
            Intrinsics.checkNotNullParameter(statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            try {
                long updateTotal = 0L;
                updateTotal = -1L;
                long timestamp = System.currentTimeMillis();
                AutoCloseable autoCloseable = statement2.noisy().execute(sql, StandardExecutionMode.GENERIC);
                Throwable throwable = null;
                try {
                    ClosableResultsProducer producer = (ClosableResultsProducer)autoCloseable;
                    boolean bl = false;
                    String string = NlsMessages.formatDuration((long)(System.currentTimeMillis() - timestamp));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
                    String executionTime = string;
                    while (producer.advance()) {
                        int count = ((Number)producer.processCurrent(StandardResultsProcessors.updateCount(-1))).intValue();
                        if (count < 0) continue;
                        if (updateTotal < 0L) {
                            updateTotal = 0L;
                        }
                        updateTotal += (long)count;
                    }
                    if (updateTotal >= 0L) {
                        Object[] objectArray = new Object[]{updateTotal, executionTime};
                        this.reporter.print(DatabaseBundle.message("0.row.s.affected.in.1", objectArray));
                    } else {
                        Object[] objectArray = new Object[]{executionTime};
                        this.reporter.print(DatabaseBundle.message("completed.in", objectArray));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception ex) {
                long l = this.failCount;
                this.failCount = l + 1L;
                if (DbImplUtil.isRemoteProcessDown(ex)) {
                    this.reporter.error(DatabaseBundle.message("connection.is.closed", new Object[0]));
                    throw new ProcessCanceledException();
                }
                this.reporter.error(JdbcEngineUtils.getErrorInfo(ex, this.dataSource));
            }
        }

        public final void addBatch(@NotNull String sql) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            this.batch.add(sql);
            this.batchLength += (long)sql.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void runBatch(@NotNull ReusableSmartStatement<String> statement2) {
            Intrinsics.checkNotNullParameter(statement2, (String)"statement");
            if (!this.batchUpdatesSupported) {
                return;
            }
            if (this.batch.size() == 0) {
                return;
            }
            try {
                while (!((Collection)this.batch).isEmpty()) {
                    this.tryRunButch(statement2);
                }
            }
            finally {
                this.batchLength = 0L;
                this.batch.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void tryRunButch(ReusableSmartStatement<String> statement2) {
            if (this.batch.size() == 0) {
                return;
            }
            int batchCount = 0;
            try {
                for (String sql : this.batch) {
                    ++batchCount;
                    Intrinsics.checkNotNull((Object)sql);
                    statement2.addBatch(sql);
                }
                this.runBatched(batchCount, statement2);
            }
            catch (SQLException e2) {
                this.batchUpdatesSupported = false;
                if (batchCount > 0) {
                    this.runBatched(batchCount, statement2);
                }
                String string = this.batch.get(batchCount - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                this.runSingle(statement2, string);
            }
            finally {
                this.batch.subList(0, batchCount).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void runBatched(int batchCount, ReusableSmartStatement<String> statement2) {
            if (batchCount == 0) {
                return;
            }
            try {
                long updateCount2 = 0L;
                long timestamp = System.currentTimeMillis();
                AutoCloseable autoCloseable = ((ReusableNoisyStatement)statement2.noisy()).executeBatch();
                Object[] objectArray = null;
                try {
                    ClosableResultsProducer producer = (ClosableResultsProducer)autoCloseable;
                    boolean bl = false;
                    while (producer.advance()) {
                        int count = ((Number)producer.processCurrent(StandardResultsProcessors.UPDATE_COUNT)).intValue();
                        if (count >= 0) {
                            updateCount2 += (long)count;
                            continue;
                        }
                        if (count != -3) continue;
                        long l = this.failCount;
                        this.failCount = l + 1L;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable object) {
                    objectArray = object;
                    throw object;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)objectArray);
                }
                String string = NlsMessages.formatDuration((long)(System.currentTimeMillis() - timestamp));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
                String executionTime = string;
                if (updateCount2 == 0L) {
                    objectArray = new Object[]{executionTime};
                    this.reporter.print(DatabaseBundle.message("completed.in", objectArray));
                } else {
                    objectArray = new Object[]{updateCount2, executionTime};
                    this.reporter.print(DatabaseBundle.message("0.row.s.affected.in.1", objectArray));
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngineUtils.getErrorInfo(ex, this.dataSource));
                this.failCount += (long)batchCount;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0010\u001a\u00020\u00062\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u001b\u0010\u0015\u001a\u00020\u00062\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/RunSqlScriptAction$StatementConsumer;", "", "r", "Lcom/intellij/database/console/RunSqlScriptAction$Runner;", "(Lcom/intellij/database/console/RunSqlScriptAction$Runner;)V", "inBatch", "", "getInBatch", "()Z", "setInBatch", "(Z)V", "getR", "()Lcom/intellij/database/console/RunSqlScriptAction$Runner;", "endGroup", "startGroup", "", "statement", "sql", "", "Lcom/intellij/openapi/util/NlsSafe;", "forceSingle", "wouldFlush", "intellij.database.impl"})
    private static final class StatementConsumer {
        @NotNull
        private final Runner r;
        private boolean inBatch;

        public StatementConsumer(@NotNull Runner r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            this.r = r;
        }

        @NotNull
        public final Runner getR() {
            return this.r;
        }

        public final boolean getInBatch() {
            return this.inBatch;
        }

        public final void setInBatch(boolean bl) {
            this.inBatch = bl;
        }

        public final void startGroup() {
            this.inBatch = false;
        }

        public final boolean endGroup() {
            if (this.inBatch) {
                if (!this.r.getBatch().isEmpty()) {
                    this.r.withStatement((Function1)new Function1<ReusableSmartStatement<String>, Unit>((Object)this.r){

                        public final void invoke(@NotNull ReusableSmartStatement<String> p0) {
                            Intrinsics.checkNotNullParameter(p0, (String)"p0");
                            ((Runner)this.receiver).runBatch(p0);
                        }
                    });
                }
                return true;
            }
            return false;
        }

        public final boolean wouldFlush(@NotNull String sql, boolean forceSingle) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            if (!this.r.getBatchUpdatesSupported() || forceSingle) {
                return true;
            }
            return this.r.getBatch().size() + 1 >= 1000 || this.r.getBatchLength() + (long)sql.length() >= 512000L;
        }

        public final boolean statement(@NotNull String sql, boolean forceSingle) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            if (!this.r.getBatchUpdatesSupported() || forceSingle) {
                this.r.withStatement((Function1)new Function1<ReusableSmartStatement<String>, Unit>(this, sql){
                    final /* synthetic */ StatementConsumer this$0;
                    final /* synthetic */ String $sql;
                    {
                        this.this$0 = $receiver;
                        this.$sql = $sql;
                        super(1);
                    }

                    public final void invoke(@NotNull ReusableSmartStatement<String> it2) {
                        Intrinsics.checkNotNullParameter(it2, (String)"it");
                        this.this$0.getR().runBatch(it2);
                        this.this$0.getR().runSingle(it2, this.$sql);
                    }
                });
                return true;
            }
            this.inBatch = true;
            this.r.addBatch(sql);
            if (this.r.getBatch().size() >= 1000 || this.r.getBatchLength() >= 512000L) {
                this.r.withStatement((Function1)new Function1<ReusableSmartStatement<String>, Unit>((Object)this.r){

                    public final void invoke(@NotNull ReusableSmartStatement<String> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        ((Runner)this.receiver).runBatch(p0);
                    }
                });
                return true;
            }
            return false;
        }
    }
}

