/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcEngineUtils {
    public static final Logger LOG = Logger.getInstance(JdbcEngineUtils.class);

    private JdbcEngineUtils() {
    }

    @Contract(value="null, _, _ -> false")
    public static boolean shouldValueBeInlined(@Nullable Object object, @Nullable String typeName, Dbms dbms) {
        return dbms.is(Dbms.MONGO) || dbms.is(Dbms.CASSANDRA) && object instanceof String && typeName != null && !CassJdbcHelper.hasCodec((String)typeName);
    }

    public static <T extends AutoValueDescriptor> boolean shouldParticipateInInsert(@NotNull Dbms dbms, @NotNull T column2) {
        if (dbms == null) {
            JdbcEngineUtils.$$$reportNull$$$0(0);
        }
        if (column2 == null) {
            JdbcEngineUtils.$$$reportNull$$$0(1);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
        return !column2.isComputed() && (!column2.isAutogenerated() || dialect.supportsInsertDefaultIntoAutoVal()) && (!column2.hasDefault() || !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.SNOWFLAKE));
    }

    @NotNull
    public static ErrorInfo getErrorInfo(Throwable th, @Nullable LocalDataSource dataSource2) {
        if (th instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)th;
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)th);
        if (cause instanceof OutOfMemoryError) {
            LOG.info(cause);
        } else if (!(cause instanceof SuppressUserStackTrace || cause instanceof UnsupportedOperationException || cause instanceof IOException || cause instanceof ExecutionException || cause instanceof UnsafeUpdateRolledBackException)) {
            try {
                ExceptionUtil.getUserStackTrace((Throwable)cause, (Logger)LOG);
            }
            catch (AssertionError e2) {
                ErrorInfo errorInfo = SimpleErrorInfo.create((Throwable)cause);
                if (errorInfo == null) {
                    JdbcEngineUtils.$$$reportNull$$$0(2);
                }
                return errorInfo;
            }
        }
        if (th instanceof EngineWarningException) {
            return new EngineWarningExceptionInfo((EngineWarningException)th);
        }
        DatabaseErrorHandler handler2 = DatabaseErrorHandler.EP.forDbms(dataSource2 == null ? Dbms.UNKNOWN : dataSource2.getDbms());
        ErrorInfo errorInfo = handler2.getErrorInfo(dataSource2, th);
        if (errorInfo == null) {
            JdbcEngineUtils.$$$reportNull$$$0(3);
        }
        return errorInfo;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull RemoteResultSet resultSet) throws Exception {
        if (resultSet == null) {
            JdbcEngineUtils.$$$reportNull$$$0(4);
        }
        RemoteResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count];
        for (int i2 = 1; i2 <= count; ++i2) {
            columnsDescr[i2 - 1] = JdbcEngineUtils.createColumnDescriptor(metaData, i2);
        }
        return columnsDescr;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataConsumer.Column createColumnDescriptor(RemoteResultSetMetaData metaData, int i2) {
        String name2 = null;
        try {
            name2 = metaData.getColumnLabel(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtil.isEmpty((String)name2)) {
            try {
                name2 = metaData.getColumnName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String typeName = null;
        try {
            typeName = metaData.getColumnTypeName(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int type2 = 1111;
        try {
            type2 = metaData.getColumnType(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String clazz = null;
        try {
            clazz = metaData.getColumnClassName(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String catalog = null;
        try {
            catalog = metaData.getCatalogName(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String schema2 = null;
        try {
            schema2 = metaData.getSchemaName(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String table = null;
        try {
            table = metaData.getTableName(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int precision = -1;
        try {
            precision = metaData.getPrecision(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int scale = -1;
        try {
            scale = metaData.getScale(i2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DataConsumer.Column(i2 - 1, name2, type2, typeName, clazz, precision, scale, catalog, schema2, table);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngineUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngineUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message2) {
            super(message2);
        }
    }

    public static class EngineWarningException
    extends SQLException {
        private final @NlsContexts.DetailedDescription String myLogMessage;
        private final ExecutionConcession myConcession;
        private final Runnable mySuppressAction;

        public EngineWarningException(@NotNull String message2, @NlsContexts.DetailedDescription @NotNull String logMessage, @NotNull ExecutionConcession concession, @Nullable Runnable suppressAction) {
            if (message2 == null) {
                EngineWarningException.$$$reportNull$$$0(0);
            }
            if (logMessage == null) {
                EngineWarningException.$$$reportNull$$$0(1);
            }
            if (concession == null) {
                EngineWarningException.$$$reportNull$$$0(2);
            }
            super(message2);
            this.myLogMessage = logMessage;
            this.myConcession = concession;
            this.mySuppressAction = suppressAction;
            this.setStackTrace(new StackTraceElement[0]);
        }

        @NotNull
        public ExecutionConcession getConcession() {
            ExecutionConcession executionConcession = this.myConcession;
            if (executionConcession == null) {
                EngineWarningException.$$$reportNull$$$0(3);
            }
            return executionConcession;
        }

        @NotNull
        @NlsContexts.DetailedDescription
        public String getLogMessage() {
            String string = this.myLogMessage;
            if (string == null) {
                EngineWarningException.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public Runnable getSuppressAction() {
            return this.mySuppressAction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "concession";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngineUtils$EngineWarningException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngineUtils$EngineWarningException";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcession";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class EngineWarningExceptionInfo
    implements ErrorInfo {
        private final EngineWarningException myException;

        public EngineWarningExceptionInfo(@NotNull EngineWarningException exception) {
            if (exception == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(0);
            }
            this.myException = exception;
        }

        @NotNull
        public EngineWarningException getOriginalThrowable() {
            EngineWarningException engineWarningException = this.myException;
            if (engineWarningException == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(1);
            }
            return engineWarningException;
        }

        @NotNull
        @NlsContexts.NotificationContent
        @NlsContexts.DetailedDescription
        public String getMessage() {
            String string = this.myException.getMessage();
            if (string == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @NlsContexts.NotificationContent
        @NlsContexts.DetailedDescription
        public String getLogMessage() {
            String string = this.myException.getLogMessage();
            if (string == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public ExecutionConcession getConcession() {
            ExecutionConcession executionConcession = this.myException.getConcession();
            if (executionConcession == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(4);
            }
            return executionConcession;
        }

        @Nullable
        public Runnable getSuppressAction() {
            return this.myException.getSuppressAction();
        }

        @NotNull
        public List<ErrorInfo.Fix> getFixes() {
            List<ErrorInfo.Fix> list = Collections.emptyList();
            if (list == null) {
                EngineWarningExceptionInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngineUtils$EngineWarningExceptionInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngineUtils$EngineWarningExceptionInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalThrowable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcession";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class QueryValidationException
    extends EngineWarningException {
        public QueryValidationException(@NlsContexts.DetailedDescription String message2) {
            super(message2, message2, ExecutionConcession.UNSAFE_STATEMENT, () -> {
                DatabaseSettings.getSettings().warnAboutUnsafeQuery = false;
                DatabaseSettings.fireSettingsChanged();
            });
        }
    }
}

