/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.SessionsUiUtil;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EmptyIcon;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseRunners {
    private DatabaseRunners() {
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getAttachDataSourceRunners(@Nullable JdbcConsoleProvider.Info info2) {
        if (info2 == null || info2.model.statements().isEmpty() || info2.editor == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (info2.editor instanceof EditorWindow && !((EditorWindow)info2.editor).isValid()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile virtualFile = info2.editor.getVirtualFile();
        if (virtualFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(2);
            }
            return list;
        }
        Project project = info2.originalFile.getProject();
        @Nls String title = SessionsUtil.getSessionTitle(virtualFile);
        Consumer consumer2 = newSession -> {
            JdbcConsole console = JdbcConsoleProvider.attachConsole(project, newSession, virtualFile);
            if (console != null) {
                Runnable runnable = () -> JdbcConsoleProvider.doRunQueryInConsole(console, info2);
                if (DbVFSUtils.isAssociatedWithDataSourceAndSchema(virtualFile)) {
                    runnable.run();
                } else {
                    DatabaseRunners.chooseSchemaAndRun((Editor)info2.editor, runnable);
                }
            }
        };
        return DatabaseRunners.getAttachDataSourceRunners(info2.file, title, (Consumer<? super DatabaseSession>)consumer2);
    }

    public static void chooseSchemaAndRun(@NotNull Editor editor2, @Nullable Runnable runnable) {
        if (editor2 == null) {
            DatabaseRunners.$$$reportNull$$$0(3);
        }
        ChooseSchemaAction action = new ChooseSchemaAction();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getContentComponent());
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)dataContext);
        Runnable finalRunnable = runnable == null ? null : () -> ApplicationManager.getApplication().invokeLater(runnable);
        action.actionPerformed(event, finalRunnable);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getAttachDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @NotNull @NotNull Consumer<? super @NotNull DatabaseSession> consumer2) {
        DbDataSource forcedDataSource;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(4);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(6);
        }
        if ((forcedDataSource = DbImplUtil.getForcedDataSourceForExec(file)) != null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(DatabaseRunners.createDataSourceRunner(forcedDataSource, title, consumer2));
            if (list == null) {
                DatabaseRunners.$$$reportNull$$$0(7);
            }
            return list;
        }
        return DatabaseRunners.getDataSourceRunners(file, title, null, consumer2);
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getSwitchDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @NotNull DatabaseSession current, @NotNull Consumer<? super @Nullable DatabaseSession> consumer2) {
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(8);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(9);
        }
        if (current == null) {
            DatabaseRunners.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(11);
        }
        return DatabaseRunners.getDataSourceRunners(file, title, current, consumer2);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getDataSourceRunners(@NotNull PsiFile file, @NotNull @Nls String title, @Nullable DatabaseSession current, @NotNull Consumer<? super @Nullable DatabaseSession> consumer2) {
        String currentDataSourceId;
        if (file == null) {
            DatabaseRunners.$$$reportNull$$$0(12);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(13);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(14);
        }
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        String string = currentDataSourceId = current == null ? null : current.getConnectionPoint().getDataSource().getUniqueId();
        if (currentDataSourceId != null) {
            result2.add(DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message("detach.data.source", new Object[0]), false, false, false, AllIcons.Actions.Cancel, () -> consumer2.consume(null)));
        }
        JBIterable<DbDataSource> dataSources2 = DbImplUtil.getAppropriateDataSourcesForExec(file);
        for (DbDataSource dataSource2 : dataSources2) {
            if (dataSource2.getUniqueId().equals(currentDataSourceId)) continue;
            result2.add(DatabaseRunners.createDataSourceRunner(dataSource2, title, consumer2));
        }
        JBIterable<DbDataSource> allDataSources = DbImplUtil.getAllDataSourcesForExec(file);
        int dataSourcesSize = dataSources2.size();
        if (dataSourcesSize == allDataSources.take(dataSourcesSize + 1).size()) {
            ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
            if (arrayList == null) {
                DatabaseRunners.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        final List allDataSourcesSubRunners = allDataSources.filter(d2 -> !d2.getUniqueId().equals(currentDataSourceId)).map(d2 -> DatabaseRunners.createDataSourceRunner(d2, title, consumer2)).toList();
        MyRunner allDataSourcesRunner = new MyRunner(DatabaseBundle.message("all.runner.title", new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

            @Override
            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                List list = allDataSourcesSubRunners;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$1", "getSubRunners"));
            }
        };
        result2.add(allDataSourcesRunner);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createDataSourceRunner(@NotNull DbDataSource dataSource2, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(17);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(18);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(19);
        }
        Runnable runnable = () -> DatabaseRunners.runInDataSource(dataSource2, title, consumer2);
        return DatabaseRunners.createRunner(dataSource2.getName(), dataSource2.getIcon(), DatabaseRunners.getDataSourceRunnerColor(dataSource2), runnable);
    }

    public static void runInDataSource(@NotNull DbDataSource dataSource2, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(20);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(21);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(22);
        }
        Project project = dataSource2.getProject();
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(dataSource2);
        DatabaseSession session2 = DatabaseSessionManager.getSession(project, localDataSource, title);
        consumer2.consume((Object)session2);
    }

    @Nullable
    private static Color getDataSourceRunnerColor(@NotNull DbDataSource o2) {
        if (o2 == null) {
            DatabaseRunners.$$$reportNull$$$0(23);
        }
        return null;
    }

    @NotNull
    public static List<PersistenceConsoleProvider.Runner> getSessionRunners(@NotNull DatabaseSession current, @NotNull @Nls String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (current == null) {
            DatabaseRunners.$$$reportNull$$$0(24);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(25);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(26);
        }
        Project project = current.getProject();
        LocalDataSource localDataSource = ((DatabaseConnectionPoint)current.getTarget()).getDataSource();
        ArrayList<PersistenceConsoleProvider.Runner> result2 = new ArrayList<PersistenceConsoleProvider.Runner>();
        result2.add(DatabaseRunners.createNewSessionRunner(project, localDataSource, title, consumer2));
        for (DatabaseSession session2 : DatabaseSessionManager.getSessions(project, localDataSource)) {
            if (session2 == current) continue;
            result2.add(DatabaseRunners.createSessionRunner(session2, consumer2));
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result2;
        if (arrayList == null) {
            DatabaseRunners.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createNewSessionRunner(@NotNull Project project, @NotNull LocalDataSource localDataSource, @Nls @NotNull String title, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (project == null) {
            DatabaseRunners.$$$reportNull$$$0(28);
        }
        if (localDataSource == null) {
            DatabaseRunners.$$$reportNull$$$0(29);
        }
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(30);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(31);
        }
        Icon icon = LayeredIcon.create((Icon)SessionsUiUtil.getIcon(false), (Icon)AllIcons.Actions.New);
        Runnable runnable = () -> {
            DatabaseSession session2 = DatabaseSessionManager.openSession(project, localDataSource, title);
            consumer2.consume((Object)session2);
        };
        return DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message("new.session", new Object[0]), false, false, false, icon, runnable);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createSessionRunner(@NotNull DatabaseSession session2, @NotNull Consumer<? super DatabaseSession> consumer2) {
        if (session2 == null) {
            DatabaseRunners.$$$reportNull$$$0(32);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(33);
        }
        String title = session2.getTitle();
        return DatabaseRunners.createRunner(title, SessionsUiUtil.getIcon(session2.isConnected()), null, () -> consumer2.consume((Object)session2));
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createDataSourceConsolesRunner(final @NotNull DbDataSource dataSource2, final @NotNull Consumer<? super VirtualFile> consumer2) {
        if (dataSource2 == null) {
            DatabaseRunners.$$$reportNull$$$0(34);
        }
        if (consumer2 == null) {
            DatabaseRunners.$$$reportNull$$$0(35);
        }
        final Project project = dataSource2.getProject();
        return new MyRunner(dataSource2.getName(), false, false, true, dataSource2.getIcon(0), DatabaseRunners.getDataSourceRunnerColor(dataSource2), EmptyRunnable.getInstance()){

            @Override
            @NotNull
            public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                VirtualFile consoleDir = DatabaseEditorHelper.getConsoleRootDir(dataSource2);
                Icon icon = dataSource2.getIcon(0);
                Icon newIcon = LayeredIcon.create((Icon)DatabaseIcons.ConsoleRun, (Icon)AllIcons.Actions.New);
                PersistenceConsoleProvider.Runner newRunner = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message("console.new.console", new Object[0]), false, consoleDir == null, true, newIcon, () -> consumer2.consume((Object)DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource2)));
                if (consoleDir == null) {
                    List<PersistenceConsoleProvider.Runner> list = Collections.singletonList(newRunner);
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                VirtualFile defaultConsoleFile = DatabaseEditorHelper.findExistingConsoleVirtualFile(dataSource2);
                Map allRunningFiles = JBIterable.from(JdbcConsole.getActiveConsoles(project)).toReverseMap(o2 -> o2.getVirtualFile());
                PersistenceConsoleProvider.Runner defRunner = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.HIGH, DatabaseBundle.message("console.default", new Object[0]), allRunningFiles.containsKey(defaultConsoleFile), true, true, icon, () -> consumer2.consume(ObjectUtils.notNull((Object)defaultConsoleFile, () -> Objects.requireNonNull(DatabaseEditorHelper.getConsoleVirtualFile(dataSource2)))));
                DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                final JBIterable perFile = FileUtil.fileTraverser((File)VfsUtilCore.virtualToIoFile((VirtualFile)consoleDir)).traverse(TreeTraversal.LEAVES_BFS).take(100).filterMap(file -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file)).map(file -> new MyRunner(Objects.requireNonNull(rootType.substituteName(project, (VirtualFile)file, false)), allRunningFiles.containsKey(file), false, true, icon, null, () -> consumer2.consume(file)));
                final PersistenceConsoleProvider.Runner dir = DatabaseRunners.createPriorityRunner(PriorityAction.Priority.LOW, DatabaseBundle.message("jump.to.console.files", new Object[0]), false, false, true, null, () -> {
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    PsiDirectory psiDirectory = psiManager.findDirectory(consoleDir);
                    if (psiDirectory != null) {
                        psiDirectory.navigate(true);
                    }
                });
                MyRunner allConsoles = new MyRunner(DatabaseBundle.message("all.runner.title", new Object[0]), false, false, true, EmptyIcon.ICON_16, null, EmptyRunnable.getInstance()){

                    @Override
                    @NotNull
                    public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                        List list = perFile.append((Object)dir).toList();
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$2$1", "getSubRunners"));
                    }
                };
                List list = (List)JBIterable.of((Object[])new PersistenceConsoleProvider.Runner[]{defRunner, newRunner}).append((Object)allConsoles).addAllTo(new ArrayList());
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseRunners$2", "getSubRunners"));
            }
        };
    }

    @NotNull
    public static PersistenceConsoleProvider.Runner createConsoleRunner(@NotNull JdbcConsole console, @NotNull Runnable runnable) {
        DbConsoleRootType rootType;
        String title;
        if (console == null) {
            DatabaseRunners.$$$reportNull$$$0(36);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(37);
        }
        title = (title = (rootType = DbConsoleRootType.getInstance()).substituteName(console.getProject(), console.getVirtualFile(), false)) != null ? title : console.getDisplayName();
        return DatabaseRunners.createRunner(title, ((DatabaseConnectionPoint)console.getTarget()).getDataSource().getIcon(), null, runnable);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createPriorityRunner(@NotNull PriorityAction.Priority priority, @NotNull @Nls String displayName, boolean running, boolean defaultSubRunner, boolean shoundBeChosenIfAlone, @Nullable Icon icon, @NotNull Runnable runnable) {
        if (priority == null) {
            DatabaseRunners.$$$reportNull$$$0(38);
        }
        if (displayName == null) {
            DatabaseRunners.$$$reportNull$$$0(39);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(40);
        }
        return new PriorityRunner(displayName, running, defaultSubRunner, shoundBeChosenIfAlone, icon, null, runnable, priority);
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner createRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
        if (title == null) {
            DatabaseRunners.$$$reportNull$$$0(41);
        }
        if (runnable == null) {
            DatabaseRunners.$$$reportNull$$$0(42);
        }
        return new MyRunner(title, true, false, true, icon, color, runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 25: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 19: 
            case 22: 
            case 26: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 17: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 37: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachDataSourceRunners";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DatabaseRunners";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceRunners";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionRunners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseSchemaAndRun";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttachDataSourceRunners";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchDataSourceRunners";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceRunners";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceRunner";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runInDataSource";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceRunnerColor";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSessionRunners";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createNewSessionRunner";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createSessionRunner";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceConsolesRunner";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleRunner";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createPriorityRunner";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createRunner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 -> new IllegalArgumentException(string);
        };
    }

    static class PriorityRunner
    extends MyRunner
    implements PriorityAction {
        private final PriorityAction.Priority myPriority;

        PriorityRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String displayName, boolean running, boolean defaultSubRunner, boolean shouldBeChosenIfAlone, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable, @NotNull PriorityAction.Priority priority) {
            if (displayName == null) {
                PriorityRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                PriorityRunner.$$$reportNull$$$0(1);
            }
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(2);
            }
            super(displayName, running, defaultSubRunner, shouldBeChosenIfAlone, icon, color, runnable);
            this.myPriority = priority;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = this.myPriority;
            if (priority == null) {
                PriorityRunner.$$$reportNull$$$0(3);
            }
            return priority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseRunners$PriorityRunner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        @Nls(capitalization=Nls.Capitalization.Title)
        final String displayName;
        final boolean running;
        final boolean defaultSubRunner;
        final boolean shouldBeChosenIfAlone;
        final Icon icon;
        final Color color;
        final Runnable runnable;

        MyRunner(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String displayName, boolean running, boolean defaultSubRunner, boolean shouldBeChosenIfAlone, @Nullable Icon icon, @Nullable Color color, @NotNull Runnable runnable) {
            if (displayName == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            this.displayName = displayName;
            this.running = running;
            this.defaultSubRunner = defaultSubRunner;
            this.shouldBeChosenIfAlone = shouldBeChosenIfAlone;
            this.icon = icon;
            this.color = color;
            this.runnable = runnable;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        @Nullable
        public Color getColor() {
            return this.color;
        }

        @Override
        public boolean isAlreadyRunning() {
            return this.running;
        }

        @Override
        public boolean isDefaultSubRunner() {
            return this.defaultSubRunner;
        }

        @Override
        public boolean shouldBeChosenIfAlone() {
            return this.shouldBeChosenIfAlone;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "displayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/DatabaseRunners$MyRunner";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

