/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.ConnectionTimerLauncher;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionTimer
implements ConnectionTimerLauncher,
Disposable {
    private static final long MIN_TIMEOUT_MS = 1000L;
    private static final long UNDEFINED = 0L;
    private final AtomicBoolean myBusy;
    private final Alarm myAlarm;
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final ConnectionHolder myConnectionHolder;
    private final ActionDescriptor myActionDescriptor;
    private volatile long myLastActivity;

    public ConnectionTimer(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull ConnectionHolder connectionHolder, @NotNull ActionDescriptor descriptor2, @NotNull Disposable parent2) {
        if (project == null) {
            ConnectionTimer.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            ConnectionTimer.$$$reportNull$$$0(1);
        }
        if (connectionHolder == null) {
            ConnectionTimer.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            ConnectionTimer.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            ConnectionTimer.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myDataSource = dataSource2;
        this.myConnectionHolder = connectionHolder;
        this.myActionDescriptor = descriptor2;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myBusy = new AtomicBoolean();
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    @Override
    public void launch() {
        this.myLastActivity = System.currentTimeMillis();
        this.pushRequest(this.getTimeout());
    }

    @Override
    public void relaunch() {
        this.pushRequest(this.computeDelay(this.myLastActivity));
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            ConnectionTimer.$$$reportNull$$$0(5);
        }
        return localDataSource;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ConnectionTimer.$$$reportNull$$$0(6);
        }
        return project;
    }

    @Override
    @Nullable
    public DatabaseConnection getConnection() {
        return this.myConnectionHolder.getConnection();
    }

    @Override
    public boolean destroyConnection() {
        return this.myConnectionHolder.close();
    }

    public void dispose() {
    }

    private long lastActivityTime() {
        return this.myLastActivity;
    }

    private boolean acquire() {
        return this.myBusy.compareAndSet(false, true);
    }

    private void release() {
        this.myBusy.set(false);
    }

    private long computeDelay(long lastActivityTime) {
        long timeout = this.getTimeout();
        if (timeout == 0L) {
            return 0L;
        }
        long timeSpent = System.currentTimeMillis() - lastActivityTime;
        return Math.max(1000L, timeout - timeSpent);
    }

    private long getTimeout() {
        return Math.max(0L, this.myActionDescriptor.getTimeout(this));
    }

    private void pushRequest(long delay) {
        if (delay == 0L || !this.myActionDescriptor.isEnabled(this) || !this.acquire()) {
            return;
        }
        try {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest((Runnable)new RequestProducer(this.myLastActivity), delay);
        }
        finally {
            this.release();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/ConnectionTimer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/ConnectionTimer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    static interface ConnectionHolder {
        public void runAsync(@NotNull Runnable var1);

        public boolean close();

        @Nullable
        public DatabaseConnection getConnection();
    }

    static interface ActionDescriptor {
        public long getTimeout(@NotNull ConnectionTimerLauncher var1);

        public boolean isEnabled(@NotNull ConnectionTimerLauncher var1);

        @NotNull
        public Runnable action(@NotNull ConnectionTimerLauncher var1);
    }

    private class RequestProducer
    implements Runnable {
        private final long myCreationTime;

        RequestProducer(long creationTime) {
            this.myCreationTime = creationTime;
        }

        @Override
        public void run() {
            if (!ConnectionTimer.this.myActionDescriptor.isEnabled(ConnectionTimer.this) || !ConnectionTimer.this.acquire()) {
                return;
            }
            Runnable action = ConnectionTimer.this.myActionDescriptor.action(ConnectionTimer.this);
            ConnectionTimer.this.myConnectionHolder.runAsync(() -> this.performAction(action));
        }

        protected void performAction(@NotNull Runnable action) {
            if (action == null) {
                RequestProducer.$$$reportNull$$$0(0);
            }
            ConnectionTimer.this.release();
            if (!ConnectionTimer.this.myActionDescriptor.isEnabled(ConnectionTimer.this)) {
                return;
            }
            long lastActivityTime = ConnectionTimer.this.lastActivityTime();
            if (this.myCreationTime != lastActivityTime) {
                ConnectionTimer.this.relaunch();
                return;
            }
            action.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/console/ConnectionTimer$RequestProducer", "performAction"));
        }
    }
}

