/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.pg;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.CommonPgCliArguments;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialogValidator
extends SimpleCliDialogValidator {
    public PgDialogValidator() {
        super(CommonPgArguments.FILE, CommonPgArguments.PASSWORD);
    }

    protected PgDialogValidator(String @NotNull [] fileArgs) {
        if (fileArgs == null) {
            PgDialogValidator.$$$reportNull$$$0(0);
        }
        super(fileArgs, CommonPgArguments.PASSWORD);
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull CliModel model2) {
        ValidationInfo info2;
        if (model2 == null) {
            PgDialogValidator.$$$reportNull$$$0(1);
        }
        return (info2 = super.createInfo(model2)) == null ? this.createInfoInternal(model2) : info2;
    }

    @Nullable
    private ValidationInfo createInfoInternal(@NotNull CliModel model2) {
        if (model2 == null) {
            PgDialogValidator.$$$reportNull$$$0(2);
        }
        CliArgument argument = this.getFormatArgument(model2.getCliComponents());
        CliComponent pathComponent = this.getPathComponent(model2.getCliComponents());
        if (this.checkFileError(pathComponent, argument)) {
            return new ValidationInfo(DatabaseBundle.message("dialog.message.path.must.point.on.file", new Object[0]), Objects.requireNonNull(pathComponent).getComponent());
        }
        if (this.checkDirError(pathComponent, argument)) {
            return new ValidationInfo(this.getInvalidDirectoryError(), Objects.requireNonNull(pathComponent).getComponent());
        }
        CliContextDescriptor cd = model2.getContext();
        return PgDialogValidator.checkDataOnly(cd) ? new ValidationInfo(DatabaseBundle.message("dialog.message.options.c.clean.data.only.cannot.be.used.together", new Object[0]), model2.getCommandComponent()) : (PgDialogValidator.checkIfExists(cd) ? new ValidationInfo(DatabaseBundle.message("dialog.message.option.if.exists.requires.option.c.clean", new Object[0]), model2.getCommandComponent()) : null);
    }

    @NlsContexts.DialogMessage
    @NotNull
    protected abstract String getInvalidDirectoryError();

    @NotNull
    protected List<CliArgument> getFileArgs() {
        List<CliArgument> list = Arrays.asList(CommonPgCliArguments.F_CUSTOM, CommonPgCliArguments.F_TAR);
        if (list == null) {
            PgDialogValidator.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected boolean isDirectoryWrong(@NotNull File file) {
        if (file == null) {
            PgDialogValidator.$$$reportNull$$$0(4);
        }
        return file.isFile();
    }

    @NotNull
    protected abstract StringCliArgument getPathArgument();

    private boolean checkDirError(@Nullable CliComponent component2, @Nullable CliArgument argument) {
        String text2 = PgDialogValidator.getText(component2);
        if (text2 == null) {
            return false;
        }
        File file = new File(text2);
        return this.isDirectoryWrong(file) && argument == CommonPgCliArguments.F_DIRECTORY;
    }

    @Nullable
    private CliArgument getFormatArgument(@NotNull List<CliComponent> components) {
        Condition condition2;
        CliComponent component3;
        if (components == null) {
            PgDialogValidator.$$$reportNull$$$0(5);
        }
        return (component3 = (CliComponent)ContainerUtil.find(components, (Condition)(condition2 = component2 -> ContainerUtil.containsIdentity(this.getFileArgs(), (Object)component2.getArgument()) || component2.getArgument() == CommonPgCliArguments.F_DIRECTORY))) == null ? null : component3.getArgument();
    }

    @Nullable
    private CliComponent getPathComponent(List<CliComponent> components) {
        return (CliComponent)ContainerUtil.find(components, component2 -> component2.getArgument() == this.getPathArgument());
    }

    private boolean checkFileError(@Nullable CliComponent component2, @Nullable CliArgument argument) {
        String text2 = PgDialogValidator.getText(component2);
        if (text2 == null) {
            return false;
        }
        File file = new File(text2);
        return file.isDirectory() && ContainerUtil.containsIdentity(this.getFileArgs(), (Object)argument);
    }

    @Nullable
    private static String getText(@Nullable CliComponent component2) {
        if (component2 == null) {
            return null;
        }
        JComponent swingComponent = component2.getComponent();
        if (!(swingComponent instanceof TextFieldWithBrowseButton)) {
            return null;
        }
        return ((TextFieldWithBrowseButton)swingComponent).getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDataOnly(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            PgDialogValidator.$$$reportNull$$$0(6);
        }
        if (ContainerUtil.find((Object[])CommonPgArguments.DATA_ONLY, cd::contains) == null) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkIfExists(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            PgDialogValidator.$$$reportNull$$$0(7);
        }
        if (!cd.contains("--if-exists")) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) != null) return false;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/dump/pg/PgDialogValidator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/dump/pg/PgDialogValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInfoInternal";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryWrong";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDataOnly";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkIfExists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

