/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.DbCliUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class CommonMysqlArguments {
    public static final String[] DEFAULTS_GROUP_SUFFIX = DbCliUtil.withEquality("--defaults-group-suffix");
    public static final String[] PASSWORD_PARAMETERIZABLE = DbCliUtil.withEquality("--password", "-p");
    public static final String[] MAX_ALLOWED_PACKET = DbCliUtil.withEquality("--max-allowed-packet");
    public static final String[] NET_BUFFER_LENGTH = DbCliUtil.withEquality("--net-buffer-length");
    public static final String[] PASSWORD = (String[])ContainerUtil.ar((Object[])new String[]{"--password", "-p"});
    public static final String[] COMMENTS = (String[])ContainerUtil.ar((Object[])new String[]{"--comments", "-i"});
    public static final String[] COMPRESS = (String[])ContainerUtil.ar((Object[])new String[]{"--compress", "-C"});
    public static final String[] DEFAULTS_FILE = DbCliUtil.withEquality("--defaults-file");
    public static final String[] VERBOSE = (String[])ContainerUtil.ar((Object[])new String[]{"--verbose", "-v"});
    public static final String[] VERSION = (String[])ContainerUtil.ar((Object[])new String[]{"--version", "-V"});
    public static final String[] DEFAULT_AUTH = DbCliUtil.withEquality("--default-auth");
    public static final String[] BIND_ADDRESS = DbCliUtil.withEquality("--bind-address");
    public static final String[] TLS_VERSION = DbCliUtil.withEquality("--tls-version");
    public static final String[] FORCE = (String[])ContainerUtil.ar((Object[])new String[]{"--force", "-f"});
    public static final String[] PLUGIN_DIR = DbCliUtil.withEquality("--plugin-dir");
    public static final String[] HELP = (String[])ContainerUtil.ar((Object[])new String[]{"--help", "-?"});
    public static final String[] SOCKET = DbCliUtil.withEquality("--socket", "-S");
    public static final String[] XML = (String[])ContainerUtil.ar((Object[])new String[]{"--xml", "-X"});
    public static final String[] QUICK = DbCliUtil.withEquality("--quick", "-q");
    public static final String[] DEBUG = DbCliUtil.withEquality("--debug", "-#");
    public static final String[] PROTOCOL = DbCliUtil.withEquality("--protocol");
    public static final String[] PORT = DbCliUtil.withEquality("--port", "-P");
    public static final String[] USER = DbCliUtil.withEquality("--user", "-u");
    public static final String[] HOST = DbCliUtil.withEquality("--host", "-h");
    public static final String ENABLE_CLEARTEXT_PLUGIN = "--enable-cleartext-plugin";
    public static final String PRINT_DEFAULTS = "--print-defaults";
    public static final String NO_DEFAULTS = "--no-defaults";
    public static final String DEBUG_CHECK = "--debug-check";
    public static final String SECURE_AUTH = "--secure-auth";
    public static final String DEBUG_INFO = "--debug-info";
    public static final String SSL = CommonMysqlArguments.ssl("");
    public static final String SKIP_SECURE_AUTH = CommonMysqlArguments.skip("--secure-auth");
    public static final String[] SKIP_QUICK = CommonMysqlArguments.skip(QUICK);
    public static final String SKIP_SSL = CommonMysqlArguments.skip(SSL);
    public static final String[] SSL_CRL_PATH = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-crlpath"));
    public static final String[] SSL_CA_PATH = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-capath"));
    public static final String[] SSL_CIPHER = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-cipher"));
    public static final String[] SSL_MODE = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-mode"));
    public static final String[] SSL_CERT = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-cert"));
    public static final String[] SSL_KEY = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-key"));
    public static final String[] SSL_CRL = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-crl"));
    public static final String[] SSL_CA = DbCliUtil.withEquality(CommonMysqlArguments.ssl("-ca"));
    public static final String SSL_VERIFY_SERVER_CERT = CommonMysqlArguments.ssl("-verify-server-cert");

    private CommonMysqlArguments() {
    }

    @NotNull
    public static String skip(@NotNull String option) {
        if (option == null) {
            CommonMysqlArguments.$$$reportNull$$$0(0);
        }
        String string = new StringBuilder(option).insert(2, "skip-").toString();
        if (string == null) {
            CommonMysqlArguments.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String[] skip(@NotNull String[] options2) {
        if (options2 == null) {
            CommonMysqlArguments.$$$reportNull$$$0(2);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String option : options2) {
            if (!option.startsWith("--")) continue;
            list.add(new StringBuilder(option).insert(2, "skip-").toString());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(list);
        if (stringArray == null) {
            CommonMysqlArguments.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    public static String ssl(@NotNull String suffix2) {
        if (suffix2 == null) {
            CommonMysqlArguments.$$$reportNull$$$0(4);
        }
        String string = "--ssl" + suffix2;
        if (string == null) {
            CommonMysqlArguments.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/argument/CommonMysqlArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/argument/CommonMysqlArguments";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ssl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "skip";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ssl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }
}

