/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliRunTargetProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\u0016\u0010+\u001a\u0004\u0018\u00010\u00072\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0012\u00101\u001a\u00020\u00072\b\b\u0001\u00102\u001a\u00020\u0007H\u0017J\u0018\u00103\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u0007H\u0016J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006:"}, d2={"Lcom/intellij/database/cli/CliRunTarget;", "Lcom/intellij/openapi/Disposable;", "provider", "Lcom/intellij/database/cli/CliRunTargetProvider;", "(Lcom/intellij/database/cli/CliRunTargetProvider;)V", "componentMap", "", "", "Ljavax/swing/JComponent;", "getComponentMap", "()Ljava/util/Map;", "getProvider", "()Lcom/intellij/database/cli/CliRunTargetProvider;", "supportsCommandLineValidation", "", "getSupportsCommandLineValidation", "()Z", "addRunTargetChangeListener", "", "runnable", "Ljava/lang/Runnable;", "adjustCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "commandLine", "checkFileStrict", "file", "Ljava/io/File;", "checkWslSymlink", "createExecutableFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "createPathChooser", "Lcom/intellij/openapi/fileChooser/PathChooserDialog;", "descriptor", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "createPathChooserDescriptor", "deserialize", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "keyPrefix", "dispose", "getPort", "defaultPort", "getPresentableUrl", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "patchFileChooserDescriptor", "patchPathLabel", "label", "serialize", "validateFilePath", "path", "validateModel", "Lcom/intellij/openapi/ui/ValidationInfo;", "model", "Lcom/intellij/database/cli/CliModel;", "intellij.database.impl"})
public abstract class CliRunTarget
implements Disposable {
    @NotNull
    private final CliRunTargetProvider provider;

    public CliRunTarget(@NotNull CliRunTargetProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
    }

    @NotNull
    public final CliRunTargetProvider getProvider() {
        return this.provider;
    }

    public void serialize(@NotNull PropertiesComponent properties2, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
    }

    public void deserialize(@NotNull PropertiesComponent properties2, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
    }

    @NotNull
    public Map<String, JComponent> getComponentMap() {
        return MapsKt.emptyMap();
    }

    public boolean getSupportsCommandLineValidation() {
        return true;
    }

    @Nullable
    public final FileChooserDescriptor createExecutableFileChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()));
    }

    @Nullable
    public final FileChooserDescriptor createPathChooserDescriptor() {
        return this.patchFileChooserDescriptor(new FileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor()));
    }

    @Nullable
    public FileChooserDescriptor patchFileChooserDescriptor(@NotNull FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2;
    }

    public void addRunTargetChangeListener(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
    }

    @NotNull
    public PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor descriptor2, @Nullable Project project, @NotNull Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        PathChooserDialog pathChooserDialog = FileChooserFactory.getInstance().createPathChooser(descriptor2, project, parentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)pathChooserDialog, (String)"createPathChooser(...)");
        return pathChooserDialog;
    }

    @NotNull
    public String getPresentableUrl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Nullable
    public ValidationInfo validateModel(@NotNull CliModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return null;
    }

    public boolean validateFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        return this.checkFileStrict(file) || this.checkWslSymlink(file);
    }

    private final boolean checkFileStrict(File file) {
        return file.exists() && file.isFile() && Files.isExecutable(file.toPath());
    }

    private final boolean checkWslSymlink(File file) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (!WslPath.Companion.isWslUncPath(string)) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        File parent2 = file2;
        String fileName = file.getName();
        File[] files2 = parent2.listFiles((arg_0, arg_1) -> CliRunTarget.checkWslSymlink$lambda$0(fileName, arg_0, arg_1));
        return files2 != null && files2.length == 1;
    }

    @NlsSafe
    @NotNull
    public String patchPathLabel(@NlsSafe @NotNull String label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        return label2;
    }

    @Nullable
    public String getPort(@Nullable String defaultPort) {
        return defaultPort;
    }

    @NotNull
    public GeneralCommandLine adjustCommandLine(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return commandLine;
    }

    public void dispose() {
    }

    private static final boolean checkWslSymlink$lambda$0(String $fileName, File file, String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)$fileName);
    }
}

