/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliLocalRunTarget;
import com.intellij.database.cli.CliLocalRunTargetProvider;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.CliRunTargetProvider;
import com.intellij.database.cli.component.CliPathTextField;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CliPanelDecorator
implements Disposable {
    private static final int WIDTH = 2;
    private final JPanel myPanel;
    private final JPanel radioButtonPanel;
    List<Pair<JBRadioButton, CliRunTarget>> myRunTargets;
    private final List<Runnable> myRunTargetChangeListeners;
    private final Map<CliComponent, JBLabel> myMutableLabels;
    private final Map<@NlsSafe String, JComponent> providerMap;
    private final ArrayList<JComponent> targetComponents;

    public CliPanelDecorator(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components, @NotNull Project project) {
        if (pathComponent == null) {
            CliPanelDecorator.$$$reportNull$$$0(0);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CliPanelDecorator.$$$reportNull$$$0(2);
        }
        this.radioButtonPanel = new JPanel((LayoutManager)new HorizontalLayout(16));
        this.myRunTargets = new SmartList();
        this.myRunTargetChangeListeners = new SmartList();
        this.myMutableLabels = new HashMap<CliComponent, JBLabel>();
        this.providerMap = new HashMap<String, JComponent>();
        this.targetComponents = new ArrayList();
        this.myPanel = new JPanel((LayoutManager)new VerticalLayout(20));
        this.initRunTarget(project);
        this.myPanel.add(this.getConfigurationPanel(pathComponent, components));
        this.myPanel.add(this.getOptionsPanel(components));
        this.addRunTargetChangeListener(() -> {
            CliRunTarget runTarget2 = this.getRunTarget();
            for (Map.Entry<CliComponent, JBLabel> entry : this.myMutableLabels.entrySet()) {
                String label2 = entry.getKey().getLabel();
                if (label2 == null) continue;
                String labelText = runTarget2.patchPathLabel(label2);
                entry.getValue().setText(labelText + ":");
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CliPanelDecorator.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public CliRunTarget getRunTarget() {
        for (Pair<JBRadioButton, CliRunTarget> entry : this.myRunTargets) {
            if (!((JBRadioButton)entry.getFirst()).isSelected()) continue;
            CliRunTarget cliRunTarget = (CliRunTarget)entry.getSecond();
            if (cliRunTarget == null) {
                CliPanelDecorator.$$$reportNull$$$0(4);
            }
            return cliRunTarget;
        }
        CliLocalRunTarget cliLocalRunTarget = CliRunTargetProvider.getDefaultRunTarget();
        if (cliLocalRunTarget == null) {
            CliPanelDecorator.$$$reportNull$$$0(5);
        }
        return cliLocalRunTarget;
    }

    public void addRunTargetChangeListener(@NotNull Runnable consumer2) {
        if (consumer2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(6);
        }
        this.myRunTargetChangeListeners.add(consumer2);
        for (Pair<JBRadioButton, CliRunTarget> pair : this.myRunTargets) {
            ((CliRunTarget)pair.getSecond()).addRunTargetChangeListener(consumer2);
        }
    }

    public void setRunTargetInfo(@NotNull String providerId, @NotNull PropertiesComponent properties2, @NotNull String keyPrefix) {
        if (providerId == null) {
            CliPanelDecorator.$$$reportNull$$$0(7);
        }
        if (properties2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(8);
        }
        if (keyPrefix == null) {
            CliPanelDecorator.$$$reportNull$$$0(9);
        }
        for (Pair<JBRadioButton, CliRunTarget> entry : this.myRunTargets) {
            CliRunTarget runTarget2 = (CliRunTarget)entry.getSecond();
            JBRadioButton button = (JBRadioButton)entry.getFirst();
            if (!runTarget2.getProvider().getId().equals(providerId)) continue;
            button.setSelected(true);
            this.onRunTargetSwitched();
            runTarget2.deserialize(properties2, keyPrefix);
        }
    }

    public void dispose() {
    }

    private void initRunTarget(@NotNull Project project) {
        if (project == null) {
            CliPanelDecorator.$$$reportNull$$$0(10);
        }
        List<CliRunTargetProvider> providers = CliRunTargetProvider.getAllProviders();
        ActionListener listener2 = e2 -> this.onRunTargetSwitched();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (CliRunTargetProvider provider : providers) {
            JBRadioButton radioButton = new JBRadioButton(provider.getDisplayName());
            if (provider instanceof CliLocalRunTargetProvider) {
                radioButton.setSelected(true);
            }
            this.radioButtonPanel.add((Component)radioButton);
            radioButton.addActionListener(listener2);
            buttonGroup.add((AbstractButton)radioButton);
            CliRunTarget runTarget2 = provider.createRunTarget(project);
            Disposer.register((Disposable)this, (Disposable)runTarget2);
            this.myRunTargets.add((Pair<JBRadioButton, CliRunTarget>)Pair.create((Object)radioButton, (Object)runTarget2));
            this.providerMap.putAll(runTarget2.getComponentMap());
        }
    }

    private void onRunTargetSwitched() {
        for (Pair<JBRadioButton, CliRunTarget> entry : this.myRunTargets) {
            JBRadioButton button = (JBRadioButton)entry.getFirst();
            boolean selected = button.isSelected();
            this.targetComponents.forEach(c2 -> c2.setVisible(selected));
            if (!selected) continue;
            for (Runnable consumer2 : this.myRunTargetChangeListeners) {
                consumer2.run();
            }
        }
    }

    private static void addPathToExecutableComponent(@NotNull JPanel panel2, @NotNull JComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(11);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(12);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(13);
        }
        JBLabel label2 = new JBLabel(DatabaseBundle.message("database.cli.integration.path.to.executable.pattern", new Object[0]));
        CliPanelDecorator.addLabeled(panel2, label2, component2, gbc);
    }

    private void addTargetComponents(JPanel panel2, GridBagConstraints gbc) {
        this.providerMap.keySet().forEach(key2 -> {
            JBLabel label2 = new JBLabel(key2.concat(":"));
            this.targetComponents.add((JComponent)label2);
            JComponent providerComponent = this.providerMap.get(key2);
            this.targetComponents.add(providerComponent);
            CliPanelDecorator.addLabeled(panel2, label2, providerComponent, gbc);
            this.targetComponents.forEach(c2 -> c2.setVisible(false));
        });
    }

    private JPanel getConfigurations(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
        if (pathComponent == null) {
            CliPanelDecorator.$$$reportNull$$$0(14);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(15);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = CliPanelDecorator.createConstraints();
        this.addTargetComponents(panel2, gbc);
        CliPanelDecorator.addPathToExecutableComponent(panel2, pathComponent, gbc);
        this.addComponents(panel2, gbc, ContainerUtil.filter(components, c2 -> CliPanelDecorator.isOutputComponent(c2)));
        return panel2;
    }

    private JPanel getConfigurationPanel(@NotNull JComponent pathComponent, @NotNull List<CliComponent> components) {
        if (pathComponent == null) {
            CliPanelDecorator.$$$reportNull$$$0(16);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(17);
        }
        JPanel titlePanel = new JPanel((LayoutManager)new HorizontalLayout(16));
        JBLabel titleLabel = new JBLabel(DatabaseBundle.message("database.cli.integration.run.target.panel.title", new Object[0]));
        titlePanel.add((Component)titleLabel);
        titlePanel.add(this.radioButtonPanel);
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.fill = 17;
        gbc.anchor = 17;
        CliPanelDecorator.addSeparatorInsets(gbc);
        panel2.add((Component)titlePanel, gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        CliPanelDecorator.addInnerInsets(gbc);
        panel2.add((Component)this.getConfigurations(pathComponent, components), gbc);
        return panel2;
    }

    private JPanel getOptionsPanel(@NotNull List<CliComponent> components) {
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(18);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        TitledSeparator separator = new TitledSeparator(DatabaseBundle.message("database.cli.integration.options.panel.additionalOptions", new Object[0]), null);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.fill = 2;
        CliPanelDecorator.addSeparatorInsets(gbc);
        panel2.add((Component)separator, gbc);
        JPanel labeledOptions = new JPanel(new GridBagLayout());
        this.addComponents(labeledOptions, CliPanelDecorator.createConstraints(), ContainerUtil.filter(components, c2 -> !CliPanelDecorator.isOutputComponent(c2)));
        CliPanelDecorator.addInnerInsets(gbc);
        CliPanelDecorator.nextLine(gbc);
        panel2.add((Component)labeledOptions, gbc);
        JPanel simpleOptions = new JPanel(new GridBagLayout());
        this.addComponents(simpleOptions, CliPanelDecorator.createConstraints(), ContainerUtil.filter(components, c2 -> c2.getLabel() == null));
        CliPanelDecorator.addInnerInsets(gbc);
        gbc.fill = 17;
        gbc.anchor = 17;
        CliPanelDecorator.nextLine(gbc);
        panel2.add((Component)simpleOptions, gbc);
        return panel2;
    }

    private void addComponents(@NotNull JPanel panel2, @NotNull GridBagConstraints gbc, @NotNull List<CliComponent> components) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(19);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(20);
        }
        if (components == null) {
            CliPanelDecorator.$$$reportNull$$$0(21);
        }
        for (CliComponent component2 : components) {
            this.addComponent(panel2, component2, gbc);
        }
    }

    private static boolean isOutputComponent(@NotNull CliComponent component2) {
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(22);
        }
        return DatabaseBundle.message("database.cli.integration.out.path", new Object[0]).equals(component2.getLabel());
    }

    private void addComponent(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(23);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(24);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(25);
        }
        if (component2.getLabel() == null) {
            CliPanelDecorator.addSimple(panel2, component2, gbc);
            return;
        }
        this.addLabeled(panel2, component2, gbc);
    }

    private static void addSimple(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(26);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(27);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(28);
        }
        CliPanelDecorator.noSpan(gbc);
        CliPanelDecorator.addSimpleInsets(gbc);
        CliPanelDecorator.addToolTip(component2);
        CliPanelDecorator.add(panel2, component2.getComponent(), gbc);
        CliPanelDecorator.addDescription(panel2, component2, gbc);
    }

    private static void addToolTip(@NotNull CliComponent component2) {
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(29);
        }
        String toolTipText = Arrays.stream(component2.getArgument().getArguments()).filter(s2 -> !s2.startsWith("--skip")).collect(Collectors.joining(", "));
        component2.getComponent().setToolTipText(toolTipText);
    }

    private void addLabeled(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(30);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(31);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(32);
        }
        JBLabel label2 = new JBLabel(component2.getLabel() + ":");
        CliPanelDecorator.addLabeled(panel2, label2, component2.getComponent(), gbc);
        CliPanelDecorator.addDescription(panel2, component2, gbc);
        if (component2 instanceof CliPathTextField) {
            this.myMutableLabels.put(component2, label2);
        }
    }

    private static void addLabeled(@NotNull JPanel panel2, @NotNull JBLabel label2, @NotNull JComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(33);
        }
        if (label2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(34);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(35);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(36);
        }
        CliPanelDecorator.noSpan(gbc);
        CliPanelDecorator.nextLine(gbc);
        CliPanelDecorator.addLabeledInsets(gbc);
        CliPanelDecorator.add(panel2, (JComponent)label2, gbc);
        CliPanelDecorator.span(gbc);
        CliPanelDecorator.addLabeledInsets(gbc);
        CliPanelDecorator.add(panel2, component2, gbc);
    }

    private static void addDescription(@NotNull JPanel panel2, @NotNull CliComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(37);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(38);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(39);
        }
        if (component2.getDescription() == null) {
            return;
        }
        CliPanelDecorator.nextCell(gbc);
        CliPanelDecorator.addDescriptionInsets(gbc);
        CliPanelDecorator.add(panel2, ComponentPanelBuilder.createCommentComponent((String)component2.getDescription(), (boolean)true, (int)100, (boolean)true), gbc);
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        CliPanelDecorator.reset(gbc);
        return gbc;
    }

    private static void reset(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(40);
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        CliPanelDecorator.noSpan(gbc);
    }

    private static void nextLine(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(41);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
    }

    private static void noSpan(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(42);
        }
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }

    private static void span(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(43);
        }
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
    }

    private static void nextCell(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(44);
        }
        if (gbc.gridx == 1) {
            CliPanelDecorator.nextLine(gbc);
            return;
        }
        CliPanelDecorator.addLabeledInsets(gbc);
        ++gbc.gridx;
    }

    private static void addLabeledInsets(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(45);
        }
        gbc.insets = new JBInsets(0, gbc.gridx == 0 ? 0 : 6, 6, 0);
    }

    private static void addDescriptionInsets(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(46);
        }
        gbc.insets = new JBInsets(0, 6, 0, 0);
    }

    private static void addSimpleInsets(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(47);
        }
        gbc.insets = new JBInsets(gbc.gridy == 0 ? 4 : 0, gbc.gridx > 0 ? 40 : 0, 4, 0);
    }

    private static void addInnerInsets(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(48);
        }
        gbc.insets = new JBInsets(0, 20, 0, 0);
    }

    private static void addSeparatorInsets(@NotNull GridBagConstraints gbc) {
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(49);
        }
        gbc.insets = new JBInsets(0, 0, 6, 0);
    }

    private static void add(@NotNull JPanel panel2, @NotNull JComponent component2, @NotNull GridBagConstraints gbc) {
        if (panel2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(50);
        }
        if (component2 == null) {
            CliPanelDecorator.$$$reportNull$$$0(51);
        }
        if (gbc == null) {
            CliPanelDecorator.$$$reportNull$$$0(52);
        }
        panel2.add((Component)component2, gbc);
        CliPanelDecorator.nextCell(gbc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathComponent";
                break;
            }
            case 1: 
            case 15: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliPanelDecorator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPrefix";
                break;
            }
            case 11: 
            case 19: 
            case 23: 
            case 26: 
            case 30: 
            case 33: 
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 12: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 35: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: 
            case 20: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gbc";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliPanelDecorator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRunTargetChangeListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setRunTargetInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initRunTarget";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPathToExecutableComponent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationPanel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsPanel";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addComponents";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isOutputComponent";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addSimple";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addToolTip";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addLabeled";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "nextLine";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "noSpan";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "span";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "nextCell";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addLabeledInsets";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptionInsets";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleInsets";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addInnerInsets";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addSeparatorInsets";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

