/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CliLexeme
implements Comparable<CliLexeme> {
    private final IElementType myType;
    private final int myStart;
    private final int myEnd;
    private final String myText;

    public CliLexeme(@NotNull String text2, @NotNull IElementType type2, int start2, int end) {
        if (text2 == null) {
            CliLexeme.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            CliLexeme.$$$reportNull$$$0(1);
        }
        this.myType = type2;
        this.myStart = start2;
        this.myEnd = end;
        this.myText = text2;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public TextRange asRange() {
        return new TextRange(this.myStart, this.myEnd);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            CliLexeme.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public IElementType getType() {
        IElementType iElementType = this.myType;
        if (iElementType == null) {
            CliLexeme.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public CliLexeme convertLineWrapToWhitespace() {
        CliLexeme cliLexeme = this.isLineWrap() ? new CliLexeme(" ", DbCliTokenType.BAD, this.myStart, this.myEnd) : this;
        if (cliLexeme == null) {
            CliLexeme.$$$reportNull$$$0(4);
        }
        return cliLexeme;
    }

    public boolean isArgument() {
        return this.myType == DbCliTokenType.LONG_PARAMETER || this.myType == DbCliTokenType.SHORT_PARAMETER;
    }

    public boolean isBad() {
        return this.myType == DbCliTokenType.BAD;
    }

    public boolean isParameter() {
        return this.myType == DbCliTokenType.VALUE;
    }

    public boolean isWhitespaceOrBad() {
        return this.isBad() && this.isWhitespace();
    }

    public boolean isWhitespace() {
        return StringUtil.equals((CharSequence)this.myText, (CharSequence)" ");
    }

    private boolean isLineWrap() {
        return this.isBad() && StringUtil.equals((CharSequence)this.myText, (CharSequence)"\n");
    }

    @Override
    public int compareTo(CliLexeme o2) {
        return Integer.compare(this.myStart, o2.myStart);
    }

    public int hashCode() {
        return this.myStart + this.myEnd * 31 + this.myText.hashCode();
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof CliLexeme)) {
            return false;
        }
        CliLexeme lexeme = (CliLexeme)obj2;
        return lexeme.myStart == this.myStart && lexeme.myEnd == this.myEnd && StringUtil.equals((CharSequence)lexeme.myText, (CharSequence)this.myText);
    }

    public String toString() {
        return this.myText + " [" + this.myType + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliLexeme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliLexeme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineWrapToWhitespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

