/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.datagrid.DataAuditors;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.util.NameTemplate;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CliConfigurationBase
implements CliConfiguration {
    private final List<CliArgumentGroup<?>> myGroups;
    private final String[] myHostArgs;
    private final String[] myPortArgs;
    private final String[] myUsernameArgs;
    private final String[] myPasswordArgs;
    private final String[] myFileArgs;
    private final String[] mySslCaArgs;
    private final String[] mySslCertArgs;
    private final String[] mySslKeyArgs;
    private final String myEnvironmentVarName;
    private final String myPropertyKey;
    private final String myName;
    protected static final GenerativePlaceholder TIMESTAMP_PLACEHOLDER = new GenerativePlaceholder("{timestamp}", (Supplier)DatabaseBundle.messagePointer("sql.code.generation.template.current.timestamp", new Object[0]), "2019-11-19 21:34:51"){
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        @Override
        @NotNull
        public String generate(@NotNull CliConfiguration.CliBuilderContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = FORMATTER.format(LocalDateTime.now());
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    protected static final GenerativePlaceholder DATA_SOURCE_PLACEHOLDER = new GenerativePlaceholder("{data_source}", (Supplier)DatabaseBundle.messagePointer("sql.code.generation.template.data.source", new Object[0]), "Postgres local"){

        @Override
        @NotNull
        public String generate(@NotNull CliConfiguration.CliBuilderContext context) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            String string = context.dataSource().getName();
            if (string == null) {
                2.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    protected CliConfigurationBase(@NotNull List<CliArgumentGroup<?>> groups2, String @NotNull [] hostArgs, String @NotNull [] portArgs, String @NotNull [] usernameArgs, String @NotNull [] passwordArgs, String @NotNull [] fileArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name2) {
        if (groups2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(0);
        }
        if (environmentVarName == null) {
            CliConfigurationBase.$$$reportNull$$$0(1);
        }
        if (propertyKey == null) {
            CliConfigurationBase.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(3);
        }
        if (hostArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(4);
        }
        if (portArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(5);
        }
        if (usernameArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(6);
        }
        if (passwordArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(7);
        }
        if (fileArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(8);
        }
        this(groups2, hostArgs, portArgs, usernameArgs, passwordArgs, fileArgs, null, null, null, environmentVarName, propertyKey, name2);
    }

    protected CliConfigurationBase(@NotNull List<CliArgumentGroup<?>> groups2, String @NotNull [] hostArgs, String @NotNull [] portArgs, String @NotNull [] usernameArgs, String @NotNull [] passwordArgs, String @NotNull [] fileArgs, String @Nullable [] sslCaArgs, String @Nullable [] sslCertArgs, String @Nullable [] sslKeyArgs, @NotNull String environmentVarName, @NotNull String propertyKey, @NotNull String name2) {
        if (groups2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(9);
        }
        if (environmentVarName == null) {
            CliConfigurationBase.$$$reportNull$$$0(10);
        }
        if (propertyKey == null) {
            CliConfigurationBase.$$$reportNull$$$0(11);
        }
        if (name2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(12);
        }
        if (hostArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(13);
        }
        if (portArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(14);
        }
        if (usernameArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(15);
        }
        if (passwordArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(16);
        }
        if (fileArgs == null) {
            CliConfigurationBase.$$$reportNull$$$0(17);
        }
        this.myGroups = groups2;
        this.myHostArgs = hostArgs;
        this.myPortArgs = portArgs;
        this.myUsernameArgs = usernameArgs;
        this.myPasswordArgs = passwordArgs;
        this.myFileArgs = fileArgs;
        this.mySslCaArgs = sslCaArgs;
        this.mySslCertArgs = sslCertArgs;
        this.mySslKeyArgs = sslKeyArgs;
        this.myEnvironmentVarName = environmentVarName;
        this.myPropertyKey = propertyKey;
        this.myName = name2;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            CliConfigurationBase.$$$reportNull$$$0(18);
        }
        List<String> list = variants;
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements2, @NotNull String text2) {
        if (elements2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(21);
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(text2);
        List mapped = ContainerUtil.map(lexemes, CliLexeme::convertLineWrapToWhitespace);
        String string = StringUtil.join((Collection)mapped, CliLexeme::getText, (String)"");
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command2, @NotNull CliConfiguration.Parameters parameters2) {
        if (command2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(23);
        }
        if (parameters2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(24);
        }
        String string = command2 + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myUsernameArgs), parameters2.username) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myHostArgs), parameters2.host) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.myPortArgs), parameters2.port) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCaArgs), parameters2.sslCa) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslCertArgs), parameters2.sslCert) + CliConfigurationBase.notNullPair(DbCliUtil.extractParameterizable(this.mySslKeyArgs), parameters2.sslKey);
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        if (SystemInfo.isLinux) {
            return "/usr/bin";
        }
        if (SystemInfo.isMac) {
            return "/usr/local/bin";
        }
        return null;
    }

    @Override
    @NotNull
    public List<CliComponent> createComponents(@NotNull CliModel model2) {
        if (model2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(27);
        }
        List<CliComponent> list = this.myGroups.stream().flatMap(group2 -> group2.createComponents(model2).stream()).collect(Collectors.toList());
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPropertyKey() {
        String string = this.myPropertyKey;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterSearcher getFileParameterSearcher() {
        return new CliParameterSearcherImpl(this.myFileArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        return new LexemeIndicators(this.myPasswordArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getUsernameIndicators() {
        return new LexemeIndicators(this.myUsernameArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getHostIndicators() {
        return new LexemeIndicators(this.myHostArgs);
    }

    @Override
    @NotNull
    public LexemeIndicators getPortIndicators() {
        return new LexemeIndicators(this.myPortArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCertIndicators() {
        return this.mySslCertArgs == null ? null : new LexemeIndicators(this.mySslCertArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslKeyIndicators() {
        return this.mySslKeyArgs == null ? null : new LexemeIndicators(this.mySslKeyArgs);
    }

    @Override
    @Nullable
    public LexemeIndicators getSslCaIndicators() {
        return this.mySslCaArgs == null ? null : new LexemeIndicators(this.mySslCaArgs);
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        return "--help";
    }

    @Override
    @NotNull
    public String getValidationCommand() {
        return "--version";
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        CliConfiguration.CliParameterProcessor cliParameterProcessor = CliParameterProcessorBase.INSTANCE;
        if (cliParameterProcessor == null) {
            CliConfigurationBase.$$$reportNull$$$0(30);
        }
        return cliParameterProcessor;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            CliConfigurationBase.$$$reportNull$$$0(31);
        }
        return new CliBuilderBase(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.myEnvironmentVarName, this.getSubstitutor());
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = DatabaseObjectsPreparer.idle().onlyIf((Condition<Collection<DbElement>>)((Condition)collection2 -> JBIterable.from((Iterable)collection2).map(e2 -> e2.getDataSource()).unique().size() == 1)).filter((Condition<DbElement>)((Condition)e2 -> ArrayUtil.contains((Object)e2.getKind(), (Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.SCHEMA}) || e2 instanceof DbDataSource || DbImplUtilCore.isDataTable((DasTable)ObjectUtils.tryCast((Object)e2, DasTable.class)))).requireNotEmpty();
        if (databaseObjectsPreparer == null) {
            CliConfigurationBase.$$$reportNull$$$0(32);
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    protected String getEnvironmentVarName() {
        String string = this.myEnvironmentVarName;
        if (string == null) {
            CliConfigurationBase.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    @Nullable
    public CliConfiguration.CliSubstitutor getSubstitutor() {
        return null;
    }

    @NotNull
    protected abstract StringCliArgument getPathArgument();

    @NotNull
    private static String notNullPair(@NotNull String argument, @Nullable String parameter) {
        if (argument == null) {
            CliConfigurationBase.$$$reportNull$$$0(34);
        }
        Object object = parameter == null || argument.isEmpty() ? "" : " " + argument + parameter;
        if (object == null) {
            CliConfigurationBase.$$$reportNull$$$0(35);
        }
        return object;
    }

    protected static void put(@NotNull Map<String, String> map2, @NotNull String text2, String ... args2) {
        if (map2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(36);
        }
        if (text2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(37);
        }
        if (args2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(38);
        }
        for (String arg : args2) {
            map2.put(arg, text2);
        }
    }

    @NotNull
    protected static List<CliLexeme> removeAll(@NotNull List<CliLexeme> lexemes, String ... args2) {
        if (lexemes == null) {
            CliConfigurationBase.$$$reportNull$$$0(39);
        }
        if (args2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(40);
        }
        return new ArrayList<CliLexeme>(ContainerUtil.filter(lexemes, (Condition)Conditions.not(DbCliUtil.lexemeFinder(args2))));
    }

    @NotNull
    protected static List<CliLexeme> addAll(@NotNull List<CliLexeme> lexemes, @NotNull String command2, String ... args2) {
        if (lexemes == null) {
            CliConfigurationBase.$$$reportNull$$$0(41);
        }
        if (command2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(42);
        }
        if (args2 == null) {
            CliConfigurationBase.$$$reportNull$$$0(43);
        }
        int offset = 0;
        for (String arg : args2) {
            int spaceLength;
            int end = command2.length() + offset;
            CliLexeme last2 = (CliLexeme)ContainerUtil.getLastItem(lexemes);
            boolean isSpace = last2 != null && last2.isWhitespace();
            int n = spaceLength = isSpace ? 0 : 1;
            if (!isSpace) {
                lexemes.add(new CliLexeme(" ", DbCliTokenType.BAD, end, end + 1));
            }
            CliLexeme lexeme = new CliLexeme(arg, DbCliTokenType.LONG_PARAMETER, end + spaceLength, end + arg.length() + spaceLength);
            offset += arg.length() + spaceLength;
            lexemes.add(lexeme);
        }
        List<CliLexeme> list = lexemes;
        if (list == null) {
            CliConfigurationBase.$$$reportNull$$$0(44);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 22, 25, 26, 28, 29, 30, 32, 33, 35, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentVarName";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostArgs";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portArgs";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usernameArgs";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordArgs";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 21: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeArguments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyKey";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterProcessor";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVarName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullPair";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 44: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeArguments";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createComponents";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notNullPair";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 22, 25, 26, 28, 29, 30, 32, 33, 35, 44 -> new IllegalStateException(string);
        };
    }

    private static final class CliParameterSearcherImpl
    implements CliConfiguration.CliParameterSearcher {
        private final String[] myArgs;

        private CliParameterSearcherImpl(String @NotNull [] args2) {
            if (args2 == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(0);
            }
            this.myArgs = args2;
        }

        @Override
        @Nullable
        public String search(@NotNull String command2, @NotNull List<String> parameterizable) {
            if (command2 == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(1);
            }
            if (parameterizable == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(2);
            }
            return DbCliUtil.getArgumentValue(command2, parameterizable, this.myArgs);
        }

        @Override
        @Nullable
        public TextRange searchRange(@NotNull String command2, @NotNull List<String> parameterizable) {
            if (command2 == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(3);
            }
            if (parameterizable == null) {
                CliParameterSearcherImpl.$$$reportNull$$$0(4);
            }
            return DbCliUtil.getArgumentValueRange(command2, parameterizable, this.myArgs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliParameterSearcherImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "search";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CliParameterProcessorBase
    implements CliConfiguration.CliParameterProcessor {
        private static final CliConfiguration.CliParameterProcessor INSTANCE = new CliParameterProcessorBase();

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(1);
            }
            String string = DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter));
            if (string == null) {
                CliParameterProcessorBase.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexeme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliParameterProcessorBase";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class CliBuilderBase
    implements CliConfiguration.CliBuilder {
        protected final Project myProject;
        protected final CliConfiguration.Operation myOperation;
        protected final String myName;
        private final CliConfiguration.CliParameterProcessor myProcessor;
        private final String myEnvName;
        private final CliConfiguration.CliSubstitutor mySubstitutor;

        public CliBuilderBase(@NotNull CliConfiguration.CliParameterProcessor processor2, @NotNull Project project, @NotNull CliConfiguration.Operation operation2, @NotNull String name2, @NotNull String envName, @Nullable CliConfiguration.CliSubstitutor substitutor) {
            if (processor2 == null) {
                CliBuilderBase.$$$reportNull$$$0(0);
            }
            if (project == null) {
                CliBuilderBase.$$$reportNull$$$0(1);
            }
            if (operation2 == null) {
                CliBuilderBase.$$$reportNull$$$0(2);
            }
            if (name2 == null) {
                CliBuilderBase.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                CliBuilderBase.$$$reportNull$$$0(4);
            }
            this.myProcessor = processor2;
            this.myProject = project;
            this.myOperation = operation2;
            this.myName = name2;
            this.myEnvName = envName;
            this.mySubstitutor = substitutor;
        }

        @NotNull
        protected Pair<GeneralCommandLine, String> prebuild(@NotNull CliConfiguration.CliBuilderContext context) {
            if (context == null) {
                CliBuilderBase.$$$reportNull$$$0(5);
            }
            String finalCommand = this.mySubstitutor == null ? context.command() : this.mySubstitutor.substitute(context);
            List<String> args2 = this.getArguments(context.parameterizable(), finalCommand);
            GeneralCommandLine line = DbCliUtil.buildCommandLine(args2);
            this.setPassword(line, context);
            Pair pair = Pair.create((Object)line, (Object)finalCommand);
            if (pair == null) {
                CliBuilderBase.$$$reportNull$$$0(6);
            }
            return pair;
        }

        @Override
        @NotNull
        public Pair<GeneralCommandLine, String> build(@NotNull CliConfiguration.CliBuilderContext context) {
            if (context == null) {
                CliBuilderBase.$$$reportNull$$$0(7);
            }
            Pair<GeneralCommandLine, String> result2 = this.prebuild(context);
            GeneralCommandLine line = context.runTarget().adjustCommandLine((GeneralCommandLine)result2.first);
            Pair pair = Pair.create((Object)line, (Object)((String)result2.second));
            if (pair == null) {
                CliBuilderBase.$$$reportNull$$$0(8);
            }
            return pair;
        }

        private void setPassword(@NotNull GeneralCommandLine line, @NotNull CliConfiguration.CliBuilderContext context) {
            String password;
            if (line == null) {
                CliBuilderBase.$$$reportNull$$$0(9);
            }
            if (context == null) {
                CliBuilderBase.$$$reportNull$$$0(10);
            }
            if ((password = context.password()) == null) {
                return;
            }
            if (!this.myEnvName.isEmpty()) {
                line.withEnvironment(this.myEnvName, password);
            }
            if (context.wslDistribution() != null) {
                line.withEnvironment("WSLENV", this.myEnvName);
            }
        }

        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command2) {
            if (parameterizable == null) {
                CliBuilderBase.$$$reportNull$$$0(11);
            }
            if (command2 == null) {
                CliBuilderBase.$$$reportNull$$$0(12);
            }
            List<String> list = DbCliUtil.getCommandLineArguments(this.myProcessor, command2, parameterizable);
            if (list == null) {
                CliBuilderBase.$$$reportNull$$$0(13);
            }
            return list;
        }

        @Override
        @NotNull
        public CliConfiguration.CliNotificationManager getNotificationManager() {
            return new CliNotificationManagerBase(this.myProject, this.myOperation, this.myName);
        }

        @Override
        public void primeProcess(@NotNull OSProcessHandler handler2, @NotNull GeneralCommandLine commandLine, @NotNull CliConfiguration.CliBuilderContext context) {
            if (handler2 == null) {
                CliBuilderBase.$$$reportNull$$$0(14);
            }
            if (commandLine == null) {
                CliBuilderBase.$$$reportNull$$$0(15);
            }
            if (context == null) {
                CliBuilderBase.$$$reportNull$$$0(16);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 8, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: 
                case 7: 
                case 10: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliBuilderBase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prebuild";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "prebuild";
                    break;
                }
                case 6: 
                case 8: 
                case 13: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setPassword";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "primeProcess";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 8, 13 -> new IllegalStateException(string);
            };
        }
    }

    protected static abstract class GenerativePlaceholder
    extends NameTemplate.Placeholder {
        protected GenerativePlaceholder(@NotNull String text2, @NotNull Supplier<String> desc, @NotNull String example) {
            if (text2 == null) {
                GenerativePlaceholder.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                GenerativePlaceholder.$$$reportNull$$$0(1);
            }
            if (example == null) {
                GenerativePlaceholder.$$$reportNull$$$0(2);
            }
            super(text2, desc, example);
        }

        @NotNull
        public abstract String generate(@NotNull CliConfiguration.CliBuilderContext var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "desc";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "example";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/cli/CliConfigurationBase$GenerativePlaceholder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class CliSubstitutorBase
    implements CliConfiguration.CliSubstitutor {
        private final CliConfigurationBase myConfiguration;
        protected final List<GenerativePlaceholder> mySupportedPlaceholders;

        public CliSubstitutorBase(@NotNull CliConfigurationBase configuration, @NotNull List<GenerativePlaceholder> placeholders) {
            if (configuration == null) {
                CliSubstitutorBase.$$$reportNull$$$0(0);
            }
            if (placeholders == null) {
                CliSubstitutorBase.$$$reportNull$$$0(1);
            }
            this.myConfiguration = configuration;
            this.mySupportedPlaceholders = placeholders;
        }

        @Override
        @NotNull
        public String substitute(@NotNull CliConfiguration.CliBuilderContext context) {
            String windowsPath;
            String wslPath;
            if (context == null) {
                CliSubstitutorBase.$$$reportNull$$$0(2);
            }
            String command2 = context.command();
            List<String> parameterizable = context.parameterizable();
            TextRange fileRange = this.myConfiguration.getFileParameterSearcher().searchRange(command2, parameterizable);
            if (fileRange == null) {
                String string = command2;
                if (string == null) {
                    CliSubstitutorBase.$$$reportNull$$$0(3);
                }
                return string;
            }
            String file = fileRange.substring(command2);
            NameTemplate.SubstitutionBuilder substitutionBuilder = new NameTemplate.SubstitutionBuilder(file);
            for (GenerativePlaceholder placeholder : this.mySupportedPlaceholders) {
                substitutionBuilder.substitute((NameTemplate.Placeholder)placeholder, FileUtil.sanitizeFileName((String)placeholder.generate(context)));
            }
            Object fileNameWithSubstitutions = substitutionBuilder.build();
            StringCliArgument pathArgument = this.myConfiguration.getPathArgument();
            WSLDistribution wslDistribution = context.wslDistribution();
            if (wslDistribution != null && (wslPath = wslDistribution.getWslPath(windowsPath = pathArgument.getUnquoter().apply(((String)fileNameWithSubstitutions).trim()))) != null) {
                fileNameWithSubstitutions = pathArgument.getQuoter().apply(wslPath) + " ";
            }
            String string = command2.substring(0, fileRange.getStartOffset()) + (String)fileNameWithSubstitutions + command2.substring(fileRange.getEndOffset());
            if (string == null) {
                CliSubstitutorBase.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDocumentation() {
            String prefix = DatabaseBundle.message("database.cli.integration.substitution.pattern.message.pattern", new Object[0]);
            String string = prefix + ": " + StringUtil.join(this.mySupportedPlaceholders, p2 -> p2.text, (String)", ");
            if (string == null) {
                CliSubstitutorBase.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public Collection<String> getDefaultPatterns() {
            List<String> list = List.of(CliConfigurationBase.DATA_SOURCE_PLACEHOLDER.text, CliConfigurationBase.TIMESTAMP_PLACEHOLDER.text);
            if (list == null) {
                CliSubstitutorBase.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placeholders";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliSubstitutorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliSubstitutorBase";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocumentation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected static class TablePlaceholder
    extends ArgumentBasedPlaceholder {
        public TablePlaceholder(@NotNull StringCliArgument argument) {
            if (argument == null) {
                TablePlaceholder.$$$reportNull$$$0(0);
            }
            super("{table}", DatabaseBundle.messagePointer("sql.code.generation.template.table", new Object[0]), "postgres", argument, "unknown_table");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/cli/CliConfigurationBase$TablePlaceholder", "<init>"));
        }
    }

    protected static class DatabasePlaceholder
    extends ArgumentBasedPlaceholder {
        public DatabasePlaceholder(@NotNull StringCliArgument argument) {
            if (argument == null) {
                DatabasePlaceholder.$$$reportNull$$$0(0);
            }
            super("{database}", DatabaseBundle.messagePointer("sql.code.generation.template.database", new Object[0]), "postgres", argument, "unknown_db");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/cli/CliConfigurationBase$DatabasePlaceholder", "<init>"));
        }
    }

    protected static class ArgumentBasedPlaceholder
    extends GenerativePlaceholder {
        private final StringCliArgument myArgument;
        private final String myDefaultValue;

        protected ArgumentBasedPlaceholder(@NotNull String text2, @NotNull Supplier<String> desc, @NotNull String example, @NotNull StringCliArgument argument, @NotNull String defaultValue) {
            if (text2 == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(1);
            }
            if (example == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(2);
            }
            if (argument == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(3);
            }
            if (defaultValue == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(4);
            }
            super(text2, desc, example);
            this.myArgument = argument;
            this.myDefaultValue = defaultValue;
        }

        @Nullable
        private TextRange searchRange(@NotNull String command2, @NotNull List<String> parameterizable) {
            ArrayList<CliLexeme> lexemes;
            CliLexeme executable;
            if (command2 == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(5);
            }
            if (parameterizable == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(6);
            }
            if ((executable = (CliLexeme)ContainerUtil.getFirstItem(lexemes = new ArrayList<CliLexeme>(DbCliUtil.filteredLexemes(command2, parameterizable)))) != null && executable.isParameter()) {
                lexemes.remove(executable);
            }
            CliContextDescriptor cd = new CliContextDescriptor(lexemes, CliContextDescriptor.Operation.UNKNOWN);
            ArrayList suitable = new ArrayList();
            DbCliUtil.iterateOverLexemes(command2, lexemes, (cur, next) -> {
                if (this.myArgument.isMyLexeme(command2, cur, next, cd)) {
                    suitable.add(Pair.create((Object)cur, (Object)next));
                }
            });
            if (suitable.size() != 1) {
                return null;
            }
            Pair param = Objects.requireNonNull((Pair)ContainerUtil.getFirstItem(suitable));
            return this.myArgument.getComponentValueRange(command2, (CliLexeme)param.first, (CliLexeme)param.second, cd);
        }

        @Nullable
        protected String search(@NotNull String command2, @NotNull List<String> parameterizable) {
            TextRange range;
            if (command2 == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(7);
            }
            if (parameterizable == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(8);
            }
            return (range = this.searchRange(command2, parameterizable)) == null ? null : DbCliUtil.clearString(DbCliUtil.cutParameter(command2, range), this.myArgument.getUnquoter());
        }

        @Override
        @NotNull
        public String generate(@NotNull CliConfiguration.CliBuilderContext context) {
            if (context == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(9);
            }
            String command2 = context.command();
            List<String> parameterizable = context.parameterizable();
            String string = (String)ObjectUtils.notNull((Object)this.search(command2, parameterizable), (Object)this.myDefaultValue);
            if (string == null) {
                ArgumentBasedPlaceholder.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "example";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$ArgumentBasedPlaceholder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$ArgumentBasedPlaceholder";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "searchRange";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "search";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "generate";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10 -> new IllegalStateException(string);
            };
        }
    }

    protected static class CliNotificationManagerBase
    implements CliConfiguration.CliNotificationManager {
        private static final Logger LOG = Logger.getInstance(CliNotificationManagerBase.class);
        private static final int DELAY = 50;
        private final Alarm myQueue;
        private final Project myProject;
        private final CliConfiguration.Operation myOperation;
        private final String myName;
        private DasDataSource mySystem;
        private volatile boolean myFirst;

        public CliNotificationManagerBase(@NotNull Project project, @NotNull CliConfiguration.Operation operation2, @NotNull String name2) {
            if (project == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(0);
            }
            if (operation2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myOperation = operation2;
            this.myName = name2;
            this.myQueue = new Alarm();
            this.myFirst = true;
        }

        @Override
        public void start(@NotNull ProgressIndicator indicator, @NotNull DasDataSource system) {
            if (indicator == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(3);
            }
            if (system == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(4);
            }
            this.mySystem = system;
            String startText = this.myOperation.getStartText(this.myName, system.getName());
            LOG.info(startText);
            indicator.setText(startText);
        }

        @Override
        public void update(@NotNull ProgressIndicator indicator, @NotNull DataAuditors.PrintingAdapter reporter, @NlsContexts.ProgressDetails @NotNull String text2, @NotNull Key outputType) {
            if (indicator == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(5);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(7);
            }
            if (outputType == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(8);
            }
            if (indicator.isCanceled()) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)text2)) {
                return;
            }
            ConsoleViewContentType type2 = CliNotificationManagerBase.getType(outputType);
            this.notification(reporter, type2, text2);
            indicator.setText2(text2);
        }

        @Override
        public void finished(@NotNull String path, @NotNull DataAuditors.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(9);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(10);
            }
            if (cancelled) {
                this.disposeQueue();
                this.notifyFinish(path, reporter, true);
                return;
            }
            this.myQueue.addRequest(() -> {
                this.notifyFinish(path, reporter, false);
                this.disposeQueue();
            }, 50);
        }

        private void disposeQueue() {
            Disposer.dispose((Disposable)this.myQueue);
        }

        private void notifyFinish(@NotNull String path, @NotNull DataAuditors.PrintingAdapter reporter, boolean cancelled) {
            if (path == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(11);
            }
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(12);
            }
            String message2 = DatabaseBundle.message("notification.content.choice.process.cancelled.process.finished", this.myName, cancelled ? 0 : 1);
            LOG.info(message2);
            reporter.print(message2);
            if (this.myOperation == CliConfiguration.Operation.RESTORE) {
                DbUIUtil.createNotification(this.mySystem, message2, NotificationType.INFORMATION, "CliNotificationManagerBase.restore.finished").notify(this.myProject);
                return;
            }
            DbUIUtil.createFileLinkNotification(this.myProject, this.mySystem, message2, NotificationType.INFORMATION, path, "CliNotificationManagerBase.dump.finished").notify(this.myProject);
        }

        @NotNull
        private static ConsoleViewContentType getType(Key outputType) {
            ConsoleViewContentType consoleViewContentType = outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.SYSTEM ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT;
            if (consoleViewContentType == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(13);
            }
            return consoleViewContentType;
        }

        private void notification(@NotNull DataAuditors.PrintingAdapter reporter, @NotNull ConsoleViewContentType type2, @NlsContexts.NotificationContent @NotNull String text2) {
            if (reporter == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(14);
            }
            if (type2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(15);
            }
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(16);
            }
            if (this.myFirst) {
                this.myQueue.addRequest(() -> reporter.println(this.getCommandText(text2), type2), 0);
                this.myFirst = false;
                return;
            }
            LOG.info(text2);
            this.myQueue.addRequest(() -> reporter.rawPrint(text2, type2), 50);
        }

        @NlsContexts.NotificationContent
        @NotNull
        protected String getCommandText(@NlsContexts.NotificationContent @NotNull String text2) {
            if (text2 == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(17);
            }
            String string = text2;
            if (string == null) {
                CliNotificationManagerBase.$$$reportNull$$$0(18);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 6: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 7: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/CliConfigurationBase$CliNotificationManagerBase";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "finished";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyFinish";
                    break;
                }
                case 13: 
                case 18: {
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "notification";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13, 18 -> new IllegalStateException(string);
            };
        }
    }
}

