/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceDetector {
    public static final ExtensionPointName<DataSourceDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.dataSourceDetector");

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            DataSourceDetector.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void collectDataSources(@NotNull Project project, @NotNull Builder builder) {
        if (project == null) {
            DataSourceDetector.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            DataSourceDetector.$$$reportNull$$$0(2);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.collectDataSources(module, builder, false);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull Builder builder, boolean onTheFly) {
        if (module == null) {
            DataSourceDetector.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            DataSourceDetector.$$$reportNull$$$0(4);
        }
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            DataSourceDetector.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/autoconfig/DataSourceDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDataSources";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelevantFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Builder {
        public Builder commit();

        public Builder reset();

        public DriverBuilder driver(@NotNull Dbms var1);

        public Builder withCallback(@NotNull Callback var1);

        public Builder withName(@Nullable String var1);

        public Builder withComment(@Nullable String var1);

        public Builder withGroupName(@Nullable String var1);

        public Builder withUrl(@Nullable String var1);

        public Builder withUser(@Nullable String var1);

        public Builder withPassword(@Nullable String var1);

        public Builder withAuthProviderId(@Nullable String var1);

        public Builder withDriverProperty(@Nullable String var1, @Nullable String var2);

        public Builder withJdbcAdditionalProperty(@Nullable String var1, @Nullable String var2);

        public Builder withDriverClass(@Nullable String var1);

        public Builder withDbms(@Nullable Dbms var1);

        public Builder withDriver(@Nullable String var1);

        public Builder withVMOptions(@Nullable String var1);

        public Builder withVMEnv(@Nullable String var1, @Nullable String var2);

        public Builder withOrigin(@Nullable Object var1);
    }

    public static abstract class Callback {
        public void onCreated(@NotNull DasDataSource dataSource2) {
            if (dataSource2 == null) {
                Callback.$$$reportNull$$$0(0);
            }
        }

        public void onUpdated(@NotNull DasDataSource dataSource2) {
            if (dataSource2 == null) {
                Callback.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/autoconfig/DataSourceDetector$Callback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DriverBuilder {
        public Builder commitDriver();

        public DriverBuilder withName(@Nullable String var1);

        public DriverBuilder withComment(@Nullable String var1);

        public DriverBuilder withDriverClass(@Nullable String var1);

        public DriverBuilder withAdditionalJar(@Nullable String var1);

        public DriverBuilder withDriverProperty(@Nullable String var1, @Nullable String var2);

        public DriverBuilder withVMOptions(@Nullable String var1);

        public DriverBuilder withVMEnv(@Nullable String var1, @Nullable String var2);
    }
}

