/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.BaseModifyObjectAction;
import com.intellij.database.actions.ddl.CreateObjectActionHelper;
import com.intellij.database.actions.ddl.DbModifyObjectDialog;
import com.intellij.database.actions.ddl.DbModifyObjectDialogPanel;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.families.ObjectsFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CreateObjectAction
extends DumbAwareAction {
    protected final BasicMetaObject<?> myMeta;
    protected final ModelHelper.ObjectKindVariant myVariant;

    protected CreateObjectAction(@NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant) {
        if (meta == null) {
            CreateObjectAction.$$$reportNull$$$0(0);
        }
        if (variant == null) {
            CreateObjectAction.$$$reportNull$$$0(1);
        }
        super(() -> variant.getText(meta), ModelFacade.forDbms(meta.getModel().dbms).getModelHelper().getIcon(meta.kind, variant));
        this.myMeta = meta;
        this.myVariant = variant;
    }

    public static boolean isSupported(@NotNull BasicElement e2, boolean alone) {
        if (e2 == null) {
            CreateObjectAction.$$$reportNull$$$0(2);
        }
        if (e2 instanceof VmElement) {
            return true;
        }
        Dbms dbms = DbImplUtilCore.getDbms(e2);
        ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e2);
        BasicModel model2 = e2.getModel();
        return (alone ? capabilities.getCreateAlone() : capabilities.getCreate()).get(model2 == null ? Version.INFINITY : model2.getRoot().getServerVersion());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreateObjectAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        DbContextDataSourceElements<BasicObjectNode> selection2;
        BasicObjectNode element2;
        if (e2 == null) {
            CreateObjectAction.$$$reportNull$$$0(4);
        }
        boolean visible = (element2 = CreateObjectAction.getSingle(selection2 = CreateObjectAction.getSelection(e2))) != null && BaseModifyObjectAction.canPerformOn(selection2.getDataSource(), this.myMeta) && CreateObjectAction.getParent(element2, this.myMeta) != null && CreateObjectAction.isSupported(this.myMeta.newDataObject(), true);
        e2.getPresentation().setVisible(visible);
        boolean canModify = selection2 != null && CreateObjectAction.canModify(selection2.getProject(), selection2.getDataSource(), element2, this.myMeta);
        e2.getPresentation().setEnabled(visible && canModify);
    }

    @TestOnly
    public boolean matches(@NotNull BasicMetaObject<?> meta, @Nullable ModelHelper.ObjectKindVariant variant) {
        if (meta == null) {
            CreateObjectAction.$$$reportNull$$$0(5);
        }
        return meta == this.myMeta && (variant == null || variant == this.myVariant);
    }

    public static boolean canModify(Project project, DasDataSource source, BasicObjectNode element2, @NotNull BasicMetaObject<?> target2) {
        if (target2 == null) {
            CreateObjectAction.$$$reportNull$$$0(6);
        }
        if (target2.kindOf(VmElement.class)) {
            return true;
        }
        if (element2 instanceof BasicElement) {
            DbElement dbElement = DbImplUtilCore.findElement(project, source, (DasObject)((Object)element2));
            return ImportUtil.canModify(dbElement);
        }
        return true;
    }

    @Nullable
    public static BasicObjectNode getParent(@Nullable BasicObjectNode e2, BasicMetaObject<?> meta) {
        return e2 == null || meta.getParent() == e2.getMetaObject() ? e2 : CreateObjectAction.getParent(e2.getParent(), meta);
    }

    @NotNull
    protected DbObjectEditorBuilder createEditorBuilder() {
        return new DbObjectEditorBuilder();
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        DbContextDataSourceElements<BasicObjectNode> selection2;
        BasicObjectNode element2;
        BasicModel model2;
        if (e2 == null) {
            CreateObjectAction.$$$reportNull$$$0(7);
        }
        BasicModel basicModel = model2 = (element2 = CreateObjectAction.getSingle(selection2 = CreateObjectAction.getSelection(e2))) == null ? null : element2.getModel();
        if (model2 == null) {
            return;
        }
        BasicObjectNode parent2 = CreateObjectAction.getParent(element2, this.myMeta);
        if (parent2 == null) {
            return;
        }
        RawDataSource dataSource2 = selection2.getDataSource();
        BasicNamespace current = CreateObjectAction.getCurrentNamespace(dataSource2, parent2);
        SearchPath searchPath = ObjectPaths.searchPathOf(current);
        Set contextElements = selection2.asIterable().toSet();
        CreateBootstrapper bootstrapper = new CreateBootstrapper(selection2.getProject(), dataSource2, model2, searchPath, parent2, this.myMeta, this.myVariant, contextElements, null);
        DbImportDialog.withCoroutineScope(cs -> {
            DbModifyObjectDialog dialog = new DbModifyObjectDialog((CoroutineScope)cs, bootstrapper, null);
            dialog.initAndShow();
        });
    }

    @Nullable
    public static BasicNamespace getCurrentNamespace(@NotNull DasDataSource dataSource2, @Nullable BasicObjectNode e2) {
        BasicElement element2;
        if (dataSource2 == null) {
            CreateObjectAction.$$$reportNull$$$0(8);
        }
        if ((element2 = CreateObjectAction.getAnyBasicElement(e2)) == null) {
            return null;
        }
        return (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObjectForSwitch(dataSource2, (DasObject)element2), BasicNamespace.class);
    }

    @Nullable
    public static BasicNamespace getCurrentNamespaceOrAnotherDb(@NotNull DasDataSource dataSource2, @NotNull Set<? extends BasicObjectNode> selection2) {
        if (dataSource2 == null) {
            CreateObjectAction.$$$reportNull$$$0(9);
        }
        if (selection2 == null) {
            CreateObjectAction.$$$reportNull$$$0(10);
        }
        return CreateObjectAction.getCurrentNamespaceOrAnotherDb(dataSource2, selection2, (BasicObjectNode)ContainerUtil.getFirstItem(selection2));
    }

    @Nullable
    private static BasicNamespace getCurrentNamespaceOrAnotherDb(@NotNull DasDataSource dataSource2, @NotNull Set<? extends BasicObjectNode> selection2, @Nullable BasicObjectNode candidate2) {
        BasicNamespace namespace;
        if (dataSource2 == null) {
            CreateObjectAction.$$$reportNull$$$0(11);
        }
        if (selection2 == null) {
            CreateObjectAction.$$$reportNull$$$0(12);
        }
        if ((namespace = CreateObjectAction.getCurrentNamespace(dataSource2, candidate2)) == null) {
            return null;
        }
        if (!selection2.contains(namespace)) {
            return namespace;
        }
        DasObject parent2 = namespace.getDasParent();
        if (parent2 == null) {
            return null;
        }
        if (parent2 instanceof BasicNamespace) {
            return CreateObjectAction.getCurrentNamespaceOrAnotherDb(dataSource2, selection2, (BasicNamespace)parent2);
        }
        TreePattern scope = DbImplUtilCore.getIntrospectionScope(dataSource2);
        JBIterable candidates2 = parent2.getDasChildren(namespace.getKind()).filter(c2 -> DataSourceSchemaMapping.isIntrospected(scope, c2)).filter(BasicNamespace.class).filter(c2 -> !selection2.contains(c2));
        return (BasicNamespace)candidates2.filter(BasicNamespace::isCurrent).append((Iterable)candidates2).first();
    }

    @Nullable
    public static BasicElement getAnyBasicElement(@Nullable BasicObjectNode o2) {
        if (o2 == null || o2 instanceof BasicElement) {
            return (BasicElement)o2;
        }
        return CreateObjectAction.getAnyBasicElement(o2.getParent());
    }

    @Nullable
    static BasicObjectNode getSingle(@Nullable DbContextDataSourceElements<BasicObjectNode> selection2) {
        return selection2 == null ? null : (BasicObjectNode)selection2.asIterable().first();
    }

    @Nullable
    static DbContextDataSourceElements<BasicObjectNode> getSelection(@Nullable AnActionEvent e2) {
        DbContextDataSourceElements<?> elements2 = e2 == null ? null : DbContextElementsKt.getSingleDsContextElements(e2);
        return elements2 == null ? null : elements2.parentsForGroups().asNodes().replace(sel -> sel.asIterable().filter(BasicObjectNode.class).collect()).nullize();
    }

    @Nullable
    static BasicMetaObject<?> getGroup(@Nullable AnActionEvent e2) {
        DbContextDataSourceElements<?> elements2 = e2 == null ? null : DbContextElementsKt.getSingleDsContextElements(e2);
        ObjectsFamily family = elements2 == null ? null : (ObjectsFamily)elements2.asNodes().asIterable().filter(ObjectsFamily.class).first();
        return family == null ? null : family.getMetaObject();
    }

    static CreateObjectActionHelper.ObjectCursor<BasicElement> cursor(@NotNull BasicObjectNode e2) {
        if (e2 == null) {
            CreateObjectAction.$$$reportNull$$$0(13);
        }
        if (e2 instanceof BasicElement) {
            return new ModelCursor<BasicElement>((BasicElement)e2);
        }
        return CreateObjectAction.cursorWithFakeParent(e2.extractObject(), e2.getParent());
    }

    static <E extends BasicElement> CreateObjectActionHelper.ObjectCursor<E> cursorWithFakeParent(@NotNull E e2, final @Nullable BasicObjectNode parent2) {
        if (e2 == null) {
            CreateObjectAction.$$$reportNull$$$0(14);
        }
        return new ModelCursor<E>(e2){

            @Override
            @Nullable
            protected BasicObjectNode getObjectParent() {
                return parent2;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ddl/CreateObjectAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ddl/CreateObjectAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canModify";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentNamespace";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentNamespaceOrAnotherDb";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cursor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cursorWithFakeParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    protected class CreateBootstrapper
    extends DbModifyObjectDialogPanel.ObjectEditorBootstrapper {
        @NotNull
        private final BasicObjectNode myParent;
        @NotNull
        private final BasicMetaObject<?> myMeta;
        @NotNull
        private final ModelHelper.ObjectKindVariant myVariant;
        @NotNull
        private final Set<BasicObjectNode> mySelection;

        public CreateBootstrapper(@NotNull Project project, @NotNull RawDataSource dataSource2, @Nullable BasicModel model2, @NotNull SearchPath searchPath, @NotNull BasicObjectNode parent2, @NotNull BasicMetaObject<?> meta, @NotNull ModelHelper.ObjectKindVariant variant, @Nullable Set<BasicObjectNode> selection2, Consumer<List<ObjectPath>> postIntrospectionCallback) {
            if (project == null) {
                CreateBootstrapper.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                CreateBootstrapper.$$$reportNull$$$0(1);
            }
            if (model2 == null) {
                CreateBootstrapper.$$$reportNull$$$0(2);
            }
            if (parent2 == null) {
                CreateBootstrapper.$$$reportNull$$$0(3);
            }
            if (meta == null) {
                CreateBootstrapper.$$$reportNull$$$0(4);
            }
            if (variant == null) {
                CreateBootstrapper.$$$reportNull$$$0(5);
            }
            if (selection2 == null) {
                CreateBootstrapper.$$$reportNull$$$0(6);
            }
            super(project, dataSource2, model2, searchPath, postIntrospectionCallback);
            this.myParent = parent2;
            this.myMeta = meta;
            this.myVariant = variant;
            this.mySelection = selection2;
        }

        @Override
        @NotNull
        public ElementIdentity<?> createTargetId(@NotNull ElementMatcher matcher, @NotNull ElementOwner targetOwner) {
            if (matcher == null) {
                CreateBootstrapper.$$$reportNull$$$0(7);
            }
            if (targetOwner == null) {
                CreateBootstrapper.$$$reportNull$$$0(8);
            }
            ElementIdentity<?> targetParentId = this.pull(Objects.requireNonNull(matcher.getOriginalOwner()), this.myParent);
            return this.createObject(targetOwner, targetParentId, this.myMeta);
        }

        @NotNull
        private <E extends BasicElement> ElementIdentity<E> createObject(@NotNull ElementOwner owner, ElementIdentity<?> targetParentId, BasicMetaObject<E> meta) {
            if (owner == null) {
                CreateBootstrapper.$$$reportNull$$$0(9);
            }
            ElementIdentity<E> id = owner.create(targetParentId, meta);
            BasicElement targetElement = (BasicElement)Objects.requireNonNull(owner.findOrCreate(id));
            CreateObjectActionHelper.prepareNewObject(this.getModel().getDbms(), CreateObjectAction.cursorWithFakeParent(targetElement, this.myParent), this.myVariant, (short)0, ContainerUtil.map2Set(this.mySelection, CreateObjectAction::cursor));
            this.addMatch(owner, id, targetElement);
            ElementIdentity<E> elementIdentity = id;
            if (elementIdentity == null) {
                CreateBootstrapper.$$$reportNull$$$0(10);
            }
            return elementIdentity;
        }

        @Override
        @Nullable
        protected DbEditorModel<?, ?> createEditorModelImpl(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> targetId) {
            if (controller == null) {
                CreateBootstrapper.$$$reportNull$$$0(11);
            }
            if (targetId == null) {
                CreateBootstrapper.$$$reportNull$$$0(12);
            }
            controller.createStructureNodeModel(targetId);
            return controller.getBuilder().createAppropriateObjectEditorModel(controller, targetId);
        }

        @Override
        @NotNull
        public DbObjectEditorBuilder createEditorBuilder() {
            DbObjectEditorBuilder dbObjectEditorBuilder = CreateObjectAction.this.createEditorBuilder();
            if (dbObjectEditorBuilder == null) {
                CreateBootstrapper.$$$reportNull$$$0(13);
            }
            return dbObjectEditorBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetOwner";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ddl/CreateObjectAction$CreateBootstrapper";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ddl/CreateObjectAction$CreateBootstrapper";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createObject";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditorBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createTargetId";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createObject";
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditorModelImpl";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 13 -> new IllegalStateException(string);
            };
        }
    }

    private static class ModelCursor<E extends BasicElement>
    implements CreateObjectActionHelper.ObjectCursor<E> {
        private final E myObject;

        private ModelCursor(@NotNull E object) {
            if (object == null) {
                ModelCursor.$$$reportNull$$$0(0);
            }
            this.myObject = object;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = DbImplUtilCore.getDbms(this.myObject);
            if (dbms == null) {
                ModelCursor.$$$reportNull$$$0(1);
            }
            return dbms;
        }

        @Override
        @NotNull
        public E getProperties() {
            E e2 = this.myObject;
            if (e2 == null) {
                ModelCursor.$$$reportNull$$$0(2);
            }
            return e2;
        }

        @Override
        @NotNull
        public BasicMetaObject<E> getMetaObject() {
            BasicMetaObject<E> basicMetaObject = BasicMetaUtils.getMetaObject(this.myObject);
            if (basicMetaObject == null) {
                ModelCursor.$$$reportNull$$$0(3);
            }
            return basicMetaObject;
        }

        @Override
        @NotNull
        public JBIterable<BasicMetaObject<?>> getMetaChildren() {
            JBIterable<BasicMetaObject<?>> jBIterable = VmModelContextFactory.getChildren(this.getMetaObject());
            if (jBIterable == null) {
                ModelCursor.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public CreateObjectActionHelper.ObjectCursor<?> getParent() {
            BasicObjectNode parent2 = this.getObjectParent();
            return parent2 == null ? null : CreateObjectAction.cursor(parent2);
        }

        @Override
        public boolean isExisting() {
            return true;
        }

        @Nullable
        protected BasicObjectNode getObjectParent() {
            return this.myObject.getParent();
        }

        @Override
        @NotNull
        public JBIterable<CreateObjectActionHelper.ObjectCursor<?>> getChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = this.myObject.getDasChildren(kind).map(o2 -> new ModelCursor<BasicElement>((BasicElement)o2));
            if (jBIterable == null) {
                ModelCursor.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof ModelCursor && ((ModelCursor)obj2).myObject == this.myObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ddl/CreateObjectAction$ModelCursor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ddl/CreateObjectAction$ModelCursor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProperties";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

