/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.CreateObjectAction;
import com.intellij.database.actions.ddl.DbModifyObjectDialog;
import com.intellij.database.actions.ddl.DbModifyObjectDialogPanel;
import com.intellij.database.actions.ddl.ModifyObjectAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.editor.DbImportDialog;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.VmActiveElement;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbContextDataSourceElements;
import com.intellij.database.view.DbContextElementsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModifyObjectAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(1);
        }
        this.update(e2, BaseModifyObjectAction.getTarget(e2));
    }

    @Nullable
    private static DbContextDataSourceElements<BasicObjectNode> getTarget(@NotNull AnActionEvent e2) {
        DbContextDataSourceElements<?> elements2;
        if (e2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(2);
        }
        if ((elements2 = DbContextElementsKt.getSingleDsContextElements(e2)) == null) {
            return null;
        }
        return elements2.expandGroups().asNodes().replace(sel -> JBIterable.of((Object)((BasicObjectNode)sel.asIterable().filter(BasicObjectNode.class).single()))).nullize();
    }

    protected void update(@NotNull AnActionEvent e2, @Nullable DbContextDataSourceElements<BasicObjectNode> selection2) {
        BasicObjectNode element2;
        if (e2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(3);
        }
        boolean visible = (element2 = BaseModifyObjectAction.getElement(selection2)) != null && this.isAcceptable(element2.extractObject()) && BaseModifyObjectAction.canPerformOn(selection2.getDataSource(), element2.getMetaObject()) && this.isSupported(element2.extractObject());
        e2.getPresentation().setVisible(visible);
        e2.getPresentation().setEnabled(visible && CreateObjectAction.canModify(selection2.getProject(), selection2.getDataSource(), element2, element2.getMetaObject()));
    }

    @Nullable
    public static BasicObjectNode getElement(@Nullable DbContextDataSourceElements<BasicObjectNode> selection2) {
        return selection2 == null ? null : (BasicObjectNode)selection2.asIterable().first();
    }

    public static boolean canPerformOn(@NotNull RawDataSource dataSource2, @NotNull BasicMetaObject<?> meta) {
        if (dataSource2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(4);
        }
        if (meta == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(5);
        }
        return dataSource2 instanceof LocalDataSource && (meta.kindOf(VmElement.class) || DbImplUtilCore.canConnectTo((LocalDataSource)dataSource2)) || dataSource2 instanceof SqlDataSource && !meta.kindOf(VmActiveElement.class);
    }

    public boolean isSupported(@NotNull BasicElement e2) {
        if (e2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(6);
        }
        if (e2 instanceof VmElement) {
            return true;
        }
        Dbms dbms = DbImplUtilCore.getDbms(e2);
        ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e2);
        BasicModel model2 = e2.getModel();
        Version version = model2 == null ? Version.INFINITY : model2.getRoot().getServerVersion();
        return this.isSupported(capabilities, version);
    }

    protected abstract boolean isSupported(ScriptingCapabilities var1, Version var2);

    protected boolean isAcceptable(BasicElement e2) {
        return true;
    }

    @Contract(value="null->null")
    static BasicElement getElement(DbElement single) {
        BasicElement element2;
        BasicElement basicElement = element2 = single == null ? null : (BasicElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicElement.class);
        if (element2 == null && single != null) {
            BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)single.getDataSource().getModel(), BasicModel.class);
            element2 = model2 == null ? null : model2.getRoot();
        }
        return element2;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        DbContextDataSourceElements<BasicObjectNode> selection2;
        BasicObjectNode element2;
        BasicModel model2;
        if (e2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(7);
        }
        BasicModel basicModel = model2 = (element2 = BaseModifyObjectAction.getElement(selection2 = BaseModifyObjectAction.getTarget(e2))) == null ? null : element2.getModel();
        if (model2 == null) {
            return;
        }
        Project project = selection2.getProject();
        RawDataSource dataSource2 = selection2.getDataSource();
        if (element2 instanceof BasicElement && BaseModifyObjectAction.shouldAbort(project, dataSource2, (BasicElement)element2, e2.getPresentation().getText())) {
            return;
        }
        BasicNamespace current = CreateObjectAction.getCurrentNamespaceOrAnotherDb(dataSource2, selection2.asIterable().toSet());
        SearchPath searchPath = ObjectPaths.searchPathOf(current);
        Consumer postIntrospectionCallback = (Consumer)e2.getDataContext().getData(ModifyObjectAction.POST_INTROSPECTION_CALLBACK);
        DbImportDialog.withCoroutineScope(cs -> {
            DbModifyObjectDialog dialog = this.createRefactoringDialog(project, (CoroutineScope)cs, dataSource2, model2, element2, searchPath, postIntrospectionCallback);
            dialog.initAndShow();
        });
    }

    private static boolean shouldAbort(@NotNull Project project, @NotNull RawDataSource dataSource2, @NotNull BasicElement element2, @Nls String actionName) {
        if (project == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(8);
        }
        if (dataSource2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(10);
        }
        return dataSource2 instanceof LocalDataSource && DetailsSyncHelper.askUserForSyncOrAbort(project, (LocalDataSource)dataSource2, element2, actionName);
    }

    @NotNull
    protected abstract DbModifyObjectDialog createRefactoringDialog(@NotNull Project var1, @NotNull CoroutineScope var2, @NotNull RawDataSource var3, @NotNull BasicModel var4, @NotNull BasicObjectNode var5, @Nullable SearchPath var6, @Nullable Consumer<List<ObjectPath>> var7);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ddl/BaseModifyObjectAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canPerformOn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldAbort";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    protected static abstract class ModifyBootstrapper
    extends DbModifyObjectDialogPanel.ObjectEditorBootstrapper {
        @NotNull
        private final BasicObjectNode myElement;

        public ModifyBootstrapper(@NotNull Project project, @NotNull RawDataSource dataSource2, @NotNull BasicModel model2, @Nullable SearchPath searchPath, @NotNull BasicObjectNode element2, @Nullable Consumer<List<ObjectPath>> postIntrospectionCallback) {
            if (project == null) {
                ModifyBootstrapper.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                ModifyBootstrapper.$$$reportNull$$$0(1);
            }
            if (model2 == null) {
                ModifyBootstrapper.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                ModifyBootstrapper.$$$reportNull$$$0(3);
            }
            super(project, dataSource2, model2, searchPath, postIntrospectionCallback);
            this.myElement = element2;
        }

        @Override
        @NotNull
        public ElementIdentity<?> createTargetId(@NotNull ElementMatcher matcher, @NotNull ElementOwner targetOwner) {
            if (matcher == null) {
                ModifyBootstrapper.$$$reportNull$$$0(4);
            }
            if (targetOwner == null) {
                ModifyBootstrapper.$$$reportNull$$$0(5);
            }
            ElementIdentity<?> elementIdentity = this.pull(Objects.requireNonNull(matcher.getOriginalOwner()), this.myElement);
            if (elementIdentity == null) {
                ModifyBootstrapper.$$$reportNull$$$0(6);
            }
            return elementIdentity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetOwner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ddl/BaseModifyObjectAction$ModifyBootstrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction$ModifyBootstrapper";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTargetId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createTargetId";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

