/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BaseRefreshAction;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.basic.BasicAuxiliaryElement;
import com.intellij.database.model.basic.BasicAuxiliaryObject;
import com.intellij.database.model.basic.BasicDetailElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/RefreshFragmentAction;", "Lcom/intellij/database/actions/BaseRefreshAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canWe", "", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "intellij.database.impl"})
public final class RefreshFragmentAction
extends BaseRefreshAction {
    public RefreshFragmentAction() {
        super(null);
    }

    @Override
    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        boolean weCan = this.canWe(dataContext);
        e2.getPresentation().setEnabledAndVisible(weCan);
    }

    private final boolean canWe(DataContext dc) {
        List<DataSourceNode> dataSourceNodes = DatabaseContextFun.getSelectionRelatedDataSources(dc);
        for (DataSourceNode dsn : dataSourceNodes) {
            if (DBIntrospectorFeatures.supportsFragmentIntrospection(dsn.getDbms())) continue;
            return false;
        }
        boolean can = false;
        JBIterable<BasicElement> selectedElements = DatabaseContextFun.getSelectedElements(dc);
        for (BasicElement element2 : selectedElements) {
            BasicElement basicElement = element2;
            if ((basicElement instanceof BasicRoot ? true : basicElement instanceof BasicNamespaceOwner) ? true : basicElement instanceof BasicNamespace) {
                return false;
            }
            if (basicElement instanceof BasicAuxiliaryObject) {
                can = true;
                continue;
            }
            if (basicElement instanceof BasicAuxiliaryElement) {
                can = can || ((BasicAuxiliaryElement)element2).getParent() instanceof BasicAuxiliaryObject;
                continue;
            }
            if ((basicElement instanceof BasicMajorObject ? true : basicElement instanceof BasicMinorObject) ? true : basicElement instanceof BasicDetailElement) {
                can = true;
                continue;
            }
            if (!(basicElement instanceof BasicSourceAware)) continue;
            can = true;
        }
        return can;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBIterable<BasicElement> elementsToRefresh2 = DatabaseContextFun.getSelectedElements(dataContext);
        RefreshActionsLogic.refreshSpecificFragments(project2, (Iterable)elementsToRefresh2);
    }
}

